/*
 * Decompiled with CFR 0.152.
 */
package com.alexbarter.ciphertool.ciphers;

import com.alexbarter.ciphertool.base.ciphers.UniKeyCipher;
import com.alexbarter.ciphertool.base.interfaces.IKeyType;
import com.alexbarter.ciphertool.base.key.types.VariableStringKeyType;
import com.alexbarter.ciphertool.lib.characters.StringUtils;
import com.alexbarter.lib.util.MathUtil;
import javax.annotation.Nullable;

public class PeriodicGromarkCipher
extends UniKeyCipher<String, VariableStringKeyType.Builder> {
    public PeriodicGromarkCipher() {
        super((IKeyType.IKeyBuilder)VariableStringKeyType.builder().setAlphabet((CharSequence)"ABCDEFGHIJKLMNOPQRSTUVWXYZ").setRange(2, Integer.MAX_VALUE));
    }

    public VariableStringKeyType.Builder limitDomainForFirstKey(VariableStringKeyType.Builder firstKey) {
        return firstKey.setRange(2, 8);
    }

    public CharSequence encode(CharSequence plainText, String key) {
        int i;
        int[] inOrd = new int[key.length()];
        int[] noOrd = new int[key.length()];
        int p = 0;
        for (char ch = 'A'; ch <= 'Z'; ch = (char)(ch + '\u0001')) {
            int keyindex = key.indexOf(ch);
            if (keyindex != -1) {
                inOrd[p++] = keyindex;
                noOrd[keyindex] = p;
                continue;
            }
            key = key + ch;
        }
        String transposedKey = "";
        int[] numericKey = new int[plainText.length()];
        for (i = 0; i < inOrd.length; ++i) {
            transposedKey = transposedKey + StringUtils.getEveryNthChar((CharSequence)key, (int)inOrd[i], (int)inOrd.length);
            numericKey[i] = noOrd[i];
        }
        for (i = 0; i < numericKey.length - noOrd.length; ++i) {
            numericKey[i + noOrd.length] = (numericKey[i] + numericKey[i + 1]) % 10;
        }
        StringBuilder cipherText = new StringBuilder(plainText.length());
        for (int i2 = 0; i2 < plainText.length(); ++i2) {
            int keyIndex = (int)(Math.floor((double)i2 / (double)inOrd.length) % (double)inOrd.length);
            cipherText.append(transposedKey.charAt((transposedKey.indexOf(key.charAt(keyIndex)) + (plainText.charAt(i2) - 65) + numericKey[i2]) % 26));
        }
        return cipherText;
    }

    public char[] decodeEfficiently(CharSequence cipherText, @Nullable char[] plainText, String key) {
        int i;
        int index;
        int[] inOrd = new int[key.length()];
        int[] noOrd = new int[key.length()];
        char[] keyFull = new char[26];
        for (index = 0; index < key.length(); ++index) {
            keyFull[index] = key.charAt(index);
        }
        int p = 0;
        for (int ch = 65; ch <= 90; ch = (int)((char)(ch + 1))) {
            int keyindex = key.indexOf(ch);
            if (keyindex != -1) {
                inOrd[p++] = keyindex;
                noOrd[keyindex] = p;
                continue;
            }
            keyFull[index++] = ch;
        }
        int[] transposedKeyIndexOf = new int[26];
        int[] numericKey = new int[cipherText.length()];
        int rows = (int)Math.ceil(26.0 / (double)key.length());
        index = 0;
        for (i = 0; i < inOrd.length; ++i) {
            for (int r = 0; r < rows && r * inOrd.length + inOrd[i] < 26; ++r) {
                transposedKeyIndexOf[keyFull[r * inOrd.length + inOrd[i]] - 65] = index++;
            }
            numericKey[i] = noOrd[i];
        }
        for (i = 0; i < numericKey.length - noOrd.length; ++i) {
            numericKey[i + noOrd.length] = (numericKey[i] + numericKey[i + 1]) % 10;
        }
        for (i = 0; i < cipherText.length(); ++i) {
            int keyIndex = (int)(Math.floor(i / inOrd.length) % (double)inOrd.length);
            plainText[i] = (char)(MathUtil.mod((int)(transposedKeyIndexOf[cipherText.charAt(i) - 65] - transposedKeyIndexOf[key.charAt(keyIndex) - 65] - numericKey[i]), (int)26) + 65);
        }
        return plainText;
    }
}

