/*
 * Decompiled with CFR 0.152.
 */
package com.alexbarter.ciphertool.ciphers;

import com.alexbarter.ciphertool.base.ciphers.BiKey;
import com.alexbarter.ciphertool.base.ciphers.TriKey;
import com.alexbarter.ciphertool.base.ciphers.TriKeyCipher;
import com.alexbarter.ciphertool.base.interfaces.IKeyType;
import com.alexbarter.ciphertool.base.key.types.EnumKeyType;
import com.alexbarter.ciphertool.base.key.types.OrderedIntegerKeyType;
import com.alexbarter.ciphertool.base.key.types.SquareStringKeyType;
import com.alexbarter.ciphertool.ciphers.ColumnarTranspositionCipher;
import com.alexbarter.ciphertool.util.ReadMode;
import javax.annotation.Nullable;

public class ADFGXCipher
extends TriKeyCipher<String, Integer[], ReadMode, SquareStringKeyType.Builder, OrderedIntegerKeyType.Builder, EnumKeyType.Builder<ReadMode>> {
    private static final ColumnarTranspositionCipher transpostion = new ColumnarTranspositionCipher();
    private final String colLabels;

    public ADFGXCipher(String alphabet, String colLabelsIn) {
        super((IKeyType.IKeyBuilder)SquareStringKeyType.builder().setAlphabet((CharSequence)alphabet).setDim(colLabelsIn.length(), colLabelsIn.length()), (IKeyType.IKeyBuilder)OrderedIntegerKeyType.builder().setMin(1).setMax(Integer.MAX_VALUE), (IKeyType.IKeyBuilder)EnumKeyType.builder(ReadMode.class).setUniverse((Enum[])new ReadMode[]{ReadMode.DOWN}));
        this.colLabels = colLabelsIn;
    }

    public ADFGXCipher() {
        this("ABCDEFGHIKLMNOPQRSTUVWXYZ", "ADFGX");
    }

    public IKeyType.IKeyBuilder<Integer[]> limitDomainForSecondKey(OrderedIntegerKeyType.Builder secondKey) {
        return secondKey.setRange(2, 9);
    }

    public CharSequence normaliseText(CharSequence plainText, TriKey<String, Integer[], ReadMode> key) {
        StringBuilder builder = new StringBuilder(plainText.length());
        for (int i = 0; i < plainText.length(); ++i) {
            char c = plainText.charAt(i);
            builder.append(c == 'J' ? (char)'I' : (char)c);
        }
        return builder;
    }

    public boolean isValid(TriKey<String, Integer[], ReadMode> key) {
        return Math.sqrt(((String)key.getFirstKey()).length()) == (double)this.colLabels.length() && super.isValid(key);
    }

    public CharSequence encode(CharSequence plainText, TriKey<String, Integer[], ReadMode> key) {
        int size = this.colLabels.length();
        StringBuilder cipherText = new StringBuilder(plainText.length() * 2);
        for (int i = 0; i < plainText.length(); ++i) {
            char c = plainText.charAt(i);
            int charIndex = ((String)key.getFirstKey()).indexOf(c);
            int row = (int)Math.floor((double)charIndex / (double)size);
            int column = charIndex % size;
            cipherText.append(this.colLabels.charAt(row));
            cipherText.append(this.colLabels.charAt(column));
        }
        return transpostion.encode((CharSequence)cipherText, (BiKey<Integer[], ReadMode>)BiKey.of((Object)key.getSecondKey(), (Object)key.getThirdKey()));
    }

    public char[] decodeEfficiently(CharSequence cipherText, @Nullable char[] plainText, TriKey<String, Integer[], ReadMode> key) {
        return ADFGXCipher.decodeTransformed(transpostion.decodeEfficiently(cipherText, plainText, (BiKey<Integer[], ReadMode>)BiKey.of((Object)key.getSecondKey(), (Object)key.getThirdKey())), (String)key.getFirstKey(), this.colLabels);
    }

    private static char[] decodeTransformed(char[] untransformedText, String keysquare, String adfgvx) {
        char[] plainText = new char[untransformedText.length / 2];
        for (int i = 0; i < untransformedText.length; i += 2) {
            char c1 = untransformedText[i];
            char c2 = untransformedText[i + 1];
            int row = adfgvx.indexOf(c1);
            int column = adfgvx.indexOf(c2);
            if (row == -1 || column == -1) continue;
            plainText[i / 2] = keysquare.charAt(row * adfgvx.length() + column);
        }
        return plainText;
    }
}

