/*
 * Decompiled with CFR 0.152.
 */
package com.alexbarter.ciphertool.ciphers;

import com.alexbarter.ciphertool.base.ciphers.BiKey;
import com.alexbarter.ciphertool.base.ciphers.BiKeyCipher;
import com.alexbarter.ciphertool.base.interfaces.IKeyType;
import com.alexbarter.ciphertool.base.key.types.IntegerGenKeyType;
import com.alexbarter.ciphertool.base.key.types.SquareStringKeyType;
import com.alexbarter.ciphertool.lib.CipherUtils;
import com.alexbarter.ciphertool.lib.characters.CharacterArrayWrapper;
import com.alexbarter.lib.util.MathUtil;
import java.util.Map;
import javax.annotation.Nullable;

public class SeriatedPlayfairCipher
extends BiKeyCipher<String, Integer, SquareStringKeyType.Builder, IntegerGenKeyType.Builder> {
    public SeriatedPlayfairCipher() {
        super((IKeyType.IKeyBuilder)SquareStringKeyType.builder().setAlphabet((CharSequence)"ABCDEFGHIKLMNOPQRSTUVWXYZ").setDim(5, 5), (IKeyType.IKeyBuilder)IntegerGenKeyType.builder().setRange(0, 5000).addFilter(i -> i != 1));
    }

    public IntegerGenKeyType.Builder limitDomainForSecondKey(IntegerGenKeyType.Builder secondKey) {
        return secondKey.setRange(0, 15);
    }

    public CharSequence normaliseText(CharSequence plainText, BiKey<String, Integer> key) {
        boolean valid;
        StringBuilder builder = new StringBuilder(plainText);
        int period = (Integer)key.getSecondKey();
        block0: do {
            valid = true;
            for (int i = 0; i < builder.length() && valid; i += period * 2) {
                int min = Math.min(period, (builder.length() - i + 1) / 2);
                for (int j = 0; j < Math.min(min, (builder.length() - i) / 2); ++j) {
                    char b;
                    char a = builder.charAt(i + j);
                    if (a != (b = builder.charAt(i + j + min))) continue;
                    char nullChar = 'X';
                    if (a == 'X') {
                        nullChar = 'Q';
                    }
                    builder.insert(i + min + j, nullChar);
                    valid = false;
                    continue block0;
                }
            }
        } while (!valid);
        if (builder.length() % 2 != 0) {
            builder.append('X');
        }
        return builder;
    }

    public CharSequence encode(CharSequence plainText, BiKey<String, Integer> key) {
        int period = (Integer)key.getSecondKey();
        if (period == 0) {
            period = plainText.length() / 2;
        }
        Character[] cipherText = new Character[plainText.length()];
        for (int i = 0; i < plainText.length(); i += period * 2) {
            int min = Math.min(period, (int)Math.ceil((double)(plainText.length() - i) / 2.0));
            for (int j = 0; j < min; ++j) {
                char d;
                char c;
                char a = plainText.charAt(i + j);
                char b = plainText.charAt(i + j + min);
                int i1 = ((String)key.getFirstKey()).indexOf(a);
                int i2 = ((String)key.getFirstKey()).indexOf(b);
                int row1 = (int)Math.floor((double)i1 / 5.0);
                int col1 = i1 % 5;
                int row2 = (int)Math.floor((double)i2 / 5.0);
                int col2 = i2 % 5;
                if (row1 == row2) {
                    c = ((String)key.getFirstKey()).charAt(row1 * 5 + MathUtil.mod((int)(col1 + 1), (int)5));
                    d = ((String)key.getFirstKey()).charAt(row2 * 5 + MathUtil.mod((int)(col2 + 1), (int)5));
                } else if (col1 == col2) {
                    c = ((String)key.getFirstKey()).charAt(MathUtil.mod((int)(row1 + 1), (int)5) * 5 + col1);
                    d = ((String)key.getFirstKey()).charAt(MathUtil.mod((int)(row2 + 1), (int)5) * 5 + col2);
                } else {
                    c = ((String)key.getFirstKey()).charAt(row1 * 5 + col2);
                    d = ((String)key.getFirstKey()).charAt(row2 * 5 + col1);
                }
                if (c == d) {
                    System.out.println("ERROR " + a + b + " " + c + d);
                }
                cipherText[i + j] = Character.valueOf(c);
                cipherText[i + j + min] = Character.valueOf(d);
            }
        }
        return new CharacterArrayWrapper(cipherText);
    }

    public char[] decodeEfficiently(CharSequence cipherText, @Nullable char[] plainText, BiKey<String, Integer> key) {
        int period = (Integer)key.getSecondKey();
        if (period == 0) {
            period = cipherText.length() / 2;
        }
        Map keyIndex = CipherUtils.createCharacterIndexMapping((CharSequence)((CharSequence)key.getFirstKey()));
        for (int i = 0; i < cipherText.length(); i += period * 2) {
            int min = Math.min(period, (int)Math.ceil((double)(plainText.length - i) / 2.0));
            for (int j = 0; j < min; ++j) {
                char d;
                char c;
                int i1 = (Integer)keyIndex.get(Character.valueOf(cipherText.charAt(i + j)));
                int i2 = (Integer)keyIndex.get(Character.valueOf(cipherText.charAt(i + j + min)));
                int row1 = i1 / 5;
                int col1 = i1 % 5;
                int row2 = i2 / 5;
                int col2 = i2 % 5;
                if (row1 == row2) {
                    c = ((String)key.getFirstKey()).charAt(row1 * 5 + MathUtil.mod((int)(col1 - 1), (int)5));
                    d = ((String)key.getFirstKey()).charAt(row2 * 5 + MathUtil.mod((int)(col2 - 1), (int)5));
                } else if (col1 == col2) {
                    c = ((String)key.getFirstKey()).charAt(MathUtil.mod((int)(row1 - 1), (int)5) * 5 + col1);
                    d = ((String)key.getFirstKey()).charAt(MathUtil.mod((int)(row2 - 1), (int)5) * 5 + col2);
                } else {
                    c = ((String)key.getFirstKey()).charAt(row1 * 5 + col2);
                    d = ((String)key.getFirstKey()).charAt(row2 * 5 + col1);
                }
                plainText[i + j] = c;
                plainText[i + j + min] = d;
            }
        }
        return plainText;
    }
}

