/*
 * Decompiled with CFR 0.152.
 */
package com.alexbarter.ciphertool.ciphers.solitaire;

import com.alexbarter.ciphertool.lib.ListUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class DeckParse {
    public Integer[] order = new Integer[54];
    public Integer[] emptyIndex;
    public Integer[] unknownCards;
    public boolean complete;

    public DeckParse(Integer[] oldOrder) {
        Arrays.fill((Object[])this.order, (Object)-1);
        ArrayList<Integer> emptyIndex = new ArrayList<Integer>();
        for (int i = 0; i < oldOrder.length; ++i) {
            if (oldOrder[i] < 0) {
                emptyIndex.add(i);
                continue;
            }
            this.order[i] = oldOrder[i];
        }
        List all = ListUtil.range((int)0, (int)53);
        ListUtil.removeAll((List)all, (Integer[])this.order);
        this.emptyIndex = ListUtil.toArrayInteger(emptyIndex);
        this.unknownCards = ListUtil.toArrayInteger((List)all);
        this.complete = this.unknownCards.length == 0;
    }

    public DeckParse(String parse) {
        Arrays.fill((Object[])this.order, (Object)-1);
        parse = parse.substring(parse.startsWith("[") ? 1 : 0, parse.length() - (parse.endsWith("]") ? 1 : 0)).replaceAll(" ", "");
        String[] cards = parse.split(",");
        ArrayList<Integer> emptyIndex = new ArrayList<Integer>();
        for (int i = 0; i < cards.length; ++i) {
            String card = cards[i];
            if (card.equals("*") || card.equalsIgnoreCase("x") || card.equals("-1")) {
                emptyIndex.add(i);
                continue;
            }
            try {
                int no = Integer.valueOf(card);
                this.order[i] = no;
                continue;
            }
            catch (NumberFormatException no) {
                if (card.length() == 2) {
                    List<Character> starter = Arrays.asList(Character.valueOf('A'), Character.valueOf('2'), Character.valueOf('3'), Character.valueOf('4'), Character.valueOf('5'), Character.valueOf('6'), Character.valueOf('7'), Character.valueOf('8'), Character.valueOf('9'), Character.valueOf('T'), Character.valueOf('J'), Character.valueOf('Q'), Character.valueOf('K'));
                    List<Character> end = Arrays.asList(Character.valueOf('c'), Character.valueOf('d'), Character.valueOf('h'), Character.valueOf('s'), Character.valueOf('C'), Character.valueOf('D'), Character.valueOf('H'), Character.valueOf('S'));
                    if (!starter.contains(Character.valueOf(card.charAt(0))) || !end.contains(Character.valueOf(card.charAt(1)))) continue;
                    this.order[i] = starter.indexOf(Character.valueOf(card.charAt(0))) + end.indexOf(Character.valueOf(card.charAt(1))) % 4 * 13;
                    continue;
                }
                if (card.length() != 1) continue;
                if (card.equals("A")) {
                    this.order[i] = 52;
                    continue;
                }
                if (!card.equals("B")) continue;
                this.order[i] = 53;
            }
        }
        List all = ListUtil.range((int)0, (int)53);
        ListUtil.removeAll((List)all, (Integer[])this.order);
        this.emptyIndex = ListUtil.toArrayInteger(emptyIndex);
        this.unknownCards = ListUtil.toArrayInteger((List)all);
        this.complete = this.unknownCards.length == 0;
    }

    public static int countUnknowns(int[] deck) {
        int count = 0;
        for (int i = 0; i < deck.length; ++i) {
            if (deck[i] >= 0) continue;
            ++count;
        }
        return count;
    }

    public Integer[] getOtherUnknowns(int staticUnknown) {
        ArrayList temp = ListUtil.toList((Object[])this.unknownCards);
        temp.remove((Object)staticUnknown);
        return ListUtil.toArrayInteger((List)temp);
    }

    public int countUnknowns() {
        return this.unknownCards.length;
    }

    public boolean isDeckComplete() {
        return this.complete;
    }

    public Integer[] copyKnowns() {
        return Arrays.copyOf(this.order, this.order.length);
    }

    public String toString() {
        return "Unknowns: " + this.countUnknowns();
    }
}

