/*
 * Decompiled with CFR 0.152.
 */
package com.alexbarter.ciphertool.ciphers;

import com.alexbarter.ciphertool.base.ciphers.UniKeyCipher;
import com.alexbarter.ciphertool.base.interfaces.IKeyType;
import com.alexbarter.ciphertool.base.key.types.PolluxKeyType;
import com.alexbarter.ciphertool.lib.MorseCode;
import com.alexbarter.ciphertool.lib.characters.CharacterArrayWrapper;
import com.alexbarter.lib.util.RandomUtil;
import javax.annotation.Nullable;

public class PolluxCipher
extends UniKeyCipher<Character[], PolluxKeyType.Builder> {
    private static char[] DIGIT_STR = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};

    public PolluxCipher() {
        super((IKeyType.IKeyBuilder)PolluxKeyType.builder());
    }

    public CharSequence encode(CharSequence plainText, Character[] key) {
        String morseText = MorseCode.getMorseEquivalent((CharSequence)plainText);
        morseText = MorseCode.getMorseEquivalent((CharSequence)plainText);
        Character[] cipherText = new Character[morseText.length()];
        for (int i = 0; i < morseText.length(); ++i) {
            char a = morseText.charAt(i);
            int no = 0;
            while (key[no = RandomUtil.pickRandomInt((int)key.length)].charValue() != a) {
            }
            cipherText[i] = Character.valueOf(DIGIT_STR[no]);
        }
        return new CharacterArrayWrapper(cipherText);
    }

    public char[] decodeEfficently(CharSequence cipherText, Character[] key) {
        return this.decodeEfficently(cipherText, (char[])null, key);
    }

    public char[] decodeEfficently(CharSequence cipherText, @Nullable char[] plainText, Character[] key) {
        char[] morseText = new char[cipherText.length()];
        for (int i = 0; i < cipherText.length(); ++i) {
            morseText[i] = key[cipherText.charAt(i) - 48].charValue();
        }
        StringBuilder builder = new StringBuilder(cipherText.length() / 4);
        int last = 0;
        for (int i = 0; i < morseText.length; ++i) {
            boolean end;
            char a = morseText[i];
            boolean bl = end = i == morseText.length - 1;
            if (a != 'X' && !end) continue;
            Character morseChar = MorseCode.getCharFromMorse((char[])morseText, (int)last, (int)(i - last + (end ? 1 : 0)));
            if (morseChar != null) {
                builder.append(morseChar.charValue());
            } else {
                builder.append(morseText, last, i - last + (end ? 1 : 0));
            }
            last = i + 1;
        }
        return builder.toString().toCharArray();
    }

    public boolean deterministic() {
        return false;
    }
}

