/*
 * Decompiled with CFR 0.152.
 */
package com.alexbarter.ciphertool.ciphers;

import com.alexbarter.ciphertool.base.ciphers.BiKey;
import com.alexbarter.ciphertool.base.ciphers.BiKeyCipher;
import com.alexbarter.ciphertool.base.interfaces.IKeyType;
import com.alexbarter.ciphertool.base.key.types.SquareStringKeyType;
import javax.annotation.Nullable;

public class FourSquareCipher
extends BiKeyCipher<String, String, SquareStringKeyType.Builder, SquareStringKeyType.Builder> {
    public FourSquareCipher() {
        super((IKeyType.IKeyBuilder)SquareStringKeyType.builder().setAlphabet((CharSequence)"ABCDEFGHIKLMNOPQRSTUVWXYZ").setDim(5, 5), (IKeyType.IKeyBuilder)SquareStringKeyType.builder().setAlphabet((CharSequence)"ABCDEFGHIKLMNOPQRSTUVWXYZ").setDim(5, 5));
    }

    public CharSequence normaliseText(CharSequence plainText, BiKey<String, String> key) {
        StringBuilder builder = new StringBuilder(plainText.length());
        for (int i = 0; i < plainText.length(); ++i) {
            char c = plainText.charAt(i);
            builder.append(c == 'J' ? (char)'I' : (char)c);
        }
        if (builder.length() % 2 == 1) {
            builder.append('X');
            return builder;
        }
        return builder;
    }

    public CharSequence encode(CharSequence plainText, BiKey<String, String> key) {
        StringBuilder cipherText = new StringBuilder(plainText.length());
        String shortAlpha = "ABCDEFGHIKLMNOPQRSTUVWXYZ";
        for (int i = 0; i < plainText.length(); i += 2) {
            char a = plainText.charAt(i);
            char b = plainText.charAt(i + 1);
            int aIndex = shortAlpha.indexOf(a);
            int bIndex = shortAlpha.indexOf(b);
            int aRow = (int)Math.floor(aIndex / 5);
            int bRow = (int)Math.floor(bIndex / 5);
            int aCol = aIndex % 5;
            int bCol = bIndex % 5;
            cipherText.append(((String)key.getFirstKey()).charAt(5 * aRow + bCol));
            cipherText.append(((String)key.getSecondKey()).charAt(5 * bRow + aCol));
        }
        return cipherText;
    }

    public char[] decodeEfficently(CharSequence cipherText, @Nullable char[] plainText, BiKey<String, String> key) {
        String shortAlpha = "ABCDEFGHIKLMNOPQRSTUVWXYZ";
        for (int i = 0; i < cipherText.length(); i += 2) {
            char a = cipherText.charAt(i);
            char b = cipherText.charAt(i + 1);
            int aIndex = ((String)key.getFirstKey()).indexOf(a);
            int bIndex = ((String)key.getSecondKey()).indexOf(b);
            int aRow = aIndex / 5;
            int bRow = bIndex / 5;
            int aCol = aIndex % 5;
            int bCol = bIndex % 5;
            plainText[i] = shortAlpha.charAt(5 * aRow + bCol);
            plainText[i + 1] = shortAlpha.charAt(5 * bRow + aCol);
        }
        return plainText;
    }
}

