/*
 * Decompiled with CFR 0.152.
 */
package com.alexbarter.ciphertool.base.key.types;

import com.alexbarter.ciphertool.base.key.IRangedKeyType;
import com.alexbarter.lib.util.RandomUtil;
import java.math.BigInteger;
import java.text.ParseException;
import java.util.Optional;
import java.util.function.Function;

public class IntegerKeyType
implements IRangedKeyType<Integer> {
    private final int min;
    private final int max;
    private final boolean alterable;

    private IntegerKeyType(int min, int max, boolean alterable) {
        this.min = min;
        this.max = max;
        this.alterable = alterable;
    }

    @Override
    public Integer randomise() {
        return RandomUtil.pickRandomInt((int)this.min, (int)this.max);
    }

    @Override
    public boolean isValid(Integer key) {
        return this.min <= key && key <= this.max;
    }

    @Override
    public boolean iterateKeys(Function<Integer, Boolean> consumer) {
        for (int i = this.min; i <= this.max; ++i) {
            if (consumer.apply(i).booleanValue()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Integer alterKey(Integer key) {
        return this.alterable ? RandomUtil.pickRandomInt((int)this.min, (int)this.max) : key;
    }

    @Override
    public BigInteger getNumOfKeys() {
        return BigInteger.valueOf(this.max).subtract(BigInteger.valueOf(this.min)).add(BigInteger.ONE);
    }

    @Override
    public Integer parse(String input) throws ParseException {
        try {
            return Integer.parseInt(input);
        }
        catch (NumberFormatException e) {
            throw new ParseException(input, 0);
        }
    }

    @Override
    public String getHelp() {
        StringBuilder builder = new StringBuilder();
        return this.min + "-" + this.max;
    }

    @Override
    public int getMin() {
        return this.min;
    }

    @Override
    public int getMax() {
        return this.max;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    implements IRangedKeyType.IRangedKeyBuilder<Integer> {
        private Optional<Integer> min = Optional.empty();
        private Optional<Integer> max = Optional.empty();
        private boolean alterable = false;

        private Builder() {
        }

        public Builder setRange(int min, int max) {
            return this.setMin(min).setMax(max);
        }

        public Builder setSize(int size) {
            return this.setRange(size, size);
        }

        public Builder setMin(int supp) {
            this.min = Optional.of(supp);
            return this;
        }

        public Builder setMax(int supp) {
            this.max = Optional.of(supp);
            return this;
        }

        public Builder setAlterable() {
            this.alterable = true;
            return this;
        }

        public IntegerKeyType create() {
            IntegerKeyType handler = new IntegerKeyType(this.min.orElse(Integer.MIN_VALUE), this.max.orElse(Integer.MAX_VALUE), this.alterable);
            return handler;
        }
    }
}

