/*
 * Decompiled with CFR 0.152.
 */
package tools.aqua.bgw.examples.tetris.service;

import java.util.Timer;
import java.util.TimerTask;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import tools.aqua.bgw.core.BoardGameApplication;
import tools.aqua.bgw.event.KeyCode;
import tools.aqua.bgw.examples.tetris.entity.Piece;
import tools.aqua.bgw.examples.tetris.entity.Tetris;
import tools.aqua.bgw.examples.tetris.entity.Tile;
import tools.aqua.bgw.examples.tetris.service.PieceGenerator;
import tools.aqua.bgw.examples.tetris.service.TetrisChecker;
import tools.aqua.bgw.examples.tetris.view.Refreshable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0002J\b\u0010\u0014\u001a\u00020\u0012H\u0002J\b\u0010\u0015\u001a\u00020\u0012H\u0002J\u000e\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0018J\b\u0010\u0019\u001a\u00020\u0012H\u0002J\b\u0010\u001a\u001a\u00020\u0012H\u0002J\u0006\u0010\u001b\u001a\u00020\u0012J\u0010\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0006\u0010\u001f\u001a\u00020\u0012R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Ltools/aqua/bgw/examples/tetris/service/LogicController;", "", "view", "Ltools/aqua/bgw/examples/tetris/view/Refreshable;", "(Ltools/aqua/bgw/examples/tetris/view/Refreshable;)V", "counter", "", "generator", "Ltools/aqua/bgw/examples/tetris/service/PieceGenerator;", "isBlocked", "", "isRunning", "mutex", "tetris", "Ltools/aqua/bgw/examples/tetris/entity/Tetris;", "timer", "Ljava/util/Timer;", "clearRows", "", "fixPiece", "loose", "movePiece", "navigate", "keyCode", "Ltools/aqua/bgw/event/KeyCode;", "nextPiece", "rotatePiece", "startGame", "startTimer", "speed", "", "stopTimer", "bgw-tetris-example"})
public final class LogicController {
    @NotNull
    private final Refreshable view;
    @NotNull
    private final Object mutex;
    @NotNull
    private final PieceGenerator generator;
    private boolean isRunning;
    private boolean isBlocked;
    private int counter;
    @NotNull
    private Timer timer;
    @NotNull
    private Tetris tetris;

    public LogicController(@NotNull Refreshable view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        this.view = view;
        this.mutex = new Object();
        this.generator = new PieceGenerator();
        this.counter = 10;
        this.timer = new Timer();
        this.tetris = new Tetris(this.generator.generate3());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void startGame() {
        Object object = this.mutex;
        synchronized (object) {
            boolean bl = false;
            if (!this.isRunning) {
                this.nextPiece();
                this.startTimer(400L);
                this.isRunning = true;
                this.view.hideStartInstructions();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void startTimer(long speed) {
        this.view.refreshSpeed(speed);
        this.counter = 10;
        Timer timer = this.timer = new Timer();
        TimerTask timerTask = new TimerTask(this, speed){
            final /* synthetic */ LogicController this$0;
            final /* synthetic */ long $speed$inlined;
            {
                this.this$0 = logicController;
                this.$speed$inlined = l;
            }

            public void run() {
                TimerTask $this$startTimer_u24lambda_u2d1 = this;
                boolean bl = false;
                BoardGameApplication.Companion.runOnGUIThread(new Runnable(this.this$0, this.$speed$inlined){
                    final /* synthetic */ LogicController this$0;
                    final /* synthetic */ long $speed;
                    {
                        this.this$0 = $receiver;
                        this.$speed = $speed;
                    }

                    public final void run() {
                        LogicController.access$movePiece(this.this$0);
                        if (LogicController.access$getCounter$p(this.this$0) <= 0) {
                            LogicController.access$getTimer$p(this.this$0).cancel();
                            LogicController.access$startTimer(this.this$0, MathKt.roundToLong((double)((double)this.$speed * 0.8)));
                        }
                    }
                });
            }
        };
        timer.scheduleAtFixedRate(timerTask, speed, speed);
    }

    public final void stopTimer() {
        this.timer.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void navigate(@NotNull KeyCode keyCode) {
        Intrinsics.checkNotNullParameter((Object)keyCode, (String)"keyCode");
        if (!keyCode.isArrow()) {
            boolean bl = false;
            String string = keyCode + " is not an arrow key.";
            throw new IllegalArgumentException(string.toString());
        }
        if (this.isBlocked || !this.isRunning) {
            return;
        }
        Object object = this.mutex;
        synchronized (object) {
            boolean bl = false;
            switch (WhenMappings.$EnumSwitchMapping$0[keyCode.ordinal()]) {
                case 1: {
                    if (TetrisChecker.checkCollision$default(TetrisChecker.INSTANCE, this.tetris, null, 0, -1, 6, null)) break;
                    this.tetris.left();
                    break;
                }
                case 2: {
                    if (TetrisChecker.checkCollision$default(TetrisChecker.INSTANCE, this.tetris, null, 0, 1, 6, null)) break;
                    this.tetris.right();
                    break;
                }
                case 3: {
                    while (!TetrisChecker.checkCollision$default(TetrisChecker.INSTANCE, this.tetris, null, 1, 0, 10, null)) {
                        this.tetris.down();
                    }
                    this.isBlocked = true;
                    break;
                }
                case 4: {
                    this.rotatePiece();
                    break;
                }
                default: {
                    throw new IllegalStateException((keyCode + " is not an arrow key.").toString());
                }
            }
            this.view.refresh(this.tetris);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void nextPiece() {
        Object object = this.mutex;
        synchronized (object) {
            Unit unit;
            boolean bl = false;
            int n = this.counter;
            this.counter = n + -1;
            this.tetris.nextPiece(this.generator.getRandomPiece());
            Unit it = unit = Unit.INSTANCE;
            boolean bl2 = false;
            this.view.refresh(this.tetris);
            Unit unit2 = Unit.INSTANCE;
        }
    }

    private final void movePiece() {
        if (TetrisChecker.checkCollision$default(TetrisChecker.INSTANCE, this.tetris, null, 1, 0, 10, null)) {
            this.fixPiece();
        } else {
            this.tetris.down();
            this.view.refresh(this.tetris);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void fixPiece() {
        Object object = this.mutex;
        synchronized (object) {
            boolean bl = false;
            Piece piece = this.tetris.getCurrentPiece();
            if (this.tetris.getCurrentYPosition() <= 0) {
                this.loose();
                return;
            }
            int n = piece.getHeight();
            for (int y = 0; y < n; ++y) {
                int n2 = piece.getWidth();
                for (int x = 0; x < n2; ++x) {
                    Tile it;
                    if (piece.getTiles()[y][x] == null) continue;
                    boolean bl2 = false;
                    this.tetris.getTetrisGrid()[y + this.tetris.getCurrentYPosition() - 1][x + this.tetris.getCurrentXPosition() - 1] = it;
                }
            }
            this.clearRows();
            this.nextPiece();
            this.isBlocked = false;
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void rotatePiece() {
        int n;
        Piece piece;
        if (this.tetris.getCurrentPiece().getHeight() == this.tetris.getCurrentPiece().getWidth()) {
            return;
        }
        int offsetY = 0;
        int offsetX = 0;
        switch (this.tetris.getCurrentPiece().getHeight()) {
            case 1: {
                int n2;
                Tile[][] tileArray;
                int n3;
                Tile[] tileArray2;
                int n4;
                int n5;
                int n6;
                offsetY = -1;
                offsetX = 1;
                Tile[][] tileArray3 = new Tile[4][];
                for (n6 = 0; n6 < 4; ++n6) {
                    n5 = n6;
                    n4 = 0;
                    tileArray2 = new Tile[1];
                    n3 = n5;
                    tileArray = tileArray3;
                    while (n4 < 1) {
                        n2 = n4++;
                        tileArray2[n2] = this.tetris.getCurrentPiece().getTiles()[0][n5];
                    }
                    tileArray[n3] = tileArray2;
                }
                Tile[][] tileArray4 = tileArray3;
                piece = new Piece(tileArray4);
                break;
            }
            case 2: {
                int n2;
                Tile[][] tileArray;
                int n3;
                Tile[] tileArray2;
                int n4;
                int n5;
                int n6;
                Tile[][] tileArray3 = new Tile[3][];
                for (n6 = 0; n6 < 3; ++n6) {
                    n5 = n6;
                    n4 = 0;
                    tileArray2 = new Tile[2];
                    n3 = n5;
                    tileArray = tileArray3;
                    while (n4 < 2) {
                        n2 = n4++;
                        tileArray2[n2] = this.tetris.getCurrentPiece().getTiles()[(n2 + 1) % 2][n5];
                    }
                    tileArray[n3] = tileArray2;
                }
                Tile[][] tileArray5 = tileArray3;
                piece = new Piece(tileArray5);
                break;
            }
            case 3: {
                int n2;
                Tile[][] tileArray;
                int n3;
                Tile[] tileArray2;
                int n4;
                int n5;
                int n6;
                Tile[][] tileArray3 = new Tile[2][];
                for (n6 = 0; n6 < 2; ++n6) {
                    n5 = n6;
                    n4 = 0;
                    tileArray2 = new Tile[3];
                    n3 = n5;
                    tileArray = tileArray3;
                    while (n4 < 3) {
                        n2 = n4++;
                        tileArray2[n2] = this.tetris.getCurrentPiece().getTiles()[-n2 + 2][n5];
                    }
                    tileArray[n3] = tileArray2;
                }
                Tile[][] tileArray6 = tileArray3;
                piece = new Piece(tileArray6);
                break;
            }
            case 4: {
                int n2;
                Tile[][] tileArray;
                int n3;
                Tile[] tileArray2;
                int n4;
                int n5;
                int n6;
                offsetY = 1;
                offsetX = -1;
                Tile[][] tileArray3 = new Tile[1][];
                for (n6 = 0; n6 < 1; ++n6) {
                    n5 = n6;
                    n4 = 0;
                    tileArray2 = new Tile[4];
                    n3 = n5;
                    tileArray = tileArray3;
                    while (n4 < 4) {
                        n2 = n4++;
                        tileArray2[n2] = this.tetris.getCurrentPiece().getTiles()[n2][0];
                    }
                    tileArray[n3] = tileArray2;
                }
                Tile[][] tileArray7 = tileArray3;
                piece = new Piece(tileArray7);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid piece height.".toString());
            }
        }
        Piece newPiece = piece;
        while (this.tetris.getCurrentXPosition() + offsetX < 1) {
            n = offsetX;
            offsetX = n + 1;
        }
        while (this.tetris.getCurrentXPosition() + offsetX + newPiece.getWidth() > 11) {
            n = offsetX;
            offsetX = n + -1;
        }
        if (!TetrisChecker.INSTANCE.checkCollision(this.tetris, newPiece, offsetY, offsetX)) {
            Tetris tetris;
            Tetris $this$rotatePiece_u24lambda_u2d8 = tetris = this.tetris;
            boolean bl = false;
            $this$rotatePiece_u24lambda_u2d8.setCurrentPiece(newPiece);
            $this$rotatePiece_u24lambda_u2d8.setCurrentYPosition($this$rotatePiece_u24lambda_u2d8.getCurrentYPosition() + offsetY);
            $this$rotatePiece_u24lambda_u2d8.setCurrentXPosition($this$rotatePiece_u24lambda_u2d8.getCurrentXPosition() + offsetX);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void clearRows() {
        Object object = this.mutex;
        synchronized (object) {
            int n;
            boolean bl = false;
            Tile[][] grid = this.tetris.getTetrisGrid();
            int row = 19;
            int cleared = 0;
            while (row >= 0) {
                if (TetrisChecker.INSTANCE.isRowFull(this.tetris, row)) {
                    for (int y = row; -1 < y; --y) {
                        for (int x = 0; x < 10; ++x) {
                            grid[y][x] = y == 0 ? new Tile(null) : grid[y - 1][x];
                        }
                    }
                    ++cleared;
                    continue;
                }
                --row;
            }
            Tetris tetris = this.tetris;
            int n2 = tetris.getPoints();
            switch (cleared) {
                case 4: {
                    n = 1200;
                    break;
                }
                case 3: {
                    n = 300;
                    break;
                }
                case 2: {
                    n = 100;
                    break;
                }
                case 1: {
                    n = 40;
                    break;
                }
                default: {
                    n = 0;
                }
            }
            tetris.setPoints(n2 + n);
            this.view.refreshPoints(this.tetris.getPoints());
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void loose() {
        this.isRunning = false;
        this.view.loose();
        this.stopTimer();
    }

    public static final /* synthetic */ void access$movePiece(LogicController $this) {
        $this.movePiece();
    }

    public static final /* synthetic */ int access$getCounter$p(LogicController $this) {
        return $this.counter;
    }

    public static final /* synthetic */ Timer access$getTimer$p(LogicController $this) {
        return $this.timer;
    }

    public static final /* synthetic */ void access$startTimer(LogicController $this, long speed) {
        $this.startTimer(speed);
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[KeyCode.values().length];
            nArray[KeyCode.LEFT.ordinal()] = 1;
            nArray[KeyCode.RIGHT.ordinal()] = 2;
            nArray[KeyCode.DOWN.ordinal()] = 3;
            nArray[KeyCode.UP.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

