/*
 * Decompiled with CFR 0.152.
 */
package tools.aqua.bgw.examples.tetris.view;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import tools.aqua.bgw.components.layoutviews.GridPane;
import tools.aqua.bgw.components.uicomponents.Label;
import tools.aqua.bgw.examples.tetris.entity.Piece;
import tools.aqua.bgw.examples.tetris.entity.Tetris;
import tools.aqua.bgw.examples.tetris.entity.Tile;
import tools.aqua.bgw.examples.tetris.view.Refreshable;
import tools.aqua.bgw.examples.tetris.view.TetrisViewController;
import tools.aqua.bgw.visual.ColorVisual;
import tools.aqua.bgw.visual.ImageVisual;
import tools.aqua.bgw.visual.Visual;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016J\u0010\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J\u0010\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u000fH\u0016J\u001b\u0010\u0013\u001a\u00020\u00062\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\r0\u0015H\u0002\u00a2\u0006\u0002\u0010\u0016J\u0010\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Ltools/aqua/bgw/examples/tetris/view/RefreshViewController;", "Ltools/aqua/bgw/examples/tetris/view/Refreshable;", "viewController", "Ltools/aqua/bgw/examples/tetris/view/TetrisViewController;", "(Ltools/aqua/bgw/examples/tetris/view/TetrisViewController;)V", "hideStartInstructions", "", "loose", "refresh", "tetris", "Ltools/aqua/bgw/examples/tetris/entity/Tetris;", "refreshActivePiece", "piece", "Ltools/aqua/bgw/examples/tetris/entity/Piece;", "yPosition", "", "xPosition", "refreshPoints", "points", "refreshPreview", "preview", "", "([Ltools/aqua/bgw/examples/tetris/entity/Piece;)V", "refreshSpeed", "speed", "", "refreshTetris", "bgw-tetris-example"})
public final class RefreshViewController
implements Refreshable {
    @NotNull
    private final TetrisViewController viewController;

    public RefreshViewController(@NotNull TetrisViewController viewController) {
        Intrinsics.checkNotNullParameter((Object)((Object)viewController), (String)"viewController");
        this.viewController = viewController;
    }

    @Override
    public void refresh(@NotNull Tetris tetris) {
        Intrinsics.checkNotNullParameter((Object)tetris, (String)"tetris");
        this.refreshPreview(tetris.getPreview());
        this.refreshTetris(tetris);
        this.refreshActivePiece(tetris.getCurrentPiece(), tetris.getCurrentYPosition(), tetris.getCurrentXPosition());
    }

    @Override
    public void hideStartInstructions() {
        this.viewController.getTetrisGameScene().getStartLabel().setVisible(false);
    }

    @Override
    public void loose() {
        this.viewController.getTetrisGameScene().getLooseLabel().setVisible(true);
    }

    @Override
    public void refreshSpeed(long speed) {
        this.viewController.getTetrisGameScene().getSpeedLabel().setText("Current delay: " + speed);
    }

    @Override
    public void refreshPoints(int points) {
        this.viewController.getTetrisGameScene().getPointsLabel().setText(points + " Points");
    }

    private final void refreshPreview(Piece[] preview) {
        if (!(preview.length == 3)) {
            boolean bl = false;
            String string = "There need to be three pieces as preview.";
            throw new IllegalArgumentException(string.toString());
        }
        this.viewController.getTetrisGameScene().getPreview1().show(preview[0]);
        this.viewController.getTetrisGameScene().getPreview2().show(preview[1]);
        this.viewController.getTetrisGameScene().getPreview3().show(preview[2]);
    }

    private final void refreshTetris(Tetris tetris) {
        GridPane<Label> viewGrid = this.viewController.getTetrisGameScene().getTetrisGrid();
        Tile[][] tetrisGrid = tetris.getTetrisGrid();
        int n = 0;
        int n2 = ((Object[])tetrisGrid).length;
        while (n < n2) {
            int y = n++;
            int n3 = 0;
            int n4 = tetrisGrid[0].length;
            while (n3 < n4) {
                int x = n3++;
                Label label = (Label)viewGrid.get(x + 1, y + 1);
                if (label == null) continue;
                ImageVisual imageVisual = tetrisGrid[y][x].getImageVisual();
                label.setVisual(imageVisual == null ? (Visual)ColorVisual.Companion.getBLACK() : (Visual)imageVisual);
            }
        }
    }

    private final void refreshActivePiece(Piece piece, int yPosition, int xPosition) {
        int n = 0;
        int n2 = ((Object[])piece.getTiles()).length;
        while (n < n2) {
            int y = n++;
            int n3 = 0;
            int n4 = piece.getTiles()[0].length;
            while (n3 < n4) {
                ImageVisual it;
                int x = n3++;
                Tile tile = piece.getTiles()[y][x];
                if (tile == null || tile.getImageVisual() == null) continue;
                boolean bl = false;
                if (yPosition + y <= 0) continue;
                Label label = (Label)this.viewController.getTetrisGameScene().getTetrisGrid().get(xPosition + x, yPosition + y);
                if (label == null) continue;
                label.setVisual((Visual)it);
            }
        }
    }
}

