/*
 * Decompiled with CFR 0.152.
 */
package tools.aqua.bgw.examples.sudoku.service;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.streams.jdk8.StreamsKt;
import kotlin.text.CharsKt;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tools.aqua.bgw.examples.sudoku.entity.Difficulty;
import tools.aqua.bgw.examples.sudoku.entity.Settings;
import tools.aqua.bgw.examples.sudoku.entity.Sudoku;
import tools.aqua.bgw.examples.sudoku.service.SudokuChecker;
import tools.aqua.bgw.examples.sudoku.view.Refreshable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010\u0018\u001a\u00020\u0017J/\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001b2\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u001b\u00a2\u0006\u0002\u0010\u001fJ\u0006\u0010 \u001a\u00020\u0017R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Ltools/aqua/bgw/examples/sudoku/service/LogicController;", "", "view", "Ltools/aqua/bgw/examples/sudoku/view/Refreshable;", "(Ltools/aqua/bgw/examples/sudoku/view/Refreshable;)V", "isTimerRunning", "", "settings", "Ltools/aqua/bgw/examples/sudoku/entity/Settings;", "getSettings", "()Ltools/aqua/bgw/examples/sudoku/entity/Settings;", "startTime", "", "sudoku", "Ltools/aqua/bgw/examples/sudoku/entity/Sudoku;", "getSudoku", "()Ltools/aqua/bgw/examples/sudoku/entity/Sudoku;", "setSudoku", "(Ltools/aqua/bgw/examples/sudoku/entity/Sudoku;)V", "getRandomSudoku", "difficulty", "Ltools/aqua/bgw/examples/sudoku/entity/Difficulty;", "newGame", "", "requestHint", "setValue", "box", "", "row", "col", "value", "(IIILjava/lang/Integer;)V", "showErrors", "bgw-sudoku-example"})
public final class LogicController {
    @NotNull
    private final Refreshable view;
    @NotNull
    private final Settings settings;
    @NotNull
    private Sudoku sudoku;
    private long startTime;
    private boolean isTimerRunning;

    public LogicController(@NotNull Refreshable view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        this.view = view;
        this.settings = new Settings(null, null, null, 7, null);
        this.sudoku = new Sudoku(null, 1, null);
        Timer timer = new Timer(true);
        long l = 0L;
        long l2 = 100L;
        TimerTask timerTask = new TimerTask(this){
            final /* synthetic */ LogicController this$0;
            {
                this.this$0 = logicController;
            }

            public void run() {
                TimerTask $this$_init__u24lambda_u2d0 = this;
                boolean bl = false;
                if (LogicController.access$isTimerRunning$p(this.this$0)) {
                    long millis = System.currentTimeMillis() - LogicController.access$getStartTime$p(this.this$0);
                    Refreshable refreshable = LogicController.access$getView$p(this.this$0);
                    Locale locale = Locale.getDefault();
                    String string = "%02d:%02d:%02d";
                    Object[] objectArray = new Object[]{TimeUnit.MILLISECONDS.toHours(millis), TimeUnit.MILLISECONDS.toMinutes(millis) - TimeUnit.HOURS.toMinutes(TimeUnit.MILLISECONDS.toHours(millis)), TimeUnit.MILLISECONDS.toSeconds(millis) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(millis))};
                    String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(locale, format, *args)");
                    refreshable.refreshTimer(string2);
                }
            }
        };
        timer.scheduleAtFixedRate(timerTask, l, l2);
    }

    @NotNull
    public final Settings getSettings() {
        return this.settings;
    }

    @NotNull
    public final Sudoku getSudoku() {
        return this.sudoku;
    }

    public final void setSudoku(@NotNull Sudoku sudoku) {
        Intrinsics.checkNotNullParameter((Object)sudoku, (String)"<set-?>");
        this.sudoku = sudoku;
    }

    public final void newGame(@NotNull Difficulty difficulty) {
        Intrinsics.checkNotNullParameter((Object)((Object)difficulty), (String)"difficulty");
        this.sudoku = this.getRandomSudoku(difficulty);
        this.startTime = System.currentTimeMillis();
        this.isTimerRunning = true;
        this.settings.setCurrentDifficulty(difficulty);
        this.view.refreshInit(this.sudoku);
    }

    /*
     * WARNING - void declaration
     */
    private final Sudoku getRandomSudoku(Difficulty difficulty) {
        void $this$forEachIndexed$iv;
        String string;
        int n;
        Object object;
        Object object2 = new Sudoku.SudokuCell[9][][];
        for (int i = 0; i < 9; ++i) {
            int n2 = i;
            Sudoku.SudokuCell[][] sudokuCellArrayArray = new Sudoku.SudokuCell[3][];
            int n3 = n2;
            Sudoku.SudokuCell[][][] sudokuCellArray = object2;
            for (int j = 0; j < 3; ++j) {
                int n4 = j;
                int n5 = 0;
                object = new Sudoku.SudokuCell[3];
                int n6 = n4;
                Sudoku.SudokuCell[][] sudokuCellArrayArray2 = sudokuCellArrayArray;
                while (n5 < 3) {
                    n = n5++;
                    object[n] = new Sudoku.SudokuCell(null, false, 3, null);
                }
                sudokuCellArrayArray2[n6] = object;
            }
            sudokuCellArray[n3] = sudokuCellArrayArray;
        }
        Sudoku.SudokuCell[][][] formatted = object2;
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(difficulty.getFile());
        if (inputStream != null) {
            InputStream $this$getRandomSudoku_u24lambda_u2d1 = inputStream;
            boolean bl = false;
            InputStream inputStream2 = $this$getRandomSudoku_u24lambda_u2d1;
            Charset charset = Charsets.UTF_8;
            object = new InputStreamReader(inputStream2, charset);
            n = 8192;
            Stream<String> stream = (object instanceof BufferedReader ? (BufferedReader)object : new BufferedReader((Reader)object, n)).lines();
            Intrinsics.checkNotNullExpressionValue(stream, (String)"bufferedReader().lines()");
            string = (String)CollectionsKt.randomOrNull((Collection)StreamsKt.toList(stream), (Random)((Random)Random.Default));
        } else {
            string = null;
        }
        if (string == null) {
            String string2 = "Required value was null.";
            throw new IllegalStateException(string2.toString());
        }
        String sudokuInput = string;
        if (!(sudokuInput.length() == 81)) {
            String string3 = "Check failed.";
            throw new IllegalStateException(string3.toString());
        }
        char[] cArray = sudokuInput.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"this as java.lang.String).toCharArray()");
        object2 = cArray;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (void item$iv : $this$forEachIndexed$iv) {
            void token;
            int n7 = index$iv++;
            void var10_23 = item$iv;
            int index = n7;
            boolean bl = false;
            int box = index / 9;
            int row = index % 9 / 3;
            int col = index % 3;
            int value = CharsKt.digitToInt((char)token);
            if (value == 0) continue;
            formatted[box][row][col] = new Sudoku.SudokuCell(value, true);
        }
        return new Sudoku(formatted);
    }

    public final void setValue(int box, int row, int col, @Nullable Integer value) {
        if (this.sudoku.getGrid()[box][row][col].isFixed()) {
            return;
        }
        this.sudoku.set(box, row, col, value);
        this.view.refreshSetValue(box, row, col, value);
        this.showErrors();
    }

    public static /* synthetic */ void setValue$default(LogicController logicController, int n, int n2, int n3, Integer n4, int n5, Object object) {
        if ((n5 & 8) != 0) {
            n4 = null;
        }
        logicController.setValue(n, n2, n3, n4);
    }

    public final void showErrors() {
        boolean isFull = SudokuChecker.INSTANCE.checkFull(this.sudoku);
        if (isFull || ((Boolean)this.settings.getInstantCheck().getValue()).booleanValue()) {
            Set<Sudoku.SudokuTuple> errors = SudokuChecker.INSTANCE.checkSudoku(this.sudoku);
            if (!((Collection)errors).isEmpty()) {
                this.view.refreshHint((Collection<Sudoku.SudokuTuple>)errors);
            } else if (isFull) {
                this.view.refreshWon();
            }
        }
    }

    public final void requestHint() {
        this.view.refreshHint((Collection<Sudoku.SudokuTuple>)SudokuChecker.INSTANCE.checkSudoku(this.sudoku));
    }

    public static final /* synthetic */ boolean access$isTimerRunning$p(LogicController $this) {
        return $this.isTimerRunning;
    }

    public static final /* synthetic */ long access$getStartTime$p(LogicController $this) {
        return $this.startTime;
    }

    public static final /* synthetic */ Refreshable access$getView$p(LogicController $this) {
        return $this.view;
    }
}

