/*
 * Decompiled with CFR 0.152.
 */
package tools.aqua.bgw.examples.sudoku.view.customcomponents;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tools.aqua.bgw.components.ComponentView;
import tools.aqua.bgw.components.layoutviews.GridPane;
import tools.aqua.bgw.examples.sudoku.entity.Sudoku;
import tools.aqua.bgw.examples.sudoku.view.customcomponents.CellSelectedEvent;
import tools.aqua.bgw.examples.sudoku.view.customcomponents.FontsKt;
import tools.aqua.bgw.examples.sudoku.view.customcomponents.SudokuBox;
import tools.aqua.bgw.examples.sudoku.view.customcomponents.SudokuCell;
import tools.aqua.bgw.util.GridIteratorElement;
import tools.aqua.bgw.visual.ColorVisual;
import tools.aqua.bgw.visual.Visual;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B/\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u0012\u0006\u0010\b\u001a\u00020\u0004\u00a2\u0006\u0004\b\t\u0010\nJ-\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u00172\b\u0010\u001a\u001a\u0004\u0018\u00010\u0017\u00a2\u0006\u0002\u0010\u001bJ0\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u00172\b\u0010\u001a\u001a\u0004\u0018\u00010\u0017H\u0086\u0002\u00a2\u0006\u0002\u0010\u001bJ(\u0010\u001d\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u0017H\u0086\u0002\u00a2\u0006\u0002\u0010\u001eJ\u001e\u0010\u001f\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u0017J\u0014\u0010 \u001a\u00020\u00142\f\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"J\u0006\u0010$\u001a\u00020\u0014J\u0006\u0010%\u001a\u00020\u0014R\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Ltools/aqua/bgw/examples/sudoku/view/customcomponents/SudokuGrid;", "Ltools/aqua/bgw/components/layoutviews/GridPane;", "Ltools/aqua/bgw/examples/sudoku/view/customcomponents/SudokuBox;", "posX", "", "posY", "size", "majorSpacing", "minorSpacing", "<init>", "(Ljava/lang/Number;Ljava/lang/Number;Ljava/lang/Number;Ljava/lang/Number;Ljava/lang/Number;)V", "selectedCell", "Ltools/aqua/bgw/examples/sudoku/view/customcomponents/SudokuCell;", "getSelectedCell", "()Ltools/aqua/bgw/examples/sudoku/view/customcomponents/SudokuCell;", "setSelectedCell", "(Ltools/aqua/bgw/examples/sudoku/view/customcomponents/SudokuCell;)V", "selectedEvent", "Lkotlin/Function1;", "Ltools/aqua/bgw/examples/sudoku/view/customcomponents/CellSelectedEvent;", "", "setFixed", "box", "", "row", "col", "value", "(IIILjava/lang/Integer;)V", "set", "get", "(III)Ljava/lang/Integer;", "getCell", "showHint", "cells", "", "Ltools/aqua/bgw/examples/sudoku/entity/Sudoku$SudokuTuple;", "showWon", "clearHints", "bgw-sudoku-example"})
@SourceDebugExtension(value={"SMAP\nSudokuGrid.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SudokuGrid.kt\ntools/aqua/bgw/examples/sudoku/view/customcomponents/SudokuGrid\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,151:1\n1863#2,2:152\n1863#2:154\n1863#2,2:155\n1864#2:157\n1863#2,2:158\n*S KotlinDebug\n*F\n+ 1 SudokuGrid.kt\ntools/aqua/bgw/examples/sudoku/view/customcomponents/SudokuGrid\n*L\n135#1:152,2\n140#1:154\n141#1:155,2\n140#1:157\n147#1:158,2\n*E\n"})
public final class SudokuGrid
extends GridPane<SudokuBox> {
    @Nullable
    private SudokuCell selectedCell;
    @Nullable
    private Function1<? super CellSelectedEvent, Unit> selectedEvent;

    /*
     * WARNING - void declaration
     */
    public SudokuGrid(@NotNull Number posX, @NotNull Number posY, @NotNull Number size, @NotNull Number majorSpacing, @NotNull Number minorSpacing) {
        Intrinsics.checkNotNullParameter((Object)posX, (String)"posX");
        Intrinsics.checkNotNullParameter((Object)posY, (String)"posY");
        Intrinsics.checkNotNullParameter((Object)size, (String)"size");
        Intrinsics.checkNotNullParameter((Object)majorSpacing, (String)"majorSpacing");
        Intrinsics.checkNotNullParameter((Object)minorSpacing, (String)"minorSpacing");
        super(posX, posY, 3, 3, majorSpacing, true, (Visual)ColorVisual.Companion.getBLACK());
        double cellSize = size.doubleValue() / (double)9;
        for (int i = 0; i < 9; ++i) {
            void $this$_init__u24lambda_u241;
            SudokuBox sudokuBox;
            SudokuBox sudokuBox2 = sudokuBox = new SudokuBox(i, cellSize, minorSpacing);
            int n = i / 3;
            int n2 = i % 3;
            SudokuGrid sudokuGrid = this;
            boolean bl = false;
            $this$_init__u24lambda_u241.setSelectedEvent((Function1<? super CellSelectedEvent, Unit>)((Function1)arg_0 -> SudokuGrid.lambda$1$lambda$0(this, arg_0)));
            Unit unit = Unit.INSTANCE;
            sudokuGrid.set(n2, n, (ComponentView)sudokuBox);
        }
    }

    @Nullable
    public final SudokuCell getSelectedCell() {
        return this.selectedCell;
    }

    public final void setSelectedCell(@Nullable SudokuCell sudokuCell) {
        this.selectedCell = sudokuCell;
    }

    public final void setFixed(int box, int row, int col, @Nullable Integer value) {
        block1: {
            block0: {
                Sudoku.Companion.checkBounds(box, row, col, value);
                if (value == null) break block0;
                Object object = (SudokuBox)this.get(box % 3, box / 3);
                if (object == null || (object = (SudokuCell)object.get(col, row)) == null) break block1;
                ((SudokuCell)((Object)object)).setFixedValue(value);
                break block1;
            }
            Object object = (SudokuBox)this.get(box % 3, box / 3);
            if (object == null || (object = (SudokuCell)object.get(col, row)) == null) break block1;
            ((SudokuCell)((Object)object)).clear();
        }
    }

    public final void set(int box, int row, int col, @Nullable Integer value) {
        Sudoku.Companion.checkBounds(box, row, col, value);
        this.getCell(box, row, col).setValue(value);
    }

    @Nullable
    public final Integer get(int box, int row, int col) {
        Sudoku.Companion.checkBounds$default(Sudoku.Companion, box, row, col, null, 8, null);
        return this.getCell(box, row, col).getValue();
    }

    @NotNull
    public final SudokuCell getCell(int box, int row, int col) {
        Sudoku.Companion.checkBounds$default(Sudoku.Companion, box, row, col, null, 8, null);
        SudokuBox sudokuBox = (SudokuBox)this.get(box % 3, box / 3);
        SudokuCell sudokuCell = sudokuBox != null ? (SudokuCell)sudokuBox.get(col, row) : null;
        if (sudokuCell == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        return sudokuCell;
    }

    public final void showHint(@NotNull Collection<Sudoku.SudokuTuple> cells) {
        Intrinsics.checkNotNullParameter(cells, (String)"cells");
        Iterable $this$forEach$iv = cells;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Sudoku.SudokuTuple it = (Sudoku.SudokuTuple)element$iv;
            boolean bl = false;
            this.getCell(it.getBox(), it.getRow(), it.getCol()).setVisual((Visual)new ColorVisual(FontsKt.getErrorColor()));
        }
    }

    public final void showWon() {
        Iterable $this$forEach$iv = (Iterable)((Object)this);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GridIteratorElement box = (GridIteratorElement)element$iv;
            boolean bl = false;
            SudokuBox sudokuBox = (SudokuBox)((Object)box.getComponent());
            if (sudokuBox == null) continue;
            Iterable $this$forEach$iv2 = (Iterable)((Object)sudokuBox);
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                GridIteratorElement cell = (GridIteratorElement)element$iv2;
                boolean bl2 = false;
                SudokuCell sudokuCell = (SudokuCell)((Object)cell.getComponent());
                if (sudokuCell == null) continue;
                sudokuCell.setVisual((Visual)new ColorVisual(FontsKt.getWonColor()));
            }
        }
    }

    public final void clearHints() {
        block2: {
            Iterable $this$forEach$iv = (Iterable)((Object)this);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                GridIteratorElement box = (GridIteratorElement)element$iv;
                boolean bl = false;
                SudokuBox sudokuBox = (SudokuBox)((Object)box.getComponent());
                if (sudokuBox == null) continue;
                Iterable $this$forEach$iv2 = (Iterable)((Object)sudokuBox);
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    GridIteratorElement cell = (GridIteratorElement)element$iv2;
                    boolean bl2 = false;
                    SudokuCell sudokuCell = (SudokuCell)((Object)cell.getComponent());
                    if (sudokuCell == null) continue;
                    sudokuCell.setVisual((Visual)ColorVisual.Companion.getWHITE());
                }
            }
            SudokuCell sudokuCell = this.selectedCell;
            if (sudokuCell == null) break block2;
            sudokuCell.setVisual((Visual)new ColorVisual(FontsKt.getSelectedColor()));
        }
    }

    private static final Unit lambda$1$lambda$0(SudokuGrid this$0, CellSelectedEvent it) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
            SudokuCell sudokuCell = this$0.selectedCell;
            if (sudokuCell != null) {
                sudokuCell.deselect();
            }
            this$0.selectedCell = it.getCell();
            Function1<? super CellSelectedEvent, Unit> function1 = this$0.selectedEvent;
            if (function1 == null) break block1;
            function1.invoke((Object)it);
        }
        return Unit.INSTANCE;
    }
}

