/*
 * Decompiled with CFR 0.152.
 */
package tools.aqua.bgw.examples.sudoku.view;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import tools.aqua.bgw.core.BoardGameApplication;
import tools.aqua.bgw.core.MenuScene;
import tools.aqua.bgw.event.KeyCode;
import tools.aqua.bgw.event.KeyEvent;
import tools.aqua.bgw.event.MouseEvent;
import tools.aqua.bgw.examples.sudoku.entity.Difficulty;
import tools.aqua.bgw.examples.sudoku.service.LogicController;
import tools.aqua.bgw.examples.sudoku.view.RefreshViewController;
import tools.aqua.bgw.examples.sudoku.view.customcomponents.SudokuCell;
import tools.aqua.bgw.examples.sudoku.view.scenes.SudokuGameScene;
import tools.aqua.bgw.examples.sudoku.view.scenes.SudokuMenuScene;
import tools.aqua.bgw.examples.sudoku.view.scenes.SudokuSettingsScene;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0010\u001a\u00020\u0011*\u00020\u0005H\u0002J\f\u0010\u0010\u001a\u00020\u0011*\u00020\u0007H\u0002J\f\u0010\u0010\u001a\u00020\u0011*\u00020\tH\u0002J\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0011H\u0002J\u0010\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0014H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Ltools/aqua/bgw/examples/sudoku/view/SudokuViewController;", "Ltools/aqua/bgw/core/BoardGameApplication;", "<init>", "()V", "sudokuMenuScene", "Ltools/aqua/bgw/examples/sudoku/view/scenes/SudokuMenuScene;", "sudokuSettingsScene", "Ltools/aqua/bgw/examples/sudoku/view/scenes/SudokuSettingsScene;", "sudokuGameScene", "Ltools/aqua/bgw/examples/sudoku/view/scenes/SudokuGameScene;", "getSudokuGameScene", "()Ltools/aqua/bgw/examples/sudoku/view/scenes/SudokuGameScene;", "refreshViewController", "Ltools/aqua/bgw/examples/sudoku/view/RefreshViewController;", "logicController", "Ltools/aqua/bgw/examples/sudoku/service/LogicController;", "registerEvents", "", "onDigitEntered", "digit", "Ltools/aqua/bgw/event/KeyCode;", "onValueDeleted", "onCursorMoved", "keyCode", "bgw-sudoku-example"})
@SourceDebugExtension(value={"SMAP\nSudokuViewController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SudokuViewController.kt\ntools/aqua/bgw/examples/sudoku/view/SudokuViewController\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,186:1\n1#2:187\n*E\n"})
public final class SudokuViewController
extends BoardGameApplication {
    @NotNull
    private final SudokuMenuScene sudokuMenuScene = new SudokuMenuScene();
    @NotNull
    private final SudokuSettingsScene sudokuSettingsScene = new SudokuSettingsScene();
    @NotNull
    private final SudokuGameScene sudokuGameScene = new SudokuGameScene();
    @NotNull
    private final RefreshViewController refreshViewController = new RefreshViewController(this);
    @NotNull
    private final LogicController logicController = new LogicController(this.refreshViewController);

    public SudokuViewController() {
        super("Sudoku", null, null, null, 14, null);
        this.registerEvents(this.sudokuMenuScene);
        this.registerEvents(this.sudokuSettingsScene);
        this.registerEvents(this.sudokuGameScene);
        this.showGameScene(this.sudokuGameScene);
        BoardGameApplication.showMenuScene$default((BoardGameApplication)this, (MenuScene)this.sudokuMenuScene, null, (int)2, null);
        this.show();
    }

    @NotNull
    public final SudokuGameScene getSudokuGameScene() {
        return this.sudokuGameScene;
    }

    private final void registerEvents(SudokuMenuScene $this$registerEvents) {
        $this$registerEvents.getContinueGameButton().setOnMouseClicked(arg_0 -> SudokuViewController.registerEvents$lambda$0(this, arg_0));
        $this$registerEvents.getNewGameEasyButton().setOnMouseClicked(arg_0 -> SudokuViewController.registerEvents$lambda$1(this, arg_0));
        $this$registerEvents.getNewGameMediumButton().setOnMouseClicked(arg_0 -> SudokuViewController.registerEvents$lambda$2(this, arg_0));
        $this$registerEvents.getNewGameHardButton().setOnMouseClicked(arg_0 -> SudokuViewController.registerEvents$lambda$3(this, arg_0));
        $this$registerEvents.getExitButton().setOnMouseClicked(arg_0 -> SudokuViewController.registerEvents$lambda$4(this, arg_0));
    }

    private final void registerEvents(SudokuSettingsScene $this$registerEvents) {
        $this$registerEvents.getShowTimerToggleButton().getButton().setOnSelectionChanged(arg_0 -> SudokuViewController.registerEvents$lambda$5(this, arg_0));
        $this$registerEvents.getInstantCheckToggleButton().getButton().setOnSelectionChanged(arg_0 -> SudokuViewController.registerEvents$lambda$6(this, arg_0));
        $this$registerEvents.getContinueGameButton().setOnMouseClicked(arg_0 -> SudokuViewController.registerEvents$lambda$7(this, arg_0));
    }

    private final void registerEvents(SudokuGameScene $this$registerEvents) {
        $this$registerEvents.setOnKeyPressed(arg_0 -> SudokuViewController.registerEvents$lambda$8(this, arg_0));
        this.logicController.getSettings().getShowTimer().addListener((arg_0, arg_1) -> SudokuViewController.registerEvents$lambda$9($this$registerEvents, arg_0, arg_1));
        $this$registerEvents.getMenuButton().setOnMouseClicked(arg_0 -> SudokuViewController.registerEvents$lambda$10(this, arg_0));
        $this$registerEvents.getSettingsButton().setOnMouseClicked(arg_0 -> SudokuViewController.registerEvents$lambda$11(this, arg_0));
        $this$registerEvents.getHintButton().setOnMouseClicked(arg_0 -> SudokuViewController.registerEvents$lambda$12(this, arg_0));
        $this$registerEvents.getClearHintsButton().setOnMouseClicked(arg_0 -> SudokuViewController.registerEvents$lambda$13($this$registerEvents, arg_0));
    }

    private final void onDigitEntered(KeyCode digit) {
        SudokuCell sudokuCell = this.sudokuGameScene.getSudokuGrid().getSelectedCell();
        if (sudokuCell == null) {
            return;
        }
        SudokuCell cell = sudokuCell;
        if (cell.isFixed() || digit == KeyCode.NUMPAD0) {
            return;
        }
        this.logicController.setValue(cell.getBoxIndex(), cell.getRowIndex(), cell.getColIndex(), Integer.parseInt(digit.getString()));
    }

    private final void onValueDeleted() {
        SudokuCell sudokuCell = this.sudokuGameScene.getSudokuGrid().getSelectedCell();
        if (sudokuCell == null) {
            return;
        }
        SudokuCell cell = sudokuCell;
        this.logicController.setValue(cell.getBoxIndex(), cell.getRowIndex(), cell.getColIndex(), null);
    }

    private final void onCursorMoved(KeyCode keyCode) {
        if (!keyCode.isArrow()) {
            boolean $i$a$-require-SudokuViewController$onCursorMoved$22 = false;
            String $i$a$-require-SudokuViewController$onCursorMoved$22 = keyCode + " is not an arrow key.";
            throw new IllegalArgumentException($i$a$-require-SudokuViewController$onCursorMoved$22.toString());
        }
        SudokuCell sudokuCell = this.sudokuGameScene.getSudokuGrid().getSelectedCell();
        if (sudokuCell == null) {
            return;
        }
        SudokuCell selectedCell = sudokuCell;
        int box = selectedCell.getBoxIndex();
        int col = selectedCell.getColIndex();
        int row = selectedCell.getRowIndex();
        switch (WhenMappings.$EnumSwitchMapping$0[keyCode.ordinal()]) {
            case 1: {
                if (row == 0) {
                    box = Math.floorMod(box - 3, 9);
                    row = 2;
                    break;
                }
                --row;
                break;
            }
            case 2: {
                if (row == 2) {
                    box = (box + 3) % 9;
                    row = 0;
                    break;
                }
                ++row;
                break;
            }
            case 3: {
                if (col == 0) {
                    box += box % 3 != 0 ? -1 : 2;
                    col = 2;
                    break;
                }
                --col;
                break;
            }
            case 4: {
                if (col == 2) {
                    box -= box % 3 != 2 ? -1 : 2;
                    col = 0;
                    break;
                }
                ++col;
                break;
            }
            default: {
                throw new IllegalStateException((keyCode + " is not an arrow key.").toString());
            }
        }
        this.sudokuGameScene.getSudokuGrid().getCell(box, row, col).select();
    }

    private static final Unit registerEvents$lambda$0(SudokuViewController this$0, MouseEvent it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        BoardGameApplication.hideMenuScene$default((BoardGameApplication)this$0, null, (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit registerEvents$lambda$1(SudokuViewController this$0, MouseEvent it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.logicController.newGame(Difficulty.EASY);
        BoardGameApplication.hideMenuScene$default((BoardGameApplication)this$0, null, (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit registerEvents$lambda$2(SudokuViewController this$0, MouseEvent it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.logicController.newGame(Difficulty.MEDIUM);
        BoardGameApplication.hideMenuScene$default((BoardGameApplication)this$0, null, (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit registerEvents$lambda$3(SudokuViewController this$0, MouseEvent it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.logicController.newGame(Difficulty.HARD);
        BoardGameApplication.hideMenuScene$default((BoardGameApplication)this$0, null, (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit registerEvents$lambda$4(SudokuViewController this$0, MouseEvent it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.exit();
        return Unit.INSTANCE;
    }

    private static final Unit registerEvents$lambda$5(SudokuViewController this$0, boolean nV) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.logicController.getSettings().getShowTimer().setValue((Object)nV);
        return Unit.INSTANCE;
    }

    private static final Unit registerEvents$lambda$6(SudokuViewController this$0, boolean nV) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.logicController.getSettings().getInstantCheck().setValue((Object)nV);
        if (nV) {
            this$0.logicController.showErrors();
        } else {
            this$0.sudokuGameScene.getSudokuGrid().clearHints();
        }
        return Unit.INSTANCE;
    }

    private static final Unit registerEvents$lambda$7(SudokuViewController this$0, MouseEvent it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        BoardGameApplication.hideMenuScene$default((BoardGameApplication)this$0, null, (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit registerEvents$lambda$8(SudokuViewController this$0, KeyEvent it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (it.getKeyCode().isArrow()) {
            this$0.onCursorMoved(it.getKeyCode());
        } else if (it.getKeyCode().isDigit()) {
            this$0.onDigitEntered(it.getKeyCode());
        } else if (it.getKeyCode() == KeyCode.DELETE) {
            this$0.onValueDeleted();
        }
        return Unit.INSTANCE;
    }

    private static final void registerEvents$lambda$9(SudokuGameScene $this_registerEvents, boolean bl, boolean nV) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this_registerEvents), (String)"$this_registerEvents");
        $this_registerEvents.getTimer().setVisible(nV);
    }

    private static final Unit registerEvents$lambda$10(SudokuViewController this$0, MouseEvent it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        BoardGameApplication.showMenuScene$default((BoardGameApplication)this$0, (MenuScene)this$0.sudokuMenuScene, null, (int)2, null);
        return Unit.INSTANCE;
    }

    private static final Unit registerEvents$lambda$11(SudokuViewController this$0, MouseEvent it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        BoardGameApplication.showMenuScene$default((BoardGameApplication)this$0, (MenuScene)this$0.sudokuSettingsScene, null, (int)2, null);
        return Unit.INSTANCE;
    }

    private static final Unit registerEvents$lambda$12(SudokuViewController this$0, MouseEvent it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.logicController.requestHint();
        return Unit.INSTANCE;
    }

    private static final Unit registerEvents$lambda$13(SudokuGameScene $this_registerEvents, MouseEvent it) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this_registerEvents), (String)"$this_registerEvents");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $this_registerEvents.getSudokuGrid().clearHints();
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[KeyCode.values().length];
            try {
                nArray[KeyCode.UP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KeyCode.DOWN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KeyCode.LEFT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KeyCode.RIGHT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

