/*
 * Decompiled with CFR 0.152.
 */
package tools.aqua.bgw.net.client;

import com.fasterxml.jackson.databind.JsonMappingException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KFunction;
import kotlin.reflect.jvm.ReflectJvmMapping;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.GlobalScope;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tools.aqua.bgw.net.client.BGWWebSocketClient;
import tools.aqua.bgw.net.client.NetworkLogger;
import tools.aqua.bgw.net.client.NetworkLogging;
import tools.aqua.bgw.net.common.GameAction;
import tools.aqua.bgw.net.common.annotations.GameActionClassProcessor;
import tools.aqua.bgw.net.common.annotations.GameActionReceiverProcessor;
import tools.aqua.bgw.net.common.message.GameActionMessage;
import tools.aqua.bgw.net.common.notification.PlayerJoinedNotification;
import tools.aqua.bgw.net.common.notification.PlayerLeftNotification;
import tools.aqua.bgw.net.common.request.CreateGameMessage;
import tools.aqua.bgw.net.common.request.JoinGameMessage;
import tools.aqua.bgw.net.common.request.LeaveGameMessage;
import tools.aqua.bgw.net.common.request.Request;
import tools.aqua.bgw.net.common.response.CreateGameResponse;
import tools.aqua.bgw.net.common.response.GameActionResponse;
import tools.aqua.bgw.net.common.response.JoinGameResponse;
import tools.aqua.bgw.net.common.response.LeaveGameResponse;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B)\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0015H\u0002J\u0006\u0010\u001f\u001a\u00020\u0015J\u0016\u0010 \u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u0003J\u001e\u0010 \u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u0003J\u0006\u0010$\u001a\u00020\u001dJ\u0015\u0010%\u001a\u00020\u001d2\u0006\u0010&\u001a\u00020'H\u0000\u00a2\u0006\u0002\b(J\u0016\u0010)\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u0003J\u000e\u0010*\u001a\u00020\u001d2\u0006\u0010+\u001a\u00020\u0003J \u0010,\u001a\u00020\u001d2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u00032\u0006\u00100\u001a\u00020\u0015H\u0016J\u0010\u00101\u001a\u00020\u001d2\u0006\u00102\u001a\u000203H\u0016J\u0010\u00104\u001a\u00020\u001d2\u0006\u00105\u001a\u000206H\u0016J\u0018\u00107\u001a\u00020\u001d2\u0006\u0010&\u001a\u00020\f2\u0006\u00108\u001a\u00020\u0003H\u0016J\u0010\u00109\u001a\u00020\u001d2\u0006\u00102\u001a\u00020:H\u0016J\u0010\u0010;\u001a\u00020\u001d2\u0006\u00102\u001a\u00020<H\u0016J\u0010\u0010=\u001a\u00020\u001d2\u0006\u00102\u001a\u00020>H\u0016J\b\u0010?\u001a\u00020\u001dH\u0016J\u0010\u0010@\u001a\u00020\u001d2\u0006\u0010A\u001a\u00020BH\u0016J\u0010\u0010C\u001a\u00020\u001d2\u0006\u0010A\u001a\u00020DH\u0016J\u000e\u0010E\u001a\u00020\u001d2\u0006\u0010F\u001a\u00020\fR\u001e\u0010\t\u001a\u0012\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\r\u001a\u0018\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0011R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006G"}, d2={"Ltools/aqua/bgw/net/client/BoardGameClient;", "", "playerName", "", "host", "secret", "networkLoggingBehavior", "Ltools/aqua/bgw/net/client/NetworkLogging;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ltools/aqua/bgw/net/client/NetworkLogging;)V", "gameActionClasses", "", "Ljava/lang/Class;", "Ltools/aqua/bgw/net/common/GameAction;", "gameActionReceivers", "", "Ljava/lang/reflect/Method;", "getHost", "()Ljava/lang/String;", "initializationJob", "Lkotlinx/coroutines/Job;", "isOpen", "", "()Z", "logger", "Ltools/aqua/bgw/net/client/NetworkLogger;", "getPlayerName", "wsClient", "Ltools/aqua/bgw/net/client/BGWWebSocketClient;", "checkConnected", "", "expectedState", "connect", "createGame", "gameID", "greetingMessage", "sessionID", "disconnect", "invokeAnnotatedReceiver", "message", "Ltools/aqua/bgw/net/common/message/GameActionMessage;", "invokeAnnotatedReceiver$bgw_net_client", "joinGame", "leaveGame", "goodbyeMessage", "onClose", "code", "", "reason", "remote", "onCreateGameResponse", "response", "Ltools/aqua/bgw/net/common/response/CreateGameResponse;", "onError", "throwable", "", "onGameActionReceived", "sender", "onGameActionResponse", "Ltools/aqua/bgw/net/common/response/GameActionResponse;", "onJoinGameResponse", "Ltools/aqua/bgw/net/common/response/JoinGameResponse;", "onLeaveGameResponse", "Ltools/aqua/bgw/net/common/response/LeaveGameResponse;", "onOpen", "onPlayerJoined", "notification", "Ltools/aqua/bgw/net/common/notification/PlayerJoinedNotification;", "onPlayerLeft", "Ltools/aqua/bgw/net/common/notification/PlayerLeftNotification;", "sendGameActionMessage", "payload", "bgw-net-client"})
public class BoardGameClient {
    @NotNull
    private final String playerName;
    @NotNull
    private final String host;
    @NotNull
    private final BGWWebSocketClient wsClient;
    @Nullable
    private Set<? extends Class<? extends GameAction>> gameActionClasses;
    @Nullable
    private Map<Class<? extends GameAction>, Method> gameActionReceivers;
    @NotNull
    private final Job initializationJob;
    @NotNull
    private final NetworkLogger logger;

    protected BoardGameClient(@NotNull String playerName, @NotNull String host, @NotNull String secret, @NotNull NetworkLogging networkLoggingBehavior) {
        Intrinsics.checkNotNullParameter((Object)playerName, (String)"playerName");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)secret, (String)"secret");
        Intrinsics.checkNotNullParameter((Object)((Object)networkLoggingBehavior), (String)"networkLoggingBehavior");
        this.playerName = playerName;
        this.host = host;
        this.logger = new NetworkLogger(networkLoggingBehavior);
        this.logger.info("Initializing BoardGameClient on host " + this.host + ".");
        URI uRI = URI.create("ws://" + this.host);
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"create(\"ws://$host\")");
        this.wsClient = new BGWWebSocketClient(uRI, this.playerName, secret, this, this.logger);
        this.logger.debug("Initializing annotated receiver functions.");
        this.initializationJob = BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ BoardGameClient this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        boolean bl;
                        Object it;
                        Map $this$forEach$iv;
                        ResultKt.throwOnFailure((Object)object);
                        Set annotatedClasses = GameActionClassProcessor.INSTANCE.getAnnotatedClasses();
                        Map annotatedFunctions = GameActionReceiverProcessor.INSTANCE.getAnnotatedReceivers(this.this$0.getClass(), annotatedClasses);
                        this.this$0.gameActionClasses = annotatedClasses;
                        this.this$0.gameActionReceivers = annotatedFunctions;
                        this.this$0.logger.debug("Found the following GameActionClasses:");
                        Iterable iterable = annotatedClasses;
                        BoardGameClient boardGameClient = this.this$0;
                        boolean $i$f$forEach = false;
                        Iterator<Object> iterator = $this$forEach$iv.iterator();
                        while (iterator.hasNext()) {
                            Object t = iterator.next();
                            it = (Class)t;
                            bl = false;
                            NetworkLogger networkLogger = boardGameClient.logger;
                            String string = ((Class)it).getName();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
                            networkLogger.debug(string);
                        }
                        this.this$0.logger.debug("Found the following GameActionReceivers:");
                        $this$forEach$iv = annotatedFunctions;
                        boardGameClient = this.this$0;
                        $i$f$forEach = false;
                        for (Map.Entry entry : $this$forEach$iv.entrySet()) {
                            it = entry;
                            bl = false;
                            NetworkLogger networkLogger = boardGameClient.logger;
                            String string = ((Method)it.getValue()).getName();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.value.name");
                            networkLogger.debug(string);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public /* synthetic */ BoardGameClient(String string, String string2, String string3, NetworkLogging networkLogging, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            networkLogging = NetworkLogging.NO_LOGGING;
        }
        this(string, string2, string3, networkLogging);
    }

    @NotNull
    public final String getPlayerName() {
        return this.playerName;
    }

    @NotNull
    public final String getHost() {
        return this.host;
    }

    public final boolean isOpen() {
        return this.wsClient.isOpen();
    }

    public final boolean connect() {
        boolean bl;
        try {
            this.checkConnected(false);
            this.logger.info("Connecting to " + this.wsClient.getURI() + ".");
            boolean result = this.wsClient.connectBlocking();
            this.logger.debug("Connection call succeeded without interruption " + (result ? "and" : "but") + " returned " + result + ".");
        }
        catch (InterruptedException e) {
            this.logger.error("Attempt to connect to " + this.wsClient.getURI() + " failed with an InterruptedException.", e);
            bl = false;
        }
        return bl;
    }

    public final void disconnect() {
        try {
            this.checkConnected(true);
            this.logger.info("Disconnecting.");
            this.wsClient.closeBlocking();
            this.logger.debug("Disconnection call succeeded without interruption.");
        }
        catch (InterruptedException e) {
            this.logger.error("Attempt to disconnect failed with an InterruptedException.", e);
        }
    }

    public final void createGame(@NotNull String gameID, @NotNull String sessionID, @NotNull String greetingMessage) {
        Intrinsics.checkNotNullParameter((Object)gameID, (String)"gameID");
        Intrinsics.checkNotNullParameter((Object)sessionID, (String)"sessionID");
        Intrinsics.checkNotNullParameter((Object)greetingMessage, (String)"greetingMessage");
        this.checkConnected(true);
        if (!(!StringsKt.isBlank((CharSequence)sessionID))) {
            boolean bl = false;
            String string = "Session ID was blank, did not create game.";
            throw new IllegalArgumentException(string.toString());
        }
        this.logger.info("Requesting creation of new game with ID \"" + gameID + "\", sessionID \"" + sessionID + "\" and greeting message \"" + greetingMessage + "\".");
        this.wsClient.sendRequest((Request)new CreateGameMessage(gameID, ((Object)StringsKt.trim((CharSequence)sessionID)).toString(), greetingMessage));
    }

    public final void createGame(@NotNull String gameID, @NotNull String greetingMessage) {
        Intrinsics.checkNotNullParameter((Object)gameID, (String)"gameID");
        Intrinsics.checkNotNullParameter((Object)greetingMessage, (String)"greetingMessage");
        this.checkConnected(true);
        this.logger.info("Requesting creation of new game with ID \"" + gameID + "\", auto sessionID and greeting message \"" + greetingMessage + "\".");
        this.wsClient.sendRequest((Request)new CreateGameMessage(gameID, null, greetingMessage));
    }

    public final void joinGame(@NotNull String sessionID, @NotNull String greetingMessage) {
        Intrinsics.checkNotNullParameter((Object)sessionID, (String)"sessionID");
        Intrinsics.checkNotNullParameter((Object)greetingMessage, (String)"greetingMessage");
        this.checkConnected(true);
        this.logger.info("Requesting joining to sessionID " + sessionID + ". Greeting message is: " + greetingMessage + ".");
        this.wsClient.sendRequest((Request)new JoinGameMessage(sessionID, greetingMessage));
    }

    public final void leaveGame(@NotNull String goodbyeMessage) {
        Intrinsics.checkNotNullParameter((Object)goodbyeMessage, (String)"goodbyeMessage");
        this.checkConnected(true);
        this.logger.info("Leaving game. Goodbye message is: " + goodbyeMessage + ".");
        this.wsClient.sendRequest((Request)new LeaveGameMessage(goodbyeMessage));
    }

    public final void sendGameActionMessage(@NotNull GameAction payload) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        this.checkConnected(true);
        this.logger.info("Sending GameActionMessage " + payload.getClass().getName());
        this.wsClient.sendGameActionMessage(payload);
    }

    public void onOpen() {
    }

    public void onClose(int code, @NotNull String reason, boolean remote) {
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
    }

    public void onError(@NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        throw throwable;
    }

    public void onPlayerJoined(@NotNull PlayerJoinedNotification notification) {
        Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
    }

    public void onPlayerLeft(@NotNull PlayerLeftNotification notification) {
        Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
    }

    public void onCreateGameResponse(@NotNull CreateGameResponse response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
    }

    public void onJoinGameResponse(@NotNull JoinGameResponse response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
    }

    public void onLeaveGameResponse(@NotNull LeaveGameResponse response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
    }

    public void onGameActionResponse(@NotNull GameActionResponse response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
    }

    public void onGameActionReceived(@NotNull GameAction message, @NotNull String sender) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
        this.logger.err("An incoming GameAction has been handled by the fallback function. Override onGameActionReceived or create dedicated handler for message type " + message.getClass().getCanonicalName() + ".");
    }

    public final void invokeAnnotatedReceiver$bgw_net_client(@NotNull GameActionMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, message, null){
            int label;
            final /* synthetic */ BoardGameClient this$0;
            final /* synthetic */ GameActionMessage $message;
            {
                this.this$0 = $receiver;
                this.$message = $message;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var10_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        if (!BoardGameClient.access$getInitializationJob$p(this.this$0).isCompleted()) {
                            BoardGameClient.access$getLogger$p(this.this$0).debug("Initialization of annotated receivers has not finished yet. Joining thread.");
                            this.label = 1;
                            v0 = BoardGameClient.access$getInitializationJob$p(this.this$0).join((Continuation)this);
                            if (v0 == var10_2) {
                                return var10_2;
                            }
                        }
                        ** GOTO lbl15
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl15:
                        // 2 sources

                        v1 = BoardGameClient.access$getGameActionClasses$p(this.this$0);
                        if (v1 == null) {
                            var4_3 = "Required value was null.";
                            throw new IllegalStateException(var4_3.toString());
                        }
                        targetClasses = v1;
                        v2 = BoardGameClient.access$getGameActionReceivers$p(this.this$0);
                        if (v2 == null) {
                            var5_6 = "Required value was null.";
                            throw new IllegalStateException(var5_6.toString());
                        }
                        targetReceivers = v2;
                        for (Class target : targetClasses) {
                            try {
                                payload = (GameAction)BoardGameClient.access$getWsClient$p(this.this$0).getMapper$bgw_net_client().readValue(this.$message.getPayload(), target);
                                v3 = (Method)targetReceivers.getOrDefault(target, targetReceivers.get(GameAction.class));
                                if (v3 == null && (v3 = ReflectJvmMapping.getJavaMethod((KFunction)((KFunction)new Function2<GameAction, String, Unit>((Object)this.this$0){

                                    public final void invoke(@NotNull GameAction p0, @NotNull String p1) {
                                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                                        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                                        ((BoardGameClient)this.receiver).onGameActionReceived(p0, p1);
                                    }
                                }))) == null) {
                                    var9_11 = "Required value was null.";
                                    throw new IllegalStateException(var9_11.toString());
                                }
                                method = v3;
                                var8_13 = new Object[]{payload, this.$message.getSender()};
                                method.invoke((Object)this.this$0, var8_13);
                                return Unit.INSTANCE;
                            }
                            catch (JsonMappingException var6_9) {
                            }
                        }
                        BoardGameClient.access$getLogger$p(this.this$0).err("Received GameActionMessage " + this.$message + " but no target class was Found. Create class annotated @GameActionClass extending GameAction in your classpath.");
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final void checkConnected(boolean expectedState) {
        if (!(this.isOpen() == expectedState)) {
            boolean bl = false;
            String string = "This BoardGameClient is " + (expectedState ? "not" : "already") + " connected to a host.";
            throw new IllegalStateException(string.toString());
        }
    }

    public static final /* synthetic */ Job access$getInitializationJob$p(BoardGameClient $this) {
        return $this.initializationJob;
    }

    public static final /* synthetic */ Set access$getGameActionClasses$p(BoardGameClient $this) {
        return $this.gameActionClasses;
    }

    public static final /* synthetic */ Map access$getGameActionReceivers$p(BoardGameClient $this) {
        return $this.gameActionReceivers;
    }

    public static final /* synthetic */ BGWWebSocketClient access$getWsClient$p(BoardGameClient $this) {
        return $this.wsClient;
    }
}

