/*
 * Decompiled with CFR 0.152.
 */
package tools.aqua.bgw.examples.maumau.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Stack;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import tools.aqua.bgw.examples.maumau.entity.CardSuit;
import tools.aqua.bgw.examples.maumau.entity.CardValue;
import tools.aqua.bgw.examples.maumau.entity.MauMauCard;
import tools.aqua.bgw.examples.maumau.entity.MauMauGame;
import tools.aqua.bgw.examples.maumau.entity.MauMauPlayer;
import tools.aqua.bgw.examples.maumau.service.network.NetworkSerialization;
import tools.aqua.bgw.examples.maumau.service.network.NetworkService;
import tools.aqua.bgw.examples.maumau.service.network.messages.MauMauGameCard;
import tools.aqua.bgw.examples.maumau.service.network.messages.MauMauInitGameAction;
import tools.aqua.bgw.examples.maumau.service.network.messages.MauMauShuffleStackGameAction;
import tools.aqua.bgw.examples.maumau.view.Refreshable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\n\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002J\u000e\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u001bJ\u0016\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\f2\u0006\u0010 \u001a\u00020\fJ*\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001b0\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020'0$H\u0002J\u0010\u0010(\u001a\u00020)2\u0006\u0010\u001f\u001a\u00020\fH\u0002JJ\u0010*\u001a\u00020\u00192\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020,2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u001b0\"2\u0006\u0010/\u001a\u00020\u001b2\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u001b0\"2\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u001b0\"H\u0002J\u000e\u0010*\u001a\u00020\u00192\u0006\u00102\u001a\u000203J\u001a\u00104\u001a\u00020\u00192\b\b\u0002\u0010+\u001a\u00020,2\b\b\u0002\u0010-\u001a\u00020,J\u000e\u00104\u001a\u00020\u00192\u0006\u0010\u0005\u001a\u00020\u0006J\u001e\u00105\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u001b2\u0006\u00106\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020\fJ \u00107\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001b2\u0006\u00106\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020\fH\u0002J \u00108\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001b2\u0006\u00106\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020\fH\u0002J \u00109\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001b2\u0006\u00106\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020\fH\u0002J\u0016\u0010:\u001a\u00020\u00192\u0006\u0010;\u001a\u00020%2\u0006\u0010\u001f\u001a\u00020\fJ\u0006\u0010<\u001a\u00020\u0019J\u000e\u0010=\u001a\u00020\u00192\u0006\u00102\u001a\u00020>R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\r\"\u0004\b\u0011\u0010\u000fR\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006?"}, d2={"Ltools/aqua/bgw/examples/maumau/service/LogicController;", "", "view", "Ltools/aqua/bgw/examples/maumau/view/Refreshable;", "(Ltools/aqua/bgw/examples/maumau/view/Refreshable;)V", "game", "Ltools/aqua/bgw/examples/maumau/entity/MauMauGame;", "getGame", "()Ltools/aqua/bgw/examples/maumau/entity/MauMauGame;", "setGame", "(Ltools/aqua/bgw/examples/maumau/entity/MauMauGame;)V", "isHost", "", "()Z", "setHost", "(Z)V", "isOnline", "setOnline", "networkService", "Ltools/aqua/bgw/examples/maumau/service/network/NetworkService;", "getNetworkService", "()Ltools/aqua/bgw/examples/maumau/service/network/NetworkService;", "getView", "()Ltools/aqua/bgw/examples/maumau/view/Refreshable;", "advanceSwapPlayers", "", "calculateHint", "Ltools/aqua/bgw/examples/maumau/entity/MauMauCard;", "checkRules", "card", "drawCard", "isCurrentPlayer", "advance", "generateMauMauCards", "", "suits", "Ljava/util/EnumSet;", "Ltools/aqua/bgw/examples/maumau/entity/CardSuit;", "values", "Ltools/aqua/bgw/examples/maumau/entity/CardValue;", "getPlayer", "Ltools/aqua/bgw/examples/maumau/entity/MauMauPlayer;", "initGame", "player1", "", "player2", "drawStack", "gameStack", "hostCards", "opponentCards", "message", "Ltools/aqua/bgw/examples/maumau/service/network/messages/MauMauInitGameAction;", "newGame", "playCard", "animated", "playJackEffect", "playNoEffect", "playSevenEffect", "selectSuit", "suit", "showHint", "shuffleStack", "Ltools/aqua/bgw/examples/maumau/service/network/messages/MauMauShuffleStackGameAction;", "bgw-maumau-example"})
public final class LogicController {
    @NotNull
    private final Refreshable view;
    @NotNull
    private MauMauGame game;
    @NotNull
    private final NetworkService networkService;
    private boolean isHost;
    private boolean isOnline;

    public LogicController(@NotNull Refreshable view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        this.view = view;
        this.game = new MauMauGame(null, null, 3, null);
        this.networkService = new NetworkService(this);
    }

    @NotNull
    public final Refreshable getView() {
        return this.view;
    }

    @NotNull
    public final MauMauGame getGame() {
        return this.game;
    }

    public final void setGame(@NotNull MauMauGame mauMauGame) {
        Intrinsics.checkNotNullParameter((Object)mauMauGame, (String)"<set-?>");
        this.game = mauMauGame;
    }

    @NotNull
    public final NetworkService getNetworkService() {
        return this.networkService;
    }

    public final boolean isHost() {
        return this.isHost;
    }

    public final void setHost(boolean bl) {
        this.isHost = bl;
    }

    public final boolean isOnline() {
        return this.isOnline;
    }

    public final void setOnline(boolean bl) {
        this.isOnline = bl;
    }

    public final void newGame(@NotNull MauMauGame game) {
        Intrinsics.checkNotNullParameter((Object)game, (String)"game");
        this.newGame(game.getPlayers().get(0).getName(), game.getPlayers().get(1).getName());
    }

    public final void newGame(@NotNull String player1, @NotNull String player2) {
        Intrinsics.checkNotNullParameter((Object)player1, (String)"player1");
        Intrinsics.checkNotNullParameter((Object)player2, (String)"player2");
        List cards = CollectionsKt.shuffled((Iterable)this.generateMauMauCards(CardSuit.Companion.allSuits(), CardValue.Companion.shortDeck()));
        this.initGame(player1, player2, cards.subList(11, cards.size()), (MauMauCard)cards.get(0), cards.subList(1, 6), cards.subList(6, 11));
        this.networkService.sendInit(this.game);
    }

    public static /* synthetic */ void newGame$default(LogicController logicController, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = "Player 1";
        }
        if ((n & 2) != 0) {
            string2 = "Player 2";
        }
        logicController.newGame(string, string2);
    }

    private final void initGame(String player1, String player2, List<MauMauCard> drawStack, MauMauCard gameStack, List<MauMauCard> hostCards, List<MauMauCard> opponentCards) {
        this.game = new MauMauGame(player1, player2);
        this.game.getMauMauCards().addAll(CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)drawStack, (Object)gameStack), (Iterable)hostCards), (Iterable)opponentCards));
        this.game.getDrawStack().getCards().addAll((Collection<MauMauCard>)drawStack);
        this.game.getGameStack().getCards().add(gameStack);
        this.game.setNextSuit(gameStack.getCardSuit());
        this.game.getPlayers().get(0).getHand().getCards().addAll((Collection<MauMauCard>)(this.isHost ? hostCards : opponentCards));
        this.game.getPlayers().get(1).getHand().getCards().addAll((Collection<MauMauCard>)(!this.isHost ? hostCards : opponentCards));
        this.view.refreshAll();
    }

    public final void initGame(@NotNull MauMauInitGameAction message) {
        Collection<MauMauCard> collection;
        Collection<MauMauCard> collection2;
        MauMauGameCard it;
        Collection<MauMauCard> collection3;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)((Object)message), (String)"message");
        Iterable iterable = message.getDrawStack();
        String string = "Opponent";
        String string2 = "Host";
        LogicController logicController = this;
        boolean $i$f$map = false;
        void var4_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            MauMauGameCard mauMauGameCard = (MauMauGameCard)item$iv$iv;
            collection3 = destination$iv$iv;
            boolean bl = false;
            collection3.add(NetworkSerialization.INSTANCE.deserialize(it));
        }
        collection3 = (List)destination$iv$iv;
        $this$map$iv = message.getHostCards();
        MauMauCard mauMauCard = NetworkSerialization.INSTANCE.deserialize(message.getGameStack());
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (MauMauGameCard)item$iv$iv;
            collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(NetworkSerialization.INSTANCE.deserialize(it));
        }
        collection2 = (List)destination$iv$iv;
        $this$map$iv = message.getYourCards();
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (MauMauGameCard)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(NetworkSerialization.INSTANCE.deserialize(it));
        }
        collection = (List)destination$iv$iv;
        logicController.initGame(string2, string, (List<MauMauCard>)collection3, mauMauCard, (List<MauMauCard>)collection2, (List<MauMauCard>)collection);
    }

    /*
     * WARNING - void declaration
     */
    public final void shuffleStack(@NotNull MauMauShuffleStackGameAction message) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)((Object)message), (String)"message");
        this.game.getDrawStack().getCards().clear();
        Iterable iterable = message.getDrawStack();
        Stack<MauMauCard> stack = this.game.getDrawStack().getCards();
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            MauMauGameCard mauMauGameCard = (MauMauGameCard)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(NetworkSerialization.INSTANCE.deserialize((MauMauGameCard)it));
        }
        stack.addAll((List)destination$iv$iv);
        this.game.getGameStack().getCards().clear();
        this.game.getGameStack().getCards().add(NetworkSerialization.INSTANCE.deserialize(message.getGameStack()));
    }

    public final void drawCard(boolean isCurrentPlayer, boolean advance) {
        MauMauPlayer player = this.getPlayer(isCurrentPlayer);
        MauMauCard card = this.game.getDrawStack().drawCard();
        player.getHand().addCard(card);
        this.view.refreshCardDrawn(card, isCurrentPlayer);
        if (this.isOnline && isCurrentPlayer) {
            this.networkService.sendCardDrawn();
        }
        if (this.game.getDrawStack().isEmpty()) {
            this.game.shuffleGameStackBack();
            this.view.refreshGameStackShuffledBack();
            this.networkService.sendStackShuffled(this.game);
        }
        if (advance) {
            if (this.isOnline) {
                this.networkService.sendEndTurn();
                this.view.refreshAdvanceOnlinePlayer();
            } else {
                this.advanceSwapPlayers();
            }
        }
    }

    public final void selectSuit(@NotNull CardSuit suit, boolean isCurrentPlayer) {
        Intrinsics.checkNotNullParameter((Object)((Object)suit), (String)"suit");
        this.game.setNextSuit(suit);
        this.view.refreshSuitSelected();
        if (isCurrentPlayer) {
            if (this.isOnline) {
                this.networkService.sendSuitSelected(suit);
                this.networkService.sendEndTurn();
                this.view.refreshAdvanceOnlinePlayer();
            } else {
                this.advanceSwapPlayers();
            }
        }
    }

    public final boolean playCard(@NotNull MauMauCard card, boolean animated, boolean isCurrentPlayer) {
        Intrinsics.checkNotNullParameter((Object)card, (String)"card");
        if (isCurrentPlayer && !this.checkRules(card)) {
            return false;
        }
        MauMauPlayer player = this.getPlayer(isCurrentPlayer);
        boolean isAdvancing = true;
        player.getHand().removeCard(card);
        if (isCurrentPlayer) {
            this.networkService.sendCardPlayed(card);
        }
        switch (WhenMappings.$EnumSwitchMapping$0[card.getCardValue().ordinal()]) {
            case 1: {
                this.playSevenEffect(card, animated, isCurrentPlayer);
                break;
            }
            case 2: {
                this.playNoEffect(card, animated, isCurrentPlayer);
                isAdvancing = false;
                break;
            }
            case 3: {
                this.playJackEffect(card, animated, isCurrentPlayer);
                isAdvancing = false;
                break;
            }
            default: {
                this.playNoEffect(card, animated, isCurrentPlayer);
            }
        }
        if (isCurrentPlayer) {
            if (player.getHand().getCards().isEmpty()) {
                this.networkService.sendEndGame();
                this.view.refreshEndGame(player.getName());
                return true;
            }
            if (isAdvancing) {
                if (this.isOnline) {
                    this.networkService.sendEndTurn();
                    this.view.refreshAdvanceOnlinePlayer();
                } else {
                    this.advanceSwapPlayers();
                }
            } else {
                this.view.refreshPlayAgain();
            }
        }
        return true;
    }

    private final void playNoEffect(MauMauCard card, boolean animated, boolean isCurrentPlayer) {
        this.game.setNextSuit(card.getCardSuit());
        this.game.getGameStack().playCard(card);
        this.view.refreshCardPlayed(card, animated, isCurrentPlayer);
    }

    private final void playJackEffect(MauMauCard card, boolean animated, boolean isCurrentPlayer) {
        this.playNoEffect(card, animated, isCurrentPlayer);
        if (isCurrentPlayer) {
            this.view.showJackEffectSelection();
        }
    }

    private final void playSevenEffect(MauMauCard card, boolean animated, boolean isCurrentPlayer) {
        this.playNoEffect(card, animated, isCurrentPlayer);
        if (isCurrentPlayer) {
            if (this.isOnline) {
                this.networkService.sendDrawTwoRequest();
            } else {
                this.drawCard(false, false);
                this.drawCard(false, false);
            }
        }
    }

    public final boolean checkRules(@NotNull MauMauCard card) {
        Intrinsics.checkNotNullParameter((Object)card, (String)"card");
        return card.getCardValue() == CardValue.JACK || card.getCardSuit() == this.game.getNextSuit() || card.getCardValue() == this.game.getGameStack().peek().getCardValue();
    }

    public final void showHint() {
        MauMauCard card = this.calculateHint();
        if (card == null) {
            this.view.refreshHintDrawCard();
        } else {
            this.view.refreshHintPlayCard(card);
        }
    }

    private final void advanceSwapPlayers() {
        CollectionsKt.reverse(this.game.getPlayers());
        this.view.refreshSwapPlayers();
    }

    private final MauMauCard calculateHint() {
        MauMauCard it;
        Iterable $this$filterTo$iv$iv;
        ArrayList<MauMauCard> cards = this.getPlayer(true).getHand().getCards();
        Iterable $this$filter$iv = cards;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (MauMauCard)element$iv$iv;
            boolean bl = false;
            if (!(it.getCardValue() == CardValue.EIGHT && this.checkRules(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List hint = (List)destination$iv$iv;
        if (!((Collection)hint).isEmpty()) {
            return (MauMauCard)CollectionsKt.first((List)hint);
        }
        $this$filter$iv = cards;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (MauMauCard)element$iv$iv;
            boolean bl = false;
            if (!(it.getCardValue() == CardValue.SEVEN && this.checkRules(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        hint = (List)destination$iv$iv;
        if (!((Collection)hint).isEmpty()) {
            return (MauMauCard)CollectionsKt.first((List)hint);
        }
        $this$filter$iv = cards;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (MauMauCard)element$iv$iv;
            boolean bl = false;
            if (!(it.getCardValue() != CardValue.JACK && this.checkRules(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        hint = (List)destination$iv$iv;
        if (!((Collection)hint).isEmpty()) {
            return (MauMauCard)CollectionsKt.first((List)hint);
        }
        $this$filter$iv = cards;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (MauMauCard)element$iv$iv;
            boolean bl = false;
            if (!(it.getCardValue() == CardValue.JACK && this.checkRules(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        hint = (List)destination$iv$iv;
        if (!((Collection)hint).isEmpty()) {
            return (MauMauCard)CollectionsKt.first((List)hint);
        }
        return null;
    }

    private final MauMauPlayer getPlayer(boolean isCurrentPlayer) {
        return this.game.getPlayers().get(isCurrentPlayer ? 0 : 1);
    }

    private final List<MauMauCard> generateMauMauCards(EnumSet<CardSuit> suits, EnumSet<CardValue> values) {
        List cards = new ArrayList(suits.size() * values.size());
        for (CardSuit suit : suits) {
            for (CardValue value : values) {
                Intrinsics.checkNotNullExpressionValue((Object)((Object)value), (String)"value");
                Intrinsics.checkNotNullExpressionValue((Object)((Object)suit), (String)"suit");
                cards.add(new MauMauCard(value, suit));
            }
        }
        return cards;
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CardValue.values().length];
            nArray[CardValue.SEVEN.ordinal()] = 1;
            nArray[CardValue.EIGHT.ordinal()] = 2;
            nArray[CardValue.JACK.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

