/*
 * Decompiled with CFR 0.152.
 */
package tools.aqua.bgw.examples.maumau.view;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tools.aqua.bgw.animation.Animation;
import tools.aqua.bgw.animation.DelayAnimation;
import tools.aqua.bgw.animation.FlipAnimation;
import tools.aqua.bgw.animation.MovementAnimation;
import tools.aqua.bgw.components.ComponentView;
import tools.aqua.bgw.components.DynamicComponentView;
import tools.aqua.bgw.components.container.CardStack;
import tools.aqua.bgw.components.container.GameComponentContainer;
import tools.aqua.bgw.components.container.LinearLayout;
import tools.aqua.bgw.components.gamecomponentviews.CardView;
import tools.aqua.bgw.components.gamecomponentviews.GameComponentView;
import tools.aqua.bgw.core.BoardGameApplication;
import tools.aqua.bgw.core.Color;
import tools.aqua.bgw.core.MenuScene;
import tools.aqua.bgw.core.Scene;
import tools.aqua.bgw.dialog.ButtonType;
import tools.aqua.bgw.dialog.Dialog;
import tools.aqua.bgw.dialog.DialogType;
import tools.aqua.bgw.event.AnimationFinishedEvent;
import tools.aqua.bgw.event.DragEvent;
import tools.aqua.bgw.event.DropEvent;
import tools.aqua.bgw.event.MouseEvent;
import tools.aqua.bgw.examples.maumau.entity.MauMauCard;
import tools.aqua.bgw.examples.maumau.entity.MauMauGame;
import tools.aqua.bgw.examples.maumau.view.MauMauViewController;
import tools.aqua.bgw.examples.maumau.view.Refreshable;
import tools.aqua.bgw.examples.maumau.view.scenes.MauMauPlayerWonScene;
import tools.aqua.bgw.examples.maumau.view.scenes.MauMauWaitForOpponentMenuScene;
import tools.aqua.bgw.util.BidirectionalMap;
import tools.aqua.bgw.visual.ColorVisual;
import tools.aqua.bgw.visual.CompoundVisual;
import tools.aqua.bgw.visual.ImageVisual;
import tools.aqua.bgw.visual.SingleLayerVisual;
import tools.aqua.bgw.visual.Visual;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0012\u001a\u00020\u000bH\u0016J\b\u0010\u0013\u001a\u00020\u000bH\u0016J\b\u0010\u0014\u001a\u00020\u000bH\u0016J\b\u0010\u0015\u001a\u00020\u000bH\u0016J\u0010\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u000bH\u0016J\b\u0010\u001b\u001a\u00020\u000bH\u0016J\b\u0010\u001c\u001a\u00020\u000bH\u0016J\b\u0010\u001d\u001a\u00020\u000bH\u0016J\b\u0010\u001e\u001a\u00020\u000bH\u0002J\u0018\u0010\u001f\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020\u00192\u0006\u0010!\u001a\u00020\u0019H\u0016J\u0012\u0010\"\u001a\u00020\u000b2\b\u0010#\u001a\u0004\u0018\u00010\u0019H\u0016J\b\u0010$\u001a\u00020\u000bH\u0016J\u0010\u0010%\u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\u0019H\u0016J\u0010\u0010&\u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\u0019H\u0016J\b\u0010'\u001a\u00020\u000bH\u0016J\b\u0010(\u001a\u00020\u000bH\u0016J\b\u0010)\u001a\u00020\u000bH\u0016J\u0010\u0010*\u001a\u00020\u000b2\u0006\u0010+\u001a\u00020\u0019H\u0016J\u0010\u0010,\u001a\u00020\u000b2\u0006\u0010+\u001a\u00020\u0019H\u0016J\b\u0010-\u001a\u00020\u000bH\u0016J\f\u0010.\u001a\u00020\u000b*\u00020/H\u0002J\f\u00100\u001a\u00020\u000b*\u00020/H\u0002J\f\u00101\u001a\u00020\u000b*\u00020/H\u0002J\f\u00102\u001a\u00020\u000b*\u00020/H\u0002J\u0010\u0010\u0014\u001a\u00020\u000b2\u0006\u00103\u001a\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Ltools/aqua/bgw/examples/maumau/view/RefreshViewController;", "Ltools/aqua/bgw/examples/maumau/view/Refreshable;", "viewController", "Ltools/aqua/bgw/examples/maumau/view/MauMauViewController;", "<init>", "(Ltools/aqua/bgw/examples/maumau/view/MauMauViewController;)V", "image", "Ljava/awt/image/BufferedImage;", "hintOverlay", "Ltools/aqua/bgw/visual/ColorVisual;", "refreshCardDrawn", "", "card", "Ltools/aqua/bgw/examples/maumau/entity/MauMauCard;", "isCurrentPlayer", "", "refreshCardPlayed", "animated", "refreshGameStackShuffledBack", "refreshPlayAgain", "showJackEffectSelection", "refreshHintDrawCard", "refreshHintPlayCard", "refreshEndGame", "playerWon", "", "refreshAdvanceOnlinePlayer", "refreshSwapPlayers", "refreshSuitSelected", "refreshAll", "refreshHands", "showConnectWarningDialog", "title", "message", "onCreateGameSuccess", "sessionID", "onJoinGameSuccess", "onCreateGameError", "onJoinGameError", "onInitializeGameReceived", "onShuffleStackReceived", "refreshEndTurn", "onUserJoined", "sender", "onUserLeft", "onServerError", "addInteraction", "Ltools/aqua/bgw/components/gamecomponentviews/CardView;", "removeInteraction", "addSneakInteraction", "removeSneakInteraction", "visible", "bgw-maumau-example"})
@SourceDebugExtension(value={"SMAP\nRefreshViewController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RefreshViewController.kt\ntools/aqua/bgw/examples/maumau/view/RefreshViewController\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,513:1\n1557#2:514\n1628#2,3:515\n2642#2:518\n1557#2:521\n1628#2,3:522\n1557#2:525\n1628#2,3:526\n1863#2,2:529\n1863#2,2:531\n1557#2:533\n1628#2,3:534\n1557#2:537\n1628#2,3:538\n1#3:519\n1#3:520\n*S KotlinDebug\n*F\n+ 1 RefreshViewController.kt\ntools/aqua/bgw/examples/maumau/view/RefreshViewController\n*L\n140#1:514\n140#1:515,3\n141#1:518\n284#1:521\n284#1:522,3\n290#1:525\n290#1:526,3\n326#1:529,2\n330#1:531,2\n395#1:533\n395#1:534,3\n401#1:537\n401#1:538,3\n141#1:519\n*E\n"})
public final class RefreshViewController
implements Refreshable {
    @NotNull
    private final MauMauViewController viewController;
    @NotNull
    private final BufferedImage image;
    @Nullable
    private ColorVisual hintOverlay;

    public RefreshViewController(@NotNull MauMauViewController viewController) {
        Intrinsics.checkNotNullParameter((Object)((Object)viewController), (String)"viewController");
        this.viewController = viewController;
        BufferedImage bufferedImage = ImageIO.read(this.getClass().getClassLoader().getResource("assets/card_deck.png"));
        Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"read(...)");
        this.image = bufferedImage;
    }

    @Override
    public void refreshCardDrawn(@NotNull MauMauCard card, boolean isCurrentPlayer) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)card, (String)"card");
            LinearLayout<CardView> playerHandView = isCurrentPlayer ? this.viewController.getMauMauGameScene().getCurrentPlayerHand() : this.viewController.getMauMauGameScene().getOtherPlayerHand();
            CardView cardView = (CardView)this.viewController.getCardMap().forward((Object)card);
            this.viewController.getMauMauGameScene().getDrawStack().remove((DynamicComponentView)cardView);
            GameComponentContainer.add$default((GameComponentContainer)((GameComponentContainer)playerHandView), (DynamicComponentView)((DynamicComponentView)cardView), (int)0, (int)2, null);
            if (isCurrentPlayer) {
                cardView.showFront();
            }
            this.viewController.getMauMauGameScene().getDrawStackInfo().setText(String.valueOf(this.viewController.getLogicController().getGame().getDrawStack().size()));
            if (isCurrentPlayer) {
                this.addInteraction(cardView);
            } else {
                this.addSneakInteraction(cardView);
            }
            this.showJackEffectSelection(false);
            ColorVisual colorVisual = this.hintOverlay;
            if (colorVisual == null) break block3;
            colorVisual.setTransparency(0.0);
        }
    }

    @Override
    public void refreshCardPlayed(@NotNull MauMauCard card, boolean animated, boolean isCurrentPlayer) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)card, (String)"card");
            CardView cardView = (CardView)this.viewController.getCardMap().forward((Object)card);
            LinearLayout<CardView> hand = isCurrentPlayer ? this.viewController.getMauMauGameScene().getCurrentPlayerHand() : this.viewController.getMauMauGameScene().getOtherPlayerHand();
            this.removeInteraction(cardView);
            cardView.showFront();
            this.showJackEffectSelection(false);
            if (animated) {
                MovementAnimation anim = MovementAnimation.Companion.toComponentView$default((MovementAnimation.Companion)MovementAnimation.Companion, (ComponentView)((ComponentView)cardView), (ComponentView)((ComponentView)this.viewController.getMauMauGameScene().getGameStack()), (Scene)((Scene)this.viewController.getMauMauGameScene()), (int)500, null, (int)16, null);
                anim.setOnFinished(arg_0 -> RefreshViewController.refreshCardPlayed$lambda$0(hand, cardView, this, arg_0));
                this.viewController.getMauMauGameScene().lock();
                this.viewController.getMauMauGameScene().playAnimation((Animation)anim);
            } else {
                hand.remove((DynamicComponentView)cardView);
                this.viewController.getMauMauGameScene().getGameStack().push(cardView);
                cardView.setPosX(0.0);
                cardView.setPosY(0.0);
                this.viewController.getMauMauGameScene().getGameStackInfo().setText(this.viewController.getLogicController().getGame().getGameStack().getCards().peek().getCardSuit().toString());
            }
            ColorVisual colorVisual = this.hintOverlay;
            if (colorVisual == null) break block2;
            colorVisual.setTransparency(0.0);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void refreshGameStackShuffledBack() {
        void $this$onEach$iv;
        void var3_5;
        CardView it;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Object object;
        CardStack<CardView> $this$refreshGameStackShuffledBack_u24lambda_u241 = object = this.viewController.getMauMauGameScene().getGameStack();
        boolean $i$a$-apply-RefreshViewController$refreshGameStackShuffledBack$22 = false;
        CardView saved = $this$refreshGameStackShuffledBack_u24lambda_u241.pop();
        $this$refreshGameStackShuffledBack_u24lambda_u241.clear();
        $this$refreshGameStackShuffledBack_u24lambda_u241.push(saved);
        object = this.viewController.getLogicController().getGame().getDrawStack().getCards();
        CardStack<CardView> cardStack = this.viewController.getMauMauGameScene().getDrawStack();
        boolean $i$f$map = false;
        void $i$a$-apply-RefreshViewController$refreshGameStackShuffledBack$22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            MauMauCard mauMauCard = (MauMauCard)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            BidirectionalMap<MauMauCard, CardView> bidirectionalMap = this.viewController.getCardMap();
            Intrinsics.checkNotNull((Object)it);
            collection.add((CardView)bidirectionalMap.forward((Object)it));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$onEach = false;
        void $this$onEach_u24lambda_u2419$iv = var3_5 = $this$onEach$iv;
        boolean bl = false;
        for (Object element$iv : $this$onEach_u24lambda_u2419$iv) {
            it = (CardView)element$iv;
            boolean bl2 = false;
            this.removeInteraction(it);
            it.showBack();
        }
        cardStack.addAll((Collection)var3_5);
    }

    @Override
    public void refreshPlayAgain() {
        this.viewController.getMauMauGameScene().unlock();
    }

    @Override
    public void showJackEffectSelection() {
        this.showJackEffectSelection(true);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void refreshHintDrawCard() {
        void $this$refreshHintDrawCard_u24lambda_u244;
        Visual visual = ((CardView)CollectionsKt.last((List)this.viewController.getMauMauGameScene().getDrawStack().getComponents())).getVisual();
        Intrinsics.checkNotNull((Object)visual, (String)"null cannot be cast to non-null type tools.aqua.bgw.visual.CompoundVisual");
        Object object = CollectionsKt.last((List)((CompoundVisual)visual).getChildren());
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type tools.aqua.bgw.visual.ColorVisual");
        Object object2 = object = (ColorVisual)object;
        RefreshViewController refreshViewController = this;
        boolean bl = false;
        $this$refreshHintDrawCard_u24lambda_u244.setColor(Color.Companion.getYELLOW());
        $this$refreshHintDrawCard_u24lambda_u244.setTransparency(0.5);
        refreshViewController.hintOverlay = object;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void refreshHintPlayCard(@NotNull MauMauCard card) {
        void $this$refreshHintPlayCard_u24lambda_u245;
        ColorVisual colorVisual;
        Intrinsics.checkNotNullParameter((Object)card, (String)"card");
        Visual visual = ((CardView)this.viewController.getCardMap().forward((Object)card)).getVisual();
        Intrinsics.checkNotNull((Object)visual, (String)"null cannot be cast to non-null type tools.aqua.bgw.visual.CompoundVisual");
        Object object = CollectionsKt.last((List)((CompoundVisual)visual).getChildren());
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type tools.aqua.bgw.visual.ColorVisual");
        ColorVisual colorVisual2 = colorVisual = (ColorVisual)object;
        RefreshViewController refreshViewController = this;
        boolean bl = false;
        $this$refreshHintPlayCard_u24lambda_u245.setColor(Color.Companion.getYELLOW());
        $this$refreshHintPlayCard_u24lambda_u245.setTransparency(0.5);
        refreshViewController.hintOverlay = colorVisual;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void refreshEndGame(@NotNull String playerWon) {
        void $this$refreshEndGame_u24lambda_u246;
        MauMauPlayerWonScene mauMauPlayerWonScene;
        Intrinsics.checkNotNullParameter((Object)playerWon, (String)"playerWon");
        MauMauPlayerWonScene mauMauPlayerWonScene2 = mauMauPlayerWonScene = this.viewController.getMauMauPlayerWonMenuScene();
        MauMauViewController mauMauViewController = this.viewController;
        boolean bl = false;
        $this$refreshEndGame_u24lambda_u246.setPlayerWon(playerWon);
        mauMauViewController.showMenuScene(mauMauPlayerWonScene, 2000);
    }

    @Override
    public void refreshAdvanceOnlinePlayer() {
        this.viewController.getMauMauGameScene().lock();
    }

    @Override
    public void refreshSwapPlayers() {
        DelayAnimation delayAnimation;
        this.viewController.getMauMauGameScene().lock();
        DelayAnimation $this$refreshSwapPlayers_u24lambda_u248 = delayAnimation = new DelayAnimation(1000);
        boolean bl = false;
        $this$refreshSwapPlayers_u24lambda_u248.setOnFinished(arg_0 -> RefreshViewController.refreshSwapPlayers$lambda$8$lambda$7(this, arg_0));
        DelayAnimation delay = delayAnimation;
        this.viewController.getMauMauGameScene().lock();
        this.viewController.getMauMauGameScene().playAnimation((Animation)delay);
    }

    @Override
    public void refreshSuitSelected() {
        this.viewController.getMauMauGameScene().getGameStackInfo().setText(this.viewController.getLogicController().getGame().getNextSuit().toString());
        this.showJackEffectSelection(false);
    }

    @Override
    public void refreshAll() {
        Object object;
        MauMauCard card;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        ImageVisual cardFront;
        MauMauGame game = this.viewController.getLogicController().getGame();
        ImageVisual cardBack = new ImageVisual(this.image, 130, 200, 260, 800);
        this.viewController.getCardMap().clear();
        for (MauMauCard card2 : game.getMauMauCards()) {
            cardFront = new ImageVisual(this.image, 130, 200, card2.getCardValue().ordinal() * 130, card2.getCardSuit().ordinal() * 200);
            Object object2 = new SingleLayerVisual[]{cardFront, ColorVisual.Companion.getTRANSPARENT()};
            CompoundVisual compoundVisual = new CompoundVisual((SingleLayerVisual[])object2);
            SingleLayerVisual[] singleLayerVisualArray = new SingleLayerVisual[]{cardBack, ColorVisual.Companion.getTRANSPARENT()};
            object2 = new CompoundVisual(singleLayerVisualArray);
            CardView cardView = new CardView(null, null, (Number)130, (Number)200, (Visual)compoundVisual, (Visual)object2, 3, null);
            this.viewController.getCardMap().add((Object)card2, (Object)cardView);
        }
        this.viewController.getMauMauGameScene().getDrawStack().clear();
        Iterable iterable = CollectionsKt.asReversedMutable((List)game.getDrawStack().getCards());
        CardStack<CardView> cardStack = this.viewController.getMauMauGameScene().getDrawStack();
        boolean $i$f$map = false;
        cardFront = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            MauMauCard mauMauCard = (MauMauCard)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            BidirectionalMap<MauMauCard, CardView> bidirectionalMap = this.viewController.getCardMap();
            Intrinsics.checkNotNull((Object)card);
            object = bidirectionalMap.forward((Object)card);
            CardView $this$refreshAll_u24lambda_u2410_u24lambda_u249 = (CardView)object;
            boolean bl2 = false;
            $this$refreshAll_u24lambda_u2410_u24lambda_u249.showBack();
            collection.add((CardView)object);
        }
        cardStack.addAll((Collection)((List)destination$iv$iv));
        this.viewController.getMauMauGameScene().getGameStack().clear();
        $this$map$iv = CollectionsKt.asReversedMutable((List)game.getGameStack().getCards());
        cardStack = this.viewController.getMauMauGameScene().getGameStack();
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            card = (MauMauCard)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            BidirectionalMap<MauMauCard, CardView> bidirectionalMap = this.viewController.getCardMap();
            Intrinsics.checkNotNull((Object)card);
            object = bidirectionalMap.forward((Object)card);
            CardView $this$refreshAll_u24lambda_u2412_u24lambda_u2411 = (CardView)object;
            boolean bl3 = false;
            $this$refreshAll_u24lambda_u2412_u24lambda_u2411.showFront();
            collection.add((CardView)object);
        }
        cardStack.addAll((Collection)((List)destination$iv$iv));
        this.viewController.getMauMauGameScene().getDrawStackInfo().setText(String.valueOf(this.viewController.getLogicController().getGame().getDrawStack().size()));
        this.viewController.getMauMauGameScene().getGameStackInfo().setText(this.viewController.getLogicController().getGame().getGameStack().getCards().peek().getCardSuit().toString());
        this.refreshHands();
        this.showJackEffectSelection(false);
    }

    /*
     * WARNING - void declaration
     */
    private final void refreshHands() {
        CardView $this$refreshHands_u24lambda_u2413;
        GameComponentContainer gameComponentContainer;
        Iterator iterator;
        int i;
        MauMauGame game = this.viewController.getLogicController().getGame();
        this.viewController.getMauMauGameScene().getCurrentPlayerHand().clear();
        this.viewController.getMauMauGameScene().getOtherPlayerHand().clear();
        int n = game.getPlayers().get(0).getHand().getCards().size();
        for (i = 0; i < n; ++i) {
            GameComponentContainer gameComponentContainer2 = (GameComponentContainer)this.viewController.getMauMauGameScene().getCurrentPlayerHand();
            BidirectionalMap<MauMauCard, CardView> bidirectionalMap = this.viewController.getCardMap();
            MauMauCard mauMauCard = game.getPlayers().get(0).getHand().getCards().get(i);
            Intrinsics.checkNotNullExpressionValue((Object)mauMauCard, (String)"get(...)");
            iterator = bidirectionalMap.forward((Object)mauMauCard);
            CardView cardView = (CardView)iterator;
            gameComponentContainer = gameComponentContainer2;
            boolean bl = false;
            $this$refreshHands_u24lambda_u2413.showFront();
            GameComponentContainer.add$default((GameComponentContainer)gameComponentContainer, (DynamicComponentView)((DynamicComponentView)iterator), (int)0, (int)2, null);
        }
        n = game.getPlayers().get(1).getHand().getCards().size();
        for (i = 0; i < n; ++i) {
            void $this$refreshHands_u24lambda_u2414;
            GameComponentContainer gameComponentContainer3 = (GameComponentContainer)this.viewController.getMauMauGameScene().getOtherPlayerHand();
            BidirectionalMap<MauMauCard, CardView> bidirectionalMap = this.viewController.getCardMap();
            MauMauCard mauMauCard = game.getPlayers().get(1).getHand().getCards().get(i);
            Intrinsics.checkNotNullExpressionValue((Object)mauMauCard, (String)"get(...)");
            iterator = bidirectionalMap.forward((Object)mauMauCard);
            $this$refreshHands_u24lambda_u2413 = (CardView)iterator;
            gameComponentContainer = gameComponentContainer3;
            boolean bl = false;
            $this$refreshHands_u24lambda_u2414.showBack();
            GameComponentContainer.add$default((GameComponentContainer)gameComponentContainer, (DynamicComponentView)((DynamicComponentView)iterator), (int)0, (int)2, null);
        }
        this.viewController.getMauMauGameScene().getCurrentPlayerName().setText(game.getPlayers().get(0).getName());
        this.viewController.getMauMauGameScene().getOtherPlayerName().setText(game.getPlayers().get(1).getName());
        Iterable $this$forEach$iv = this.viewController.getMauMauGameScene().getCurrentPlayerHand().getComponents();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CardView it = (CardView)element$iv;
            boolean bl = false;
            this.addInteraction(it);
            this.removeSneakInteraction(it);
        }
        $this$forEach$iv = this.viewController.getMauMauGameScene().getOtherPlayerHand().getComponents();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CardView it = (CardView)element$iv;
            boolean bl = false;
            this.removeInteraction(it);
            this.addSneakInteraction(it);
        }
    }

    @Override
    public void showConnectWarningDialog(@NotNull String title, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.viewController.showDialog(new Dialog(DialogType.WARNING, title, title, message, new ButtonType[0]));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onCreateGameSuccess(@Nullable String sessionID) {
        void it;
        MauMauWaitForOpponentMenuScene mauMauWaitForOpponentMenuScene;
        this.viewController.showDialogNonBlocking(new Dialog(DialogType.INFORMATION, "Session ID", "Session ID", "Session ID is " + sessionID, new ButtonType[0]));
        MauMauWaitForOpponentMenuScene mauMauWaitForOpponentMenuScene2 = mauMauWaitForOpponentMenuScene = this.viewController.getMauMauWaitForOpponentMenuScene();
        BoardGameApplication boardGameApplication = this.viewController;
        boolean bl = false;
        it.startAnimation();
        BoardGameApplication.showMenuScene$default((BoardGameApplication)boardGameApplication, (MenuScene)mauMauWaitForOpponentMenuScene, null, (int)2, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onJoinGameSuccess() {
        void it;
        MauMauWaitForOpponentMenuScene mauMauWaitForOpponentMenuScene;
        MauMauWaitForOpponentMenuScene mauMauWaitForOpponentMenuScene2 = mauMauWaitForOpponentMenuScene = this.viewController.getMauMauWaitForOpponentMenuScene();
        BoardGameApplication boardGameApplication = this.viewController;
        boolean bl = false;
        it.startAnimation();
        BoardGameApplication.showMenuScene$default((BoardGameApplication)boardGameApplication, (MenuScene)mauMauWaitForOpponentMenuScene, null, (int)2, null);
    }

    @Override
    public void onCreateGameError(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.viewController.showDialog(new Dialog(DialogType.ERROR, "Error creating game", "Error creating game", message, new ButtonType[0]));
    }

    @Override
    public void onJoinGameError(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.viewController.showDialog(new Dialog(DialogType.ERROR, "Error joining game", "Error joining game", message, new ButtonType[0]));
    }

    @Override
    public void onInitializeGameReceived() {
        MauMauViewController mauMauViewController;
        MauMauViewController $this$onInitializeGameReceived_u24lambda_u2419 = mauMauViewController = this.viewController;
        boolean bl = false;
        $this$onInitializeGameReceived_u24lambda_u2419.getMauMauGameScene().startAnimation();
        $this$onInitializeGameReceived_u24lambda_u2419.getMauMauGameScene().lock();
        BoardGameApplication.hideMenuScene$default((BoardGameApplication)$this$onInitializeGameReceived_u24lambda_u2419, null, (int)1, null);
    }

    @Override
    public void onShuffleStackReceived() {
        Object object;
        MauMauCard card;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        MauMauViewController mauMauViewController;
        MauMauViewController $this$onShuffleStackReceived_u24lambda_u2424 = mauMauViewController = this.viewController;
        boolean bl = false;
        $this$onShuffleStackReceived_u24lambda_u2424.getMauMauGameScene().getDrawStack().clear();
        Iterable iterable = CollectionsKt.asReversedMutable((List)$this$onShuffleStackReceived_u24lambda_u2424.getLogicController().getGame().getDrawStack().getCards());
        CardStack<CardView> cardStack = $this$onShuffleStackReceived_u24lambda_u2424.getMauMauGameScene().getDrawStack();
        boolean $i$f$map = false;
        void var7_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            MauMauCard mauMauCard = (MauMauCard)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            BidirectionalMap<MauMauCard, CardView> bidirectionalMap = $this$onShuffleStackReceived_u24lambda_u2424.getCardMap();
            Intrinsics.checkNotNull((Object)card);
            object = bidirectionalMap.forward((Object)card);
            CardView $this$onShuffleStackReceived_u24lambda_u2424_u24lambda_u2421_u24lambda_u2420 = (CardView)object;
            boolean bl3 = false;
            $this$onShuffleStackReceived_u24lambda_u2424_u24lambda_u2421_u24lambda_u2420.showBack();
            collection.add((CardView)object);
        }
        cardStack.addAll((Collection)((List)destination$iv$iv));
        $this$onShuffleStackReceived_u24lambda_u2424.getMauMauGameScene().getGameStack().clear();
        $this$map$iv = CollectionsKt.asReversedMutable((List)$this$onShuffleStackReceived_u24lambda_u2424.getLogicController().getGame().getGameStack().getCards());
        cardStack = $this$onShuffleStackReceived_u24lambda_u2424.getMauMauGameScene().getGameStack();
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            card = (MauMauCard)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl4 = false;
            BidirectionalMap<MauMauCard, CardView> bidirectionalMap = $this$onShuffleStackReceived_u24lambda_u2424.getCardMap();
            Intrinsics.checkNotNull((Object)card);
            object = bidirectionalMap.forward((Object)card);
            CardView $this$onShuffleStackReceived_u24lambda_u2424_u24lambda_u2423_u24lambda_u2422 = (CardView)object;
            boolean bl5 = false;
            $this$onShuffleStackReceived_u24lambda_u2424_u24lambda_u2423_u24lambda_u2422.showFront();
            collection.add((CardView)object);
        }
        cardStack.addAll((Collection)((List)destination$iv$iv));
        $this$onShuffleStackReceived_u24lambda_u2424.getMauMauGameScene().getDrawStackInfo().setText(String.valueOf($this$onShuffleStackReceived_u24lambda_u2424.getLogicController().getGame().getDrawStack().size()));
        $this$onShuffleStackReceived_u24lambda_u2424.getMauMauGameScene().getGameStackInfo().setText($this$onShuffleStackReceived_u24lambda_u2424.getLogicController().getGame().getGameStack().getCards().peek().getCardSuit().toString());
    }

    @Override
    public void refreshEndTurn() {
        this.viewController.getMauMauGameScene().unlock();
    }

    @Override
    public void onUserJoined(@NotNull String sender) {
        Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
        this.viewController.getMauMauWaitForOpponentMenuScene().onOpponentConnected(sender);
    }

    @Override
    public void onUserLeft(@NotNull String sender) {
        Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
        System.out.println((Object)(sender + " left."));
    }

    @Override
    public void onServerError() {
        throw new IllegalStateException("Server error".toString());
    }

    private final void addInteraction(CardView $this$addInteraction) {
        $this$addInteraction.setDraggable(true);
        Ref.ObjectRef overlay = new Ref.ObjectRef();
        $this$addInteraction.setOnDragGestureStarted(arg_0 -> RefreshViewController.addInteraction$lambda$26(overlay, this, $this$addInteraction, arg_0));
        $this$addInteraction.setOnDragGestureEnded((arg_0, arg_1) -> RefreshViewController.addInteraction$lambda$27(overlay, arg_0, arg_1));
        $this$addInteraction.setOnMouseClicked(arg_0 -> RefreshViewController.addInteraction$lambda$28(this, $this$addInteraction, arg_0));
    }

    private final void removeInteraction(CardView $this$removeInteraction) {
        $this$removeInteraction.setDraggable(false);
        $this$removeInteraction.setOnMouseClicked(null);
        $this$removeInteraction.setOnMouseEntered(null);
        $this$removeInteraction.setOnMouseExited(null);
    }

    private final void addSneakInteraction(CardView $this$addSneakInteraction) {
        $this$addSneakInteraction.setOnMouseEntered(arg_0 -> RefreshViewController.addSneakInteraction$lambda$29(this, $this$addSneakInteraction, arg_0));
        $this$addSneakInteraction.setOnMouseExited(arg_0 -> RefreshViewController.addSneakInteraction$lambda$30(this, $this$addSneakInteraction, arg_0));
    }

    private final void removeSneakInteraction(CardView $this$removeSneakInteraction) {
        $this$removeSneakInteraction.setOnMouseEntered(null);
        $this$removeSneakInteraction.setOnMouseExited(null);
    }

    private final void showJackEffectSelection(boolean visible) {
        this.viewController.getMauMauGameScene().getButtonDiamonds().setVisible(visible);
        this.viewController.getMauMauGameScene().getButtonHearts().setVisible(visible);
        this.viewController.getMauMauGameScene().getButtonSpades().setVisible(visible);
        this.viewController.getMauMauGameScene().getButtonClubs().setVisible(visible);
    }

    private static final Unit refreshCardPlayed$lambda$0(LinearLayout $hand, CardView $cardView, RefreshViewController this$0, AnimationFinishedEvent it) {
        Intrinsics.checkNotNullParameter((Object)$hand, (String)"$hand");
        Intrinsics.checkNotNullParameter((Object)$cardView, (String)"$cardView");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $hand.remove((DynamicComponentView)$cardView);
        GameComponentContainer.add$default((GameComponentContainer)((GameComponentContainer)this$0.viewController.getMauMauGameScene().getGameStack()), (DynamicComponentView)((DynamicComponentView)$cardView), (int)0, (int)2, null);
        $cardView.setPosX(0.0);
        $cardView.setPosY(0.0);
        this$0.viewController.getMauMauGameScene().getGameStackInfo().setText(this$0.viewController.getLogicController().getGame().getGameStack().getCards().peek().getCardSuit().toString());
        return Unit.INSTANCE;
    }

    private static final Unit refreshSwapPlayers$lambda$8$lambda$7(RefreshViewController this$0, AnimationFinishedEvent it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.refreshHands();
        this$0.viewController.getMauMauGameScene().unlock();
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit addInteraction$lambda$26(Ref.ObjectRef $overlay, RefreshViewController this$0, CardView $this_addInteraction, DragEvent it) {
        void $this$addInteraction_u24lambda_u2426_u24lambda_u2425;
        Intrinsics.checkNotNullParameter((Object)$overlay, (String)"$overlay");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$this_addInteraction, (String)"$this_addInteraction");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Visual visual = ((CardView)CollectionsKt.last((List)this$0.viewController.getMauMauGameScene().getGameStack().getComponents())).getVisual();
        Intrinsics.checkNotNull((Object)visual, (String)"null cannot be cast to non-null type tools.aqua.bgw.visual.CompoundVisual");
        Object object = CollectionsKt.last((List)((CompoundVisual)visual).getChildren());
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type tools.aqua.bgw.visual.ColorVisual");
        Object object2 = object = (ColorVisual)object;
        Ref.ObjectRef objectRef = $overlay;
        boolean bl = false;
        $this$addInteraction_u24lambda_u2426_u24lambda_u2425.setColor(this$0.viewController.getLogicController().checkRules((MauMauCard)this$0.viewController.getCardMap().backward((Object)$this_addInteraction)) ? Color.Companion.getGREEN() : Color.Companion.getRED());
        $this$addInteraction_u24lambda_u2426_u24lambda_u2425.setTransparency(0.5);
        objectRef.element = object;
        return Unit.INSTANCE;
    }

    private static final Unit addInteraction$lambda$27(Ref.ObjectRef $overlay, DropEvent dropEvent, boolean bl) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)$overlay, (String)"$overlay");
            Intrinsics.checkNotNullParameter((Object)dropEvent, (String)"<unused var>");
            ColorVisual colorVisual = (ColorVisual)$overlay.element;
            if (colorVisual == null) break block0;
            colorVisual.setTransparency(0.0);
        }
        return Unit.INSTANCE;
    }

    private static final Unit addInteraction$lambda$28(RefreshViewController this$0, CardView $this_addInteraction, MouseEvent it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$this_addInteraction, (String)"$this_addInteraction");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.viewController.getLogicController().playCard((MauMauCard)this$0.viewController.getCardMap().backward((Object)$this_addInteraction), true, true);
        return Unit.INSTANCE;
    }

    private static final Unit addSneakInteraction$lambda$29(RefreshViewController this$0, CardView $this_addSneakInteraction, MouseEvent it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$this_addSneakInteraction, (String)"$this_addSneakInteraction");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.viewController.getMauMauGameScene().playAnimation((Animation)new FlipAnimation((GameComponentView)$this_addSneakInteraction, $this_addSneakInteraction.getBackVisual(), $this_addSneakInteraction.getFrontVisual(), 0, 8, null));
        return Unit.INSTANCE;
    }

    private static final Unit addSneakInteraction$lambda$30(RefreshViewController this$0, CardView $this_addSneakInteraction, MouseEvent it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$this_addSneakInteraction, (String)"$this_addSneakInteraction");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.viewController.getMauMauGameScene().playAnimation((Animation)new FlipAnimation((GameComponentView)$this_addSneakInteraction, $this_addSneakInteraction.getFrontVisual(), $this_addSneakInteraction.getBackVisual(), 0, 8, null));
        return Unit.INSTANCE;
    }
}

