/*
 * Decompiled with CFR 0.152.
 */
package tools.aqua.bgw.examples.maumau.service.network;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tools.aqua.bgw.examples.maumau.entity.CardSuit;
import tools.aqua.bgw.examples.maumau.entity.CardValue;
import tools.aqua.bgw.examples.maumau.entity.GameActionType;
import tools.aqua.bgw.examples.maumau.entity.MauMauCard;
import tools.aqua.bgw.examples.maumau.entity.MauMauGame;
import tools.aqua.bgw.examples.maumau.service.LogicController;
import tools.aqua.bgw.examples.maumau.service.network.MauMauBoardGameClient;
import tools.aqua.bgw.examples.maumau.service.network.NetworkSerialization;
import tools.aqua.bgw.examples.maumau.service.network.messages.MauMauEndGameAction;
import tools.aqua.bgw.examples.maumau.service.network.messages.MauMauGameAction;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J&\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000bJ&\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000bJ \u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000bH\u0002J\u000e\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u0016\u001a\u00020\tJ\u0006\u0010\u0017\u001a\u00020\tJ\u000e\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0006\u0010\u001e\u001a\u00020\tJ\u0006\u0010\u001f\u001a\u00020\tJ\u0006\u0010 \u001a\u00020\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Ltools/aqua/bgw/examples/maumau/service/network/NetworkService;", "", "logicController", "Ltools/aqua/bgw/examples/maumau/service/LogicController;", "<init>", "(Ltools/aqua/bgw/examples/maumau/service/LogicController;)V", "client", "Ltools/aqua/bgw/examples/maumau/service/network/MauMauBoardGameClient;", "hostGame", "", "address", "", "secret", "name", "sessionID", "joinGame", "connect", "", "sendInit", "game", "Ltools/aqua/bgw/examples/maumau/entity/MauMauGame;", "sendStackShuffled", "sendCardDrawn", "sendDrawTwoRequest", "sendCardPlayed", "card", "Ltools/aqua/bgw/examples/maumau/entity/MauMauCard;", "sendSuitSelected", "suit", "Ltools/aqua/bgw/examples/maumau/entity/CardSuit;", "sendEndTurn", "sendEndGame", "close", "bgw-maumau-example"})
public final class NetworkService {
    @NotNull
    private final LogicController logicController;
    @Nullable
    private MauMauBoardGameClient client;

    public NetworkService(@NotNull LogicController logicController) {
        Intrinsics.checkNotNullParameter((Object)logicController, (String)"logicController");
        this.logicController = logicController;
    }

    public final void hostGame(@NotNull String address, @NotNull String secret, @NotNull String name, @NotNull String sessionID) {
        block2: {
            block1: {
                Intrinsics.checkNotNullParameter((Object)address, (String)"address");
                Intrinsics.checkNotNullParameter((Object)secret, (String)"secret");
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter((Object)sessionID, (String)"sessionID");
                if (!this.connect(address, secret, name)) {
                    return;
                }
                if (!(((CharSequence)sessionID).length() == 0)) break block1;
                MauMauBoardGameClient mauMauBoardGameClient = this.client;
                if (mauMauBoardGameClient == null) break block2;
                mauMauBoardGameClient.createGame("MauMau", "Welcome!");
                break block2;
            }
            MauMauBoardGameClient mauMauBoardGameClient = this.client;
            if (mauMauBoardGameClient == null) break block2;
            mauMauBoardGameClient.createGame("MauMau", sessionID, "Welcome!");
        }
    }

    public final void joinGame(@NotNull String address, @NotNull String secret, @NotNull String name, @NotNull String sessionID) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)address, (String)"address");
            Intrinsics.checkNotNullParameter((Object)secret, (String)"secret");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)sessionID, (String)"sessionID");
            if (((CharSequence)sessionID).length() == 0) {
                this.logicController.getView().showConnectWarningDialog("SessionID is empty", "Please fill in the sessionID field.");
                return;
            }
            if (!this.connect(address, secret, name)) {
                return;
            }
            MauMauBoardGameClient mauMauBoardGameClient = this.client;
            if (mauMauBoardGameClient == null) break block2;
            mauMauBoardGameClient.joinGame(sessionID, "greeting");
        }
    }

    private final boolean connect(String address, String secret, String name) {
        boolean bl;
        if (((CharSequence)address).length() == 0) {
            this.logicController.getView().showConnectWarningDialog("Address is empty", "Please fill in the address field.");
            return false;
        }
        if (((CharSequence)secret).length() == 0) {
            this.logicController.getView().showConnectWarningDialog("Secret is empty", "Please fill in the secret field.");
            return false;
        }
        if (((CharSequence)name).length() == 0) {
            this.logicController.getView().showConnectWarningDialog("Name is empty", "Please fill in the name field.");
            return false;
        }
        MauMauBoardGameClient newClient = new MauMauBoardGameClient(name, address, secret, this.logicController);
        if (newClient.connect()) {
            this.client = newClient;
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public final void sendInit(@NotNull MauMauGame game) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)game, (String)"game");
            MauMauBoardGameClient mauMauBoardGameClient = this.client;
            if (mauMauBoardGameClient == null) break block0;
            mauMauBoardGameClient.sendGameActionMessage(NetworkSerialization.INSTANCE.serializeInitMessage(game));
        }
    }

    public final void sendStackShuffled(@NotNull MauMauGame game) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)game, (String)"game");
            MauMauBoardGameClient mauMauBoardGameClient = this.client;
            if (mauMauBoardGameClient == null) break block0;
            mauMauBoardGameClient.sendGameActionMessage(NetworkSerialization.INSTANCE.serializeStacksShuffledMessage(game));
        }
    }

    public final void sendCardDrawn() {
        block0: {
            MauMauBoardGameClient mauMauBoardGameClient = this.client;
            if (mauMauBoardGameClient == null) break block0;
            mauMauBoardGameClient.sendGameActionMessage(new MauMauGameAction(NetworkSerialization.INSTANCE.serializeGameAction(GameActionType.DRAW), null, 2, null));
        }
    }

    public final void sendDrawTwoRequest() {
        block0: {
            MauMauBoardGameClient mauMauBoardGameClient = this.client;
            if (mauMauBoardGameClient == null) break block0;
            mauMauBoardGameClient.sendGameActionMessage(new MauMauGameAction(NetworkSerialization.INSTANCE.serializeGameAction(GameActionType.REQUEST_DRAW_TWO), null, 2, null));
        }
    }

    public final void sendCardPlayed(@NotNull MauMauCard card) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)card, (String)"card");
            MauMauBoardGameClient mauMauBoardGameClient = this.client;
            if (mauMauBoardGameClient == null) break block0;
            mauMauBoardGameClient.sendGameActionMessage(new MauMauGameAction(NetworkSerialization.INSTANCE.serializeGameAction(GameActionType.PLAY), NetworkSerialization.INSTANCE.serialize(card)));
        }
    }

    public final void sendSuitSelected(@NotNull CardSuit suit) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)((Object)suit), (String)"suit");
            MauMauBoardGameClient mauMauBoardGameClient = this.client;
            if (mauMauBoardGameClient == null) break block0;
            mauMauBoardGameClient.sendGameActionMessage(new MauMauGameAction(NetworkSerialization.INSTANCE.serializeGameAction(GameActionType.REQUEST_SUIT), NetworkSerialization.INSTANCE.serialize(new MauMauCard(CardValue.ACE, suit))));
        }
    }

    public final void sendEndTurn() {
        block0: {
            MauMauBoardGameClient mauMauBoardGameClient = this.client;
            if (mauMauBoardGameClient == null) break block0;
            mauMauBoardGameClient.sendGameActionMessage(new MauMauGameAction(NetworkSerialization.INSTANCE.serializeGameAction(GameActionType.END_TURN), null, 2, null));
        }
    }

    public final void sendEndGame() {
        block1: {
            MauMauBoardGameClient mauMauBoardGameClient = this.client;
            if (mauMauBoardGameClient == null) break block1;
            Object object = this.client;
            if (object == null || (object = object.getPlayerName()) == null) {
                object = "Your Opponent";
            }
            mauMauBoardGameClient.sendGameActionMessage(new MauMauEndGameAction((String)object));
        }
    }

    public final void close() {
        block1: {
            MauMauBoardGameClient mauMauBoardGameClient = this.client;
            boolean bl = mauMauBoardGameClient != null ? mauMauBoardGameClient.isOpen() : false;
            if (!bl) break block1;
            MauMauBoardGameClient mauMauBoardGameClient2 = this.client;
            if (mauMauBoardGameClient2 != null) {
                mauMauBoardGameClient2.disconnect();
            }
        }
    }
}

