/*
 * Decompiled with CFR 0.152.
 */
package tools.aqua.bgw.builder;

import java.io.FileNotFoundException;
import java.net.URL;
import javafx.animation.Animation;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.event.ActionEvent;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Duration;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tools.aqua.bgw.components.layoutviews.CameraPane;
import tools.aqua.bgw.components.layoutviews.LayoutView;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001aH\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0002J\b\u0010\u001f\u001a\u00020\u001eH\u0002J\u0010\u0010 \u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\tH\u0002J\u0018\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u000f2\u0006\u0010%\u001a\u00020\tH\u0002J\u0010\u0010&\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001aH\u0002J\u0006\u0010'\u001a\u00020#J\u0016\u0010(\u001a\u00020#2\u0006\u0010)\u001a\u00020\u000f2\u0006\u0010*\u001a\u00020\u000fJ\u000e\u0010+\u001a\u00020#2\u0006\u0010!\u001a\u00020\tR\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u0004\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u000fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Ltools/aqua/bgw/builder/ZoomableScrollPane;", "Ljavafx/scene/control/ScrollPane;", "target", "Ljavafx/scene/layout/Pane;", "cameraPane", "Ltools/aqua/bgw/components/layoutviews/CameraPane;", "Ltools/aqua/bgw/components/layoutviews/LayoutView;", "(Ljavafx/scene/layout/Pane;Ltools/aqua/bgw/components/layoutviews/CameraPane;)V", "anchorPoint", "Ljavafx/geometry/Point2D;", "getAnchorPoint", "()Ljavafx/geometry/Point2D;", "setAnchorPoint", "(Ljavafx/geometry/Point2D;)V", "lerpTime", "", "value", "scaleValue", "getScaleValue", "()D", "setScaleValue", "(D)V", "timeline", "Ljavafx/animation/Timeline;", "zoomIntensity", "zoomNode", "Ljavafx/scene/Node;", "centeredNode", "node", "inFullHorizontalView", "", "inFullVerticalView", "inTargetBounds", "point", "onScroll", "", "wheelDelta", "mousePoint", "outerNode", "reset", "scrollBy", "xOffset", "yOffset", "scrollTo", "bgw-gui"})
public final class ZoomableScrollPane
extends ScrollPane {
    @NotNull
    private final Pane target;
    @NotNull
    private final CameraPane<? extends LayoutView<?>> cameraPane;
    private double scaleValue;
    private final double zoomIntensity;
    @NotNull
    private final Node zoomNode;
    @Nullable
    private Timeline timeline;
    private double lerpTime;
    @NotNull
    private Point2D anchorPoint;

    public ZoomableScrollPane(@NotNull Pane target, @NotNull CameraPane<? extends LayoutView<?>> cameraPane) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter(cameraPane, (String)"cameraPane");
        this.target = target;
        this.cameraPane = cameraPane;
        this.scaleValue = 1.0;
        this.zoomIntensity = 0.02;
        this.anchorPoint = new Point2D(0.0, 0.0);
        URL uRL = ((Object)((Object)this)).getClass().getResource("/style.css");
        if (uRL == null) {
            throw new FileNotFoundException();
        }
        URL resource = uRL;
        this.getStylesheets().add((Object)resource.toExternalForm());
        this.setBackground(Background.fill((Paint)((Paint)Color.TRANSPARENT)));
        Node[] nodeArray = new Node[]{(Node)this.target};
        this.zoomNode = (Node)new Group(nodeArray);
        this.setContent(this.outerNode(this.zoomNode));
        this.setPannable(true);
        this.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        this.setVbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
    }

    public final double getScaleValue() {
        return this.scaleValue;
    }

    public final void setScaleValue(double value) {
        this.scaleValue = Math.max(value, 0.01);
        this.target.setScaleX(this.scaleValue);
        this.target.setScaleY(this.scaleValue);
    }

    @NotNull
    public final Point2D getAnchorPoint() {
        return this.anchorPoint;
    }

    public final void setAnchorPoint(@NotNull Point2D point2D) {
        Intrinsics.checkNotNullParameter((Object)point2D, (String)"<set-?>");
        this.anchorPoint = point2D;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean inTargetBounds(Point2D point) {
        double d = this.cameraPane.getTarget$bgw_gui().getWidth();
        double d2 = point.getX();
        if (!(0.0 <= d2)) return false;
        if (!(d2 <= d)) return false;
        boolean bl = true;
        if (!bl) return false;
        d = this.cameraPane.getTarget$bgw_gui().getHeight();
        d2 = point.getY();
        if (!(0.0 <= d2)) return false;
        if (!(d2 <= d)) return false;
        return true;
    }

    private final boolean inFullHorizontalView() {
        return this.cameraPane.getTarget$bgw_gui().getWidth() == this.cameraPane.getWidth();
    }

    private final boolean inFullVerticalView() {
        return this.cameraPane.getTarget$bgw_gui().getHeight() == this.cameraPane.getHeight();
    }

    public final void scrollTo(@NotNull Point2D point) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        if (this.inTargetBounds(point)) {
            this.anchorPoint = point;
            double viewWidth = this.cameraPane.getWidth() / this.scaleValue;
            double viewHeight = this.cameraPane.getHeight() / this.scaleValue;
            this.setHvalue(point.getX() / (this.cameraPane.getTarget$bgw_gui().getWidth() - viewWidth));
            this.setVvalue(point.getY() / (this.cameraPane.getTarget$bgw_gui().getHeight() - viewHeight));
        }
    }

    public final void scrollBy(double xOffset, double yOffset) {
        Point2D point2D = this.anchorPoint.add(xOffset, yOffset);
        Intrinsics.checkNotNullExpressionValue((Object)point2D, (String)"anchorPoint.add(xOffset, yOffset)");
        if (this.inTargetBounds(point2D)) {
            Point2D point2D2 = this.anchorPoint.add(xOffset, yOffset);
            Intrinsics.checkNotNullExpressionValue((Object)point2D2, (String)"anchorPoint.add(xOffset, yOffset)");
            this.anchorPoint = point2D2;
            this.scrollTo(this.anchorPoint);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void reset() {
        block1: {
            void $this$reset_u24lambda_u2d1;
            Timeline timeline = this.timeline;
            if ((timeline != null ? timeline.getStatus() : null) == Animation.Status.RUNNING) {
                return;
            }
            Timeline timeline2 = new Timeline[]{new KeyFrame(Duration.millis((double)10.0), arg_0 -> ZoomableScrollPane.reset$lambda-0(this, arg_0), new KeyValue[0])};
            Timeline timeline3 = timeline2 = new Timeline((KeyFrame[])timeline2);
            ZoomableScrollPane zoomableScrollPane = this;
            boolean bl = false;
            $this$reset_u24lambda_u2d1.setCycleCount(-1);
            zoomableScrollPane.timeline = timeline2;
            Timeline timeline4 = this.timeline;
            if (timeline4 == null) break block1;
            timeline4.play();
        }
    }

    private final Node outerNode(Node node) {
        Node outerNode = this.centeredNode(node);
        outerNode.setOnScroll(arg_0 -> ZoomableScrollPane.outerNode$lambda-2(this, arg_0));
        return outerNode;
    }

    private final Node centeredNode(Node node) {
        Node[] nodeArray = new Node[]{node};
        VBox vBox = new VBox(nodeArray);
        vBox.setAlignment(Pos.TOP_LEFT);
        return (Node)vBox;
    }

    private final void onScroll(double wheelDelta, Point2D mousePoint) {
        Timeline timeline = this.timeline;
        if ((timeline != null ? timeline.getStatus() : null) == Animation.Status.RUNNING) {
            return;
        }
        double zoomFactor = Math.exp(wheelDelta * this.zoomIntensity);
        Bounds innerBounds = this.zoomNode.getLayoutBounds();
        Bounds viewportBounds = this.getViewportBounds();
        double valX = this.getHvalue() * (innerBounds.getWidth() - viewportBounds.getWidth());
        double valY = this.getVvalue() * (innerBounds.getHeight() - viewportBounds.getHeight());
        this.setScaleValue(this.scaleValue * zoomFactor);
        this.layout();
        Point2D posInZoomTarget = this.target.parentToLocal(this.zoomNode.parentToLocal(mousePoint));
        Point2D adjustment = this.target.getLocalToParentTransform().deltaTransform(posInZoomTarget.multiply(zoomFactor - 1.0));
        Bounds updatedInnerBounds = this.zoomNode.getBoundsInLocal();
        this.setHvalue((valX + adjustment.getX()) / (updatedInnerBounds.getWidth() - viewportBounds.getWidth()));
        this.setVvalue((valY + adjustment.getY()) / (updatedInnerBounds.getHeight() - viewportBounds.getHeight()));
    }

    private static final void reset$lambda-0(ZoomableScrollPane this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.setHvalue(this$0.getHvalue() + ((double)0.0f - this$0.getHvalue()) * this$0.lerpTime);
        this$0.setVvalue(this$0.getVvalue() + ((double)0.0f - this$0.getVvalue()) * this$0.lerpTime);
        this$0.setScaleValue(this$0.scaleValue + ((double)1.0f - this$0.scaleValue) * this$0.lerpTime);
        this$0.lerpTime += 0.001;
        if (Math.abs(this$0.getHvalue() - 0.0) <= 0.01 && Math.abs(this$0.getVvalue() - 0.0) <= 0.01 && Math.abs(this$0.scaleValue - 1.0) <= 0.01) {
            Timeline timeline = this$0.timeline;
            if (timeline != null) {
                timeline.stop();
            }
            this$0.setHvalue(0.0);
            this$0.setVvalue(0.0);
            this$0.setScaleValue(1.0);
            this$0.lerpTime = 0.0;
        }
    }

    private static final void outerNode$lambda-2(ZoomableScrollPane this$0, ScrollEvent e) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        e.consume();
        if (this$0.isPannable()) {
            this$0.onScroll(e.getTextDeltaY(), new Point2D(e.getX(), e.getY()));
        }
    }
}

