/*
 * Decompiled with CFR 0.152.
 */
package tools.aqua.bgw.observable.lists;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.streams.jdk8.StreamsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tools.aqua.bgw.observable.lists.ReadonlyObservableList;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0007J\u001b\u0010\u0004\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u000bJ\u001c\u0010\f\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u000eJ\u0014\u0010\f\u001a\u00020\u00052\f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u000eJ\u0006\u0010\u000f\u001a\u00020\bJ\u0013\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0007J\u0012\u0010\u0012\u001a\u00020\u00052\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000eJ\u0013\u0010\u0013\u001a\u00028\u00002\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0014J\u000b\u0010\u0015\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0016J\r\u0010\u0017\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\u0016J\u0016\u0010\u0018\u001a\u00020\u00052\u000e\u0010\u0019\u001a\n\u0012\u0006\b\u0000\u0012\u00028\u00000\u001aJ\u000b\u0010\u001b\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0016J\r\u0010\u001c\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\u0016J\u0014\u0010\u001d\u001a\u00020\b2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00000\u001fJ\u0012\u0010 \u001a\u00020\u00052\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000eJ\u001e\u0010!\u001a\u00028\u00002\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00028\u0000H\u0086\u0002\u00a2\u0006\u0002\u0010\"J\u0014\u0010#\u001a\u00020\u00052\f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u000eJ\u001b\u0010$\u001a\u00020\b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000%H\u0000\u00a2\u0006\u0002\b&J\u0018\u0010'\u001a\u00020\b2\u0010\u0010(\u001a\f\u0012\u0006\b\u0000\u0012\u00028\u0000\u0018\u00010)J\u001c\u0010*\u001a\b\u0012\u0004\u0012\u00028\u00000%2\u0006\u0010+\u001a\u00020\n2\u0006\u0010,\u001a\u00020\n\u00a8\u0006-"}, d2={"Ltools/aqua/bgw/observable/lists/ObservableList;", "T", "Ltools/aqua/bgw/observable/lists/ReadonlyObservableList;", "()V", "add", "", "element", "(Ljava/lang/Object;)Z", "", "index", "", "(ILjava/lang/Object;)V", "addAll", "elements", "", "clear", "remove", "o", "removeAll", "removeAt", "(I)Ljava/lang/Object;", "removeFirst", "()Ljava/lang/Object;", "removeFirstOrNull", "removeIf", "filter", "Ljava/util/function/Predicate;", "removeLast", "removeLastOrNull", "replaceAll", "operator", "Ljava/util/function/UnaryOperator;", "retainAll", "set", "(ILjava/lang/Object;)Ljava/lang/Object;", "setAll", "setSilent", "", "setSilent$bgw_gui", "sort", "comparator", "Ljava/util/Comparator;", "subList", "fromIndex", "toIndex", "bgw-gui"})
public abstract class ObservableList<T>
extends ReadonlyObservableList<T> {
    public final T set(int index, T element2) {
        List snapshot = CollectionsKt.toList((Iterable)this);
        Object oldValue = this.getList().get(index);
        this.getList().set(index, element2);
        this.notifyChange$bgw_gui(snapshot, CollectionsKt.toList((Iterable)this));
        return oldValue;
    }

    public final boolean add(T element2) {
        List snapshot = CollectionsKt.toList((Iterable)this);
        boolean isAdded = this.getList().add(element2);
        this.notifyChange$bgw_gui(snapshot, CollectionsKt.toList((Iterable)this));
        return isAdded;
    }

    public final void add(int index, T element2) {
        List snapshot = CollectionsKt.toList((Iterable)this);
        this.getList().add(index, element2);
        this.notifyChange$bgw_gui(snapshot, CollectionsKt.toList((Iterable)this));
    }

    public final boolean remove(T o) {
        List snapshot = CollectionsKt.toList((Iterable)this);
        boolean isRemoved = this.getList().remove(o);
        if (isRemoved) {
            this.notifyChange$bgw_gui(snapshot, CollectionsKt.toList((Iterable)this));
        }
        return isRemoved;
    }

    public final T removeAt(int index) {
        List snapshot = CollectionsKt.toList((Iterable)this);
        Object isRemoved = this.getList().remove(index);
        this.notifyChange$bgw_gui(snapshot, CollectionsKt.toList((Iterable)this));
        return isRemoved;
    }

    @Nullable
    public final T removeFirstOrNull() {
        List snapshot = CollectionsKt.toList((Iterable)this);
        Object isRemoved = CollectionsKt.removeFirstOrNull(this.getList());
        if (isRemoved != null) {
            this.notifyChange$bgw_gui(snapshot, CollectionsKt.toList((Iterable)this));
        }
        return (T)isRemoved;
    }

    public final T removeFirst() {
        T t = this.removeFirstOrNull();
        if (t == null) {
            throw new NoSuchElementException("List is empty");
        }
        return t;
    }

    @Nullable
    public final T removeLastOrNull() {
        List snapshot = CollectionsKt.toList((Iterable)this);
        Object isRemoved = CollectionsKt.removeLastOrNull(this.getList());
        if (isRemoved != null) {
            this.notifyChange$bgw_gui(snapshot, CollectionsKt.toList((Iterable)this));
        }
        return (T)isRemoved;
    }

    public final T removeLast() {
        T t = this.removeLastOrNull();
        if (t == null) {
            throw new NoSuchElementException("List is empty");
        }
        return t;
    }

    public final void clear() {
        List snapshot = CollectionsKt.toList((Iterable)this);
        if (!((Collection)this.getList()).isEmpty()) {
            this.getList().clear();
            this.notifyChange$bgw_gui(snapshot, CollectionsKt.toList((Iterable)this));
        }
    }

    public final boolean setAll(@NotNull Collection<? extends T> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        List snapshot = CollectionsKt.toList((Iterable)this);
        if (this.getList().size() == elements.size()) {
            boolean bl;
            block5: {
                Iterable $this$all$iv = CollectionsKt.zip((Iterable)this.getList(), (Iterable)elements);
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        Object t2;
                        Pair pair = (Pair)element$iv;
                        boolean bl2 = false;
                        Object t1 = pair.component1();
                        if (t1 == (t2 = pair.component2())) continue;
                        bl = false;
                        break block5;
                    }
                    bl = true;
                }
            }
            if (bl) {
                return false;
            }
        }
        this.getList().clear();
        boolean isAdded = this.getList().addAll(elements);
        this.notifyChange$bgw_gui(snapshot, CollectionsKt.toList((Iterable)this));
        return isAdded;
    }

    public final boolean addAll(@NotNull Collection<? extends T> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        List snapshot = CollectionsKt.toList((Iterable)this);
        boolean isAdded = this.getList().addAll(elements);
        this.notifyChange$bgw_gui(snapshot, CollectionsKt.toList((Iterable)this));
        return isAdded;
    }

    public final boolean addAll(int index, @NotNull Collection<? extends T> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        List snapshot = CollectionsKt.toList((Iterable)this);
        boolean isAdded = this.getList().addAll(index, elements);
        this.notifyChange$bgw_gui(snapshot, CollectionsKt.toList((Iterable)this));
        return isAdded;
    }

    public final boolean removeAll(@NotNull Collection<?> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        List snapshot = CollectionsKt.toList((Iterable)this);
        Collection collection = this.getList();
        Collection collection2 = CollectionsKt.toSet((Iterable)elements);
        boolean isRemoved = TypeIntrinsics.asMutableCollection((Object)collection).removeAll(collection2);
        if (isRemoved) {
            this.notifyChange$bgw_gui(snapshot, CollectionsKt.toList((Iterable)this));
        }
        return isRemoved;
    }

    public final boolean retainAll(@NotNull Collection<?> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        List snapshot = CollectionsKt.toList((Iterable)this);
        Collection collection = this.getList();
        Collection collection2 = CollectionsKt.toSet((Iterable)elements);
        boolean isRetained = TypeIntrinsics.asMutableCollection((Object)collection).retainAll(collection2);
        this.notifyChange$bgw_gui(snapshot, CollectionsKt.toList((Iterable)this));
        return isRetained;
    }

    @NotNull
    public final List<T> subList(int fromIndex, int toIndex) {
        return this.getList().subList(fromIndex, toIndex);
    }

    public final boolean removeIf(@NotNull Predicate<? super T> filter) {
        Intrinsics.checkNotNullParameter(filter, (String)"filter");
        List snapshot = CollectionsKt.toList((Iterable)this);
        boolean isRemoved = this.getList().removeIf(filter);
        if (isRemoved) {
            this.notifyChange$bgw_gui(snapshot, CollectionsKt.toList((Iterable)this));
        }
        return isRemoved;
    }

    public final void replaceAll(@NotNull UnaryOperator<T> operator) {
        Intrinsics.checkNotNullParameter(operator, (String)"operator");
        List snapshot = CollectionsKt.toList((Iterable)this);
        this.getList().replaceAll(operator);
        this.notifyChange$bgw_gui(snapshot, CollectionsKt.toList((Iterable)this));
    }

    public final void sort(@Nullable Comparator<? super T> comparator) {
        Stream<? super T> stream = this.getList().stream().sorted(comparator);
        Intrinsics.checkNotNullExpressionValue(stream, (String)"list.stream().sorted(comparator)");
        List sorted = StreamsKt.toList(stream);
        this.getList().clear();
        this.getList().addAll(sorted);
    }

    public final void setSilent$bgw_gui(@NotNull List<? extends T> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        this.getList().clear();
        this.getList().addAll((Collection)elements);
    }
}

