/*
 * Decompiled with CFR 0.152.
 */
package tools.aqua.bgw.observable;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.streams.jdk8.StreamsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tools.aqua.bgw.observable.ValueObservable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010(\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00030\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0004B\u0005\u00a2\u0006\u0002\u0010\u0005J\u0013\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0015J\u001b\u0010\u0012\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0018J\u001c\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u000f2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u001bJ\u0014\u0010\u0019\u001a\u00020\u00132\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u001bJ\u0006\u0010\u001c\u001a\u00020\u0016J\u0013\u0010\u001d\u001a\u00020\u00132\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0086\u0002J\u0016\u0010 \u001a\u00020\u00162\u000e\u0010!\u001a\n\u0012\u0006\b\u0000\u0012\u00028\u00000\"J\u0016\u0010#\u001a\u00028\u00002\u0006\u0010\u0017\u001a\u00020\u000fH\u0086\u0002\u00a2\u0006\u0002\u0010$J\u0010\u0010%\u001a\u00020\u000f2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fJ\u0006\u0010&\u001a\u00020\u0013J\u0006\u0010'\u001a\u00020\u0013J\u000f\u0010(\u001a\b\u0012\u0004\u0012\u00028\u00000)H\u0096\u0002J\u0010\u0010*\u001a\u00020\u000f2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fJ\u0013\u0010+\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0015J\u0012\u0010,\u001a\u00020\u00132\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u001bJ\u0013\u0010-\u001a\u00028\u00002\u0006\u0010\u0017\u001a\u00020\u000f\u00a2\u0006\u0002\u0010$J\u000b\u0010.\u001a\u00028\u0000\u00a2\u0006\u0002\u0010/J\r\u00100\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010/J\u0016\u00101\u001a\u00020\u00132\u000e\u00102\u001a\n\u0012\u0006\b\u0000\u0012\u00028\u000003J\u000b\u00104\u001a\u00028\u0000\u00a2\u0006\u0002\u0010/J\r\u00105\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010/J\u0014\u00106\u001a\u00020\u00162\f\u00107\u001a\b\u0012\u0004\u0012\u00028\u000008J\u0012\u00109\u001a\u00020\u00132\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u001bJ\u001e\u0010:\u001a\u00028\u00002\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00028\u0000H\u0086\u0002\u00a2\u0006\u0002\u0010;J\u001b\u0010<\u001a\u00020\u00162\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003H\u0000\u00a2\u0006\u0002\b=J\u0018\u0010>\u001a\u00020\u00162\u0010\u0010?\u001a\f\u0012\u0006\b\u0000\u0012\u00028\u0000\u0018\u00010@J\f\u0010A\u001a\b\u0012\u0004\u0012\u00028\u00000BJ\u001c\u0010C\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\u0006\u0010D\u001a\u00020\u000f2\u0006\u0010E\u001a\u00020\u000fR\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0018\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006F"}, d2={"Ltools/aqua/bgw/observable/ObservableList;", "T", "Ltools/aqua/bgw/observable/ValueObservable;", "", "", "()V", "indices", "Lkotlin/ranges/IntRange;", "getIndices", "()Lkotlin/ranges/IntRange;", "list", "", "getList", "()Ljava/util/List;", "size", "", "getSize", "()I", "add", "", "element", "(Ljava/lang/Object;)Z", "", "index", "(ILjava/lang/Object;)V", "addAll", "elements", "", "clear", "contains", "o", "", "forEach", "action", "Ljava/util/function/Consumer;", "get", "(I)Ljava/lang/Object;", "indexOf", "isEmpty", "isNotEmpty", "iterator", "", "lastIndexOf", "remove", "removeAll", "removeAt", "removeFirst", "()Ljava/lang/Object;", "removeFirstOrNull", "removeIf", "filter", "Ljava/util/function/Predicate;", "removeLast", "removeLastOrNull", "replaceAll", "operator", "Ljava/util/function/UnaryOperator;", "retainAll", "set", "(ILjava/lang/Object;)Ljava/lang/Object;", "setSilent", "setSilent$bgw_core", "sort", "comparator", "Ljava/util/Comparator;", "spliterator", "Ljava/util/Spliterator;", "subList", "fromIndex", "toIndex", "bgw-core"})
public abstract class ObservableList<T>
extends ValueObservable<List<? extends T>>
implements Iterable<T>,
KMappedMarker {
    public final int getSize() {
        return this.getList().size();
    }

    @NotNull
    public final IntRange getIndices() {
        return RangesKt.until((int)0, (int)this.getSize());
    }

    @NotNull
    public abstract List<T> getList();

    public final boolean isEmpty() {
        return this.getList().size() == 0;
    }

    public final boolean isNotEmpty() {
        return !this.isEmpty();
    }

    public final boolean contains(@Nullable Object o) {
        return CollectionsKt.contains((Iterable)this.getList(), (Object)o);
    }

    public final int indexOf(@Nullable Object o) {
        return CollectionsKt.indexOf(this.getList(), (Object)o);
    }

    public final int lastIndexOf(@Nullable Object o) {
        return CollectionsKt.lastIndexOf(this.getList(), (Object)o);
    }

    public final T get(int index) {
        return this.getList().get(index);
    }

    public final T set(int index, T element2) {
        List snapshot = CollectionsKt.toList((Iterable)this);
        T oldValue = this.getList().get(index);
        this.getList().set(index, element2);
        this.notifyChange$bgw_core(snapshot, CollectionsKt.toList((Iterable)this));
        return oldValue;
    }

    public final boolean add(T element2) {
        List snapshot = CollectionsKt.toList((Iterable)this);
        boolean result = this.getList().add(element2);
        this.notifyChange$bgw_core(snapshot, CollectionsKt.toList((Iterable)this));
        return result;
    }

    public final void add(int index, T element2) {
        List snapshot = CollectionsKt.toList((Iterable)this);
        this.getList().add(index, element2);
        this.notifyChange$bgw_core(snapshot, CollectionsKt.toList((Iterable)this));
    }

    public final boolean remove(T o) {
        List snapshot = CollectionsKt.toList((Iterable)this);
        boolean result = this.getList().remove(o);
        if (result) {
            this.notifyChange$bgw_core(snapshot, CollectionsKt.toList((Iterable)this));
        }
        return result;
    }

    public final T removeAt(int index) {
        List snapshot = CollectionsKt.toList((Iterable)this);
        T result = this.getList().remove(index);
        this.notifyChange$bgw_core(snapshot, CollectionsKt.toList((Iterable)this));
        return result;
    }

    @Nullable
    public final T removeFirstOrNull() {
        List snapshot = CollectionsKt.toList((Iterable)this);
        Object result = CollectionsKt.removeFirstOrNull(this.getList());
        if (result != null) {
            this.notifyChange$bgw_core(snapshot, CollectionsKt.toList((Iterable)this));
        }
        return (T)result;
    }

    public final T removeFirst() {
        T t = this.removeFirstOrNull();
        if (t == null) {
            throw new NoSuchElementException("List is empty");
        }
        return t;
    }

    @Nullable
    public final T removeLastOrNull() {
        List snapshot = CollectionsKt.toList((Iterable)this);
        Object result = CollectionsKt.removeLastOrNull(this.getList());
        if (result != null) {
            this.notifyChange$bgw_core(snapshot, CollectionsKt.toList((Iterable)this));
        }
        return (T)result;
    }

    public final T removeLast() {
        T t = this.removeLastOrNull();
        if (t == null) {
            throw new NoSuchElementException("List is empty");
        }
        return t;
    }

    public final void clear() {
        List snapshot = CollectionsKt.toList((Iterable)this);
        Collection collection = this.getList();
        boolean bl = false;
        if (!collection.isEmpty()) {
            this.getList().clear();
            this.notifyChange$bgw_core(snapshot, CollectionsKt.toList((Iterable)this));
        }
    }

    public final boolean addAll(@NotNull Collection<? extends T> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        List snapshot = CollectionsKt.toList((Iterable)this);
        boolean result = this.getList().addAll(elements);
        this.notifyChange$bgw_core(snapshot, CollectionsKt.toList((Iterable)this));
        return result;
    }

    public final boolean addAll(int index, @NotNull Collection<? extends T> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        List snapshot = CollectionsKt.toList((Iterable)this);
        boolean result = this.getList().addAll(index, elements);
        this.notifyChange$bgw_core(snapshot, CollectionsKt.toList((Iterable)this));
        return result;
    }

    public final boolean removeAll(@NotNull Collection<?> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        List snapshot = CollectionsKt.toList((Iterable)this);
        Collection collection = this.getList();
        boolean bl = false;
        Collection collection2 = collection;
        if (collection2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.MutableCollection<T>");
        }
        boolean result = TypeIntrinsics.asMutableCollection((Object)collection2).removeAll(elements);
        if (result) {
            this.notifyChange$bgw_core(snapshot, CollectionsKt.toList((Iterable)this));
        }
        return result;
    }

    public final boolean retainAll(@NotNull Collection<?> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        List snapshot = CollectionsKt.toList((Iterable)this);
        Collection collection = this.getList();
        boolean bl = false;
        Collection collection2 = collection;
        if (collection2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.MutableCollection<T>");
        }
        boolean result = TypeIntrinsics.asMutableCollection((Object)collection2).retainAll(elements);
        this.notifyChange$bgw_core(snapshot, CollectionsKt.toList((Iterable)this));
        return result;
    }

    @NotNull
    public final List<T> subList(int fromIndex, int toIndex) {
        return this.getList().subList(fromIndex, toIndex);
    }

    @Override
    public final void forEach(@NotNull Consumer<? super T> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        this.getList().forEach(action);
    }

    @Override
    @NotNull
    public final Spliterator<T> spliterator() {
        Spliterator<T> spliterator = this.getList().spliterator();
        Intrinsics.checkNotNullExpressionValue(spliterator, (String)"list.spliterator()");
        return spliterator;
    }

    public final boolean removeIf(@NotNull Predicate<? super T> filter) {
        Intrinsics.checkNotNullParameter(filter, (String)"filter");
        List snapshot = CollectionsKt.toList((Iterable)this);
        boolean result = this.getList().removeIf(filter);
        if (result) {
            this.notifyChange$bgw_core(snapshot, CollectionsKt.toList((Iterable)this));
        }
        return result;
    }

    public final void replaceAll(@NotNull UnaryOperator<T> operator) {
        Intrinsics.checkNotNullParameter(operator, (String)"operator");
        List snapshot = CollectionsKt.toList((Iterable)this);
        this.getList().replaceAll(operator);
        this.notifyChange$bgw_core(snapshot, CollectionsKt.toList((Iterable)this));
    }

    public final void sort(@Nullable Comparator<? super T> comparator) {
        Stream<? super T> stream = this.getList().stream().sorted(comparator);
        Intrinsics.checkNotNullExpressionValue(stream, (String)"list.stream().sorted(comparator)");
        List sorted = StreamsKt.toList(stream);
        this.getList().clear();
        this.getList().addAll(sorted);
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return this.getList().iterator();
    }

    public final void setSilent$bgw_core(@NotNull List<? extends T> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        this.getList().clear();
        this.getList().addAll((Collection)elements);
    }
}

