/*
 * Decompiled with CFR 0.152.
 */
package tools.aqua.bgw.builder;

import java.util.Collection;
import javafx.animation.Animation;
import javafx.animation.FadeTransition;
import javafx.animation.PauseTransition;
import javafx.animation.RotateTransition;
import javafx.animation.ScaleTransition;
import javafx.animation.SequentialTransition;
import javafx.animation.TranslateTransition;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.scene.Node;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.util.Duration;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import org.jetbrains.annotations.NotNull;
import tools.aqua.bgw.animation.DelayAnimation;
import tools.aqua.bgw.animation.DiceAnimation;
import tools.aqua.bgw.animation.FadeAnimation;
import tools.aqua.bgw.animation.FlipAnimation;
import tools.aqua.bgw.animation.MovementAnimation;
import tools.aqua.bgw.animation.RandomizeAnimation;
import tools.aqua.bgw.animation.RotationAnimation;
import tools.aqua.bgw.animation.ScaleAnimation;
import tools.aqua.bgw.builder.VisualBuilder;
import tools.aqua.bgw.components.ComponentView;
import tools.aqua.bgw.components.gamecomponentviews.CardView;
import tools.aqua.bgw.components.gamecomponentviews.DiceView;
import tools.aqua.bgw.core.Scene;
import tools.aqua.bgw.event.AnimationFinishedEvent;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Ltools/aqua/bgw/builder/AnimationBuilder;", "", "()V", "Companion", "bgw-core"})
public final class AnimationBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J%\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\nJ \u0010\u000b\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\fH\u0002J$\u0010\r\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00062\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0002J$\u0010\u000f\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00062\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0002J$\u0010\u0011\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00062\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\u0012H\u0002J$\u0010\u0013\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00062\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\u0014H\u0002J$\u0010\u0015\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00062\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\u0016H\u0002J$\u0010\u0017\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00062\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\u0018H\u0002J$\u0010\u0019\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00062\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\u001aH\u0002J \u0010\u001b\u001a\u00020\u001c2\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u001d"}, d2={"Ltools/aqua/bgw/builder/AnimationBuilder$Companion;", "", "()V", "build", "Ljavafx/animation/Animation;", "scene", "Ltools/aqua/bgw/core/Scene;", "Ltools/aqua/bgw/components/ComponentView;", "anim", "Ltools/aqua/bgw/animation/Animation;", "build$bgw_core", "buildDelayAnimation", "Ltools/aqua/bgw/animation/DelayAnimation;", "buildDiceAnimation", "Ltools/aqua/bgw/animation/DiceAnimation;", "buildFadeAnimation", "Ltools/aqua/bgw/animation/FadeAnimation;", "buildFlipAnimation", "Ltools/aqua/bgw/animation/FlipAnimation;", "buildMovementAnimation", "Ltools/aqua/bgw/animation/MovementAnimation;", "buildRandomizeAnimation", "Ltools/aqua/bgw/animation/RandomizeAnimation;", "buildRotateAnimation", "Ltools/aqua/bgw/animation/RotationAnimation;", "buildScaleAnimation", "Ltools/aqua/bgw/animation/ScaleAnimation;", "onFinished", "", "bgw-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Animation build$bgw_core(@NotNull Scene<? extends ComponentView> scene, @NotNull tools.aqua.bgw.animation.Animation anim) {
            Animation animation;
            Intrinsics.checkNotNullParameter(scene, (String)"scene");
            Intrinsics.checkNotNullParameter((Object)anim, (String)"anim");
            tools.aqua.bgw.animation.Animation animation2 = anim;
            if (animation2 instanceof MovementAnimation) {
                animation = this.buildMovementAnimation(scene, (MovementAnimation)anim);
            } else if (animation2 instanceof RotationAnimation) {
                animation = this.buildRotateAnimation(scene, (RotationAnimation)anim);
            } else if (animation2 instanceof ScaleAnimation) {
                animation = this.buildScaleAnimation(scene, (ScaleAnimation)anim);
            } else if (animation2 instanceof FadeAnimation) {
                animation = this.buildFadeAnimation(scene, (FadeAnimation)anim);
            } else if (animation2 instanceof FlipAnimation) {
                animation = this.buildFlipAnimation(scene, (FlipAnimation)anim);
            } else if (animation2 instanceof DelayAnimation) {
                animation = this.buildDelayAnimation(scene, (DelayAnimation)anim);
            } else if (animation2 instanceof DiceAnimation) {
                animation = this.buildDiceAnimation(scene, (DiceAnimation)anim);
            } else if (animation2 instanceof RandomizeAnimation) {
                animation = this.buildRandomizeAnimation(scene, (RandomizeAnimation)anim);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return animation;
        }

        private final Animation buildMovementAnimation(Scene<? extends ComponentView> scene, MovementAnimation<?> anim) {
            StackPane stackPane = scene.getComponentsMap$bgw_core().get(anim.getComponentView());
            Intrinsics.checkNotNull((Object)stackPane);
            StackPane node = stackPane;
            node.setLayoutX(anim.getFromX());
            node.setLayoutY(anim.getFromY());
            TranslateTransition translateTransition = new TranslateTransition(Duration.millis((double)anim.getDuration()), (Node)node);
            boolean bl = false;
            boolean bl2 = false;
            TranslateTransition $this$buildMovementAnimation_u24lambda_u2d1 = translateTransition;
            boolean bl3 = false;
            $this$buildMovementAnimation_u24lambda_u2d1.setByX(anim.getToX() - anim.getFromX());
            $this$buildMovementAnimation_u24lambda_u2d1.setByY(anim.getToY() - anim.getFromY());
            $this$buildMovementAnimation_u24lambda_u2d1.setOnFinished(arg_0 -> Companion.buildMovementAnimation$lambda-1$lambda-0(node, anim, scene, arg_0));
            return (Animation)translateTransition;
        }

        private final Animation buildRotateAnimation(Scene<? extends ComponentView> scene, RotationAnimation<?> anim) {
            StackPane stackPane = scene.getComponentsMap$bgw_core().get(anim.getComponentView());
            Intrinsics.checkNotNull((Object)stackPane);
            StackPane node = stackPane;
            node.setRotate(anim.getFromAngle());
            RotateTransition rotateTransition = new RotateTransition(Duration.millis((double)anim.getDuration()), (Node)node);
            boolean bl = false;
            boolean bl2 = false;
            RotateTransition $this$buildRotateAnimation_u24lambda_u2d3 = rotateTransition;
            boolean bl3 = false;
            $this$buildRotateAnimation_u24lambda_u2d3.setByAngle(anim.getToAngle() - anim.getFromAngle());
            $this$buildRotateAnimation_u24lambda_u2d3.setOnFinished(arg_0 -> Companion.buildRotateAnimation$lambda-3$lambda-2(node, anim, scene, arg_0));
            return (Animation)rotateTransition;
        }

        private final Animation buildScaleAnimation(Scene<? extends ComponentView> scene, ScaleAnimation<?> anim) {
            StackPane stackPane = scene.getComponentsMap$bgw_core().get(anim.getComponentView());
            Intrinsics.checkNotNull((Object)stackPane);
            StackPane node = stackPane;
            node.setScaleX(anim.getFromScaleX());
            node.setScaleY(anim.getFromScaleY());
            ScaleTransition scaleTransition = new ScaleTransition(Duration.millis((double)anim.getDuration()), (Node)node);
            boolean bl = false;
            boolean bl2 = false;
            ScaleTransition $this$buildScaleAnimation_u24lambda_u2d5 = scaleTransition;
            boolean bl3 = false;
            $this$buildScaleAnimation_u24lambda_u2d5.setToX(anim.getToScaleX());
            $this$buildScaleAnimation_u24lambda_u2d5.setToY(anim.getToScaleY());
            $this$buildScaleAnimation_u24lambda_u2d5.setOnFinished(arg_0 -> Companion.buildScaleAnimation$lambda-5$lambda-4(scene, anim, arg_0));
            return (Animation)scaleTransition;
        }

        private final Animation buildFadeAnimation(Scene<? extends ComponentView> scene, FadeAnimation<?> anim) {
            StackPane stackPane = scene.getComponentsMap$bgw_core().get(anim.getComponentView());
            Intrinsics.checkNotNull((Object)stackPane);
            StackPane node = stackPane;
            node.setOpacity(anim.getFromOpacity());
            FadeTransition fadeTransition = new FadeTransition(Duration.millis((double)anim.getDuration()), (Node)node);
            boolean bl = false;
            boolean bl2 = false;
            FadeTransition $this$buildFadeAnimation_u24lambda_u2d7 = fadeTransition;
            boolean bl3 = false;
            $this$buildFadeAnimation_u24lambda_u2d7.setFromValue(anim.getFromOpacity());
            $this$buildFadeAnimation_u24lambda_u2d7.setToValue(anim.getToOpacity());
            $this$buildFadeAnimation_u24lambda_u2d7.setOnFinished(arg_0 -> Companion.buildFadeAnimation$lambda-7$lambda-6(scene, anim, arg_0));
            return (Animation)fadeTransition;
        }

        private final Animation buildFlipAnimation(Scene<? extends ComponentView> scene, FlipAnimation<?> anim) {
            StackPane stackPane = scene.getComponentsMap$bgw_core().get(anim.getComponentView());
            Intrinsics.checkNotNull((Object)stackPane);
            StackPane node = stackPane;
            Region fromVisual = VisualBuilder.Companion.buildVisual$bgw_core(anim.getFromVisual());
            Region region = VisualBuilder.Companion.buildVisual$bgw_core(anim.getToVisual());
            boolean bl = false;
            boolean bl2 = false;
            Region $this$buildFlipAnimation_u24lambda_u2d8 = region;
            boolean bl3 = false;
            $this$buildFlipAnimation_u24lambda_u2d8.setScaleX(0.0);
            Region toVisual = region;
            ScaleTransition scaleTransition = new ScaleTransition(Duration.millis((double)((double)anim.getDuration() / 2.0)), (Node)fromVisual);
            bl2 = false;
            boolean bl4 = false;
            ScaleTransition $this$buildFlipAnimation_u24lambda_u2d9 = scaleTransition;
            boolean bl5 = false;
            $this$buildFlipAnimation_u24lambda_u2d9.setFromX(1.0);
            $this$buildFlipAnimation_u24lambda_u2d9.setToX(0.0);
            ScaleTransition animation1 = scaleTransition;
            ScaleTransition scaleTransition2 = new ScaleTransition(Duration.millis((double)((double)anim.getDuration() / 2.0)), (Node)toVisual);
            bl4 = false;
            boolean bl6 = false;
            ScaleTransition $this$buildFlipAnimation_u24lambda_u2d10 = scaleTransition2;
            boolean bl7 = false;
            $this$buildFlipAnimation_u24lambda_u2d10.setFromX(0.0);
            $this$buildFlipAnimation_u24lambda_u2d10.setToX(1.0);
            ScaleTransition animation2 = scaleTransition2;
            node.getChildren().set(0, (Object)fromVisual);
            animation1.setOnFinished(arg_0 -> Companion.buildFlipAnimation$lambda-11(node, toVisual, animation2, arg_0));
            animation2.setOnFinished(arg_0 -> Companion.buildFlipAnimation$lambda-12(scene, anim, arg_0));
            return (Animation)animation1;
        }

        private final Animation buildDelayAnimation(Scene<? extends ComponentView> scene, DelayAnimation anim) {
            PauseTransition pauseTransition = new PauseTransition(Duration.millis((double)anim.getDuration()));
            boolean bl = false;
            boolean bl2 = false;
            PauseTransition $this$buildDelayAnimation_u24lambda_u2d14 = pauseTransition;
            boolean bl3 = false;
            $this$buildDelayAnimation_u24lambda_u2d14.setOnFinished(arg_0 -> Companion.buildDelayAnimation$lambda-14$lambda-13(scene, anim, arg_0));
            return (Animation)pauseTransition;
        }

        private final Animation buildDiceAnimation(Scene<? extends ComponentView> scene, DiceAnimation<?> anim) {
            SequentialTransition seq = new SequentialTransition();
            int n = anim.getSpeed();
            boolean bl = false;
            int n2 = 0;
            n2 = 0;
            int n3 = n;
            while (n2 < n3) {
                int it = n2++;
                boolean bl2 = false;
                SequentialTransition sequentialTransition = seq;
                Object object = sequentialTransition.getChildren();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"seq.children");
                object = (Collection)object;
                PauseTransition pauseTransition = new PauseTransition(Duration.millis((double)((double)anim.getDuration() / (double)anim.getSpeed())));
                boolean bl3 = false;
                boolean bl4 = false;
                PauseTransition $this$buildDiceAnimation_u24lambda_u2d17_u24lambda_u2d16 = pauseTransition;
                boolean bl5 = false;
                $this$buildDiceAnimation_u24lambda_u2d17_u24lambda_u2d16.setOnFinished(arg_0 -> Companion.buildDiceAnimation$lambda-17$lambda-16$lambda-15(anim, arg_0));
                bl3 = false;
                object.add(pauseTransition);
            }
            seq.setOnFinished(arg_0 -> Companion.buildDiceAnimation$lambda-18(anim, scene, arg_0));
            return (Animation)seq;
        }

        private final Animation buildRandomizeAnimation(Scene<? extends ComponentView> scene, RandomizeAnimation<?> anim) {
            SequentialTransition seq = new SequentialTransition();
            int n = anim.getSpeed();
            boolean bl = false;
            int n2 = 0;
            n2 = 0;
            int n3 = n;
            while (n2 < n3) {
                int it = n2++;
                boolean bl2 = false;
                SequentialTransition sequentialTransition = seq;
                Object object = sequentialTransition.getChildren();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"seq.children");
                object = (Collection)object;
                PauseTransition pauseTransition = new PauseTransition(Duration.millis((double)((double)anim.getDuration() / (double)anim.getSpeed())));
                boolean bl3 = false;
                boolean bl4 = false;
                PauseTransition $this$buildRandomizeAnimation_u24lambda_u2d21_u24lambda_u2d20 = pauseTransition;
                boolean bl5 = false;
                $this$buildRandomizeAnimation_u24lambda_u2d21_u24lambda_u2d20.setOnFinished(arg_0 -> Companion.buildRandomizeAnimation$lambda-21$lambda-20$lambda-19(anim, arg_0));
                bl3 = false;
                object.add(pauseTransition);
            }
            seq.setOnFinished(arg_0 -> Companion.buildRandomizeAnimation$lambda-22(anim, scene, arg_0));
            return (Animation)seq;
        }

        private final void onFinished(Scene<? extends ComponentView> scene, tools.aqua.bgw.animation.Animation anim) {
            scene.getAnimations$bgw_core().remove(anim);
            Platform.runLater(() -> Companion.onFinished$lambda-23(anim));
        }

        private static final void buildMovementAnimation$lambda-1$lambda-0(StackPane $node, MovementAnimation $anim, Scene $scene, ActionEvent it) {
            Intrinsics.checkNotNullParameter((Object)$node, (String)"$node");
            Intrinsics.checkNotNullParameter((Object)$anim, (String)"$anim");
            Intrinsics.checkNotNullParameter((Object)$scene, (String)"$scene");
            $node.setLayoutX($anim.getToX());
            $node.setLayoutY($anim.getToY());
            $node.setTranslateX(0.0);
            $node.setTranslateY(0.0);
            Companion.onFinished($scene, $anim);
        }

        private static final void buildRotateAnimation$lambda-3$lambda-2(StackPane $node, RotationAnimation $anim, Scene $scene, ActionEvent it) {
            Intrinsics.checkNotNullParameter((Object)$node, (String)"$node");
            Intrinsics.checkNotNullParameter((Object)$anim, (String)"$anim");
            Intrinsics.checkNotNullParameter((Object)$scene, (String)"$scene");
            $node.setRotate($anim.getToAngle());
            $node.setTranslateX(0.0);
            $node.setTranslateY(0.0);
            Companion.onFinished($scene, $anim);
        }

        private static final void buildScaleAnimation$lambda-5$lambda-4(Scene $scene, ScaleAnimation $anim, ActionEvent it) {
            Intrinsics.checkNotNullParameter((Object)$scene, (String)"$scene");
            Intrinsics.checkNotNullParameter((Object)$anim, (String)"$anim");
            Companion.onFinished($scene, $anim);
        }

        private static final void buildFadeAnimation$lambda-7$lambda-6(Scene $scene, FadeAnimation $anim, ActionEvent it) {
            Intrinsics.checkNotNullParameter((Object)$scene, (String)"$scene");
            Intrinsics.checkNotNullParameter((Object)$anim, (String)"$anim");
            Companion.onFinished($scene, $anim);
        }

        private static final void buildFlipAnimation$lambda-11(StackPane $node, Region $toVisual, ScaleTransition $animation2, ActionEvent it) {
            Intrinsics.checkNotNullParameter((Object)$node, (String)"$node");
            Intrinsics.checkNotNullParameter((Object)$toVisual, (String)"$toVisual");
            Intrinsics.checkNotNullParameter((Object)$animation2, (String)"$animation2");
            $node.getChildren().set(0, (Object)$toVisual);
            $animation2.play();
        }

        private static final void buildFlipAnimation$lambda-12(Scene $scene, FlipAnimation $anim, ActionEvent it) {
            Intrinsics.checkNotNullParameter((Object)$scene, (String)"$scene");
            Intrinsics.checkNotNullParameter((Object)$anim, (String)"$anim");
            Companion.onFinished($scene, $anim);
        }

        private static final void buildDelayAnimation$lambda-14$lambda-13(Scene $scene, DelayAnimation $anim, ActionEvent it) {
            Intrinsics.checkNotNullParameter((Object)$scene, (String)"$scene");
            Intrinsics.checkNotNullParameter((Object)$anim, (String)"$anim");
            Companion.onFinished($scene, $anim);
        }

        private static final void buildDiceAnimation$lambda-17$lambda-16$lambda-15(DiceAnimation $anim, ActionEvent it) {
            Intrinsics.checkNotNullParameter((Object)$anim, (String)"$anim");
            ((DiceView)$anim.getComponentView()).setCurrentSide(Random.Default.nextInt(((DiceView)$anim.getComponentView()).getVisuals$bgw_core().getSize()));
        }

        private static final void buildDiceAnimation$lambda-18(DiceAnimation $anim, Scene $scene, ActionEvent it) {
            Intrinsics.checkNotNullParameter((Object)$anim, (String)"$anim");
            Intrinsics.checkNotNullParameter((Object)$scene, (String)"$scene");
            ((DiceView)$anim.getComponentView()).setCurrentSide($anim.getToSide());
            Companion.onFinished($scene, $anim);
        }

        private static final void buildRandomizeAnimation$lambda-21$lambda-20$lambda-19(RandomizeAnimation $anim, ActionEvent it) {
            Intrinsics.checkNotNullParameter((Object)$anim, (String)"$anim");
            ((CardView)$anim.getComponentView()).setBackVisual($anim.getVisuals().get(Random.Default.nextInt($anim.getVisuals().size())));
        }

        private static final void buildRandomizeAnimation$lambda-22(RandomizeAnimation $anim, Scene $scene, ActionEvent it) {
            Intrinsics.checkNotNullParameter((Object)$anim, (String)"$anim");
            Intrinsics.checkNotNullParameter((Object)$scene, (String)"$scene");
            ((CardView)$anim.getComponentView()).setBackVisual($anim.getToVisual());
            Companion.onFinished($scene, $anim);
        }

        private static final void onFinished$lambda-23(tools.aqua.bgw.animation.Animation $anim) {
            Intrinsics.checkNotNullParameter((Object)$anim, (String)"$anim");
            Function1<AnimationFinishedEvent, Unit> function1 = $anim.getOnFinished();
            if (function1 != null) {
                function1.invoke((Object)new AnimationFinishedEvent());
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

