/*
 * Decompiled with CFR 0.152.
 */
package tools.aqua.bgw.util;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import tools.aqua.bgw.util.Coordinate;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0004\n\u0002\b\t\n\u0002\u0010\u0006\n\u0002\b\b\b\u0016\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005B%\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000bR\u0011\u0010\f\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000eR\u0011\u0010\u0015\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u000eR\u0011\u0010\u0017\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0013\u00a8\u0006\u0019"}, d2={"Ltools/aqua/bgw/util/CoordinatePlain;", "", "topLeft", "Ltools/aqua/bgw/util/Coordinate;", "bottomRight", "(Ltools/aqua/bgw/util/Coordinate;Ltools/aqua/bgw/util/Coordinate;)V", "topLeftX", "", "topLeftY", "bottomRightX", "bottomRightY", "(Ljava/lang/Number;Ljava/lang/Number;Ljava/lang/Number;Ljava/lang/Number;)V", "bottomLeft", "getBottomLeft", "()Ltools/aqua/bgw/util/Coordinate;", "getBottomRight", "height", "", "getHeight", "()D", "getTopLeft", "topRight", "getTopRight", "width", "getWidth", "bgw-core"})
public class CoordinatePlain {
    @NotNull
    private final Coordinate topLeft;
    @NotNull
    private final Coordinate topRight;
    @NotNull
    private final Coordinate bottomLeft;
    @NotNull
    private final Coordinate bottomRight;
    private final double width;
    private final double height;

    public CoordinatePlain(@NotNull Number topLeftX, @NotNull Number topLeftY, @NotNull Number bottomRightX, @NotNull Number bottomRightY) {
        Intrinsics.checkNotNullParameter((Object)topLeftX, (String)"topLeftX");
        Intrinsics.checkNotNullParameter((Object)topLeftY, (String)"topLeftY");
        Intrinsics.checkNotNullParameter((Object)bottomRightX, (String)"bottomRightX");
        Intrinsics.checkNotNullParameter((Object)bottomRightY, (String)"bottomRightY");
        boolean bl = topLeftX.doubleValue() <= bottomRightX.doubleValue();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Top left corner is not to the right of bottom left corner.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = topLeftY.doubleValue() <= bottomRightY.doubleValue();
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Top left corner is not to the right of bottom left corner.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.topLeft = new Coordinate(topLeftX, topLeftY);
        this.topRight = new Coordinate(bottomRightX, topLeftY);
        this.bottomLeft = new Coordinate(topLeftX, bottomRightY);
        this.bottomRight = new Coordinate(bottomRightX, bottomRightY);
        this.width = bottomRightX.doubleValue() - topLeftX.doubleValue();
        this.height = bottomRightY.doubleValue() - topLeftY.doubleValue();
    }

    @NotNull
    public final Coordinate getTopLeft() {
        return this.topLeft;
    }

    @NotNull
    public final Coordinate getTopRight() {
        return this.topRight;
    }

    @NotNull
    public final Coordinate getBottomLeft() {
        return this.bottomLeft;
    }

    @NotNull
    public final Coordinate getBottomRight() {
        return this.bottomRight;
    }

    public final double getWidth() {
        return this.width;
    }

    public final double getHeight() {
        return this.height;
    }

    public CoordinatePlain(@NotNull Coordinate topLeft, @NotNull Coordinate bottomRight) {
        Intrinsics.checkNotNullParameter((Object)topLeft, (String)"topLeft");
        Intrinsics.checkNotNullParameter((Object)bottomRight, (String)"bottomRight");
        this(topLeft.getXCoord(), topLeft.getYCoord(), bottomRight.getXCoord(), bottomRight.getYCoord());
    }
}

