/*
 * Decompiled with CFR 0.152.
 */
package tools.aqua.bgw.observable;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.streams.jdk8.StreamsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tools.aqua.bgw.observable.Observable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010(\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0014J\u001b\u0010\u0011\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0017J\u001c\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u000e2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\u001aJ\u0014\u0010\u0018\u001a\u00020\u00122\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\u001aJ\u0006\u0010\u001b\u001a\u00020\u0015J\u0013\u0010\u001c\u001a\u00020\u00122\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0086\u0002J\u0016\u0010\u001f\u001a\u00020\u00152\u000e\u0010 \u001a\n\u0012\u0006\b\u0000\u0012\u00028\u00000!J\u0016\u0010\"\u001a\u00028\u00002\u0006\u0010\u0016\u001a\u00020\u000eH\u0086\u0002\u00a2\u0006\u0002\u0010#J\u0010\u0010$\u001a\u00020\u000e2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eJ\u0006\u0010%\u001a\u00020\u0012J\u0006\u0010&\u001a\u00020\u0012J\u000f\u0010'\u001a\b\u0012\u0004\u0012\u00028\u00000(H\u0096\u0002J\u0010\u0010)\u001a\u00020\u000e2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eJ\u0013\u0010*\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0014J\u0012\u0010+\u001a\u00020\u00122\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u001aJ\u0013\u0010,\u001a\u00028\u00002\u0006\u0010\u0016\u001a\u00020\u000e\u00a2\u0006\u0002\u0010#J\u000b\u0010-\u001a\u00028\u0000\u00a2\u0006\u0002\u0010.J\r\u0010/\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010.J\u0016\u00100\u001a\u00020\u00122\u000e\u00101\u001a\n\u0012\u0006\b\u0000\u0012\u00028\u000002J\u000b\u00103\u001a\u00028\u0000\u00a2\u0006\u0002\u0010.J\r\u00104\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010.J\u0014\u00105\u001a\u00020\u00152\f\u00106\u001a\b\u0012\u0004\u0012\u00028\u000007J\u0012\u00108\u001a\u00020\u00122\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u001aJ\u001e\u00109\u001a\u00028\u00002\u0006\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00028\u0000H\u0086\u0002\u00a2\u0006\u0002\u0010:J\u001b\u0010;\u001a\u00020\u00152\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000<H\u0000\u00a2\u0006\u0002\b=J\u0018\u0010>\u001a\u00020\u00152\u0010\u0010?\u001a\f\u0012\u0006\b\u0000\u0012\u00028\u0000\u0018\u00010@J\f\u0010A\u001a\b\u0012\u0004\u0012\u00028\u00000BJ\u001c\u0010C\u001a\b\u0012\u0004\u0012\u00028\u00000<2\u0006\u0010D\u001a\u00020\u000e2\u0006\u0010E\u001a\u00020\u000eR\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0018\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006F"}, d2={"Ltools/aqua/bgw/observable/ObservableList;", "T", "Ltools/aqua/bgw/observable/Observable;", "", "()V", "indices", "Lkotlin/ranges/IntRange;", "getIndices", "()Lkotlin/ranges/IntRange;", "list", "", "getList", "()Ljava/util/List;", "size", "", "getSize", "()I", "add", "", "element", "(Ljava/lang/Object;)Z", "", "index", "(ILjava/lang/Object;)V", "addAll", "elements", "", "clear", "contains", "o", "", "forEach", "action", "Ljava/util/function/Consumer;", "get", "(I)Ljava/lang/Object;", "indexOf", "isEmpty", "isNotEmpty", "iterator", "", "lastIndexOf", "remove", "removeAll", "removeAt", "removeFirst", "()Ljava/lang/Object;", "removeFirstOrNull", "removeIf", "filter", "Ljava/util/function/Predicate;", "removeLast", "removeLastOrNull", "replaceAll", "operator", "Ljava/util/function/UnaryOperator;", "retainAll", "set", "(ILjava/lang/Object;)Ljava/lang/Object;", "setSilent", "", "setSilent$bgw_core", "sort", "comparator", "Ljava/util/Comparator;", "spliterator", "Ljava/util/Spliterator;", "subList", "fromIndex", "toIndex", "bgw-core"})
public abstract class ObservableList<T>
extends Observable
implements Iterable<T>,
KMappedMarker {
    public final int getSize() {
        return this.getList().size();
    }

    @NotNull
    public final IntRange getIndices() {
        return RangesKt.until((int)0, (int)this.getSize());
    }

    @NotNull
    public abstract List<T> getList();

    public final boolean isEmpty() {
        return this.getList().size() == 0;
    }

    public final boolean isNotEmpty() {
        return !this.isEmpty();
    }

    public final boolean contains(@Nullable Object o) {
        return CollectionsKt.contains((Iterable)this.getList(), (Object)o);
    }

    public final int indexOf(@Nullable Object o) {
        return CollectionsKt.indexOf(this.getList(), (Object)o);
    }

    public final int lastIndexOf(@Nullable Object o) {
        return CollectionsKt.lastIndexOf(this.getList(), (Object)o);
    }

    public final T get(int index) {
        return this.getList().get(index);
    }

    public final T set(int index, T element) {
        T oldValue = this.getList().get(index);
        this.getList().set(index, element);
        this.notifyChange();
        return oldValue;
    }

    public final boolean add(T element) {
        boolean result = this.getList().add(element);
        this.notifyChange();
        return result;
    }

    public final void add(int index, T element) {
        this.getList().add(index, element);
        this.notifyChange();
    }

    public final boolean remove(T o) {
        boolean result = this.getList().remove(o);
        if (result) {
            this.notifyChange();
        }
        return result;
    }

    public final T removeAt(int index) {
        T result = this.getList().remove(index);
        this.notifyChange();
        return result;
    }

    @Nullable
    public final T removeFirstOrNull() {
        Object result = CollectionsKt.removeFirstOrNull(this.getList());
        if (result != null) {
            this.notifyChange();
        }
        return (T)result;
    }

    public final T removeFirst() {
        T t = this.removeFirstOrNull();
        if (t == null) {
            throw new NoSuchElementException("List is empty");
        }
        return t;
    }

    @Nullable
    public final T removeLastOrNull() {
        Object result = CollectionsKt.removeLastOrNull(this.getList());
        if (result != null) {
            this.notifyChange();
        }
        return (T)result;
    }

    public final T removeLast() {
        T t = this.removeLastOrNull();
        if (t == null) {
            throw new NoSuchElementException("List is empty");
        }
        return t;
    }

    public final void clear() {
        Collection collection = this.getList();
        boolean bl = false;
        if (!collection.isEmpty()) {
            this.getList().clear();
            this.notifyChange();
        }
    }

    public final boolean addAll(@NotNull Collection<? extends T> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        boolean result = this.getList().addAll(elements);
        this.notifyChange();
        return result;
    }

    public final boolean addAll(int index, @NotNull Collection<? extends T> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        boolean result = this.getList().addAll(index, elements);
        this.notifyChange();
        return result;
    }

    public final boolean removeAll(@NotNull Collection<?> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Collection collection = this.getList();
        boolean bl = false;
        Collection collection2 = collection;
        if (collection2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.MutableCollection<T>");
        }
        boolean result = TypeIntrinsics.asMutableCollection((Object)collection2).removeAll(elements);
        if (result) {
            this.notifyChange();
        }
        return result;
    }

    public final boolean retainAll(@NotNull Collection<?> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Collection collection = this.getList();
        boolean bl = false;
        Collection collection2 = collection;
        if (collection2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.MutableCollection<T>");
        }
        boolean result = TypeIntrinsics.asMutableCollection((Object)collection2).retainAll(elements);
        this.notifyChange();
        return result;
    }

    @NotNull
    public final List<T> subList(int fromIndex, int toIndex) {
        return this.getList().subList(fromIndex, toIndex);
    }

    @Override
    public final void forEach(@NotNull Consumer<? super T> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        this.getList().forEach(action);
    }

    @Override
    @NotNull
    public final Spliterator<T> spliterator() {
        Spliterator<T> spliterator = this.getList().spliterator();
        Intrinsics.checkNotNullExpressionValue(spliterator, (String)"list.spliterator()");
        return spliterator;
    }

    public final boolean removeIf(@NotNull Predicate<? super T> filter) {
        Intrinsics.checkNotNullParameter(filter, (String)"filter");
        boolean result = this.getList().removeIf(filter);
        if (result) {
            this.notifyChange();
        }
        return result;
    }

    public final void replaceAll(@NotNull UnaryOperator<T> operator) {
        Intrinsics.checkNotNullParameter(operator, (String)"operator");
        this.getList().replaceAll(operator);
        this.notifyChange();
    }

    public final void sort(@Nullable Comparator<? super T> comparator) {
        Stream<? super T> stream = this.getList().stream().sorted(comparator);
        Intrinsics.checkNotNullExpressionValue(stream, (String)"list.stream().sorted(comparator)");
        List sorted = StreamsKt.toList(stream);
        this.getList().clear();
        this.getList().addAll(sorted);
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return this.getList().iterator();
    }

    public final void setSilent$bgw_core(@NotNull List<? extends T> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        this.getList().clear();
        this.getList().addAll((Collection)elements);
    }
}

