/*
 * Decompiled with CFR 0.152.
 */
package tools.aqua.bgw.builder;

import java.util.Collection;
import javafx.animation.Animation;
import javafx.animation.PauseTransition;
import javafx.animation.RotateTransition;
import javafx.animation.ScaleTransition;
import javafx.animation.SequentialTransition;
import javafx.animation.TranslateTransition;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.scene.Node;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.util.Duration;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import org.jetbrains.annotations.NotNull;
import tools.aqua.bgw.animation.DelayAnimation;
import tools.aqua.bgw.animation.DiceAnimation;
import tools.aqua.bgw.animation.FlipAnimation;
import tools.aqua.bgw.animation.MovementAnimation;
import tools.aqua.bgw.animation.RandomizeAnimation;
import tools.aqua.bgw.animation.RotationAnimation;
import tools.aqua.bgw.builder.VisualBuilder;
import tools.aqua.bgw.components.ComponentView;
import tools.aqua.bgw.components.gamecomponentviews.DiceView;
import tools.aqua.bgw.components.gamecomponentviews.GameComponentView;
import tools.aqua.bgw.core.Scene;
import tools.aqua.bgw.event.AnimationFinishedEvent;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Ltools/aqua/bgw/builder/AnimationBuilder;", "", "()V", "Companion", "bgw-core"})
public final class AnimationBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0002J$\u0010\n\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00062\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0002J$\u0010\f\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00062\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\rH\u0002J$\u0010\u000e\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00062\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\u000fH\u0002J$\u0010\u0010\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00062\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\u0011H\u0002J%\u0010\u0012\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\b\u0014J$\u0010\u0015\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00062\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\u0016H\u0002J \u0010\u0017\u001a\u00020\u00182\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\u0013H\u0002\u00a8\u0006\u0019"}, d2={"Ltools/aqua/bgw/builder/AnimationBuilder$Companion;", "", "()V", "addDelayAnimation", "Ljavafx/animation/Animation;", "scene", "Ltools/aqua/bgw/core/Scene;", "Ltools/aqua/bgw/components/ComponentView;", "anim", "Ltools/aqua/bgw/animation/DelayAnimation;", "addDiceAnimation", "Ltools/aqua/bgw/animation/DiceAnimation;", "addFlipAnimation", "Ltools/aqua/bgw/animation/FlipAnimation;", "addRandomizeAnimation", "Ltools/aqua/bgw/animation/RandomizeAnimation;", "addRotateAnimation", "Ltools/aqua/bgw/animation/RotationAnimation;", "build", "Ltools/aqua/bgw/animation/Animation;", "build$bgw_core", "buildMovementAnimation", "Ltools/aqua/bgw/animation/MovementAnimation;", "onFinished", "", "bgw-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Animation build$bgw_core(@NotNull Scene<? extends ComponentView> scene, @NotNull tools.aqua.bgw.animation.Animation anim) {
            Animation animation;
            Intrinsics.checkNotNullParameter(scene, (String)"scene");
            Intrinsics.checkNotNullParameter((Object)anim, (String)"anim");
            tools.aqua.bgw.animation.Animation animation2 = anim;
            if (animation2 instanceof MovementAnimation) {
                animation = this.buildMovementAnimation(scene, (MovementAnimation)anim);
            } else if (animation2 instanceof RotationAnimation) {
                animation = this.addRotateAnimation(scene, (RotationAnimation)anim);
            } else if (animation2 instanceof FlipAnimation) {
                animation = this.addFlipAnimation(scene, (FlipAnimation)anim);
            } else if (animation2 instanceof DelayAnimation) {
                animation = this.addDelayAnimation(scene, (DelayAnimation)anim);
            } else if (animation2 instanceof DiceAnimation) {
                animation = this.addDiceAnimation(scene, (DiceAnimation)anim);
            } else if (animation2 instanceof RandomizeAnimation) {
                animation = this.addRandomizeAnimation(scene, (RandomizeAnimation)anim);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return animation;
        }

        private final Animation buildMovementAnimation(Scene<? extends ComponentView> scene, MovementAnimation<?> anim) {
            StackPane stackPane = scene.getComponentsMap$bgw_core().get(anim.getComponentView());
            Intrinsics.checkNotNull((Object)stackPane);
            StackPane node = stackPane;
            node.setLayoutX(anim.getFromX());
            node.setLayoutY(anim.getFromY());
            TranslateTransition translateTransition = new TranslateTransition(Duration.millis((double)anim.getDuration()), (Node)node);
            boolean bl = false;
            boolean bl2 = false;
            TranslateTransition $this$buildMovementAnimation_u24lambda_u2d0 = translateTransition;
            boolean bl3 = false;
            $this$buildMovementAnimation_u24lambda_u2d0.setByX(anim.getToX() - anim.getFromX());
            $this$buildMovementAnimation_u24lambda_u2d0.setByY(anim.getToY() - anim.getFromY());
            TranslateTransition animation = translateTransition;
            animation.setOnFinished(arg_0 -> Companion.buildMovementAnimation$lambda-1(node, anim, scene, arg_0));
            return (Animation)animation;
        }

        private final Animation addRotateAnimation(Scene<? extends ComponentView> scene, RotationAnimation<?> anim) {
            StackPane stackPane = scene.getComponentsMap$bgw_core().get(anim.getComponentView());
            Intrinsics.checkNotNull((Object)stackPane);
            StackPane node = stackPane;
            node.setRotate(anim.getFromAngle());
            RotateTransition rotateTransition = new RotateTransition(Duration.millis((double)anim.getDuration()), (Node)node);
            boolean bl = false;
            boolean bl2 = false;
            RotateTransition $this$addRotateAnimation_u24lambda_u2d2 = rotateTransition;
            boolean bl3 = false;
            $this$addRotateAnimation_u24lambda_u2d2.setByAngle(anim.getToAngle() - anim.getFromAngle());
            RotateTransition animation = rotateTransition;
            animation.setOnFinished(arg_0 -> Companion.addRotateAnimation$lambda-3(node, anim, scene, arg_0));
            return (Animation)animation;
        }

        private final Animation addFlipAnimation(Scene<? extends ComponentView> scene, FlipAnimation<?> anim) {
            StackPane stackPane = scene.getComponentsMap$bgw_core().get(anim.getComponentView());
            Intrinsics.checkNotNull((Object)stackPane);
            StackPane node = stackPane;
            Region fromVisual = VisualBuilder.Companion.buildVisual$bgw_core(anim.getFromVisual());
            Region region = VisualBuilder.Companion.buildVisual$bgw_core(anim.getToVisual());
            boolean bl = false;
            boolean bl2 = false;
            Region $this$addFlipAnimation_u24lambda_u2d4 = region;
            boolean bl3 = false;
            $this$addFlipAnimation_u24lambda_u2d4.setScaleX(0.0);
            Region toVisual = region;
            ScaleTransition scaleTransition = new ScaleTransition(Duration.millis((double)((double)anim.getDuration() / 2.0)), (Node)fromVisual);
            bl2 = false;
            boolean bl4 = false;
            ScaleTransition $this$addFlipAnimation_u24lambda_u2d5 = scaleTransition;
            boolean bl5 = false;
            $this$addFlipAnimation_u24lambda_u2d5.setFromX(1.0);
            $this$addFlipAnimation_u24lambda_u2d5.setToX(0.0);
            ScaleTransition animation1 = scaleTransition;
            ScaleTransition scaleTransition2 = new ScaleTransition(Duration.millis((double)((double)anim.getDuration() / 2.0)), (Node)toVisual);
            bl4 = false;
            boolean bl6 = false;
            ScaleTransition $this$addFlipAnimation_u24lambda_u2d6 = scaleTransition2;
            boolean bl7 = false;
            $this$addFlipAnimation_u24lambda_u2d6.setFromX(0.0);
            $this$addFlipAnimation_u24lambda_u2d6.setToX(1.0);
            ScaleTransition animation2 = scaleTransition2;
            node.getChildren().set(0, (Object)fromVisual);
            animation1.setOnFinished(arg_0 -> Companion.addFlipAnimation$lambda-7(node, toVisual, animation2, arg_0));
            animation2.setOnFinished(arg_0 -> Companion.addFlipAnimation$lambda-8(scene, anim, arg_0));
            return (Animation)animation1;
        }

        private final Animation addDelayAnimation(Scene<? extends ComponentView> scene, DelayAnimation anim) {
            PauseTransition animation = new PauseTransition(Duration.millis((double)anim.getDuration()));
            animation.setOnFinished(arg_0 -> Companion.addDelayAnimation$lambda-9(scene, anim, arg_0));
            return (Animation)animation;
        }

        private final Animation addDiceAnimation(Scene<? extends ComponentView> scene, DiceAnimation<?> anim) {
            SequentialTransition seq = new SequentialTransition();
            int n = anim.getSpeed();
            boolean bl = false;
            int n2 = 0;
            n2 = 0;
            int n3 = n;
            while (n2 < n3) {
                int it = n2++;
                boolean bl2 = false;
                SequentialTransition sequentialTransition = seq;
                Object object = sequentialTransition.getChildren();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"seq.children");
                object = (Collection)object;
                PauseTransition pauseTransition = new PauseTransition(Duration.millis((double)((double)anim.getDuration() / (double)anim.getSpeed())));
                boolean bl3 = false;
                boolean bl4 = false;
                PauseTransition $this$addDiceAnimation_u24lambda_u2d12_u24lambda_u2d11 = pauseTransition;
                boolean bl5 = false;
                $this$addDiceAnimation_u24lambda_u2d12_u24lambda_u2d11.setOnFinished(arg_0 -> Companion.addDiceAnimation$lambda-12$lambda-11$lambda-10(anim, arg_0));
                bl3 = false;
                object.add(pauseTransition);
            }
            seq.setOnFinished(arg_0 -> Companion.addDiceAnimation$lambda-13(anim, scene, arg_0));
            return (Animation)seq;
        }

        private final Animation addRandomizeAnimation(Scene<? extends ComponentView> scene, RandomizeAnimation<?> anim) {
            SequentialTransition seq = new SequentialTransition();
            int n = anim.getSpeed();
            boolean bl = false;
            int n2 = 0;
            n2 = 0;
            int n3 = n;
            while (n2 < n3) {
                int it = n2++;
                boolean bl2 = false;
                SequentialTransition sequentialTransition = seq;
                Object object = sequentialTransition.getChildren();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"seq.children");
                object = (Collection)object;
                PauseTransition pauseTransition = new PauseTransition(Duration.millis((double)((double)anim.getDuration() / (double)anim.getSpeed())));
                boolean bl3 = false;
                boolean bl4 = false;
                PauseTransition $this$addRandomizeAnimation_u24lambda_u2d16_u24lambda_u2d15 = pauseTransition;
                boolean bl5 = false;
                $this$addRandomizeAnimation_u24lambda_u2d16_u24lambda_u2d15.setOnFinished(arg_0 -> Companion.addRandomizeAnimation$lambda-16$lambda-15$lambda-14(anim, arg_0));
                bl3 = false;
                object.add(pauseTransition);
            }
            seq.setOnFinished(arg_0 -> Companion.addRandomizeAnimation$lambda-17(anim, scene, arg_0));
            return (Animation)seq;
        }

        private final void onFinished(Scene<? extends ComponentView> scene, tools.aqua.bgw.animation.Animation anim) {
            scene.getAnimations$bgw_core().remove(anim);
            Platform.runLater(() -> Companion.onFinished$lambda-18(anim));
        }

        private static final void buildMovementAnimation$lambda-1(StackPane $node, MovementAnimation $anim, Scene $scene, ActionEvent it) {
            Intrinsics.checkNotNullParameter((Object)$node, (String)"$node");
            Intrinsics.checkNotNullParameter((Object)$anim, (String)"$anim");
            Intrinsics.checkNotNullParameter((Object)$scene, (String)"$scene");
            $node.setLayoutX($anim.getToX());
            $node.setLayoutY($anim.getToY());
            $node.setTranslateX(0.0);
            $node.setTranslateY(0.0);
            Companion.onFinished($scene, $anim);
        }

        private static final void addRotateAnimation$lambda-3(StackPane $node, RotationAnimation $anim, Scene $scene, ActionEvent it) {
            Intrinsics.checkNotNullParameter((Object)$node, (String)"$node");
            Intrinsics.checkNotNullParameter((Object)$anim, (String)"$anim");
            Intrinsics.checkNotNullParameter((Object)$scene, (String)"$scene");
            $node.setRotate($anim.getToAngle());
            $node.setTranslateX(0.0);
            $node.setTranslateY(0.0);
            Companion.onFinished($scene, $anim);
        }

        private static final void addFlipAnimation$lambda-7(StackPane $node, Region $toVisual, ScaleTransition $animation2, ActionEvent it) {
            Intrinsics.checkNotNullParameter((Object)$node, (String)"$node");
            Intrinsics.checkNotNullParameter((Object)$toVisual, (String)"$toVisual");
            Intrinsics.checkNotNullParameter((Object)$animation2, (String)"$animation2");
            $node.getChildren().set(0, (Object)$toVisual);
            $animation2.play();
        }

        private static final void addFlipAnimation$lambda-8(Scene $scene, FlipAnimation $anim, ActionEvent it) {
            Intrinsics.checkNotNullParameter((Object)$scene, (String)"$scene");
            Intrinsics.checkNotNullParameter((Object)$anim, (String)"$anim");
            Companion.onFinished($scene, $anim);
        }

        private static final void addDelayAnimation$lambda-9(Scene $scene, DelayAnimation $anim, ActionEvent it) {
            Intrinsics.checkNotNullParameter((Object)$scene, (String)"$scene");
            Intrinsics.checkNotNullParameter((Object)$anim, (String)"$anim");
            Companion.onFinished($scene, $anim);
        }

        private static final void addDiceAnimation$lambda-12$lambda-11$lambda-10(DiceAnimation $anim, ActionEvent it) {
            Intrinsics.checkNotNullParameter((Object)$anim, (String)"$anim");
            ((DiceView)$anim.getComponentView()).setCurrentSide(Random.Default.nextInt(((DiceView)$anim.getComponentView()).getVisuals$bgw_core().getSize()));
        }

        private static final void addDiceAnimation$lambda-13(DiceAnimation $anim, Scene $scene, ActionEvent it) {
            Intrinsics.checkNotNullParameter((Object)$anim, (String)"$anim");
            Intrinsics.checkNotNullParameter((Object)$scene, (String)"$scene");
            ((DiceView)$anim.getComponentView()).setCurrentSide($anim.getToSide());
            Companion.onFinished($scene, $anim);
        }

        private static final void addRandomizeAnimation$lambda-16$lambda-15$lambda-14(RandomizeAnimation $anim, ActionEvent it) {
            Intrinsics.checkNotNullParameter((Object)$anim, (String)"$anim");
            ((GameComponentView)$anim.getComponentView()).setVisual($anim.getVisuals().get(Random.Default.nextInt($anim.getVisuals().size())));
        }

        private static final void addRandomizeAnimation$lambda-17(RandomizeAnimation $anim, Scene $scene, ActionEvent it) {
            Intrinsics.checkNotNullParameter((Object)$anim, (String)"$anim");
            Intrinsics.checkNotNullParameter((Object)$scene, (String)"$scene");
            ((GameComponentView)$anim.getComponentView()).setVisual($anim.getToVisual());
            Companion.onFinished($scene, $anim);
        }

        private static final void onFinished$lambda-18(tools.aqua.bgw.animation.Animation $anim) {
            Intrinsics.checkNotNullParameter((Object)$anim, (String)"$anim");
            Function1<AnimationFinishedEvent, Unit> function1 = $anim.getOnFinished();
            if (function1 != null) {
                function1.invoke((Object)new AnimationFinishedEvent());
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

