/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.tomcat3;

import java.io.IOException;
import org.apache.coyote.ActionCode;
import org.apache.coyote.Request;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.MessageBytes;

public class Tomcat3Request
extends org.apache.tomcat.core.Request {
    Request coyoteRequest = null;
    ByteChunk readChunk = new ByteChunk(8096);
    int pos = -1;
    int end = -1;
    byte[] readBuffer = null;

    public Tomcat3Request() {
        this.remoteAddrMB.recycle();
        this.remoteHostMB.recycle();
    }

    public void recycle() {
        super.recycle();
        if (this.coyoteRequest != null) {
            this.coyoteRequest.recycle();
        }
        this.remoteAddrMB.recycle();
        this.remoteHostMB.recycle();
        this.readChunk.recycle();
        this.readBuffer = null;
        this.pos = -1;
        this.end = -1;
    }

    public Request getCoyoteRequest() {
        return this.coyoteRequest;
    }

    public void setCoyoteRequest(Request cReq) {
        this.coyoteRequest = cReq;
        this.schemeMB = this.coyoteRequest.scheme();
        this.methodMB = this.coyoteRequest.method();
        this.uriMB = this.coyoteRequest.requestURI();
        this.queryMB = this.coyoteRequest.query();
        this.protoMB = this.coyoteRequest.protocol();
        this.headers = this.coyoteRequest.getMimeHeaders();
        this.scookies.setHeaders(this.headers);
        this.params.setHeaders(this.headers);
        this.params.setQuery(this.queryMB);
        this.remoteAddrMB = this.coyoteRequest.remoteAddr();
        this.remoteHostMB = this.coyoteRequest.remoteHost();
        this.serverNameMB = this.coyoteRequest.serverName();
    }

    public int doRead() throws IOException {
        if (this.available == 0) {
            return -1;
        }
        if (this.available != -1) {
            --this.available;
        }
        if (this.pos >= this.end && this.readBytes() < 0) {
            return -1;
        }
        return this.readBuffer[this.pos++] & 0xFF;
    }

    public int doRead(byte[] b, int off, int len) throws IOException {
        if (this.available == 0) {
            return -1;
        }
        if (this.pos >= this.end && this.readBytes() <= 0) {
            return -1;
        }
        int rd = -1;
        rd = this.end - this.pos > len ? len : this.end - this.pos;
        System.arraycopy(this.readBuffer, this.pos, b, off, rd);
        this.pos += rd;
        if (this.available != -1) {
            this.available -= rd;
        }
        return rd;
    }

    protected int readBytes() throws IOException {
        int result = this.coyoteRequest.doRead(this.readChunk);
        if (result > 0) {
            this.readBuffer = this.readChunk.getBytes();
            this.end = this.readChunk.getEnd();
            this.pos = this.readChunk.getStart();
        } else if (result < 0) {
            throw new IOException("Read bytes failed " + result);
        }
        return result;
    }

    public MessageBytes remoteAddr() {
        if (this.remoteAddrMB.isNull()) {
            this.coyoteRequest.action(ActionCode.ACTION_REQ_HOST_ADDR_ATTRIBUTE, (Object)this.coyoteRequest);
        }
        return this.remoteAddrMB;
    }

    public MessageBytes remoteHost() {
        if (this.remoteHostMB.isNull()) {
            this.coyoteRequest.action(ActionCode.ACTION_REQ_HOST_ATTRIBUTE, (Object)this.coyoteRequest);
        }
        return this.remoteHostMB;
    }

    public String getLocalHost() {
        return this.localHost;
    }

    public MessageBytes serverName() {
        return this.coyoteRequest.serverName();
    }

    public int getServerPort() {
        return this.coyoteRequest.getServerPort();
    }

    public void setServerPort(int i) {
        this.coyoteRequest.setServerPort(i);
    }

    public void setRemoteUser(String s) {
        super.setRemoteUser(s);
        this.coyoteRequest.getRemoteUser().setString(s);
    }

    public String getRemoteUser() {
        String s = this.coyoteRequest.getRemoteUser().toString();
        if (s == null) {
            s = super.getRemoteUser();
        }
        return s;
    }

    public String getAuthType() {
        return this.coyoteRequest.getAuthType().toString();
    }

    public void setAuthType(String s) {
        this.coyoteRequest.getAuthType().setString(s);
    }

    public String getJvmRoute() {
        return this.coyoteRequest.instanceId().toString();
    }

    public void setJvmRoute(String s) {
        this.coyoteRequest.instanceId().setString(s);
    }

    public boolean isSecure() {
        return "https".equalsIgnoreCase(this.coyoteRequest.scheme().toString());
    }
}

