/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.tomcat3;

import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.coyote.ActionCode;
import org.apache.coyote.Adapter;
import org.apache.coyote.ProtocolHandler;
import org.apache.coyote.Request;
import org.apache.coyote.tomcat3.Tomcat3Adapter;
import org.apache.coyote.tomcat3.Tomcat3Request;
import org.apache.coyote.tomcat3.Tomcat3Response;
import org.apache.tomcat.core.BaseInterceptor;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.core.Response;
import org.apache.tomcat.core.TomcatException;
import org.apache.tomcat.util.IntrospectionUtils;

public class CoyoteInterceptor2
extends BaseInterceptor {
    private String processorClassName = "org.apache.coyote.http11.Http11Protocol";
    Tomcat3Adapter adapter;
    ProtocolHandler proto;
    int protocolNote;
    Hashtable attributes = new Hashtable();

    public CoyoteInterceptor2() {
        this.setAttribute("port", "8080");
        this.setAttribute("soLinger", "-1");
    }

    public void setProcessorClassName(String pcn) {
        this.processorClassName = pcn;
    }

    public void setAttribute(String prop, Object value) {
        this.attributes.put(prop, value);
    }

    public void setProperty(String prop, String value) {
        this.setAttribute(prop, value);
    }

    public void engineInit(ContextManager cm) throws TomcatException {
        super.engineInit(cm);
        this.protocolNote = cm.getNoteId(5, "coyote.protocol");
        this.adapter = new Tomcat3Adapter(cm);
        try {
            Class<?> c = Class.forName(this.processorClassName);
            this.proto = (ProtocolHandler)c.newInstance();
            this.setNote(this.protocolNote, this.proto);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.setAttribute("jkHome", cm.getHome());
        this.proto.setAdapter((Adapter)this.adapter);
        try {
            Enumeration keys = this.attributes.keys();
            while (keys.hasMoreElements()) {
                String k = (String)keys.nextElement();
                Object o = this.attributes.get(k);
                if (o instanceof String) {
                    IntrospectionUtils.setProperty((Object)this.proto, (String)k, (String)((String)o));
                    continue;
                }
                IntrospectionUtils.setAttribute((Object)this.proto, (String)k, o);
            }
            this.proto.init();
        }
        catch (Exception ex) {
            throw new TomcatException("Error setting protocol properties ", (Throwable)ex);
        }
    }

    public void engineStart(ContextManager cm) throws TomcatException {
        try {
            this.proto.start();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new TomcatException((Throwable)ex);
        }
    }

    public void engineShutdown(ContextManager cm) throws TomcatException {
        try {
            this.proto.destroy();
        }
        catch (Exception ex) {
            throw new TomcatException((Throwable)ex);
        }
    }

    public int preService(org.apache.tomcat.core.Request request, Response response) {
        if (response instanceof Tomcat3Response) {
            try {
                ((Tomcat3Response)response).sendAcknowledgement();
            }
            catch (Exception ex) {
                this.log("Can't send ACK", ex);
            }
        }
        return 0;
    }

    public int postRequest(org.apache.tomcat.core.Request request, Response response) {
        if (request instanceof Tomcat3Request) {
            try {
                Tomcat3Request httpReq = (Tomcat3Request)request;
                Request cReq = httpReq.getCoyoteRequest();
                cReq.action(ActionCode.ACTION_POST_REQUEST, null);
            }
            catch (Exception ex) {
                this.log("Can't send ACK", ex);
            }
        }
        return 0;
    }

    public Object getInfo(Context ctx, org.apache.tomcat.core.Request request, int id, String key) {
        if (!(request instanceof Tomcat3Request)) {
            return null;
        }
        Tomcat3Request httpReq = (Tomcat3Request)request;
        if (key != null && httpReq != null) {
            Request cReq = httpReq.getCoyoteRequest();
            Object info = cReq.getAttribute(key);
            if (info != null) {
                return info;
            }
            if (CoyoteInterceptor2.isSSLAttribute(key)) {
                cReq.action(ActionCode.ACTION_REQ_SSL_ATTRIBUTE, (Object)httpReq.getCoyoteRequest());
                Object[] value = (Object[])cReq.getAttribute("javax.servlet.request.X509Certificate");
                if (value != null) {
                    cReq.setAttribute("javax.servlet.request.X509Certificate", value[0]);
                }
                return cReq.getAttribute(key);
            }
            return cReq.getAttribute(key);
        }
        return super.getInfo(ctx, request, id, key);
    }

    public int setInfo(Context ctx, org.apache.tomcat.core.Request request, int id, String key, String object) {
        if (!(request instanceof Tomcat3Request)) {
            return -1;
        }
        Tomcat3Request httpReq = (Tomcat3Request)request;
        if (key != null && httpReq != null) {
            Request cReq = httpReq.getCoyoteRequest();
            cReq.setAttribute(key, (Object)object);
            return 0;
        }
        return super.setInfo(ctx, request, id, key, (Object)object);
    }

    public static boolean isSSLAttribute(String key) {
        return "javax.servlet.request.cipher_suite".equals(key) || "javax.servlet.request.key_size".equals(key) || "javax.servlet.request.X509Certificate".equals(key) || "javax.servlet.request.ssl_session".equals(key);
    }
}

