/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jk.common;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jk.common.JniHandler;
import org.apache.jk.core.Msg;
import org.apache.jk.core.MsgContext;

public class ChannelJni
extends JniHandler {
    int receivedNote = 1;
    private static Log log = LogFactory.getLog((Class)(class$org$apache$jk$common$ChannelJni == null ? (class$org$apache$jk$common$ChannelJni = ChannelJni.class$("org.apache.jk.common.ChannelJni")) : class$org$apache$jk$common$ChannelJni));
    static /* synthetic */ Class class$org$apache$jk$common$ChannelJni;

    public void init() throws IOException {
        super.initNative("channel.jni:jni");
        if (this.apr == null) {
            return;
        }
        this.apr.addJkHandler("channelJni", this);
        log.info((Object)"JK2: listening on channel.jni:jni");
        if (this.next == null) {
            if (this.nextName != null) {
                this.setNext(this.wEnv.getHandler(this.nextName));
            }
            if (this.next == null) {
                this.next = this.wEnv.getHandler("dispatch");
            }
            if (this.next == null) {
                this.next = this.wEnv.getHandler("request");
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Setting default next " + this.next.getClass().getName()));
            }
        }
    }

    public int receive(Msg msg, MsgContext ep) throws IOException {
        Msg sentResponse = (Msg)ep.getNote(this.receivedNote);
        ep.setNote(this.receivedNote, null);
        if (sentResponse == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No send() prior to receive(), no data buffer");
            }
            msg.reset();
            return 0;
        }
        sentResponse.processHeader();
        if (log.isTraceEnabled()) {
            sentResponse.dump("received response ");
        }
        if (msg != sentResponse) {
            log.error((Object)"Error, in JNI mode the msg used for receive() must be identical with the one used for send()");
        }
        return 0;
    }

    public int send(Msg msg, MsgContext ep) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("ChannelJni.send: " + msg));
        }
        int rc = super.nativeDispatch(msg, ep, 21, 0);
        ep.setNote(this.receivedNote, msg);
        return rc;
    }

    public int invoke(Msg msg, MsgContext ep) throws IOException {
        if (this.apr == null) {
            return -1;
        }
        long xEnv = ep.getJniEnv();
        long cEndpointP = ep.getJniContext();
        int type = ep.getType();
        if (log.isDebugEnabled()) {
            log.debug((Object)("ChannelJni.invoke: " + ep + " " + type));
        }
        switch (type) {
            case 10: {
                return this.receive(msg, ep);
            }
            case 11: {
                ep.setNote(this.receivedNote, null);
                return this.send(msg, ep);
            }
            case 12: {
                ep.setNote(this.receivedNote, null);
                return 0;
            }
        }
        ep.setNote(this.receivedNote, null);
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Received request " + xEnv));
            }
            msg.processHeader();
            if (log.isTraceEnabled()) {
                msg.dump("Incoming msg ");
            }
            int status = this.next.invoke(msg, ep);
            if (log.isDebugEnabled()) {
                log.debug((Object)("after processCallbacks " + status));
            }
            return status;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

