/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.Socket;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Server;
import org.apache.catalina.startup.ContextRuleSet;
import org.apache.catalina.startup.Embedded;
import org.apache.catalina.startup.EngineRuleSet;
import org.apache.catalina.startup.HostRuleSet;
import org.apache.catalina.startup.NamingRuleSet;
import org.apache.catalina.startup.SetAllPropertiesRule;
import org.apache.catalina.startup.SetParentClassLoaderRule;
import org.apache.catalina.util.CatalinaDigester;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.RuleSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tomcat.util.log.SystemLogHandler;
import org.xml.sax.InputSource;

public class Catalina
extends Embedded {
    protected String configFile = "conf/server.xml";
    protected ClassLoader parentClassLoader = (class$org$apache$catalina$startup$Catalina == null ? (class$org$apache$catalina$startup$Catalina = Catalina.class$("org.apache.catalina.startup.Catalina")) : class$org$apache$catalina$startup$Catalina).getClassLoader();
    protected Server server = null;
    protected boolean starting = false;
    protected boolean stopping = false;
    protected boolean useShutdownHook = true;
    protected Thread shutdownHook = null;
    private static Log log = LogFactory.getLog((Class)(class$org$apache$catalina$startup$Catalina == null ? (class$org$apache$catalina$startup$Catalina = Catalina.class$("org.apache.catalina.startup.Catalina")) : class$org$apache$catalina$startup$Catalina));
    static /* synthetic */ Class class$org$apache$catalina$startup$Catalina;
    static /* synthetic */ Class class$org$apache$catalina$core$StandardServer;

    public void setConfig(String file) {
        this.configFile = file;
    }

    public void setConfigFile(String file) {
        this.configFile = file;
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public void setUseShutdownHook(boolean useShutdownHook) {
        this.useShutdownHook = useShutdownHook;
    }

    public boolean getUseShutdownHook() {
        return this.useShutdownHook;
    }

    public void setParentClassLoader(ClassLoader parentClassLoader) {
        this.parentClassLoader = parentClassLoader;
    }

    public void setServer(Server server) {
        this.server = server;
    }

    public static void main(String[] args) {
        new Catalina().process(args);
    }

    public void process(String[] args) {
        this.setAwait(true);
        this.setCatalinaHome();
        this.setCatalinaBase();
        try {
            if (this.arguments(args)) {
                if (this.starting) {
                    this.load(args);
                    this.start();
                } else if (this.stopping) {
                    this.stopServer();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    protected boolean arguments(String[] args) {
        boolean isConfig = false;
        if (args.length < 1) {
            this.usage();
            return false;
        }
        for (int i = 0; i < args.length; ++i) {
            if (isConfig) {
                this.configFile = args[i];
                isConfig = false;
                continue;
            }
            if (args[i].equals("-config")) {
                isConfig = true;
                continue;
            }
            if (args[i].equals("-debug")) {
                this.debug = 1;
                continue;
            }
            if (args[i].equals("-nonaming")) {
                this.setUseNaming(false);
                continue;
            }
            if (args[i].equals("-help")) {
                this.usage();
                return false;
            }
            if (args[i].equals("start")) {
                this.starting = true;
                this.stopping = false;
                continue;
            }
            if (args[i].equals("stop")) {
                this.starting = false;
                this.stopping = true;
                continue;
            }
            this.usage();
            return false;
        }
        return true;
    }

    protected File configFile() {
        File file = new File(this.configFile);
        if (!file.isAbsolute()) {
            file = new File(System.getProperty("catalina.base"), this.configFile);
        }
        return file;
    }

    protected Digester createStartDigester() {
        long t1 = System.currentTimeMillis();
        CatalinaDigester digester = new CatalinaDigester();
        if (this.debug > 0) {
            digester.setDebug(this.debug);
        }
        digester.setValidating(false);
        digester.setClassLoader((class$org$apache$catalina$core$StandardServer == null ? (class$org$apache$catalina$core$StandardServer = Catalina.class$("org.apache.catalina.core.StandardServer")) : class$org$apache$catalina$core$StandardServer).getClassLoader());
        digester.addObjectCreate("Server", "org.apache.catalina.core.StandardServer", "className");
        digester.addSetProperties("Server");
        digester.addSetNext("Server", "setServer", "org.apache.catalina.Server");
        digester.addObjectCreate("Server/GlobalNamingResources", "org.apache.catalina.deploy.NamingResources");
        digester.addSetProperties("Server/GlobalNamingResources");
        digester.addSetNext("Server/GlobalNamingResources", "setGlobalNamingResources", "org.apache.catalina.deploy.NamingResources");
        digester.addObjectCreate("Server/Listener", null, "className");
        digester.addSetProperties("Server/Listener");
        digester.addSetNext("Server/Listener", "addLifecycleListener", "org.apache.catalina.LifecycleListener");
        digester.addObjectCreate("Server/Service", "org.apache.catalina.core.StandardService", "className");
        digester.addSetProperties("Server/Service");
        digester.addSetNext("Server/Service", "addService", "org.apache.catalina.Service");
        digester.addObjectCreate("Server/Service/Listener", null, "className");
        digester.addSetProperties("Server/Service/Listener");
        digester.addSetNext("Server/Service/Listener", "addLifecycleListener", "org.apache.catalina.LifecycleListener");
        digester.addObjectCreate("Server/Service/Connector", "org.apache.coyote.tomcat5.CoyoteConnector", "className");
        digester.addRule("Server/Service/Connector", new SetAllPropertiesRule());
        digester.addSetNext("Server/Service/Connector", "addConnector", "org.apache.catalina.Connector");
        digester.addObjectCreate("Server/Service/Connector/Factory", "org.apache.coyote.tomcat5.CoyoteServerSocketFactory", "className");
        digester.addSetProperties("Server/Service/Connector/Factory");
        digester.addSetNext("Server/Service/Connector/Factory", "setFactory", "org.apache.catalina.net.ServerSocketFactory");
        digester.addObjectCreate("Server/Service/Connector/Listener", null, "className");
        digester.addSetProperties("Server/Service/Connector/Listener");
        digester.addSetNext("Server/Service/Connector/Listener", "addLifecycleListener", "org.apache.catalina.LifecycleListener");
        digester.addRuleSet((RuleSet)new NamingRuleSet("Server/GlobalNamingResources/"));
        digester.addRuleSet((RuleSet)new EngineRuleSet("Server/Service/"));
        digester.addRuleSet((RuleSet)new HostRuleSet("Server/Service/Engine/"));
        digester.addRuleSet((RuleSet)new ContextRuleSet("Server/Service/Engine/Default"));
        digester.addRuleSet((RuleSet)new NamingRuleSet("Server/Service/Engine/DefaultContext/"));
        digester.addRuleSet((RuleSet)new ContextRuleSet("Server/Service/Engine/Host/Default"));
        digester.addRuleSet((RuleSet)new NamingRuleSet("Server/Service/Engine/Host/DefaultContext/"));
        digester.addRuleSet((RuleSet)new ContextRuleSet("Server/Service/Engine/Host/"));
        digester.addRuleSet((RuleSet)new NamingRuleSet("Server/Service/Engine/Host/Context/"));
        digester.addRule("Server/Service/Engine", new SetParentClassLoaderRule(digester, this.parentClassLoader));
        long t2 = System.currentTimeMillis();
        log.debug((Object)("Digester for server.xml created " + (t2 - t1)));
        return digester;
    }

    protected Digester createStopDigester() {
        Digester digester = new Digester();
        if (this.debug > 0) {
            digester.setDebug(this.debug);
        }
        digester.addObjectCreate("Server", "org.apache.catalina.core.StandardServer", "className");
        digester.addSetProperties("Server");
        digester.addSetNext("Server", "setServer", "org.apache.catalina.Server");
        return digester;
    }

    public void stopServer() {
        if (this.server == null) {
            Digester digester = this.createStopDigester();
            digester.setClassLoader(Thread.currentThread().getContextClassLoader());
            File file = this.configFile();
            try {
                InputSource is = new InputSource("file://" + file.getAbsolutePath());
                FileInputStream fis = new FileInputStream(file);
                is.setByteStream(fis);
                digester.push((Object)this);
                digester.parse(is);
                fis.close();
            }
            catch (Exception e) {
                System.out.println("Catalina.stop: " + e);
                e.printStackTrace(System.out);
                System.exit(1);
            }
        }
        try {
            Socket socket = new Socket("127.0.0.1", this.server.getPort());
            OutputStream stream = socket.getOutputStream();
            String shutdown = this.server.getShutdown();
            for (int i = 0; i < shutdown.length(); ++i) {
                stream.write(shutdown.charAt(i));
            }
            stream.flush();
            stream.close();
            socket.close();
        }
        catch (IOException e) {
            System.out.println("Catalina.stop: " + e);
            e.printStackTrace(System.out);
            System.exit(1);
        }
    }

    public void setCatalinaBase() {
        this.initDirs();
    }

    public void setCatalinaHome() {
        this.initDirs();
    }

    public void load() {
        this.initDirs();
        this.initNaming();
        Digester digester = this.createStartDigester();
        long t1 = System.currentTimeMillis();
        Object ex = null;
        InputSource inputSource = null;
        InputStream inputStream = null;
        try {
            File file = this.configFile();
            inputStream = new FileInputStream(file);
            inputSource = new InputSource("file://" + file.getAbsolutePath());
        }
        catch (Exception e) {
            // empty catch block
        }
        if (inputStream == null) {
            try {
                inputStream = this.getClass().getClassLoader().getResourceAsStream(this.getConfigFile());
                inputSource = new InputSource(this.getClass().getClassLoader().getResource(this.getConfigFile()).toString());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (inputStream == null) {
            System.out.println("Can't load server.xml");
            return;
        }
        try {
            inputSource.setByteStream(inputStream);
            digester.push((Object)this);
            digester.parse(inputSource);
            inputStream.close();
        }
        catch (Exception e) {
            System.out.println("Catalina.start: " + e);
            e.printStackTrace(System.out);
            return;
        }
        SystemLogHandler systemlog = new SystemLogHandler(System.out);
        System.setOut((PrintStream)systemlog);
        System.setErr((PrintStream)systemlog);
        if (this.server instanceof Lifecycle) {
            try {
                this.server.initialize();
            }
            catch (LifecycleException e) {
                log.error((Object)"Catalina.start", (Throwable)e);
            }
        }
        long t2 = System.currentTimeMillis();
        log.info((Object)("Initialization processed in " + (t2 - t1) + " ms"));
    }

    public void load(String[] args) {
        this.setCatalinaHome();
        this.setCatalinaBase();
        try {
            if (this.arguments(args)) {
                this.load();
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    public void create() {
    }

    public void destroy() {
    }

    public void start() {
        if (this.server == null) {
            this.load();
        }
        long t1 = System.currentTimeMillis();
        if (this.server instanceof Lifecycle) {
            try {
                ((Lifecycle)((Object)this.server)).start();
            }
            catch (LifecycleException e) {
                log.error((Object)"Catalina.start: ", (Throwable)e);
            }
        }
        long t2 = System.currentTimeMillis();
        log.info((Object)("Server startup in " + (t2 - t1) + " ms"));
        try {
            if (this.useShutdownHook) {
                if (this.shutdownHook == null) {
                    this.shutdownHook = new CatalinaShutdownHook();
                }
                Runtime.getRuntime().addShutdownHook(this.shutdownHook);
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (this.await) {
            this.await();
            this.stop();
        }
    }

    public void stop() {
        try {
            if (this.useShutdownHook) {
                Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (this.server instanceof Lifecycle) {
            try {
                ((Lifecycle)((Object)this.server)).stop();
            }
            catch (LifecycleException e) {
                log.error((Object)"Catalina.stop", (Throwable)e);
            }
        }
    }

    public void await() {
        this.server.await();
    }

    protected void usage() {
        System.out.println("usage: java org.apache.catalina.startup.Catalina [ -config {pathname} ] [ -debug ] [ -nonaming ] { start | stop }");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class CatalinaShutdownHook
    extends Thread {
        protected CatalinaShutdownHook() {
        }

        public void run() {
            if (Catalina.this.server != null) {
                Catalina.this.stop();
            }
        }
    }
}

