/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.session;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.catalina.Container;
import org.apache.catalina.DefaultContext;
import org.apache.catalina.Engine;
import org.apache.catalina.Manager;
import org.apache.catalina.Session;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.session.StandardSession;
import org.apache.catalina.util.StringManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.modeler.Registry;

public abstract class ManagerBase
implements Manager,
MBeanRegistration {
    protected Log log = LogFactory.getLog((Class)(class$org$apache$catalina$session$ManagerBase == null ? (class$org$apache$catalina$session$ManagerBase = ManagerBase.class$("org.apache.catalina.session.ManagerBase")) : class$org$apache$catalina$session$ManagerBase));
    protected DataInputStream randomIS = null;
    protected String devRandomSource = "/dev/urandom";
    protected static final String DEFAULT_ALGORITHM = "MD5";
    protected static final int SESSION_ID_BYTES = 16;
    protected String algorithm = "MD5";
    protected Container container;
    protected int debug = 0;
    protected DefaultContext defaultContext = null;
    protected MessageDigest digest = null;
    protected boolean distributable;
    protected String entropy = null;
    private static final String info = "ManagerBase/1.0";
    protected int maxInactiveInterval = 60;
    protected static String name = "ManagerBase";
    protected Random random = null;
    protected String randomClass = "java.security.SecureRandom";
    protected HashMap sessions = new HashMap();
    protected int sessionCounter = 0;
    protected int maxActive = 0;
    protected int duplicates = 0;
    protected boolean initialized = false;
    protected static StringManager sm = StringManager.getManager("org.apache.catalina.session");
    protected PropertyChangeSupport support = new PropertyChangeSupport(this);
    protected String domain;
    protected ObjectName oname;
    protected MBeanServer mserver;
    static /* synthetic */ Class class$org$apache$catalina$session$ManagerBase;

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        String oldAlgorithm = this.algorithm;
        this.algorithm = algorithm;
        this.support.firePropertyChange("algorithm", oldAlgorithm, this.algorithm);
    }

    public Container getContainer() {
        return this.container;
    }

    public void setContainer(Container container) {
        Container oldContainer = this.container;
        this.container = container;
        this.support.firePropertyChange("container", oldContainer, this.container);
    }

    public DefaultContext getDefaultContext() {
        return this.defaultContext;
    }

    public void setDefaultContext(DefaultContext defaultContext) {
        DefaultContext oldDefaultContext = this.defaultContext;
        this.defaultContext = defaultContext;
        this.support.firePropertyChange("defaultContext", oldDefaultContext, this.defaultContext);
    }

    public int getDebug() {
        return this.debug;
    }

    public void setDebug(int debug) {
        this.debug = debug;
    }

    public String getClassName() {
        return this.getClass().getName();
    }

    public synchronized MessageDigest getDigest() {
        if (this.digest == null) {
            long t1 = System.currentTimeMillis();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)sm.getString("managerBase.getting", this.algorithm));
            }
            try {
                this.digest = MessageDigest.getInstance(this.algorithm);
            }
            catch (NoSuchAlgorithmException e) {
                this.log.error((Object)sm.getString("managerBase.digest", this.algorithm), (Throwable)e);
                try {
                    this.digest = MessageDigest.getInstance(DEFAULT_ALGORITHM);
                }
                catch (NoSuchAlgorithmException f) {
                    this.log.error((Object)sm.getString("managerBase.digest", DEFAULT_ALGORITHM), (Throwable)e);
                    this.digest = null;
                }
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)sm.getString("managerBase.gotten"));
            }
            long t2 = System.currentTimeMillis();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("getDigest() " + (t2 - t1)));
            }
        }
        return this.digest;
    }

    public boolean getDistributable() {
        return this.distributable;
    }

    public void setDistributable(boolean distributable) {
        boolean oldDistributable = this.distributable;
        this.distributable = distributable;
        this.support.firePropertyChange("distributable", new Boolean(oldDistributable), new Boolean(this.distributable));
    }

    public String getEntropy() {
        if (this.entropy == null) {
            this.setEntropy(this.toString());
        }
        return this.entropy;
    }

    public void setEntropy(String entropy) {
        String oldEntropy = entropy;
        this.entropy = entropy;
        this.support.firePropertyChange("entropy", oldEntropy, this.entropy);
    }

    public String getInfo() {
        return info;
    }

    public int getMaxInactiveInterval() {
        return this.maxInactiveInterval;
    }

    public void setMaxInactiveInterval(int interval) {
        int oldMaxInactiveInterval = this.maxInactiveInterval;
        this.maxInactiveInterval = interval;
        this.support.firePropertyChange("maxInactiveInterval", new Integer(oldMaxInactiveInterval), new Integer(this.maxInactiveInterval));
    }

    public String getName() {
        return name;
    }

    public void setRandomFile(String s) {
        if (System.getSecurityManager() != null) {
            this.randomIS = (DataInputStream)AccessController.doPrivileged(new PrivilegedSetRandomFile());
        } else {
            try {
                this.devRandomSource = s;
                File f = new File(this.devRandomSource);
                if (!f.exists()) {
                    return;
                }
                this.randomIS = new DataInputStream(new FileInputStream(f));
                this.randomIS.readLong();
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Opening " + this.devRandomSource));
                }
            }
            catch (IOException ex) {
                this.randomIS = null;
            }
        }
    }

    public String getRandomFile() {
        return this.devRandomSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Random getRandom() {
        if (this.random == null) {
            ManagerBase managerBase = this;
            synchronized (managerBase) {
                if (this.random == null) {
                    long seed;
                    long t1 = seed = System.currentTimeMillis();
                    char[] entropy = this.getEntropy().toCharArray();
                    for (int i = 0; i < entropy.length; ++i) {
                        long update = (byte)entropy[i] << i % 8 * 8;
                        seed ^= update;
                    }
                    try {
                        Class<?> clazz = Class.forName(this.randomClass);
                        this.random = (Random)clazz.newInstance();
                        this.random.setSeed(seed);
                    }
                    catch (Exception e) {
                        this.log.error((Object)sm.getString("managerBase.random", this.randomClass), (Throwable)e);
                        this.random = new Random();
                        this.random.setSeed(seed);
                    }
                    long t2 = System.currentTimeMillis();
                    if (t2 - t1 > 100L) {
                        this.log.debug((Object)(sm.getString("managerBase.seeding", this.randomClass) + " " + (t2 - t1)));
                    }
                }
            }
        }
        return this.random;
    }

    public String getRandomClass() {
        return this.randomClass;
    }

    public void setRandomClass(String randomClass) {
        String oldRandomClass = this.randomClass;
        this.randomClass = randomClass;
        this.support.firePropertyChange("randomClass", oldRandomClass, this.randomClass);
    }

    public void backgroundProcess() {
    }

    public void destroy() {
        if (this.oname != null) {
            Registry.getRegistry().unregisterComponent(this.oname);
        }
        this.initialized = false;
        this.oname = null;
    }

    public void init() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        if (this.oname == null) {
            try {
                StandardContext ctx = (StandardContext)this.getContainer();
                Engine eng = (Engine)ctx.getParent().getParent();
                this.domain = ctx.getEngineName();
                StandardHost hst = (StandardHost)ctx.getParent();
                String path = ctx.getPath();
                if (path.equals("")) {
                    path = "/";
                }
                this.oname = new ObjectName(this.domain + ":type=Manager,path=" + path + ",host=" + hst.getName());
                Registry.getRegistry().registerComponent((Object)this, this.oname, null);
            }
            catch (Exception e) {
                this.log.error((Object)"Error registering ", (Throwable)e);
            }
        }
        this.log.debug((Object)("Registering " + this.oname));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Session session) {
        HashMap hashMap = this.sessions;
        synchronized (hashMap) {
            this.sessions.put(session.getId(), session);
            if (this.sessions.size() > this.maxActive) {
                this.maxActive = this.sessions.size();
            }
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session createSession() {
        Session session = this.createEmptySession();
        session.setNew(true);
        session.setValid(true);
        session.setCreationTime(System.currentTimeMillis());
        session.setMaxInactiveInterval(this.maxInactiveInterval);
        String sessionId = this.generateSessionId();
        String jvmRoute = this.getJvmRoute();
        if (jvmRoute != null) {
            sessionId = sessionId + '.' + jvmRoute;
        }
        HashMap hashMap = this.sessions;
        synchronized (hashMap) {
            while (this.sessions.get(sessionId) != null) {
                ++this.duplicates;
                sessionId = this.generateSessionId();
                if (jvmRoute == null) continue;
                sessionId = sessionId + '.' + jvmRoute;
            }
        }
        session.setId(sessionId);
        ++this.sessionCounter;
        return session;
    }

    public Session createEmptySession() {
        return this.getNewSession();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session findSession(String id) throws IOException {
        if (id == null) {
            return null;
        }
        HashMap hashMap = this.sessions;
        synchronized (hashMap) {
            Session session = (Session)this.sessions.get(id);
            return session;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session[] findSessions() {
        Session[] results = null;
        HashMap hashMap = this.sessions;
        synchronized (hashMap) {
            results = new Session[this.sessions.size()];
            results = this.sessions.values().toArray(results);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Session session) {
        HashMap hashMap = this.sessions;
        synchronized (hashMap) {
            this.sessions.remove(session.getId());
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    protected StandardSession getNewSession() {
        return new StandardSession(this);
    }

    protected void getRandomBytes(byte[] bytes) {
        if (this.devRandomSource != null && this.randomIS == null) {
            this.setRandomFile(this.devRandomSource);
        }
        if (this.randomIS != null) {
            try {
                int len = this.randomIS.read(bytes);
                if (len == bytes.length) {
                    return;
                }
                this.log.debug((Object)("Got " + len + " " + bytes.length));
            }
            catch (Exception ex) {
                // empty catch block
            }
            this.devRandomSource = null;
            this.randomIS = null;
        }
        Random random = this.getRandom();
        this.getRandom().nextBytes(bytes);
    }

    protected synchronized String generateSessionId() {
        byte[] bytes = new byte[16];
        this.getRandomBytes(bytes);
        bytes = this.getDigest().digest(bytes);
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            byte b1 = (byte)((bytes[i] & 0xF0) >> 4);
            byte b2 = (byte)(bytes[i] & 0xF);
            if (b1 < 10) {
                result.append((char)(48 + b1));
            } else {
                result.append((char)(65 + (b1 - 10)));
            }
            if (b2 < 10) {
                result.append((char)(48 + b2));
                continue;
            }
            result.append((char)(65 + (b2 - 10)));
        }
        return result.toString();
    }

    public Engine getEngine() {
        Engine e = null;
        for (Container c = this.getContainer(); e == null && c != null; c = c.getParent()) {
            if (c == null || !(c instanceof Engine)) continue;
            e = (Engine)c;
        }
        return e;
    }

    public String getJvmRoute() {
        Engine e = this.getEngine();
        return e == null ? null : e.getJvmRoute();
    }

    protected void log(String message) {
        this.log.info((Object)message);
    }

    protected void log(String message, Throwable throwable) {
        this.log.info((Object)message, throwable);
    }

    public void setSessionCounter(int sessionCounter) {
        this.sessionCounter = sessionCounter;
    }

    public int getSessionCounter() {
        return this.sessionCounter;
    }

    public int getDuplicates() {
        return this.duplicates;
    }

    public void setDuplicates(int duplicates) {
        this.duplicates = duplicates;
    }

    public int getActiveSessions() {
        return this.sessions.size();
    }

    public int getMaxActive() {
        return this.maxActive;
    }

    public void setMaxActive(int maxActive) {
        this.maxActive = maxActive;
    }

    public String listSessionIds() {
        StringBuffer sb = new StringBuffer();
        Iterator keys = this.sessions.keySet().iterator();
        while (keys.hasNext()) {
            sb.append(keys.next()).append(" ");
        }
        return sb.toString();
    }

    public String getSessionAttribute(String sessionId, String key) {
        Session s = (Session)this.sessions.get(sessionId);
        if (s == null) {
            this.log.info((Object)("Session not found " + sessionId));
            return null;
        }
        Object o = s.getSession().getAttribute(key);
        if (o == null) {
            return null;
        }
        return o.toString();
    }

    public void expireSession(String sessionId) {
        Session s = (Session)this.sessions.get(sessionId);
        if (s == null) {
            this.log.info((Object)("Session not found " + sessionId));
            return;
        }
        s.expire();
    }

    public String getLastAccessedTime(String sessionId) {
        Session s = (Session)this.sessions.get(sessionId);
        if (s == null) {
            this.log.info((Object)("Session not found " + sessionId));
            return "";
        }
        return new Date(s.getLastAccessedTime()).toString();
    }

    public ObjectName getObjectName() {
        return this.oname;
    }

    public String getDomain() {
        return this.domain;
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.oname = name;
        this.mserver = server;
        this.domain = name.getDomain();
        return name;
    }

    public void postRegister(Boolean registrationDone) {
    }

    public void preDeregister() throws Exception {
    }

    public void postDeregister() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class PrivilegedSetRandomFile
    implements PrivilegedAction {
        private PrivilegedSetRandomFile() {
        }

        public Object run() {
            try {
                File f = new File(ManagerBase.this.devRandomSource);
                if (!f.exists()) {
                    return null;
                }
                ManagerBase.this.randomIS = new DataInputStream(new FileInputStream(f));
                ManagerBase.this.randomIS.readLong();
                if (ManagerBase.this.log.isDebugEnabled()) {
                    ManagerBase.this.log.debug((Object)("Opening " + ManagerBase.this.devRandomSource));
                }
                return ManagerBase.this.randomIS;
            }
            catch (IOException ex) {
                return null;
            }
        }
    }
}

