/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.security;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import javax.security.auth.Subject;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.catalina.util.StringManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class SecurityUtil {
    private static final int INIT = 0;
    private static final int SERVICE = 1;
    private static final int DOFILTER = 1;
    private static final int DESTROY = 2;
    private static final String INIT_METHOD = "init";
    private static final String DOFILTER_METHOD = "doFilter";
    private static final String SERVICE_METHOD = "service";
    private static final String DESTROY_METHOD = "destroy";
    private static HashMap objectCache = new HashMap();
    private static Log log = LogFactory.getLog((Class)(class$org$apache$catalina$security$SecurityUtil == null ? (class$org$apache$catalina$security$SecurityUtil = SecurityUtil.class$("org.apache.catalina.security.SecurityUtil")) : class$org$apache$catalina$security$SecurityUtil));
    private static String PACKAGE = "org.apache.catalina.security";
    private static final StringManager sm = StringManager.getManager(PACKAGE);
    static /* synthetic */ Class class$org$apache$catalina$security$SecurityUtil;

    public static void doAsPrivilege(String methodName, Servlet targetObject) throws Exception {
        SecurityUtil.doAsPrivilege(methodName, targetObject, null, null, null);
    }

    public static void doAsPrivilege(String methodName, Servlet targetObject, Class[] targetType, Object[] targetArguments) throws Exception {
        SecurityUtil.doAsPrivilege(methodName, targetObject, targetType, targetArguments, null);
    }

    public static void doAsPrivilege(String methodName, Servlet targetObject, Class[] targetType, Object[] targetArguments, Principal principal) throws Exception {
        Method method = null;
        Method[] methodsCache = null;
        if (objectCache.containsKey(targetObject)) {
            methodsCache = (Method[])objectCache.get(targetObject);
            method = SecurityUtil.findMethod(methodsCache, methodName);
            if (method == null) {
                method = SecurityUtil.createMethodAndCacheIt(methodsCache, methodName, targetObject, targetType);
            }
        } else {
            method = SecurityUtil.createMethodAndCacheIt(methodsCache, methodName, targetObject, targetType);
        }
        SecurityUtil.execute(method, targetObject, targetArguments, principal);
    }

    public static void doAsPrivilege(String methodName, Filter targetObject) throws Exception {
        SecurityUtil.doAsPrivilege(methodName, targetObject, null, null);
    }

    public static void doAsPrivilege(String methodName, Filter targetObject, Class[] targetType, Object[] targetArguments) throws Exception {
        Method method = null;
        Method[] methodsCache = null;
        if (objectCache.containsKey(targetObject)) {
            methodsCache = (Method[])objectCache.get(targetObject);
            method = SecurityUtil.findMethod(methodsCache, methodName);
            if (method == null) {
                method = SecurityUtil.createMethodAndCacheIt(methodsCache, methodName, targetObject, targetType);
            }
        } else {
            method = SecurityUtil.createMethodAndCacheIt(methodsCache, methodName, targetObject, targetType);
        }
        SecurityUtil.execute(method, targetObject, targetArguments, null);
    }

    private static void execute(final Method method, final Object targetObject, final Object[] targetArguments, Principal principal) throws Exception {
        try {
            HttpServletRequest request;
            HttpSession session;
            Subject subject = null;
            PrivilegedExceptionAction pea = new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    method.invoke(targetObject, targetArguments);
                    return null;
                }
            };
            if (targetArguments != null && targetArguments[0] instanceof HttpServletRequest && (session = (request = (HttpServletRequest)targetArguments[0]).getSession(false)) != null && (subject = (Subject)session.getAttribute("javax.security.auth.subject")) == null) {
                subject = new Subject();
                session.setAttribute("javax.security.auth.subject", (Object)subject);
            }
            Subject.doAsPrivileged(subject, pea, null);
        }
        catch (PrivilegedActionException pe) {
            Throwable e = ((InvocationTargetException)pe.getException()).getTargetException();
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("SecurityUtil.doAsPrivilege"), e);
            }
            if (e instanceof UnavailableException) {
                throw (UnavailableException)e;
            }
            if (e instanceof ServletException) {
                throw (ServletException)e;
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new ServletException(e.getMessage(), e);
        }
    }

    private static Method findMethod(Method[] methodsCache, String methodName) {
        if (methodName.equalsIgnoreCase(INIT_METHOD) && methodsCache[0] != null) {
            return methodsCache[0];
        }
        if (methodName.equalsIgnoreCase(DESTROY_METHOD) && methodsCache[2] != null) {
            return methodsCache[2];
        }
        if (methodName.equalsIgnoreCase(SERVICE_METHOD) && methodsCache[1] != null) {
            return methodsCache[1];
        }
        if (methodName.equalsIgnoreCase(DOFILTER_METHOD) && methodsCache[1] != null) {
            return methodsCache[1];
        }
        return null;
    }

    private static Method createMethodAndCacheIt(Method[] methodsCache, String methodName, Object targetObject, Class[] targetType) throws Exception {
        if (methodsCache == null) {
            methodsCache = new Method[3];
        }
        Method method = targetObject.getClass().getMethod(methodName, targetType);
        if (methodName.equalsIgnoreCase(INIT_METHOD)) {
            methodsCache[0] = method;
        } else if (methodName.equalsIgnoreCase(DESTROY_METHOD)) {
            methodsCache[2] = method;
        } else if (methodName.equalsIgnoreCase(SERVICE_METHOD)) {
            methodsCache[1] = method;
        } else if (methodName.equalsIgnoreCase(DOFILTER_METHOD)) {
            methodsCache[1] = method;
        }
        objectCache.put(targetObject, methodsCache);
        return method;
    }

    public static void remove(Object cachedObject) {
        objectCache.remove(cachedObject);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

