/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Context;
import org.apache.catalina.HttpRequest;
import org.apache.catalina.Logger;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.ValveContext;
import org.apache.catalina.connector.ClientAbortException;
import org.apache.catalina.core.ApplicationFilterChain;
import org.apache.catalina.core.ApplicationFilterFactory;
import org.apache.catalina.core.StandardWrapper;
import org.apache.catalina.util.StringManager;
import org.apache.catalina.valves.ValveBase;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tomcat.util.buf.MessageBytes;

final class StandardWrapperValve
extends ValveBase {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$catalina$core$StandardWrapperValve == null ? (class$org$apache$catalina$core$StandardWrapperValve = StandardWrapperValve.class$("org.apache.catalina.core.StandardWrapperValve")) : class$org$apache$catalina$core$StandardWrapperValve));
    private long processingTime;
    private long maxTime;
    private int requestCount;
    private int errorCount;
    private static final StringManager sm = StringManager.getManager("org.apache.catalina.core");
    static /* synthetic */ Class class$org$apache$catalina$core$StandardWrapperValve;

    StandardWrapperValve() {
    }

    public final void invoke(Request request, Response response, ValveContext valveContext) throws IOException, ServletException {
        long t1;
        block49: {
            Servlet servlet;
            StandardWrapper wrapper;
            Throwable throwable;
            block48: {
                block47: {
                    boolean unavailable = false;
                    throwable = null;
                    t1 = System.currentTimeMillis();
                    ++this.requestCount;
                    wrapper = (StandardWrapper)this.getContainer();
                    HttpRequest hrequest = (HttpRequest)request;
                    servlet = null;
                    HttpServletRequest hreq = (HttpServletRequest)request.getRequest();
                    HttpServletResponse hres = (HttpServletResponse)response.getResponse();
                    if (!((Context)wrapper.getParent()).getAvailable()) {
                        hres.sendError(503, sm.getString("standardContext.isUnavailable"));
                        unavailable = true;
                    }
                    if (!unavailable && wrapper.isUnavailable()) {
                        this.log(sm.getString("standardWrapper.isUnavailable", wrapper.getName()));
                        if (hres != null) {
                            long available = wrapper.getAvailable();
                            if (available > 0L && available < Long.MAX_VALUE) {
                                hres.setDateHeader("Retry-After", available);
                                hres.sendError(503, sm.getString("standardWrapper.isUnavailable", wrapper.getName()));
                            } else if (available == Long.MAX_VALUE) {
                                hres.sendError(404, sm.getString("standardWrapper.notFound", wrapper.getName()));
                            }
                        }
                        unavailable = true;
                    }
                    try {
                        if (!unavailable) {
                            servlet = wrapper.allocate();
                        }
                    }
                    catch (UnavailableException e) {
                        long available = wrapper.getAvailable();
                        if (available > 0L && available < Long.MAX_VALUE) {
                            hres.setDateHeader("Retry-After", available);
                            hres.sendError(503, sm.getString("standardWrapper.isUnavailable", wrapper.getName()));
                        } else if (available == Long.MAX_VALUE) {
                            hres.sendError(404, sm.getString("standardWrapper.notFound", wrapper.getName()));
                        }
                    }
                    catch (ServletException e) {
                        this.log(sm.getString("standardWrapper.allocateException", wrapper.getName()), e);
                        throwable = e;
                        this.exception(request, response, e);
                        servlet = null;
                    }
                    catch (Throwable e) {
                        this.log(sm.getString("standardWrapper.allocateException", wrapper.getName()), e);
                        throwable = e;
                        this.exception(request, response, e);
                        servlet = null;
                    }
                    try {
                        response.sendAcknowledgement();
                    }
                    catch (IOException e) {
                        hreq.removeAttribute("org.apache.catalina.jsp_file");
                        this.log(sm.getString("standardWrapper.acknowledgeException", wrapper.getName()), e);
                        throwable = e;
                        this.exception(request, response, e);
                    }
                    catch (Throwable e) {
                        this.log(sm.getString("standardWrapper.acknowledgeException", wrapper.getName()), e);
                        throwable = e;
                        this.exception(request, response, e);
                        servlet = null;
                    }
                    MessageBytes requestPathMB = null;
                    if (hreq != null) {
                        requestPathMB = hrequest.getRequestPathMB();
                    }
                    hreq.setAttribute("org.apache.catalina.core.DISPATCHER_TYPE", (Object)ApplicationFilterFactory.REQUEST_INTEGER);
                    hreq.setAttribute("org.apache.catalina.core.DISPATCHER_REQUEST_PATH", (Object)requestPathMB);
                    ApplicationFilterFactory factory = ApplicationFilterFactory.getInstance();
                    ApplicationFilterChain filterChain = factory.createFilterChain((ServletRequest)request, wrapper, servlet);
                    try {
                        String jspFile = wrapper.getJspFile();
                        if (jspFile != null) {
                            hreq.setAttribute("org.apache.catalina.jsp_file", (Object)jspFile);
                        } else {
                            hreq.removeAttribute("org.apache.catalina.jsp_file");
                        }
                        if (servlet != null && filterChain != null) {
                            filterChain.doFilter((ServletRequest)hreq, (ServletResponse)hres);
                        }
                        hreq.removeAttribute("org.apache.catalina.jsp_file");
                    }
                    catch (ClientAbortException e) {
                        hreq.removeAttribute("org.apache.catalina.jsp_file");
                        throwable = e;
                        this.exception(request, response, e);
                    }
                    catch (IOException e) {
                        hreq.removeAttribute("org.apache.catalina.jsp_file");
                        this.log(sm.getString("standardWrapper.serviceException", wrapper.getName()), e);
                        throwable = e;
                        this.exception(request, response, e);
                    }
                    catch (UnavailableException e) {
                        hreq.removeAttribute("org.apache.catalina.jsp_file");
                        this.log(sm.getString("standardWrapper.serviceException", wrapper.getName()), e);
                        wrapper.unavailable(e);
                        long available = wrapper.getAvailable();
                        if (available > 0L && available < Long.MAX_VALUE) {
                            hres.setDateHeader("Retry-After", available);
                            hres.sendError(503, sm.getString("standardWrapper.isUnavailable", wrapper.getName()));
                        } else if (available == Long.MAX_VALUE) {
                            hres.sendError(404, sm.getString("standardWrapper.notFound", wrapper.getName()));
                        }
                    }
                    catch (ServletException e) {
                        hreq.removeAttribute("org.apache.catalina.jsp_file");
                        Throwable rootCause = e;
                        Throwable rootCauseCheck = null;
                        do {
                            try {
                                rootCauseCheck = (Throwable)PropertyUtils.getProperty((Object)rootCause, (String)"rootCause");
                                if (rootCauseCheck == null) continue;
                                rootCause = rootCauseCheck;
                            }
                            catch (ClassCastException ex) {
                                rootCauseCheck = null;
                            }
                            catch (IllegalAccessException ex) {
                                rootCauseCheck = null;
                            }
                            catch (NoSuchMethodException ex) {
                                rootCauseCheck = null;
                            }
                            catch (InvocationTargetException ex) {
                                rootCauseCheck = null;
                            }
                        } while (rootCauseCheck != null);
                        if (!(rootCause instanceof ClientAbortException)) {
                            this.log(sm.getString("standardWrapper.serviceException", wrapper.getName()), rootCause);
                        }
                        throwable = e;
                        this.exception(request, response, e);
                    }
                    catch (Throwable e) {
                        hreq.removeAttribute("org.apache.catalina.jsp_file");
                        this.log(sm.getString("standardWrapper.serviceException", wrapper.getName()), e);
                        throwable = e;
                        this.exception(request, response, e);
                    }
                    try {
                        if (filterChain != null) {
                            filterChain.release();
                        }
                    }
                    catch (Throwable e) {
                        this.log(sm.getString("standardWrapper.releaseFilters", wrapper.getName()), e);
                        if (throwable != null) break block47;
                        throwable = e;
                        this.exception(request, response, e);
                    }
                }
                try {
                    if (servlet != null) {
                        wrapper.deallocate(servlet);
                    }
                }
                catch (Throwable e) {
                    this.log(sm.getString("standardWrapper.deallocateException", wrapper.getName()), e);
                    if (throwable != null) break block48;
                    throwable = e;
                    this.exception(request, response, e);
                }
            }
            try {
                if (servlet != null && wrapper.getAvailable() == Long.MAX_VALUE) {
                    wrapper.unload();
                }
            }
            catch (Throwable e) {
                this.log(sm.getString("standardWrapper.unloadException", wrapper.getName()), e);
                if (throwable != null) break block49;
                throwable = e;
                this.exception(request, response, e);
            }
        }
        long t2 = System.currentTimeMillis();
        long time = t2 - t1;
        this.processingTime += time;
        if (time > this.maxTime) {
            this.maxTime = time;
        }
    }

    private void log(String message) {
        Logger logger = null;
        if (this.container != null) {
            logger = this.container.getLogger();
        }
        if (logger != null) {
            logger.log("StandardWrapperValve[" + this.container.getName() + "]: " + message);
        } else {
            String containerName = null;
            if (this.container != null) {
                containerName = this.container.getName();
            }
            System.out.println("StandardWrapperValve[" + containerName + "]: " + message);
        }
    }

    private void log(String message, Throwable throwable) {
        Logger logger = null;
        if (this.container != null) {
            logger = this.container.getLogger();
        }
        if (logger != null) {
            logger.log("StandardWrapperValve[" + this.container.getName() + "]: " + message, throwable);
        } else {
            String containerName = null;
            if (this.container != null) {
                containerName = this.container.getName();
            }
            System.out.println("StandardWrapperValve[" + containerName + "]: " + message);
            System.out.println("" + throwable);
            throwable.printStackTrace(System.out);
        }
    }

    private void exception(Request request, Response response, Throwable exception) {
        ServletRequest sreq = request.getRequest();
        sreq.setAttribute("javax.servlet.error.exception", (Object)exception);
        ServletResponse sresponse = response.getResponse();
        if (sresponse instanceof HttpServletResponse) {
            ((HttpServletResponse)sresponse).setStatus(500);
        }
    }

    public long getProcessingTime() {
        return this.processingTime;
    }

    public void setProcessingTime(long processingTime) {
        this.processingTime = processingTime;
    }

    public long getMaxTime() {
        return this.maxTime;
    }

    public void setMaxTime(long maxTime) {
        this.maxTime = maxTime;
    }

    public int getRequestCount() {
        return this.requestCount;
    }

    public void setRequestCount(int requestCount) {
        this.requestCount = requestCount;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public void setErrorCount(int errorCount) {
        this.errorCount = errorCount;
    }

    public ObjectName createObjectName(String domain, ObjectName parent) throws MalformedObjectNameException {
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

