/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpSession;
import org.apache.catalina.Context;
import org.apache.catalina.Session;
import org.apache.catalina.util.Enumerator;
import org.apache.catalina.util.RequestUtil;
import org.apache.catalina.util.StringManager;

class ApplicationHttpRequest
extends HttpServletRequestWrapper {
    protected static final String[] specials = new String[]{"javax.servlet.include.request_uri", "javax.servlet.include.context_path", "javax.servlet.include.servlet_path", "javax.servlet.include.path_info", "javax.servlet.include.query_string", "javax.servlet.forward.request_uri", "javax.servlet.forward.context_path", "javax.servlet.forward.servlet_path", "javax.servlet.forward.path_info", "javax.servlet.forward.query_string"};
    protected static StringManager sm = StringManager.getManager("org.apache.catalina.core");
    protected Context context = null;
    protected String contextPath = null;
    protected boolean crossContext = false;
    protected Object dispatcherType = null;
    protected static final String info = "org.apache.catalina.core.ApplicationHttpRequest/1.0";
    protected Map parameters = null;
    private boolean parsedParams = false;
    protected String pathInfo = null;
    private String queryParamString = null;
    protected String queryString = null;
    protected Object requestDispatcherPath = null;
    protected String requestURI = null;
    protected String servletPath = null;
    protected HttpSession session = null;
    protected Object[] specialAttributes = new Object[specials.length];

    public ApplicationHttpRequest(HttpServletRequest request, Context context, boolean crossContext) {
        super(request);
        this.context = context;
        this.crossContext = crossContext;
        this.setRequest(request);
    }

    public Object getAttribute(String name) {
        if (name.equals("org.apache.catalina.core.DISPATCHER_TYPE")) {
            return this.dispatcherType;
        }
        if (name.equals("org.apache.catalina.core.DISPATCHER_REQUEST_PATH")) {
            if (this.requestDispatcherPath != null) {
                return this.requestDispatcherPath.toString();
            }
            return null;
        }
        int pos = this.getSpecial(name);
        if (pos == -1) {
            return this.getRequest().getAttribute(name);
        }
        return this.specialAttributes[pos];
    }

    public Enumeration getAttributeNames() {
        return new AttributeNamesEnumerator();
    }

    public void removeAttribute(String name) {
        if (!this.removeSpecial(name)) {
            this.getRequest().removeAttribute(name);
        }
    }

    public void setAttribute(String name, Object value) {
        if (name.equals("org.apache.catalina.core.DISPATCHER_TYPE")) {
            this.dispatcherType = value;
            return;
        }
        if (name.equals("org.apache.catalina.core.DISPATCHER_REQUEST_PATH")) {
            this.requestDispatcherPath = value;
            return;
        }
        if (!this.setSpecial(name, value)) {
            this.getRequest().setAttribute(name, value);
        }
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        if (this.context == null) {
            return null;
        }
        if (path == null) {
            return null;
        }
        if (path.startsWith("/")) {
            return this.context.getServletContext().getRequestDispatcher(path);
        }
        String servletPath = (String)this.getAttribute("javax.servlet.include.servlet_path");
        if (servletPath == null) {
            servletPath = this.getServletPath();
        }
        String pathInfo = this.getPathInfo();
        String requestPath = null;
        requestPath = pathInfo == null ? servletPath : servletPath + pathInfo;
        int pos = requestPath.lastIndexOf(47);
        String relative = null;
        relative = pos >= 0 ? RequestUtil.normalize(requestPath.substring(0, pos + 1) + path) : RequestUtil.normalize(requestPath + path);
        return this.context.getServletContext().getRequestDispatcher(relative);
    }

    public String getContextPath() {
        return this.contextPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getParameter(String name) {
        this.parseParameters();
        Map map = this.parameters;
        synchronized (map) {
            Object value = this.parameters.get(name);
            if (value == null) {
                return null;
            }
            if (value instanceof String[]) {
                return ((String[])value)[0];
            }
            if (value instanceof String) {
                return (String)value;
            }
            return value.toString();
        }
    }

    public Map getParameterMap() {
        this.parseParameters();
        return this.parameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getParameterNames() {
        this.parseParameters();
        Map map = this.parameters;
        synchronized (map) {
            return new Enumerator(this.parameters.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getParameterValues(String name) {
        this.parseParameters();
        Map map = this.parameters;
        synchronized (map) {
            Object value = this.parameters.get(name);
            if (value == null) {
                return null;
            }
            if (value instanceof String[]) {
                return (String[])value;
            }
            if (value instanceof String) {
                String[] values = new String[]{(String)value};
                return values;
            }
            String[] values = new String[]{value.toString()};
            return values;
        }
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public HttpSession getSession(boolean create) {
        if (this.crossContext) {
            if (this.context == null) {
                return null;
            }
            if (this.session != null) {
                return this.session;
            }
            HttpSession other = super.getSession(false);
            if (create && other == null) {
                other = super.getSession(true);
            }
            if (other != null) {
                Session localSession = null;
                try {
                    localSession = this.context.getManager().findSession(other.getId());
                }
                catch (IOException e) {
                    // empty catch block
                }
                if (localSession == null) {
                    localSession = this.context.getManager().createEmptySession();
                    localSession.setId(other.getId());
                    localSession.setValid(true);
                }
                this.session = localSession.getSession();
                return this.session;
            }
            return null;
        }
        return super.getSession(create);
    }

    public String getInfo() {
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map copyMap(Map orig) {
        if (orig == null) {
            return new HashMap();
        }
        HashMap dest = new HashMap();
        Map map = orig;
        synchronized (map) {
            Iterator keys = orig.keySet().iterator();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                dest.put(key, orig.get(key));
            }
        }
        return dest;
    }

    void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    void setPathInfo(String pathInfo) {
        this.pathInfo = pathInfo;
    }

    void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    void setRequest(HttpServletRequest request) {
        super.setRequest((ServletRequest)request);
        this.dispatcherType = request.getAttribute("org.apache.catalina.core.DISPATCHER_TYPE");
        this.requestDispatcherPath = request.getAttribute("org.apache.catalina.core.DISPATCHER_REQUEST_PATH");
        this.contextPath = request.getContextPath();
        this.pathInfo = request.getPathInfo();
        this.queryString = request.getQueryString();
        this.requestURI = request.getRequestURI();
        this.servletPath = request.getServletPath();
    }

    void setRequestURI(String requestURI) {
        this.requestURI = requestURI;
    }

    void setServletPath(String servletPath) {
        this.servletPath = servletPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void parseParameters() {
        if (this.parsedParams) {
            return;
        }
        this.parameters = new HashMap();
        Map map = this.parameters;
        synchronized (map) {
            this.parameters = this.copyMap(this.getRequest().getParameterMap());
            this.mergeParameters();
            this.parsedParams = true;
        }
    }

    void setQueryParams(String queryString) {
        this.queryParamString = queryString;
    }

    protected boolean isSpecial(String name) {
        for (int i = 0; i < specials.length; ++i) {
            if (!specials[i].equals(name)) continue;
            return true;
        }
        return false;
    }

    protected int getSpecial(String name) {
        for (int i = 0; i < specials.length; ++i) {
            if (!specials[i].equals(name)) continue;
            return i;
        }
        return -1;
    }

    protected boolean setSpecial(String name, Object value) {
        for (int i = 0; i < specials.length; ++i) {
            if (!specials[i].equals(name)) continue;
            this.specialAttributes[i] = value;
            return true;
        }
        return false;
    }

    protected boolean removeSpecial(String name) {
        for (int i = 0; i < specials.length; ++i) {
            if (!specials[i].equals(name)) continue;
            this.specialAttributes[i] = null;
            return true;
        }
        return false;
    }

    protected String[] mergeValues(Object values1, Object values2) {
        int i;
        String[] values;
        ArrayList<Object> results = new ArrayList<Object>();
        if (values1 != null) {
            if (values1 instanceof String) {
                results.add(values1);
            } else if (values1 instanceof String[]) {
                values = (String[])values1;
                for (i = 0; i < values.length; ++i) {
                    results.add(values[i]);
                }
            } else {
                results.add(values1.toString());
            }
        }
        if (values2 != null) {
            if (values2 instanceof String) {
                results.add(values2);
            } else if (values2 instanceof String[]) {
                values = (String[])values2;
                for (i = 0; i < values.length; ++i) {
                    results.add(values[i]);
                }
            } else {
                results.add(values2.toString());
            }
        }
        values = new String[results.size()];
        return results.toArray(values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeParameters() {
        if (this.queryParamString == null || this.queryParamString.length() < 1) {
            return;
        }
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        String encoding = this.getCharacterEncoding();
        if (encoding == null) {
            encoding = "ISO-8859-1";
        }
        try {
            RequestUtil.parseParameters(queryParameters, this.queryParamString, encoding);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Map map = this.parameters;
        synchronized (map) {
            Iterator keys = this.parameters.keySet().iterator();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                Object value = queryParameters.get(key);
                if (value == null) {
                    queryParameters.put(key, this.parameters.get(key));
                    continue;
                }
                queryParameters.put(key, this.mergeValues(value, this.parameters.get(key)));
            }
            this.parameters = queryParameters;
        }
    }

    protected class AttributeNamesEnumerator
    implements Enumeration {
        protected int pos = -1;
        protected int last = -1;
        protected Enumeration parentEnumeration = null;

        public AttributeNamesEnumerator() {
            this.parentEnumeration = ApplicationHttpRequest.this.getRequest().getAttributeNames();
            for (int i = 0; i < ApplicationHttpRequest.this.specialAttributes.length; ++i) {
                if (ApplicationHttpRequest.this.specialAttributes[i] == null) continue;
                this.last = i;
            }
        }

        public boolean hasMoreElements() {
            return this.pos != this.last || this.parentEnumeration.hasMoreElements();
        }

        public Object nextElement() {
            if (this.pos != this.last) {
                for (int i = this.pos + 1; i <= this.last; ++i) {
                    if (ApplicationHttpRequest.this.specialAttributes[i] == null) continue;
                    this.pos = i;
                    return specials[i];
                }
            }
            return this.parentEnumeration.nextElement();
        }
    }
}

