/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Deployer;
import org.apache.catalina.Host;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Valve;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.core.DefaultContext;
import org.apache.catalina.core.StandardHostValve;
import org.apache.catalina.valves.ErrorDispatcherValve;

public class StandardHost
extends ContainerBase
implements Deployer,
Host {
    private String[] aliases = new String[0];
    private String appBase = ".";
    private String configClass = "org.apache.catalina.startup.ContextConfig";
    private String contextClass = "org.apache.catalina.core.StandardContext";
    private String errorReportValveClass = "org.apache.catalina.valves.ErrorReportValve";
    private static final String info = "org.apache.catalina.core.StandardHost/1.0";
    private String mapperClass = "org.apache.catalina.core.StandardHostMapper";
    private boolean unpackWARs = true;
    private String workDir = null;
    private DefaultContext defaultContext;

    public StandardHost() {
        this.pipeline.setBasic(new StandardHostValve());
    }

    public void addAlias(String alias) {
        alias = alias.toLowerCase();
        int i = 0;
        while (i < this.aliases.length) {
            if (this.aliases[i].equals(alias)) {
                return;
            }
            ++i;
        }
        String[] newAliases = new String[this.aliases.length + 1];
        int i2 = 0;
        while (i2 < this.aliases.length) {
            newAliases[i2] = this.aliases[i2];
            ++i2;
        }
        newAliases[this.aliases.length] = alias;
        this.aliases = newAliases;
        this.fireContainerEvent("addAlias", alias);
    }

    public void addChild(Container child) {
        if (!(child instanceof Context)) {
            throw new IllegalArgumentException(ContainerBase.sm.getString("standardHost.notContext"));
        }
        super.addChild(child);
    }

    public void addDefaultContext(DefaultContext defaultContext) {
        DefaultContext oldDefaultContext = this.defaultContext;
        this.defaultContext = defaultContext;
        this.support.firePropertyChange("defaultContext", oldDefaultContext, this.defaultContext);
    }

    protected void addDefaultMapper(String mapperClass) {
        super.addDefaultMapper(this.mapperClass);
    }

    protected void expand(InputStream input, File docBase, String name) throws IOException {
        int n;
        File file = new File(docBase, name);
        BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(file));
        byte[] buffer = new byte[2048];
        while ((n = input.read(buffer)) > 0) {
            output.write(buffer, 0, n);
        }
        output.close();
    }

    protected String expand(URL war) throws IOException {
        File appBase;
        int slash;
        int period;
        String pathname;
        if (this.debug >= 1) {
            this.log("expand(" + war.toString() + ")");
        }
        if ((pathname = war.toString().replace('\\', '/')).endsWith("!/")) {
            pathname = pathname.substring(0, pathname.length() - 2);
        }
        if ((period = pathname.lastIndexOf(46)) >= pathname.length() - 4) {
            pathname = pathname.substring(0, period);
        }
        if ((slash = pathname.lastIndexOf(47)) >= 0) {
            pathname = pathname.substring(slash + 1);
        }
        if (this.debug >= 1) {
            this.log("  Proposed directory name: " + pathname);
        }
        if (!(appBase = new File(this.getAppBase())).isAbsolute()) {
            appBase = new File(System.getProperty("catalina.base"), this.getAppBase());
        }
        if (!appBase.exists() || !appBase.isDirectory()) {
            throw new IOException(ContainerBase.sm.getString("standardHost.appBase", appBase.getAbsolutePath()));
        }
        File docBase = new File(appBase, pathname);
        if (docBase.exists()) {
            return docBase.getAbsolutePath();
        }
        docBase.mkdir();
        if (this.debug >= 2) {
            this.log("  Have created expansion directory " + docBase.getAbsolutePath());
        }
        JarURLConnection juc = (JarURLConnection)war.openConnection();
        juc.setUseCaches(false);
        JarFile jarFile = juc.getJarFile();
        if (this.debug >= 2) {
            this.log("  Have opened JAR file successfully");
        }
        Enumeration<JarEntry> jarEntries = jarFile.entries();
        if (this.debug >= 2) {
            this.log("  Have retrieved entries enumeration");
        }
        while (jarEntries.hasMoreElements()) {
            int last;
            JarEntry jarEntry = jarEntries.nextElement();
            String name = jarEntry.getName();
            if (this.debug >= 2) {
                this.log("  Am processing entry " + name);
            }
            if ((last = name.lastIndexOf(47)) >= 0) {
                File parent = new File(docBase, name.substring(0, last));
                if (this.debug >= 2) {
                    this.log("  Creating parent directory " + parent);
                }
                parent.mkdirs();
            }
            if (name.endsWith("/")) continue;
            if (this.debug >= 2) {
                this.log("  Creating expanded file " + name);
            }
            InputStream input = jarFile.getInputStream(jarEntry);
            this.expand(input, docBase, name);
            input.close();
        }
        jarFile.close();
        return docBase.getAbsolutePath();
    }

    public String[] findAliases() {
        return this.aliases;
    }

    public Context findDeployedApp(String contextPath) {
        if (contextPath == null) {
            return null;
        }
        HashMap hashMap = this.children;
        synchronized (hashMap) {
            Context context = (Context)this.children.get(contextPath);
            Object var4_4 = null;
            return context;
        }
    }

    public String[] findDeployedApps() {
        HashMap hashMap = this.children;
        synchronized (hashMap) {
            String[] results = new String[this.children.size()];
            String[] stringArray = this.children.keySet().toArray(results);
            Object var3_4 = null;
            return stringArray;
        }
    }

    public String getAppBase() {
        return this.appBase;
    }

    public String getConfigClass() {
        return this.configClass;
    }

    public String getContextClass() {
        return this.contextClass;
    }

    public String getErrorReportValveClass() {
        return this.errorReportValveClass;
    }

    public String getInfo() {
        return info;
    }

    public String getMapperClass() {
        return this.mapperClass;
    }

    public String getName() {
        return this.name;
    }

    public String getWorkDir() {
        return this.workDir;
    }

    public void importDefaultContext(Context context) {
        if (this.defaultContext != null) {
            this.defaultContext.importDefaultContext(context);
        }
    }

    public void install(String contextPath, URL war) throws IOException {
        if (contextPath == null) {
            throw new IllegalArgumentException(ContainerBase.sm.getString("standardHost.pathRequired"));
        }
        if (!contextPath.equals("") && !contextPath.startsWith("/")) {
            throw new IllegalArgumentException(ContainerBase.sm.getString("standardHost.pathFormat", contextPath));
        }
        if (this.findDeployedApp(contextPath) != null) {
            throw new IllegalArgumentException(ContainerBase.sm.getString("standardHost.pathUsed", contextPath));
        }
        if (war == null) {
            throw new IllegalArgumentException(ContainerBase.sm.getString("standardHost.warRequired"));
        }
        String url = war.toString();
        String docBase = null;
        this.log(ContainerBase.sm.getString("standardHost.installing", contextPath, url));
        if (this.isUnpackWARs()) {
            if (url.startsWith("jar:")) {
                docBase = this.expand(war);
            } else if (url.startsWith("file://")) {
                docBase = url.substring(7);
            } else if (url.startsWith("file:")) {
                docBase = url.substring(5);
            } else {
                throw new IllegalArgumentException(ContainerBase.sm.getString("standardHost.warURL", url));
            }
            File docBaseDir = new File(docBase);
            if (!(docBaseDir.exists() && docBaseDir.isDirectory() && docBaseDir.canRead())) {
                throw new IllegalArgumentException(ContainerBase.sm.getString("standardHost.accessBase", docBase));
            }
        } else {
            if (url.startsWith("jar:")) {
                url = url.substring(4, url.length() - 2);
            }
            if (url.startsWith("file://")) {
                docBase = url.substring(7);
            } else if (url.startsWith("file:")) {
                docBase = url.substring(5);
            } else {
                throw new IllegalArgumentException(ContainerBase.sm.getString("standardHost.warURL", url));
            }
        }
        try {
            Class<?> clazz = Class.forName(this.contextClass);
            Context context = (Context)clazz.newInstance();
            context.setPath(contextPath);
            context.setDocBase(docBase);
            if (context instanceof Lifecycle) {
                clazz = Class.forName(this.configClass);
                LifecycleListener listener = (LifecycleListener)clazz.newInstance();
                ((Lifecycle)((Object)context)).addLifecycleListener(listener);
            }
            this.addChild(context);
            this.fireContainerEvent("install", context);
        }
        catch (Exception e) {
            this.log(ContainerBase.sm.getString("standardHost.installError", contextPath), e);
            throw new IOException(e.toString());
        }
    }

    public boolean isUnpackWARs() {
        return this.unpackWARs;
    }

    public Context map(String uri) {
        int slash;
        if (this.debug > 0) {
            this.log("Mapping request URI '" + uri + "'");
        }
        if (uri == null) {
            return null;
        }
        if (this.debug > 1) {
            this.log("  Trying the longest context path prefix");
        }
        Context context = null;
        while ((context = (Context)this.findChild(uri)) == null && (slash = uri.lastIndexOf(47)) >= 0) {
            uri = uri.substring(0, slash);
        }
        if (context == null) {
            if (this.debug > 1) {
                this.log("  Trying the default context");
            }
            context = (Context)this.findChild("");
        }
        if (context == null) {
            this.log(ContainerBase.sm.getString("standardHost.mappingError", uri));
            return null;
        }
        if (this.debug > 0) {
            this.log(" Mapped to context '" + context.getPath() + "'");
        }
        return context;
    }

    protected void remove(File dir) throws IOException {
        String[] list = dir.list();
        int i = 0;
        while (i < list.length) {
            File file = new File(dir, list[i]);
            if (file.isDirectory()) {
                this.remove(file);
            } else if (!file.delete()) {
                throw new IOException("Cannot delete file " + file.getAbsolutePath());
            }
            ++i;
        }
        if (!dir.delete()) {
            throw new IOException("Cannot delete directory " + dir.getAbsolutePath());
        }
    }

    public void remove(String contextPath) throws IOException {
        if (contextPath == null) {
            throw new IllegalArgumentException(ContainerBase.sm.getString("standardHost.pathRequired"));
        }
        if (!contextPath.equals("") && !contextPath.startsWith("/")) {
            throw new IllegalArgumentException(ContainerBase.sm.getString("standardHost.pathFormat", contextPath));
        }
        Context context = this.findDeployedApp(contextPath);
        if (context == null) {
            throw new IllegalArgumentException(ContainerBase.sm.getString("standardHost.pathMissing", contextPath));
        }
        this.log(ContainerBase.sm.getString("standardHost.removing", contextPath));
        try {
            this.removeChild(context);
        }
        catch (Exception e) {
            this.log(ContainerBase.sm.getString("standardHost.removeError", contextPath), e);
            throw new IOException(e.toString());
        }
    }

    public void removeAlias(String alias) {
        alias = alias.toLowerCase();
        String[] stringArray = this.aliases;
        synchronized (stringArray) {
            int n = -1;
            int i = 0;
            while (i < this.aliases.length) {
                if (this.aliases[i].equals(alias)) {
                    n = i;
                    break;
                }
                ++i;
            }
            if (n < 0) {
                Object var3_5 = null;
                return;
            }
            int j = 0;
            String[] results = new String[this.aliases.length - 1];
            int i2 = 0;
            while (i2 < this.aliases.length) {
                if (i2 != n) {
                    results[j++] = this.aliases[i2];
                }
                ++i2;
            }
            this.aliases = results;
        }
        this.fireContainerEvent("removeAlias", alias);
    }

    public void setAppBase(String appBase) {
        String oldAppBase = this.appBase;
        this.appBase = appBase;
        this.support.firePropertyChange("appBase", oldAppBase, this.appBase);
    }

    public void setConfigClass(String configClass) {
        String oldConfigClass = this.configClass;
        this.configClass = configClass;
        this.support.firePropertyChange("configClass", oldConfigClass, this.configClass);
    }

    public void setContextClass(String contextClass) {
        String oldContextClass = this.contextClass;
        this.contextClass = contextClass;
        this.support.firePropertyChange("contextClass", oldContextClass, this.contextClass);
    }

    public void setErrorReportValveClass(String errorReportValveClass) {
        String oldErrorReportValveClassClass = this.errorReportValveClass;
        this.errorReportValveClass = errorReportValveClass;
        this.support.firePropertyChange("errorReportValveClass", oldErrorReportValveClassClass, this.errorReportValveClass);
    }

    public void setMapperClass(String mapperClass) {
        String oldMapperClass = this.mapperClass;
        this.mapperClass = mapperClass;
        this.support.firePropertyChange("mapperClass", oldMapperClass, this.mapperClass);
    }

    public void setName(String name) {
        if (name == null) {
            throw new IllegalArgumentException(ContainerBase.sm.getString("standardHost.nullName"));
        }
        name = name.toLowerCase();
        String oldName = this.name;
        this.name = name;
        this.support.firePropertyChange("name", oldName, this.name);
    }

    public void setUnpackWARs(boolean unpackWARs) {
        this.unpackWARs = unpackWARs;
    }

    public void setWorkDir(String workDir) {
        this.workDir = workDir;
    }

    public synchronized void start() throws LifecycleException {
        if (this.errorReportValveClass != null && !this.errorReportValveClass.equals("")) {
            try {
                Valve valve = (Valve)Class.forName(this.errorReportValveClass).newInstance();
                this.addValve(valve);
            }
            catch (Throwable throwable) {
                this.log(ContainerBase.sm.getString("standardHost.invalidErrorReportValveClass", this.errorReportValveClass));
            }
        }
        this.addValve(new ErrorDispatcherValve());
        super.start();
    }

    public void start(String contextPath) throws IOException {
        if (contextPath == null) {
            throw new IllegalArgumentException(ContainerBase.sm.getString("standardHost.pathRequired"));
        }
        if (!contextPath.equals("") && !contextPath.startsWith("/")) {
            throw new IllegalArgumentException(ContainerBase.sm.getString("standardHost.pathFormat", contextPath));
        }
        Context context = this.findDeployedApp(contextPath);
        if (context == null) {
            throw new IllegalArgumentException(ContainerBase.sm.getString("standardHost.pathMissing", contextPath));
        }
        this.log("standardHost.start " + contextPath);
        try {
            ((Lifecycle)((Object)context)).start();
        }
        catch (LifecycleException e) {
            this.log("standardHost.start " + contextPath + ": ", e);
            throw new IllegalStateException("standardHost.start " + contextPath + ": " + e);
        }
    }

    public void stop(String contextPath) throws IOException {
        if (contextPath == null) {
            throw new IllegalArgumentException(ContainerBase.sm.getString("standardHost.pathRequired"));
        }
        if (!contextPath.equals("") && !contextPath.startsWith("/")) {
            throw new IllegalArgumentException(ContainerBase.sm.getString("standardHost.pathFormat", contextPath));
        }
        Context context = this.findDeployedApp(contextPath);
        if (context == null) {
            throw new IllegalArgumentException(ContainerBase.sm.getString("standardHost.pathMissing", contextPath));
        }
        this.log("standardHost.stop " + contextPath);
        try {
            ((Lifecycle)((Object)context)).stop();
        }
        catch (LifecycleException e) {
            this.log("standardHost.stop " + contextPath + ": ", e);
            throw new IllegalStateException("standardHost.stop " + contextPath + ": " + e);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.getParent() != null) {
            sb.append(this.getParent().toString());
            sb.append(".");
        }
        sb.append("StandardHost[");
        sb.append(this.getName());
        sb.append("]");
        return sb.toString();
    }
}

