/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.realm;

import java.security.Principal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.naming.Context;
import javax.sql.DataSource;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Realm;
import org.apache.catalina.ServerFactory;
import org.apache.catalina.core.StandardServer;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.catalina.realm.RealmBase;
import org.apache.catalina.util.StringManager;

public class DataSourceRealm
extends RealmBase {
    private StringBuffer preparedRoles = null;
    private StringBuffer preparedCredentials = null;
    protected String dataSourceName = null;
    protected static final String info = "org.apache.catalina.realm.DataSourceRealm/1.0";
    protected static final String name = "DataSourceRealm";
    protected String roleNameCol = null;
    protected static final StringManager sm = StringManager.getManager((String)"org.apache.catalina.realm");
    protected String userCredCol = null;
    protected String userNameCol = null;
    protected String userRoleTable = null;
    protected String userTable = null;

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    public String getRoleNameCol() {
        return this.roleNameCol;
    }

    public void setRoleNameCol(String roleNameCol) {
        this.roleNameCol = roleNameCol;
    }

    public String getUserCredCol() {
        return this.userCredCol;
    }

    public void setUserCredCol(String userCredCol) {
        this.userCredCol = userCredCol;
    }

    public String getUserNameCol() {
        return this.userNameCol;
    }

    public void setUserNameCol(String userNameCol) {
        this.userNameCol = userNameCol;
    }

    public String getUserRoleTable() {
        return this.userRoleTable;
    }

    public void setUserRoleTable(String userRoleTable) {
        this.userRoleTable = userRoleTable;
    }

    public String getUserTable() {
        return this.userTable;
    }

    public void setUserTable(String userTable) {
        this.userTable = userTable;
    }

    public Principal authenticate(String username, String credentials) {
        Connection dbConnection = null;
        try {
            dbConnection = this.open();
            if (dbConnection == null) {
                return null;
            }
            Principal principal = this.authenticate(dbConnection, username, credentials);
            if (!dbConnection.getAutoCommit()) {
                dbConnection.commit();
            }
            this.close(dbConnection);
            dbConnection = null;
            return principal;
        }
        catch (SQLException e) {
            this.log(sm.getString("dataSourceRealm.exception"), e);
            if (dbConnection != null) {
                this.close(dbConnection);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Principal authenticate(Connection dbConnection, String username, String credentials) throws SQLException {
        ArrayList<String> list;
        PreparedStatement stmt;
        block18: {
            ResultSet rs;
            block16: {
                Principal principal;
                block17: {
                    String dbCredentials;
                    block14: {
                        Principal principal2;
                        block15: {
                            rs = null;
                            stmt = null;
                            list = null;
                            dbCredentials = null;
                            stmt = this.credentials(dbConnection, username);
                            rs = stmt.executeQuery();
                            while (rs.next()) {
                                dbCredentials = rs.getString(1).trim();
                            }
                            rs.close();
                            rs = null;
                            stmt.close();
                            stmt = null;
                            if (dbCredentials != null) break block14;
                            principal2 = null;
                            Object var11_10 = null;
                            if (rs == null) break block15;
                            rs.close();
                        }
                        if (stmt != null) {
                            stmt.close();
                        }
                        return principal2;
                    }
                    boolean validated = false;
                    validated = this.hasMessageDigest() ? this.digest(credentials).equalsIgnoreCase(dbCredentials) : this.digest(credentials).equals(dbCredentials);
                    if (validated) {
                        if (this.debug >= 2) {
                            this.log(sm.getString("dataSourceRealm.authenticateSuccess", (Object)username));
                        }
                        break block16;
                    }
                    if (this.debug >= 2) {
                        this.log(sm.getString("dataSourceRealm.authenticateFailure", (Object)username));
                    }
                    principal = null;
                    Object var11_11 = null;
                    if (rs == null) break block17;
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
                return principal;
            }
            try {
                list = new ArrayList<String>();
                stmt = this.roles(dbConnection, username);
                rs = stmt.executeQuery();
                while (rs.next()) {
                    list.add(rs.getString(1).trim());
                }
                Object var11_12 = null;
                if (rs == null) break block18;
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
                throw throwable;
            }
            rs.close();
        }
        if (stmt != null) {
            stmt.close();
        }
        return new GenericPrincipal((Realm)this, username, credentials, list);
    }

    private void close(Connection dbConnection) {
        if (dbConnection == null) {
            return;
        }
        try {
            dbConnection.close();
        }
        catch (SQLException e) {
            this.log(sm.getString("dataSourceRealm.close"), e);
        }
    }

    private Connection open() {
        try {
            StandardServer server = (StandardServer)ServerFactory.getServer();
            Context context = server.getGlobalNamingContext();
            DataSource dataSource = (DataSource)context.lookup(this.dataSourceName);
            return dataSource.getConnection();
        }
        catch (Exception e) {
            this.log(sm.getString("dataSourceRealm.exception"), e);
            return null;
        }
    }

    private PreparedStatement credentials(Connection dbConnection, String username) throws SQLException {
        PreparedStatement credentials = dbConnection.prepareStatement(this.preparedCredentials.toString());
        credentials.setString(1, username);
        return credentials;
    }

    protected String getName() {
        return name;
    }

    protected String getPassword(String username) {
        return null;
    }

    protected Principal getPrincipal(String username) {
        return null;
    }

    private PreparedStatement roles(Connection dbConnection, String username) throws SQLException {
        PreparedStatement roles = dbConnection.prepareStatement(this.preparedRoles.toString());
        roles.setString(1, username);
        return roles;
    }

    public void start() throws LifecycleException {
        this.preparedRoles = new StringBuffer("SELECT ");
        this.preparedRoles.append(this.roleNameCol);
        this.preparedRoles.append(" FROM ");
        this.preparedRoles.append(this.userRoleTable);
        this.preparedRoles.append(" WHERE ");
        this.preparedRoles.append(this.userNameCol);
        this.preparedRoles.append(" = ?");
        this.preparedCredentials = new StringBuffer("SELECT ");
        this.preparedCredentials.append(this.userCredCol);
        this.preparedCredentials.append(" FROM ");
        this.preparedCredentials.append(this.userTable);
        this.preparedCredentials.append(" WHERE ");
        this.preparedCredentials.append(this.userNameCol);
        this.preparedCredentials.append(" = ?");
        super.start();
    }

    public void stop() throws LifecycleException {
        super.stop();
    }
}

