/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.cluster.tcp;

import java.io.IOException;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import org.apache.catalina.Manager;
import org.apache.catalina.Session;
import org.apache.catalina.cluster.CatalinaCluster;
import org.apache.catalina.cluster.ClusterManager;
import org.apache.catalina.cluster.ClusterMessage;
import org.apache.catalina.cluster.ClusterSession;
import org.apache.catalina.cluster.ClusterValve;
import org.apache.catalina.cluster.session.DeltaManager;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.util.StringManager;
import org.apache.catalina.valves.ValveBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReplicationValve
extends ValveBase
implements ClusterValve {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$catalina$cluster$tcp$ReplicationValve == null ? (class$org$apache$catalina$cluster$tcp$ReplicationValve = ReplicationValve.class$("org.apache.catalina.cluster.tcp.ReplicationValve")) : class$org$apache$catalina$cluster$tcp$ReplicationValve));
    private static final String info = "org.apache.catalina.cluster.tcp.ReplicationValve/1.2";
    protected static StringManager sm = StringManager.getManager((String)"org.apache.catalina.cluster.tcp");
    private CatalinaCluster cluster = null;
    protected Pattern[] reqFilters = new Pattern[0];
    protected String filter;
    protected long totalRequestTime = 0L;
    protected long totalSendTime = 0L;
    protected long nrOfRequests = 0L;
    protected long lastSendTime = 0L;
    protected long nrOfFilterRequests = 0L;
    protected boolean primaryIndicator = false;
    protected String primaryIndicatorName = "org.apache.catalina.cluster.tcp.isPrimarySession";
    static /* synthetic */ Class class$org$apache$catalina$cluster$tcp$ReplicationValve;

    public String getInfo() {
        return info;
    }

    public CatalinaCluster getCluster() {
        return this.cluster;
    }

    public void setCluster(CatalinaCluster cluster) {
        this.cluster = cluster;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("ReplicationValve.filter.loading", (Object)filter));
        }
        this.filter = filter;
        StringTokenizer t = new StringTokenizer(filter, ";");
        this.reqFilters = new Pattern[t.countTokens()];
        int i = 0;
        while (t.hasMoreTokens()) {
            String s = t.nextToken();
            if (log.isTraceEnabled()) {
                log.trace((Object)sm.getString("ReplicationValve.filter.token", (Object)s));
            }
            try {
                this.reqFilters[i++] = Pattern.compile(s);
            }
            catch (Exception x) {
                log.error((Object)sm.getString("ReplicationValve.filter.token.failure", (Object)s), (Throwable)x);
            }
        }
    }

    public boolean isPrimaryIndicator() {
        return this.primaryIndicator;
    }

    public void setPrimaryIndicator(boolean primaryIndicator) {
        this.primaryIndicator = primaryIndicator;
    }

    public String getPrimaryIndicatorName() {
        return this.primaryIndicatorName;
    }

    public void setPrimaryIndicatorName(String primaryIndicatorName) {
        this.primaryIndicatorName = primaryIndicatorName;
    }

    public long getLastSendTime() {
        return this.lastSendTime;
    }

    public long getNrOfRequests() {
        return this.nrOfRequests;
    }

    public long getNrOfFilterRequests() {
        return this.nrOfFilterRequests;
    }

    public long getTotalRequestTime() {
        return this.totalRequestTime;
    }

    public long getTotalSendTime() {
        return this.totalSendTime;
    }

    protected Pattern[] getReqFilters() {
        return this.reqFilters;
    }

    protected void setReqFilters(Pattern[] reqFilters) {
        this.reqFilters = reqFilters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(Request request, Response response) throws IOException, ServletException {
        long totalstart = System.currentTimeMillis();
        if (this.primaryIndicator) {
            this.createPrimaryIndicator(request);
        }
        this.getNext().invoke(request, response);
        long start = System.currentTimeMillis();
        Manager manager = request.getContext().getManager();
        if (manager != null && manager instanceof ClusterManager) {
            ClusterManager clusterManager = (ClusterManager)manager;
            CatalinaCluster cluster = (CatalinaCluster)this.getContainer().getCluster();
            if (cluster == null) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)sm.getString("ReplicationValve.nocluster"));
                }
                return;
            }
            if (cluster.getManager(clusterManager.getName()) == null) {
                return;
            }
            if (cluster.getMembers().length > 0) {
                try {
                    if (!(clusterManager instanceof DeltaManager)) {
                        this.sendInvalidSessions(clusterManager, cluster);
                    }
                    this.sendSessionReplicationMessage(request, clusterManager, cluster);
                }
                catch (Exception x) {
                    log.error((Object)sm.getString("ReplicationValve.send.failure"), (Throwable)x);
                }
                finally {
                    long stop = System.currentTimeMillis();
                    this.updateStats(stop - totalstart, stop - start);
                }
            }
        }
    }

    public void resetStatistics() {
        this.totalRequestTime = 0L;
        this.totalSendTime = 0L;
        this.lastSendTime = 0L;
        this.nrOfFilterRequests = 0L;
        this.nrOfRequests = 0L;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ReplicationValve[");
        if (this.container != null) {
            sb.append(this.container.getName());
        }
        sb.append("]");
        return sb.toString();
    }

    protected void sendSessionReplicationMessage(Request request, ClusterManager manager, CatalinaCluster cluster) {
        Session session = request.getSessionInternal(false);
        if (session != null) {
            String uri = request.getDecodedRequestURI();
            if (!this.isRequestWithoutSessionChange(uri)) {
                ClusterMessage msg;
                String id;
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("ReplicationValve.invoke.uri", (Object)uri));
                }
                if ((id = session.getIdInternal()) != null && (msg = manager.requestCompleted(id)) != null) {
                    if (manager.isSendClusterDomainOnly()) {
                        cluster.sendClusterDomain(msg);
                    } else {
                        cluster.send(msg);
                    }
                }
            } else {
                ++this.nrOfFilterRequests;
            }
        }
    }

    protected void sendInvalidSessions(ClusterManager manager, CatalinaCluster cluster) {
        String[] invalidIds = manager.getInvalidatedSessions();
        if (invalidIds.length > 0) {
            for (int i = 0; i < invalidIds.length; ++i) {
                try {
                    ClusterMessage imsg = manager.requestCompleted(invalidIds[i]);
                    if (imsg == null) continue;
                    if (manager.isSendClusterDomainOnly()) {
                        cluster.sendClusterDomain(imsg);
                        continue;
                    }
                    cluster.send(imsg);
                    continue;
                }
                catch (Exception x) {
                    log.error((Object)sm.getString("ReplicationValve.send.invalid.failure", (Object)invalidIds[i]), (Throwable)x);
                }
            }
        }
    }

    protected boolean isRequestWithoutSessionChange(String uri) {
        boolean filterfound = false;
        for (int i = 0; i < this.reqFilters.length && !filterfound; ++i) {
            Matcher matcher = this.reqFilters[i].matcher(uri);
            filterfound = matcher.matches();
        }
        return filterfound;
    }

    protected synchronized void updateStats(long requestTime, long clusterTime) {
        this.totalSendTime += clusterTime;
        this.totalRequestTime += requestTime;
        ++this.nrOfRequests;
        if (this.nrOfRequests % 100L == 0L && log.isInfoEnabled()) {
            log.info((Object)sm.getString("ReplicationValve.stats", new Object[]{new Long(this.totalRequestTime / this.nrOfRequests), new Long(this.totalSendTime / this.nrOfRequests), new Long(this.nrOfRequests), new Long(this.nrOfFilterRequests), new Long(this.totalRequestTime), new Long(this.totalSendTime)}));
        }
        this.lastSendTime = System.currentTimeMillis();
    }

    protected void createPrimaryIndicator(Request request) throws IOException {
        String id = request.getRequestedSessionId();
        if (id != null && id.length() > 0) {
            Manager manager = request.getContext().getManager();
            Session session = manager.findSession(id);
            if (session instanceof ClusterSession) {
                ClusterSession cses = (ClusterSession)session;
                if (cses != null) {
                    Boolean isPrimary = new Boolean(cses.isPrimarySession());
                    if (log.isDebugEnabled()) {
                        log.debug((Object)sm.getString("ReplicationValve.session.indicator", (Object)request.getContext().getName(), (Object)id, (Object)this.primaryIndicatorName, (Object)isPrimary));
                    }
                    request.setAttribute(this.primaryIndicatorName, (Object)isPrimary);
                }
            } else if (log.isDebugEnabled()) {
                if (session != null) {
                    log.debug((Object)sm.getString("ReplicationValve.session.found", (Object)request.getContext().getName(), (Object)id));
                } else {
                    log.debug((Object)sm.getString("ReplicationValve.session.invalid", (Object)request.getContext().getName(), (Object)id));
                }
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

