/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.cluster.session;

import java.io.IOException;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Session;
import org.apache.catalina.cluster.ClusterMessage;
import org.apache.catalina.cluster.session.ClusterListener;
import org.apache.catalina.cluster.session.SessionIDMessage;
import org.apache.catalina.core.StandardEngine;

public class JvmRouteSessionIDBinderListener
extends ClusterListener {
    protected static final String info = "org.apache.catalina.session.JvmRouteSessionIDBinderListener/1.1";
    protected boolean started = false;
    private long numberOfSessions = 0L;

    public String getInfo() {
        return info;
    }

    public long getNumberOfSessions() {
        return this.numberOfSessions;
    }

    public void start() throws LifecycleException {
        if (this.started) {
            return;
        }
        this.getCluster().addClusterListener(this);
        this.started = true;
        if (log.isInfoEnabled()) {
            log.info((Object)this.sm.getString("jvmRoute.clusterListener.started"));
        }
    }

    public void stop() throws LifecycleException {
        this.started = false;
        this.getCluster().removeClusterListener(this);
        if (log.isInfoEnabled()) {
            log.info((Object)this.sm.getString("jvmRoute.clusterListener.stopped"));
        }
    }

    public void messageReceived(ClusterMessage msg) {
        if (msg instanceof SessionIDMessage && msg != null) {
            Container host;
            SessionIDMessage sessionmsg = (SessionIDMessage)msg;
            if (log.isDebugEnabled()) {
                log.debug((Object)this.sm.getString("jvmRoute.receiveMessage.sessionIDChanged", (Object)sessionmsg.getOrignalSessionID(), (Object)sessionmsg.getBackupSessionID(), (Object)sessionmsg.getContextPath()));
            }
            if ((host = this.getCluster().getContainer()) != null) {
                Context context = (Context)host.findChild(sessionmsg.getContextPath());
                if (context != null) {
                    try {
                        Session session = context.getManager().findSession(sessionmsg.getOrignalSessionID());
                        if (session != null) {
                            session.setId(sessionmsg.getBackupSessionID());
                        } else if (log.isInfoEnabled()) {
                            log.info((Object)this.sm.getString("jvmRoute.lostSession", (Object)sessionmsg.getOrignalSessionID(), (Object)sessionmsg.getContextPath()));
                        }
                    }
                    catch (IOException e) {
                        log.error((Object)e);
                    }
                } else if (log.isErrorEnabled()) {
                    log.error((Object)this.sm.getString("jvmRoute.contextNotFound", (Object)sessionmsg.getContextPath(), (Object)((StandardEngine)host.getParent()).getJvmRoute()));
                }
            } else if (log.isErrorEnabled()) {
                log.error((Object)this.sm.getString("jvmRoute.hostNotFound", (Object)sessionmsg.getContextPath()));
            }
        }
    }

    public boolean accept(ClusterMessage msg) {
        return msg instanceof SessionIDMessage;
    }
}

