/*
 * Decompiled with CFR 0.152.
 */
package tokyo.baseballyama.kvelte;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.coroutines.AwaitKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Deferred;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tokyo.baseballyama.kvelte.KvelteConfig;
import tokyo.baseballyama.kvelte.KvelteLoader;
import tokyo.baseballyama.kvelte.SSRResult;
import tokyo.baseballyama.kvelte.SSRResultCSS;
import tokyo.baseballyama.kvelte.SimpleLruCache;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000f\u001a\u00020\fH\u0002J\b\u0010\u0010\u001a\u00020\rH\u0002J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\fH\u0002J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\f0\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\fH\u0016J\"\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\f2\u0010\u0010\u0017\u001a\f\u0012\u0004\u0012\u00020\f\u0012\u0002\b\u00030\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Ltokyo/baseballyama/kvelte/KvelteLoaderProd;", "Ltokyo/baseballyama/kvelte/KvelteLoader;", "config", "Ltokyo/baseballyama/kvelte/KvelteConfig;", "(Ltokyo/baseballyama/kvelte/KvelteConfig;)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "now", "", "scriptEngineMap", "Ltokyo/baseballyama/kvelte/SimpleLruCache;", "", "Ljavax/script/ScriptEngine;", "getResources", "fileName", "getScriptEngine", "path", "getSvelteFilePaths", "", "loadJavaScript", "loadPage", "src", "props", "", "loadPages", "", "kvelte"})
public final class KvelteLoaderProd
extends KvelteLoader {
    @NotNull
    private final KvelteConfig config;
    private final Logger logger;
    private final long now;
    @NotNull
    private final SimpleLruCache<String, ScriptEngine> scriptEngineMap;

    public KvelteLoaderProd(@NotNull KvelteConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config);
        this.config = config;
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.now = new Date().getTime();
        this.scriptEngineMap = new SimpleLruCache();
        this.loadPages();
    }

    @Override
    @NotNull
    public String loadPage(@NotNull String src, @NotNull Map<String, ?> props) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter(props, (String)"props");
        this.logger.debug("START loadPage: " + src);
        String propsStr = this.getMapper().writeValueAsString(props);
        Object ssrResult = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        ScriptEngine scriptEngine = this.getScriptEngine(src);
        Intrinsics.checkNotNull((Object)scriptEngine, (String)"null cannot be cast to non-null type javax.script.Invocable");
        Invocable inv = (Invocable)((Object)scriptEngine);
        Object[] objectArray = new Object[]{propsStr};
        String res = inv.invokeFunction("render", objectArray).toString();
        Object object = this.getMapper().readValue(res, SSRResult.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"mapper.readValue(res, SSRResult::class.java)");
        ssrResult = object;
        long time = System.currentTimeMillis() - start$iv;
        this.logger.debug("END loadPage: " + src + " (" + time + " ms)");
        StringBuilder stringBuilder = new StringBuilder().append("\n            <!DOCTYPE html>\n            <html lang=\"").append(this.config.getLang()).append("\">\n              <head>\n                <meta charset=\"UTF-8\" />\n                <link rel=\"icon\" href=\"/assets/favicon.ico\" />\n                <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\" />\n                <style>");
        Object object2 = ((SSRResult)ssrResult).getCss();
        if (object2 == null || (object2 = ((SSRResultCSS)object2).getCode()) == null) {
            object2 = "";
        }
        return StringsKt.trimIndent((String)stringBuilder.append((String)object2).append("</style>\n                ").append(((SSRResult)ssrResult).getHead()).append("\n              </head>\n              <body>\n                <div id=\"kvelte\">").append(((SSRResult)ssrResult).getHtml()).append("</div>\n                <script type=\"module\">\n                  import App from \"/.kvelte/").append(StringsKt.removePrefix((String)src, (CharSequence)"/")).append('?').append(this.now).append("\";\n                  new App({\n                    target: document.getElementById(\"kvelte\"),\n                    hydrate: true,\n                    props: ").append(propsStr).append("\n                  });\n                </script>\n              </body>\n            </html>\n        ").toString());
    }

    @Override
    @NotNull
    public String loadJavaScript(@NotNull String path) {
        String string;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Object object = new String[]{"?"};
        Object it = object = CollectionsKt.toMutableList((Collection)StringsKt.split$default((CharSequence)StringsKt.removePrefix((String)path, (CharSequence)"/"), (String[])object, (boolean)false, (int)0, (int)6, null));
        boolean bl = false;
        if (it.size() > 1) {
            CollectionsKt.removeLast((List)it);
        }
        String paths = CollectionsKt.joinToString$default((Iterable)((Iterable)object), (CharSequence)"?", null, null, (int)0, null, null, (int)62, null);
        if (StringsKt.startsWith$default((String)paths, (String)"chunks", (boolean)false, (int)2, null)) {
            string = this.getResources(".kvelte/dom/" + paths);
            if (string == null) {
                string = "";
            }
        } else {
            string = this.getResources(".kvelte/dom/pages/" + paths + ".js");
            if (string == null) {
                string = "";
            }
        }
        return string;
    }

    private final ScriptEngine getScriptEngine(String path) {
        String resourcePath = ".kvelte/ssr/pages/" + StringsKt.removePrefix((String)path, (CharSequence)"/") + ".js";
        if (!this.scriptEngineMap.containsKey(resourcePath)) {
            ScriptEngine scriptEngine = this.getScriptEngine();
            String script = this.getResources(resourcePath);
            scriptEngine.eval(script);
            ((Map)this.scriptEngineMap).put(resourcePath, scriptEngine);
        }
        Object v = this.scriptEngineMap.get(resourcePath);
        Intrinsics.checkNotNull(v);
        return (ScriptEngine)v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String getResources(String fileName) {
        Object object;
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(fileName);
        if (inputStream != null) {
            Closeable closeable = inputStream;
            Object object2 = Charsets.UTF_8;
            Object object3 = new InputStreamReader((InputStream)closeable, (Charset)object2);
            int n = 8192;
            closeable = object3 instanceof BufferedReader ? (BufferedReader)object3 : new BufferedReader((Reader)object3, n);
            object2 = null;
            try {
                BufferedReader it = (BufferedReader)closeable;
                boolean bl = false;
                object3 = TextStreamsKt.readText((Reader)it);
                object = object3;
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)object2);
            }
        } else {
            object = null;
        }
        return object;
    }

    private final void loadPages() {
        List apiAsyncList = new ArrayList();
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<? extends Unit>>, Object>(this, (List<Deferred<Unit>>)apiAsyncList, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ KvelteLoaderProd this$0;
            final /* synthetic */ List<Deferred<Unit>> $apiAsyncList;
            {
                this.this$0 = $receiver;
                this.$apiAsyncList = $apiAsyncList;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$forEach$iv;
                        ResultKt.throwOnFailure((Object)object);
                        CoroutineScope $this$runBlocking = (CoroutineScope)this.L$0;
                        Iterable iterable = KvelteLoaderProd.access$getSvelteFilePaths(this.this$0);
                        List<Deferred<Unit>> list = this.$apiAsyncList;
                        KvelteLoaderProd kvelteLoaderProd = this.this$0;
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            String path = (String)element$iv;
                            boolean bl = false;
                            list.add((Deferred<Unit>)BuildersKt.async$default((CoroutineScope)$this$runBlocking, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(kvelteLoaderProd, path, null){
                                int label;
                                final /* synthetic */ KvelteLoaderProd this$0;
                                final /* synthetic */ String $path;
                                {
                                    this.this$0 = $receiver;
                                    this.$path = $path;
                                    super(2, $completion);
                                }

                                @Nullable
                                public final Object invokeSuspend(@NotNull Object object) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)object);
                                            ScriptEngine scriptEngine = KvelteLoaderProd.access$getScriptEngine(this.this$0);
                                            String script = KvelteLoaderProd.access$getResources(this.this$0, this.$path);
                                            scriptEngine.eval(script);
                                            ((Map)KvelteLoaderProd.access$getScriptEngineMap$p(this.this$0)).put(this.$path, scriptEngine);
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                @Nullable
                                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (int)3, null));
                        }
                        this.label = 1;
                        Object object3 = AwaitKt.awaitAll((Collection)this.$apiAsyncList, (Continuation)((Continuation)this));
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super List<? extends Unit>>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)function2;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super List<Unit>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    private final ScriptEngine getScriptEngine() {
        ScriptEngine scriptEngine = new ScriptEngineManager().getEngineByName("graal.js");
        Intrinsics.checkNotNullExpressionValue((Object)scriptEngine, (String)"ScriptEngineManager().getEngineByName(\"graal.js\")");
        return scriptEngine;
    }

    private final List<String> getSvelteFilePaths() {
        List files = new ArrayList();
        URI uri = this.getClass().getClassLoader().getResource(".kvelte/ssr/pages").toURI();
        FileSystem fileSystem = FileSystems.newFileSystem(uri, MapsKt.emptyMap());
        Path myPath = fileSystem.getPath(".kvelte/ssr/pages", new String[0]);
        Iterator ite = Files.walk(myPath, new FileVisitOption[0]).sorted().iterator();
        while (ite.hasNext()) {
            String path = ite.next().toString();
            if (!StringsKt.endsWith$default((String)path, (String)".js", (boolean)false, (int)2, null)) continue;
            files.add(path);
        }
        return files;
    }

    public static final /* synthetic */ List access$getSvelteFilePaths(KvelteLoaderProd $this) {
        return $this.getSvelteFilePaths();
    }

    public static final /* synthetic */ ScriptEngine access$getScriptEngine(KvelteLoaderProd $this) {
        return $this.getScriptEngine();
    }

    public static final /* synthetic */ String access$getResources(KvelteLoaderProd $this, String fileName) {
        return $this.getResources(fileName);
    }

    public static final /* synthetic */ SimpleLruCache access$getScriptEngineMap$p(KvelteLoaderProd $this) {
        return $this.scriptEngineMap;
    }
}

