/*
 * Decompiled with CFR 0.152.
 */
package tk.mybatis.mapper.additional.idlist;

import java.util.List;
import java.util.Set;
import org.apache.ibatis.mapping.MappedStatement;
import tk.mybatis.mapper.MapperException;
import tk.mybatis.mapper.entity.EntityColumn;
import tk.mybatis.mapper.mapperhelper.EntityHelper;
import tk.mybatis.mapper.mapperhelper.MapperHelper;
import tk.mybatis.mapper.mapperhelper.MapperTemplate;
import tk.mybatis.mapper.mapperhelper.SqlHelper;

public class IdListProvider
extends MapperTemplate {
    public IdListProvider(Class<?> mapperClass, MapperHelper mapperHelper) {
        super(mapperClass, mapperHelper);
    }

    public static void notEmpty(List<?> list, String errorMsg) {
        if (list == null || list.size() == 0) {
            throw new MapperException(errorMsg);
        }
    }

    public String deleteByIdList(MappedStatement ms) {
        Class<?> entityClass = this.getEntityClass(ms);
        StringBuilder sql = new StringBuilder();
        sql.append(SqlHelper.deleteFromTable(entityClass, this.tableName(entityClass)));
        this.appendWhereIdList(sql, entityClass, this.getConfig().isSafeDelete());
        return sql.toString();
    }

    public String selectByIdList(MappedStatement ms) {
        Class<?> entityClass = this.getEntityClass(ms);
        this.setResultType(ms, entityClass);
        StringBuilder sql = new StringBuilder();
        sql.append(SqlHelper.selectAllColumns(entityClass));
        sql.append(SqlHelper.fromTable(entityClass, this.tableName(entityClass)));
        this.appendWhereIdList(sql, entityClass, false);
        return sql.toString();
    }

    private void appendWhereIdList(StringBuilder sql, Class<?> entityClass, boolean notEmpty) {
        EntityColumn column;
        Set<EntityColumn> columnList = EntityHelper.getPKColumns(entityClass);
        if (columnList.size() == 1) {
            column = columnList.iterator().next();
            if (notEmpty) {
                sql.append("<bind name=\"notEmptyListCheck\" value=\"@tk.mybatis.mapper.additional.idlist.IdListProvider@notEmpty(");
                sql.append("idList, 'idList \u4e0d\u80fd\u4e3a\u7a7a')\"/>");
            }
        } else {
            throw new MapperException("\u7ee7\u627f ByIdList \u65b9\u6cd5\u7684\u5b9e\u4f53\u7c7b[" + entityClass.getCanonicalName() + "]\u4e2d\u5fc5\u987b\u53ea\u6709\u4e00\u4e2a\u5e26\u6709 @Id \u6ce8\u89e3\u7684\u5b57\u6bb5");
        }
        sql.append("<where>");
        sql.append("<foreach collection=\"idList\" item=\"id\" separator=\",\" open=\"");
        sql.append(column.getColumn());
        sql.append(" in ");
        sql.append("(\" close=\")\">");
        sql.append("#{id}");
        sql.append("</foreach>");
        sql.append("</where>");
    }
}

