/*
 * Decompiled with CFR 0.152.
 */
package tk.mybatis.mapper.mapperhelper;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ibatis.annotations.DeleteProvider;
import org.apache.ibatis.annotations.InsertProvider;
import org.apache.ibatis.annotations.SelectProvider;
import org.apache.ibatis.annotations.UpdateProvider;
import org.apache.ibatis.builder.annotation.ProviderSqlSource;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSession;
import tk.mybatis.mapper.mapperhelper.EmptyMapperProvider;
import tk.mybatis.mapper.mapperhelper.EntityHelper;
import tk.mybatis.mapper.mapperhelper.MapperTemplate;

public class MapperHelper {
    private Map<Class<?>, MapperTemplate> registerMapper = new ConcurrentHashMap();
    private Map<String, MapperTemplate> msIdCache = new HashMap<String, MapperTemplate>();
    private final Map<String, Boolean> msIdSkip = new HashMap<String, Boolean>();
    private Set<Collection<MappedStatement>> collectionSet = new HashSet<Collection<MappedStatement>>();
    private boolean spring = false;
    private boolean spring4 = false;
    private String springVersion;
    private boolean notEmpty = false;
    private List<SqlSession> sqlSessions = new ArrayList<SqlSession>();
    private Config config = new Config();

    public MapperHelper() {
    }

    public MapperHelper(Properties properties) {
        this.setProperties(properties);
    }

    public void setSqlSessions(SqlSession[] sqlSessions) {
        if (sqlSessions != null && sqlSessions.length > 0) {
            this.sqlSessions.addAll(Arrays.asList(sqlSessions));
        }
    }

    public boolean isNotEmpty() {
        return this.notEmpty;
    }

    public void setNotEmpty(boolean notEmpty) {
        this.notEmpty = notEmpty;
    }

    public void initMapper() {
        this.initSpringVersion();
        for (SqlSession sqlSession : this.sqlSessions) {
            this.processConfiguration(sqlSession.getConfiguration());
        }
    }

    private void initSpringVersion() {
        try {
            Class<?> springVersionClass = Class.forName("org.springframework.core.SpringVersion");
            this.springVersion = (String)springVersionClass.getDeclaredMethod("getVersion", new Class[0]).invoke(null, new Object[0]);
            this.spring = true;
            if (this.springVersion.indexOf(".") > 0) {
                int MajorVersion = Integer.parseInt(this.springVersion.substring(0, this.springVersion.indexOf(".")));
                this.spring4 = MajorVersion > 3;
            }
        }
        catch (Exception e) {
            this.spring = false;
            this.spring4 = false;
        }
    }

    public boolean isSpring4() {
        return this.spring4;
    }

    public boolean isSpring() {
        return this.spring;
    }

    public String getSpringVersion() {
        return this.springVersion;
    }

    private MapperTemplate fromMapperClass(Class<?> mapperClass) {
        Method[] methods = mapperClass.getDeclaredMethods();
        Class templateClass = null;
        Class tempClass = null;
        HashSet<String> methodSet = new HashSet<String>();
        for (Method method : methods) {
            SelectProvider provider;
            if (method.isAnnotationPresent(SelectProvider.class)) {
                provider = method.getAnnotation(SelectProvider.class);
                tempClass = provider.type();
                methodSet.add(method.getName());
            } else if (method.isAnnotationPresent(InsertProvider.class)) {
                provider = method.getAnnotation(InsertProvider.class);
                tempClass = provider.type();
                methodSet.add(method.getName());
            } else if (method.isAnnotationPresent(DeleteProvider.class)) {
                provider = method.getAnnotation(DeleteProvider.class);
                tempClass = provider.type();
                methodSet.add(method.getName());
            } else if (method.isAnnotationPresent(UpdateProvider.class)) {
                provider = method.getAnnotation(UpdateProvider.class);
                tempClass = provider.type();
                methodSet.add(method.getName());
            }
            if (templateClass == null) {
                templateClass = tempClass;
                continue;
            }
            if (templateClass == tempClass) continue;
            throw new RuntimeException("\u4e00\u4e2a\u901a\u7528Mapper\u4e2d\u53ea\u5141\u8bb8\u5b58\u5728\u4e00\u4e2aMapperTemplate\u5b50\u7c7b!");
        }
        if (templateClass == null || !MapperTemplate.class.isAssignableFrom(templateClass)) {
            templateClass = EmptyMapperProvider.class;
        }
        MapperTemplate mapperTemplate = null;
        try {
            mapperTemplate = (MapperTemplate)templateClass.getConstructor(Class.class, MapperHelper.class).newInstance(mapperClass, this);
        }
        catch (Exception e) {
            throw new RuntimeException("\u5b9e\u4f8b\u5316MapperTemplate\u5bf9\u8c61\u5931\u8d25:" + e.getMessage());
        }
        for (String methodName : methodSet) {
            try {
                mapperTemplate.addMethodMap(methodName, templateClass.getMethod(methodName, MappedStatement.class));
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(templateClass.getCanonicalName() + "\u4e2d\u7f3a\u5c11" + methodName + "\u65b9\u6cd5!");
            }
        }
        return mapperTemplate;
    }

    public void registerMapper(Class<?> mapperClass) {
        Class<?>[] interfaces;
        if (!this.registerMapper.containsKey(mapperClass)) {
            this.registerMapper.put(mapperClass, this.fromMapperClass(mapperClass));
        }
        if ((interfaces = mapperClass.getInterfaces()) != null && interfaces.length > 0) {
            for (Class<?> anInterface : interfaces) {
                this.registerMapper(anInterface);
            }
        }
    }

    public void registerMapper(String mapperClass) {
        try {
            this.registerMapper(Class.forName(mapperClass));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("\u6ce8\u518c\u901a\u7528Mapper[" + mapperClass + "]\u5931\u8d25\uff0c\u627e\u4e0d\u5230\u8be5\u901a\u7528Mapper!");
        }
    }

    public void setMappers(String[] mappers) {
        if (mappers != null && mappers.length > 0) {
            for (String mapper : mappers) {
                this.registerMapper(mapper);
            }
        }
    }

    public void setUUID(String UUID) {
        this.config.UUID = UUID;
    }

    public void setIDENTITY(String IDENTITY) {
        IdentityDialect identityDialect = IdentityDialect.getDatabaseDialect(IDENTITY);
        if (identityDialect != null) {
            this.config.IDENTITY = identityDialect.getIdentityRetrievalStatement();
        } else {
            this.config.IDENTITY = IDENTITY;
        }
    }

    public void setOrder(String order) {
        this.config.BEFORE = "BEFORE".equalsIgnoreCase(order);
    }

    public void setSeqFormat(String seqFormat) {
        this.config.seqFormat = seqFormat;
    }

    public void setCatalog(String catalog) {
        this.config.catalog = catalog;
    }

    public void setSchema(String schema) {
        this.config.schema = schema;
    }

    public String getPrefix() {
        if (this.config.catalog != null && this.config.catalog.length() > 0) {
            return this.config.catalog;
        }
        if (this.config.schema != null && this.config.schema.length() > 0) {
            return this.config.catalog;
        }
        return "";
    }

    public String getUUID() {
        if (this.config.UUID != null && this.config.UUID.length() > 0) {
            return this.config.UUID;
        }
        return "@java.util.UUID@randomUUID().toString().replace(\"-\", \"\")";
    }

    public String getIDENTITY() {
        if (this.config.IDENTITY != null && this.config.IDENTITY.length() > 0) {
            return this.config.IDENTITY;
        }
        return IdentityDialect.MYSQL.getIdentityRetrievalStatement();
    }

    public boolean getBEFORE() {
        return this.config.BEFORE;
    }

    public String getSeqFormat() {
        if (this.config.seqFormat != null && this.config.seqFormat.length() > 0) {
            return this.config.seqFormat;
        }
        return "{0}.nextval";
    }

    public String getTableName(Class<?> entityClass) {
        EntityHelper.EntityTable entityTable = EntityHelper.getEntityTable(entityClass);
        String prefix = entityTable.getPrefix();
        if (prefix.equals("")) {
            prefix = this.getPrefix();
        }
        if (!prefix.equals("")) {
            return prefix + "." + entityTable.getName();
        }
        return entityTable.getName();
    }

    public boolean isMapperMethod(String msId) {
        if (this.msIdSkip.get(msId) != null) {
            return this.msIdSkip.get(msId);
        }
        for (Map.Entry<Class<?>, MapperTemplate> entry : this.registerMapper.entrySet()) {
            if (!entry.getValue().supportMethod(msId)) continue;
            this.msIdSkip.put(msId, true);
            return true;
        }
        this.msIdSkip.put(msId, false);
        return false;
    }

    private MapperTemplate getMapperTemplate(String msId) {
        MapperTemplate mapperTemplate = null;
        if (this.msIdCache.get(msId) != null) {
            mapperTemplate = this.msIdCache.get(msId);
        } else {
            for (Map.Entry<Class<?>, MapperTemplate> entry : this.registerMapper.entrySet()) {
                if (!entry.getValue().supportMethod(msId)) continue;
                mapperTemplate = entry.getValue();
                break;
            }
            this.msIdCache.put(msId, mapperTemplate);
        }
        return mapperTemplate;
    }

    public void setSqlSource(MappedStatement ms) {
        MapperTemplate mapperTemplate = this.getMapperTemplate(ms.getId());
        try {
            if (mapperTemplate != null) {
                mapperTemplate.setSqlSource(ms);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("\u8c03\u7528\u65b9\u6cd5\u5f02\u5e38:" + e.getMessage());
        }
    }

    public void setProperties(Properties properties) {
        String mapper;
        String notEmpty;
        String ORDER;
        String schema;
        String catalog;
        String seqFormat;
        String IDENTITY;
        if (properties == null) {
            return;
        }
        String UUID = properties.getProperty("UUID");
        if (UUID != null && UUID.length() > 0) {
            this.setUUID(UUID);
        }
        if ((IDENTITY = properties.getProperty("IDENTITY")) != null && IDENTITY.length() > 0) {
            this.setIDENTITY(IDENTITY);
        }
        if ((seqFormat = properties.getProperty("seqFormat")) != null && seqFormat.length() > 0) {
            this.setSeqFormat(seqFormat);
        }
        if ((catalog = properties.getProperty("catalog")) != null && catalog.length() > 0) {
            this.setCatalog(catalog);
        }
        if ((schema = properties.getProperty("schema")) != null && schema.length() > 0) {
            this.setSchema(schema);
        }
        if ((ORDER = properties.getProperty("ORDER")) != null && ORDER.length() > 0) {
            this.setOrder(ORDER);
        }
        if ((notEmpty = properties.getProperty("notEmpty")) != null && notEmpty.length() > 0) {
            this.notEmpty = notEmpty.equalsIgnoreCase("TRUE");
        }
        if ((mapper = properties.getProperty("mappers")) != null && mapper.length() > 0) {
            String[] mappers;
            for (String mapperClass : mappers = mapper.split(",")) {
                if (mapperClass.length() <= 0) continue;
                this.registerMapper(mapperClass);
            }
        }
    }

    public void processConfiguration(Configuration configuration) {
        Collection collection = configuration.getMappedStatements();
        if (this.collectionSet.contains(collection)) {
            return;
        }
        this.collectionSet.add(collection);
        int size = collection.size();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            MappedStatement ms;
            Object object = iterator.next();
            if (object instanceof MappedStatement && this.isMapperMethod((ms = (MappedStatement)object).getId()) && ms.getSqlSource() instanceof ProviderSqlSource) {
                this.setSqlSource(ms);
            }
            if (collection.size() == size) continue;
            size = collection.size();
            iterator = collection.iterator();
        }
    }

    private class Config {
        private String UUID;
        private String IDENTITY;
        private boolean BEFORE = false;
        private String seqFormat;
        private String catalog;
        private String schema;

        private Config() {
        }
    }

    public static enum IdentityDialect {
        DB2("VALUES IDENTITY_VAL_LOCAL()"),
        MYSQL("SELECT LAST_INSERT_ID()"),
        SQLSERVER("SELECT SCOPE_IDENTITY()"),
        CLOUDSCAPE("VALUES IDENTITY_VAL_LOCAL()"),
        DERBY("VALUES IDENTITY_VAL_LOCAL()"),
        HSQLDB("CALL IDENTITY()"),
        SYBASE("SELECT @@IDENTITY"),
        DB2_MF("SELECT IDENTITY_VAL_LOCAL() FROM SYSIBM.SYSDUMMY1"),
        INFORMIX("select dbinfo('sqlca.sqlerrd1') from systables where tabid=1");

        private String identityRetrievalStatement;

        private IdentityDialect(String identityRetrievalStatement) {
            this.identityRetrievalStatement = identityRetrievalStatement;
        }

        public String getIdentityRetrievalStatement() {
            return this.identityRetrievalStatement;
        }

        public static IdentityDialect getDatabaseDialect(String database) {
            IdentityDialect returnValue = null;
            if ("DB2".equalsIgnoreCase(database)) {
                returnValue = DB2;
            } else if ("MySQL".equalsIgnoreCase(database)) {
                returnValue = MYSQL;
            } else if ("SqlServer".equalsIgnoreCase(database)) {
                returnValue = SQLSERVER;
            } else if ("Cloudscape".equalsIgnoreCase(database)) {
                returnValue = CLOUDSCAPE;
            } else if ("Derby".equalsIgnoreCase(database)) {
                returnValue = DERBY;
            } else if ("HSQLDB".equalsIgnoreCase(database)) {
                returnValue = HSQLDB;
            } else if ("SYBASE".equalsIgnoreCase(database)) {
                returnValue = SYBASE;
            } else if ("DB2_MF".equalsIgnoreCase(database)) {
                returnValue = DB2_MF;
            } else if ("Informix".equalsIgnoreCase(database)) {
                returnValue = INFORMIX;
            }
            return returnValue;
        }
    }
}

