/*
 * Decompiled with CFR 0.152.
 */
package tk.mybatis.mapper.mapperhelper;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OrderBy;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import tk.mybatis.mapper.mapperhelper.MapperHelper;

public class EntityHelper {
    private static final Map<Class<?>, EntityTable> entityTableMap = new HashMap();

    public static EntityTable getEntityTable(Class<?> entityClass) {
        EntityTable entityTable = entityTableMap.get(entityClass);
        if (entityTable == null) {
            EntityHelper.initEntityNameMap(entityClass);
            entityTable = entityTableMap.get(entityClass);
        }
        if (entityTable == null) {
            throw new RuntimeException("\u65e0\u6cd5\u83b7\u53d6\u5b9e\u4f53\u7c7b" + entityClass.getCanonicalName() + "\u5bf9\u5e94\u7684\u8868\u540d!");
        }
        return entityTable;
    }

    public static String getOrderByClause(Class<?> entityClass) {
        EntityTable table = EntityHelper.getEntityTable(entityClass);
        if (table.orderByClause != null) {
            return table.orderByClause;
        }
        StringBuilder orderBy = new StringBuilder();
        for (EntityColumn column : table.getEntityClassColumns()) {
            if (column.getOrderBy() == null) continue;
            if (orderBy.length() != 0) {
                orderBy.append(",");
            }
            orderBy.append(column.getColumn()).append(" ").append(column.getOrderBy());
        }
        table.orderByClause = orderBy.toString();
        return table.orderByClause;
    }

    public static Set<EntityColumn> getColumns(Class<?> entityClass) {
        return EntityHelper.getEntityTable(entityClass).getEntityClassColumns();
    }

    public static Set<EntityColumn> getPKColumns(Class<?> entityClass) {
        return EntityHelper.getEntityTable(entityClass).getEntityClassPKColumns();
    }

    public static Map<String, String> getColumnAlias(Class<?> entityClass) {
        EntityTable entityTable = EntityHelper.getEntityTable(entityClass);
        if (entityTable.aliasMap != null) {
            return entityTable.aliasMap;
        }
        Set<EntityColumn> columnList = entityTable.getEntityClassColumns();
        entityTable.aliasMap = new HashMap(columnList.size());
        for (EntityColumn column : columnList) {
            entityTable.aliasMap.put(column.getColumn(), column.getProperty());
        }
        return entityTable.aliasMap;
    }

    public static String getSelectColumns(Class<?> entityClass) {
        Set<EntityColumn> columnList = EntityHelper.getColumns(entityClass);
        StringBuilder selectBuilder = new StringBuilder();
        boolean skipAlias = Map.class.isAssignableFrom(entityClass);
        for (EntityColumn entityColumn : columnList) {
            selectBuilder.append(entityColumn.getColumn());
            if (!skipAlias && !entityColumn.getColumn().equalsIgnoreCase(entityColumn.getProperty())) {
                selectBuilder.append(" ").append(entityColumn.getProperty().toUpperCase()).append(",");
                continue;
            }
            selectBuilder.append(",");
        }
        return selectBuilder.substring(0, selectBuilder.length() - 1);
    }

    public static String getAllColumns(Class<?> entityClass) {
        Set<EntityColumn> columnList = EntityHelper.getColumns(entityClass);
        StringBuilder selectBuilder = new StringBuilder();
        for (EntityColumn entityColumn : columnList) {
            selectBuilder.append(entityColumn.getColumn()).append(",");
        }
        return selectBuilder.substring(0, selectBuilder.length() - 1);
    }

    public static String getPrimaryKeyWhere(Class<?> entityClass) {
        Set<EntityColumn> entityColumns = EntityHelper.getPKColumns(entityClass);
        StringBuilder whereBuilder = new StringBuilder();
        for (EntityColumn column : entityColumns) {
            whereBuilder.append(column.getColumn()).append(" = ?").append(" AND ");
        }
        return whereBuilder.substring(0, whereBuilder.length() - 4);
    }

    public static synchronized void initEntityNameMap(Class<?> entityClass) {
        Table table;
        if (entityTableMap.get(entityClass) != null) {
            return;
        }
        EntityTable entityTable = null;
        if (entityClass.isAnnotationPresent(Table.class) && !(table = entityClass.getAnnotation(Table.class)).name().equals("")) {
            entityTable = new EntityTable();
            entityTable.setTable(table);
        }
        if (entityTable == null) {
            entityTable = new EntityTable();
            entityTable.name = EntityHelper.camelhumpToUnderline(entityClass.getSimpleName());
        }
        List<Field> fieldList = EntityHelper.getAllField(entityClass, null);
        LinkedHashSet<EntityColumn> columnSet = new LinkedHashSet<EntityColumn>();
        LinkedHashSet<EntityColumn> pkColumnSet = new LinkedHashSet<EntityColumn>();
        for (Field field : fieldList) {
            if (field.isAnnotationPresent(Transient.class)) continue;
            EntityColumn entityColumn = new EntityColumn(entityTable);
            if (field.isAnnotationPresent(Id.class)) {
                entityColumn.setId(true);
            }
            String columnName = null;
            if (field.isAnnotationPresent(Column.class)) {
                Column column = field.getAnnotation(Column.class);
                columnName = column.name();
            }
            if (columnName == null || columnName.equals("")) {
                columnName = EntityHelper.camelhumpToUnderline(field.getName());
            }
            entityColumn.setProperty(field.getName());
            entityColumn.setColumn(columnName.toUpperCase());
            entityColumn.setJavaType(field.getType());
            if (field.isAnnotationPresent(OrderBy.class)) {
                OrderBy orderBy = field.getAnnotation(OrderBy.class);
                if (orderBy.value().equals("")) {
                    entityColumn.setOrderBy("ASC");
                } else {
                    entityColumn.setOrderBy(orderBy.value());
                }
            }
            if (field.isAnnotationPresent(SequenceGenerator.class)) {
                SequenceGenerator sequenceGenerator = field.getAnnotation(SequenceGenerator.class);
                if (sequenceGenerator.sequenceName().equals("")) {
                    throw new RuntimeException(entityClass + "\u5b57\u6bb5" + field.getName() + "\u7684\u6ce8\u89e3@SequenceGenerator\u672a\u6307\u5b9asequenceName!");
                }
                entityColumn.setSequenceName(sequenceGenerator.sequenceName());
            } else if (field.isAnnotationPresent(GeneratedValue.class)) {
                GeneratedValue generatedValue = field.getAnnotation(GeneratedValue.class);
                if (generatedValue.generator().equals("UUID")) {
                    entityColumn.setUuid(true);
                } else if (generatedValue.generator().equals("JDBC")) {
                    entityColumn.setIdentity(true);
                    entityColumn.setGenerator("JDBC");
                    entityTable.setKeyProperties(entityColumn.getProperty());
                    entityTable.setKeyColumns(entityColumn.getColumn());
                } else if (generatedValue.strategy() == GenerationType.IDENTITY) {
                    entityColumn.setIdentity(true);
                    if (!generatedValue.generator().equals("")) {
                        String generator = null;
                        MapperHelper.IdentityDialect identityDialect = MapperHelper.IdentityDialect.getDatabaseDialect(generatedValue.generator());
                        generator = identityDialect != null ? identityDialect.getIdentityRetrievalStatement() : generatedValue.generator();
                        entityColumn.setGenerator(generator);
                    }
                } else {
                    throw new RuntimeException(field.getName() + " - \u8be5\u5b57\u6bb5@GeneratedValue\u914d\u7f6e\u53ea\u5141\u8bb8\u4ee5\u4e0b\u51e0\u79cd\u5f62\u5f0f:" + "\n1.\u5168\u90e8\u6570\u636e\u5e93\u901a\u7528\u7684@GeneratedValue(generator=\"UUID\")" + "\n2.useGeneratedKeys\u7684@GeneratedValue(generator=\\\"JDBC\\\")  " + "\n3.\u7c7b\u4f3cmysql\u6570\u636e\u5e93\u7684@GeneratedValue(strategy=GenerationType.IDENTITY[,generator=\"Mysql\"])");
                }
            }
            columnSet.add(entityColumn);
            if (!entityColumn.isId()) continue;
            pkColumnSet.add(entityColumn);
        }
        entityTable.entityClassColumns = columnSet;
        if (pkColumnSet.size() == 0) {
            entityTable.entityClassPKColumns = columnSet;
        } else {
            entityTable.entityClassPKColumns = pkColumnSet;
        }
        entityTableMap.put(entityClass, entityTable);
    }

    public static String camelhumpToUnderline(String str) {
        char[] chars = str.toCharArray();
        int size = chars.length;
        StringBuilder sb = new StringBuilder(size * 3 / 2 + 1);
        for (int i = 0; i < size; ++i) {
            char c = chars[i];
            if (EntityHelper.isUppercaseAlpha(c)) {
                sb.append('_').append(c);
                continue;
            }
            sb.append(EntityHelper.toUpperAscii(c));
        }
        return sb.charAt(0) == '_' ? sb.substring(1) : sb.toString();
    }

    public static String underlineToCamelhump(String str) {
        Matcher matcher = Pattern.compile("_[a-z]").matcher(str);
        StringBuilder builder = new StringBuilder(str);
        int i = 0;
        while (matcher.find()) {
            builder.replace(matcher.start() - i, matcher.end() - i, matcher.group().substring(1).toUpperCase());
            ++i;
        }
        if (Character.isUpperCase(builder.charAt(0))) {
            builder.replace(0, 1, String.valueOf(Character.toLowerCase(builder.charAt(0))));
        }
        return builder.toString();
    }

    public static boolean isUppercaseAlpha(char c) {
        return c >= 'A' && c <= 'Z';
    }

    public static char toUpperAscii(char c) {
        if (EntityHelper.isUppercaseAlpha(c)) {
            c = (char)(c - 32);
        }
        return c;
    }

    private static List<Field> getAllField(Class<?> entityClass, List<Field> fieldList) {
        Field[] fields;
        if (fieldList == null) {
            fieldList = new LinkedList<Field>();
        }
        if (entityClass.equals(Object.class)) {
            return fieldList;
        }
        for (Field field : fields = entityClass.getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            fieldList.add(field);
        }
        Class<?> superClass = entityClass.getSuperclass();
        if (superClass != null && !superClass.equals(Object.class) && (superClass.isAnnotationPresent(Entity.class) || !Map.class.isAssignableFrom(superClass) && !Collection.class.isAssignableFrom(superClass))) {
            return EntityHelper.getAllField(entityClass.getSuperclass(), fieldList);
        }
        return fieldList;
    }

    public static class EntityColumn {
        private EntityTable table;
        private String property;
        private String column;
        private Class<?> javaType;
        private String sequenceName;
        private boolean id = false;
        private boolean uuid = false;
        private boolean identity = false;
        private String generator;
        private String orderBy;

        public EntityColumn() {
        }

        public EntityColumn(EntityTable table) {
            this.table = table;
        }

        public EntityTable getTable() {
            return this.table;
        }

        public void setTable(EntityTable table) {
            this.table = table;
        }

        public String getProperty() {
            return this.property;
        }

        public void setProperty(String property) {
            this.property = property;
        }

        public String getColumn() {
            return this.column;
        }

        public void setColumn(String column) {
            this.column = column;
        }

        public Class<?> getJavaType() {
            return this.javaType;
        }

        public void setJavaType(Class<?> javaType) {
            this.javaType = javaType;
        }

        public String getSequenceName() {
            return this.sequenceName;
        }

        public void setSequenceName(String sequenceName) {
            this.sequenceName = sequenceName;
        }

        public boolean isId() {
            return this.id;
        }

        public void setId(boolean id) {
            this.id = id;
        }

        public boolean isUuid() {
            return this.uuid;
        }

        public void setUuid(boolean uuid) {
            this.uuid = uuid;
        }

        public boolean isIdentity() {
            return this.identity;
        }

        public void setIdentity(boolean identity) {
            this.identity = identity;
        }

        public String getGenerator() {
            return this.generator;
        }

        public void setGenerator(String generator) {
            this.generator = generator;
        }

        public String getOrderBy() {
            return this.orderBy;
        }

        public void setOrderBy(String orderBy) {
            this.orderBy = orderBy;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EntityColumn that = (EntityColumn)o;
            if (this.id != that.id) {
                return false;
            }
            if (this.identity != that.identity) {
                return false;
            }
            if (this.uuid != that.uuid) {
                return false;
            }
            if (this.column != null ? !this.column.equals(that.column) : that.column != null) {
                return false;
            }
            if (this.generator != null ? !this.generator.equals(that.generator) : that.generator != null) {
                return false;
            }
            if (this.javaType != null ? !this.javaType.equals(that.javaType) : that.javaType != null) {
                return false;
            }
            if (this.orderBy != null ? !this.orderBy.equals(that.orderBy) : that.orderBy != null) {
                return false;
            }
            if (this.property != null ? !this.property.equals(that.property) : that.property != null) {
                return false;
            }
            return !(this.sequenceName != null ? !this.sequenceName.equals(that.sequenceName) : that.sequenceName != null);
        }

        public int hashCode() {
            int result = this.property != null ? this.property.hashCode() : 0;
            result = 31 * result + (this.column != null ? this.column.hashCode() : 0);
            result = 31 * result + (this.javaType != null ? this.javaType.hashCode() : 0);
            result = 31 * result + (this.sequenceName != null ? this.sequenceName.hashCode() : 0);
            result = 31 * result + (this.id ? 1 : 0);
            result = 31 * result + (this.uuid ? 1 : 0);
            result = 31 * result + (this.identity ? 1 : 0);
            result = 31 * result + (this.generator != null ? this.generator.hashCode() : 0);
            result = 31 * result + (this.orderBy != null ? this.orderBy.hashCode() : 0);
            return result;
        }
    }

    public static class EntityTable {
        private String name;
        private String catalog;
        private String schema;
        private String orderByClause;
        private Set<EntityColumn> entityClassColumns;
        private Set<EntityColumn> entityClassPKColumns;
        private Map<String, String> aliasMap;
        private List<String> keyProperties;
        private List<String> keyColumns;

        public void setTable(Table table) {
            this.name = table.name();
            this.catalog = table.catalog();
            this.schema = table.schema();
        }

        public String getName() {
            return this.name;
        }

        public String getCatalog() {
            return this.catalog;
        }

        public String getSchema() {
            return this.schema;
        }

        public String getPrefix() {
            if (this.catalog != null && this.catalog.length() > 0) {
                return this.catalog;
            }
            if (this.schema != null && this.schema.length() > 0) {
                return this.catalog;
            }
            return "";
        }

        public Set<EntityColumn> getEntityClassColumns() {
            return this.entityClassColumns;
        }

        public Set<EntityColumn> getEntityClassPKColumns() {
            return this.entityClassPKColumns;
        }

        public Map<String, String> getAliasMap() {
            return this.aliasMap;
        }

        public String[] getKeyProperties() {
            if (this.keyProperties != null && this.keyProperties.size() > 0) {
                return this.keyProperties.toArray(new String[0]);
            }
            return new String[0];
        }

        public void setKeyProperties(String keyProperty) {
            if (this.keyProperties == null) {
                this.keyProperties = new LinkedList<String>();
                this.keyProperties.add(keyProperty);
            } else {
                this.keyProperties.add(keyProperty);
            }
        }

        public String[] getKeyColumns() {
            if (this.keyColumns != null && this.keyColumns.size() > 0) {
                return this.keyColumns.toArray(new String[0]);
            }
            return new String[0];
        }

        public void setKeyColumns(String keyColumn) {
            if (this.keyColumns == null) {
                this.keyColumns = new LinkedList<String>();
                this.keyColumns.add(keyColumn);
            } else {
                this.keyColumns.add(keyColumn);
            }
        }
    }
}

