/*
 * Decompiled with CFR 0.152.
 */
package tk.jamun.volley.helpers;

import android.support.annotation.NonNull;
import com.android.volley.DefaultRetryPolicy;
import com.android.volley.Request;
import com.android.volley.RetryPolicy;
import com.android.volley.toolbox.StringRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import tk.jamun.volley.classes.VolleyJsonArrayRequest;
import tk.jamun.volley.classes.VolleyJsonObjectRequest;
import tk.jamun.volley.classes.VolleyMultipartRequest;
import tk.jamun.volley.classes.VolleyNetworkRequest;
import tk.jamun.volley.classes.VolleyResponseRequests;
import tk.jamun.volley.helpers.VolleyValues;
import tk.jamun.volley.main.VolleySingleton;
import tk.jamun.volley.model.ModelHeader;

public class VolleyNeeds {
    private static VolleyNeeds volleyNeeds;
    private ArrayList<ModelHeader> headerArrayList;

    public static VolleyNeeds get() {
        if (volleyNeeds == null) {
            volleyNeeds = new VolleyNeeds();
        }
        return volleyNeeds;
    }

    public boolean checkResponseCode(@NonNull Integer networkResponse) {
        return networkResponse > 199 && networkResponse < 300;
    }

    public void addCalls(@NonNull Object[] objects) {
        for (Object object : objects) {
            this.addCalls(object);
        }
    }

    public void addCalls(@NonNull Object object) {
        if (object instanceof VolleyNetworkRequest) {
            ((VolleyNetworkRequest)((Object)object)).setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(VolleyValues.get().getDefaultRequestTime(), 1, 1.0f));
            VolleySingleton.get().getRequestQueue().add((Request)((VolleyNetworkRequest)((Object)object)));
        } else if (object instanceof StringRequest) {
            ((StringRequest)object).setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(VolleyValues.get().getDefaultRequestTime(), 1, 1.0f));
            VolleySingleton.get().getRequestQueue().add((Request)((StringRequest)object));
        } else if (object instanceof VolleyResponseRequests) {
            ((VolleyResponseRequests)((Object)object)).setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(VolleyValues.get().getDefaultRequestTime(), 1, 1.0f));
            VolleySingleton.get().getRequestQueue().add((Request)((VolleyResponseRequests)((Object)object)));
        } else if (object instanceof VolleyJsonArrayRequest) {
            ((VolleyJsonArrayRequest)((Object)object)).setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(VolleyValues.get().getDefaultRequestTime(), 1, 1.0f));
            VolleySingleton.get().getRequestQueue().add((Request)((VolleyJsonArrayRequest)((Object)object)));
        } else if (object instanceof VolleyJsonObjectRequest) {
            ((VolleyJsonObjectRequest)((Object)object)).setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(VolleyValues.get().getDefaultRequestTime(), 1, 1.0f));
            VolleySingleton.get().getRequestQueue().add((Request)((VolleyJsonObjectRequest)((Object)object)));
        } else if (object instanceof VolleyMultipartRequest) {
            ((VolleyMultipartRequest)((Object)object)).setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(VolleyValues.get().getDefaultRequestTime(), 1, 1.0f));
            VolleySingleton.get().getRequestQueue().add((Request)((VolleyMultipartRequest)((Object)object)));
        }
    }

    public Map<String, String> setVolleyHeader() {
        HashMap<String, String> headers = new HashMap<String, String>();
        if (VolleyValues.get().isEnableHeaderContentType()) {
            headers.put("Content-Type", VolleyValues.get().getHeaderContentType());
        }
        if (this.headerArrayList != null && !this.headerArrayList.isEmpty()) {
            for (ModelHeader modelHeader : this.headerArrayList) {
                headers.put(modelHeader.getKey(), modelHeader.getValue());
            }
        }
        return headers;
    }

    public ArrayList<ModelHeader> getUpHeaders() {
        if (this.headerArrayList == null) {
            this.headerArrayList = new ArrayList();
        }
        return this.headerArrayList;
    }

    public void setUpHeaders(@NonNull ArrayList<ModelHeader> arrayList) {
        this.headerArrayList = arrayList;
    }
}

