/*
 * Decompiled with CFR 0.152.
 */
package tk.jamun.volley.helpers;

import android.support.annotation.NonNull;
import com.android.volley.NetworkError;
import com.android.volley.NoConnectionError;
import com.android.volley.ParseError;
import com.android.volley.TimeoutError;
import com.android.volley.VolleyError;

public class VolleyErrorExceptions {
    private static VolleyErrorExceptions volleyErrorExceptions;
    @NonNull
    public String VOLLEY_ERROR_STRING_CONNECTION_TIMEOUT = "Connection Timeout!";
    @NonNull
    public String VOLLEY_ERROR_STRING_UNAUTHORIZED = "You are not Authorized, Please Login Again!";
    @NonNull
    public String VOLLEY_ERROR_STRING_CHECK_DATA = "Please Check your data and Try Again!";
    @NonNull
    public String VOLLEY_ERROR_STRING_FORBIDDEN_ACCESS = "Forbidden Error, You cannot access this!";
    @NonNull
    public String VOLLEY_ERROR_STRING_PAGE_NOT_FOUND = "Page not found or Missing Resources!";
    @NonNull
    public String VOLLEY_ERROR_STRING_NETWORK = "Network Failure, Please Try Again!";
    @NonNull
    public String VOLLEY_ERROR_STRING_PARSING = "Parsing Error,Unable to Parse Request!";
    @NonNull
    public String VOLLEY_ERROR_STRING_ELSE = "Check Connection and Try Again!";
    @NonNull
    public String VOLLEY_ERROR_STRING_WRONG_METHOD = "Request Method not allowed!";

    public static VolleyErrorExceptions get() {
        if (volleyErrorExceptions == null) {
            volleyErrorExceptions = new VolleyErrorExceptions();
        }
        return volleyErrorExceptions;
    }

    public void setVolleyErrors(@NonNull String for400, @NonNull String for401, @NonNull String for403, @NonNull String for404, @NonNull String forElse, @NonNull String forConnectionTimeOut, @NonNull String forNetworkError, @NonNull String forParsing, @NonNull String forMethod) {
        this.VOLLEY_ERROR_STRING_CONNECTION_TIMEOUT = forConnectionTimeOut;
        this.VOLLEY_ERROR_STRING_UNAUTHORIZED = for401;
        this.VOLLEY_ERROR_STRING_CHECK_DATA = for400;
        this.VOLLEY_ERROR_STRING_FORBIDDEN_ACCESS = for403;
        this.VOLLEY_ERROR_STRING_NETWORK = forNetworkError;
        this.VOLLEY_ERROR_STRING_PAGE_NOT_FOUND = for404;
        this.VOLLEY_ERROR_STRING_ELSE = forElse;
        this.VOLLEY_ERROR_STRING_PARSING = forParsing;
        this.VOLLEY_ERROR_STRING_WRONG_METHOD = forMethod;
    }

    public int getVolleyErrorStatusCode(VolleyError error) {
        if (error != null && error.networkResponse != null) {
            return error.networkResponse.statusCode;
        }
        return 0;
    }

    public String getVolleyErrorMessage(VolleyError error) {
        if (error != null && error.networkResponse != null) {
            switch (error.networkResponse.statusCode) {
                case 400: {
                    return this.VOLLEY_ERROR_STRING_CHECK_DATA;
                }
                case 401: {
                    return this.VOLLEY_ERROR_STRING_UNAUTHORIZED;
                }
                case 403: {
                    return this.VOLLEY_ERROR_STRING_FORBIDDEN_ACCESS;
                }
                case 404: {
                    return this.VOLLEY_ERROR_STRING_PAGE_NOT_FOUND;
                }
                case 405: {
                    return this.VOLLEY_ERROR_STRING_PAGE_NOT_FOUND;
                }
            }
            if (error instanceof TimeoutError || error instanceof NoConnectionError) {
                return this.VOLLEY_ERROR_STRING_CONNECTION_TIMEOUT;
            }
            if (error instanceof NetworkError) {
                return this.VOLLEY_ERROR_STRING_NETWORK;
            }
            if (error instanceof ParseError) {
                return this.VOLLEY_ERROR_STRING_PARSING;
            }
            return this.VOLLEY_ERROR_STRING_ELSE;
        }
        return "";
    }

    public int getVolleyErrorStatusCode(Exception e) {
        return this.getVolleyErrorStatusCode(new VolleyError(e.getMessage()));
    }

    public String getVolleyErrorMessage(Exception e) {
        return this.getVolleyErrorMessage(new VolleyError(e.getMessage()));
    }
}

