/*
 * Decompiled with CFR 0.152.
 */
package tk.jamun.volley.classes;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.android.volley.Cache;
import com.android.volley.NetworkResponse;
import com.android.volley.Request;
import com.android.volley.Response;
import com.android.volley.VolleyLog;
import com.android.volley.toolbox.HttpHeaderParser;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.util.Map;
import tk.jamun.volley.classes.VolleyGSON;
import tk.jamun.volley.classes.VolleyWorkLoad;
import tk.jamun.volley.helpers.VolleyNeeds;
import tk.jamun.volley.helpers.VolleyValues;
import tk.jamun.volley.variables.VolleyResponse;
import tk.jamun.volley.variables.VolleyResponses;

public class VolleyStringRequest
extends Request<String> {
    @Nullable
    private VolleyResponse.Listener<String> volleyListener;
    private VolleyResponses listener;
    private Response.Listener<String> mListener;
    private String mRequestBody;

    public VolleyStringRequest(int method, @NonNull String url, Object payload, Type typeOfPayload, VolleyResponses volleyListener) {
        this(method, url, VolleyGSON.get().toJson(payload, typeOfPayload), volleyListener);
    }

    public VolleyStringRequest(@NonNull String url, Object payload, Type typeOfPayload, @Nullable VolleyResponses listener) {
        this(1, url, VolleyGSON.get().toJson(payload, typeOfPayload), listener);
    }

    public VolleyStringRequest(@NonNull String url, @Nullable VolleyResponses listener) {
        this(0, url, null, listener);
    }

    public VolleyStringRequest(@NonNull String url, @Nullable String payload, @Nullable VolleyResponses listener) {
        this(1, url, payload, listener);
    }

    public VolleyStringRequest(int method, @NonNull String url, @Nullable String payload, @Nullable VolleyResponses listener) {
        super(method, url, VolleyWorkLoad.errorListenerHandler(listener));
        this.listener = listener;
        this.mRequestBody = payload;
    }

    @Deprecated
    public VolleyStringRequest(@NonNull String url, @Nullable VolleyResponse.Listener<String> listener, @Nullable VolleyResponse.ErrorListener errorListener) {
        this(0, url, null, listener, errorListener);
    }

    @Deprecated
    public VolleyStringRequest(@NonNull String url, @Nullable String payload, @Nullable VolleyResponse.Listener<String> listener, @Nullable VolleyResponse.ErrorListener errorListener) {
        this(1, url, payload, listener, errorListener);
    }

    public VolleyStringRequest(int method, @NonNull String url, @Nullable String payload, @Nullable VolleyResponse.Listener<String> listener, @Nullable VolleyResponse.ErrorListener errorListener) {
        super(method, url, VolleyWorkLoad.errorListenerHandler(errorListener));
        this.volleyListener = listener;
        this.mRequestBody = payload;
    }

    public VolleyStringRequest(int method, @NonNull String url, @Nullable String payload, Response.Listener<String> listener, Response.ErrorListener errorListener) {
        super(method, url, errorListener);
        this.mListener = listener;
        this.mRequestBody = payload;
    }

    public VolleyStringRequest(int method, @NonNull String url, Response.Listener<String> listener, Response.ErrorListener errorListener) {
        this(method, url, null, listener, errorListener);
    }

    public VolleyStringRequest(@NonNull String url, @Nullable String payload, Response.Listener<String> listener, Response.ErrorListener errorListener) {
        this(1, url, payload, listener, errorListener);
    }

    public VolleyStringRequest(@NonNull String url, Response.Listener<String> listener, Response.ErrorListener errorListener) {
        this(0, url, null, listener, errorListener);
    }

    public String getBodyContentType() {
        return "application/json";
    }

    public byte[] getBody() {
        try {
            return this.mRequestBody == null ? null : this.mRequestBody.getBytes(VolleyValues.PROTOCOL_CHARSET);
        }
        catch (UnsupportedEncodingException uee) {
            VolleyLog.wtf((String)"Unsupported Encoding while trying to get the bytes of %s using %s", (Object[])new Object[]{this.mRequestBody, VolleyValues.PROTOCOL_CHARSET});
            return null;
        }
    }

    public Map<String, String> getHeaders() {
        return VolleyNeeds.get().setVolleyHeader();
    }

    protected void deliverResponse(String response) {
        if (this.volleyListener != null) {
            this.volleyListener.onResponse(response);
        }
        if (this.mListener != null) {
            this.mListener.onResponse((Object)response);
        }
        if (this.listener != null) {
            this.listener.onResponse(response);
        }
    }

    protected Response<String> parseNetworkResponse(NetworkResponse response) {
        String parsed;
        try {
            parsed = new String(response.data, HttpHeaderParser.parseCharset((Map)response.headers));
        }
        catch (UnsupportedEncodingException e) {
            parsed = new String(response.data);
        }
        return Response.success((Object)parsed, (Cache.Entry)HttpHeaderParser.parseCacheHeaders((NetworkResponse)response));
    }
}

