/*
 * Decompiled with CFR 0.152.
 */
package tk.jamun.volley.classes;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.android.volley.NetworkResponse;
import com.android.volley.Request;
import com.android.volley.Response;
import com.android.volley.VolleyLog;
import com.android.volley.toolbox.StringRequest;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.util.Map;
import tk.jamun.volley.classes.VolleyGSON;
import tk.jamun.volley.classes.VolleyWorkLoad;
import tk.jamun.volley.helpers.VolleyNeeds;
import tk.jamun.volley.helpers.VolleyValues;
import tk.jamun.volley.variables.VolleyResponses;

public class VolleyResponseRequests
extends Request<StringRequest> {
    private String mRequestBody;
    private VolleyResponses listener;

    public VolleyResponseRequests(int method, @NonNull String url, Object payload, Type typeOfPayload, VolleyResponses listener) {
        this(method, url, VolleyGSON.get().toJson(payload, typeOfPayload), listener);
    }

    public VolleyResponseRequests(@NonNull String url, Object payload, Type typeOfPayload, VolleyResponses listener) {
        this(1, url, VolleyGSON.get().toJson(payload, typeOfPayload), listener);
    }

    public VolleyResponseRequests(@NonNull String url, VolleyResponses listener) {
        this(0, url, null, listener);
    }

    public VolleyResponseRequests(int method, @NonNull String url, @Nullable String payload, VolleyResponses listener) {
        super(method, url, VolleyWorkLoad.errorListenerHandler(listener));
        this.listener = listener;
        this.mRequestBody = payload;
    }

    public VolleyResponseRequests(@NonNull String url, @Nullable String payload, VolleyResponses listener) {
        this(1, url, payload, listener);
    }

    public Map<String, String> getHeaders() {
        return VolleyNeeds.get().setVolleyHeader();
    }

    public byte[] getBody() {
        try {
            return this.mRequestBody == null ? null : this.mRequestBody.getBytes(VolleyValues.PROTOCOL_CHARSET);
        }
        catch (UnsupportedEncodingException uee) {
            VolleyLog.wtf((String)"Unsupported Encoding while trying to get the bytes of %s using %s", (Object[])new Object[]{this.mRequestBody, VolleyValues.PROTOCOL_CHARSET});
            return null;
        }
    }

    protected Response<StringRequest> parseNetworkResponse(NetworkResponse response) {
        this.listener.onStatusCodeResponse(response.statusCode);
        return null;
    }

    protected void deliverResponse(StringRequest response) {
        this.listener.onResponse(response);
    }
}

