/*
 * Decompiled with CFR 0.152.
 */
package tk.jamun.volley.classes;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.android.volley.AuthFailureError;
import com.android.volley.Cache;
import com.android.volley.NetworkResponse;
import com.android.volley.ParseError;
import com.android.volley.Request;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.HttpHeaderParser;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import tk.jamun.volley.classes.VolleyWorkLoad;
import tk.jamun.volley.helpers.VolleyNeeds;
import tk.jamun.volley.helpers.VolleyValues;
import tk.jamun.volley.model.ModelByPart;
import tk.jamun.volley.variables.VolleyResponse;
import tk.jamun.volley.variables.VolleyResponses;

public class VolleyMultipartRequest
extends Request<String> {
    private final String twoHyphens = "--";
    private final String lineEnd = "\r\n";
    private final String boundary = "*****";
    private VolleyResponses responses;
    private VolleyResponse.Listener<String> listener;
    private Response.Listener<String> mListener;
    private Map<String, ModelByPart> params;

    @Deprecated
    public VolleyMultipartRequest(@NonNull String url, Map<String, ModelByPart> params, @Nullable VolleyResponse.Listener<String> listener, @Nullable VolleyResponse.ErrorListener errorListener) {
        this(1, url, params, listener, errorListener);
    }

    @Deprecated
    public VolleyMultipartRequest(int method, @NonNull String url, Map<String, ModelByPart> params, @Nullable VolleyResponse.Listener<String> listener, @Nullable VolleyResponse.ErrorListener errorListener) {
        super(method, url, VolleyWorkLoad.errorListenerHandler(errorListener));
        this.listener = listener;
        this.params = params;
    }

    public VolleyMultipartRequest(@NonNull String url, Map<String, ModelByPart> params, VolleyResponses listener) {
        super(1, url, VolleyWorkLoad.errorListenerHandler(listener));
        this.responses = listener;
        this.params = params;
    }

    @Deprecated
    public VolleyMultipartRequest(@NonNull String url, VolleyResponses listener) {
        super(0, url, VolleyWorkLoad.errorListenerHandler(listener));
        this.responses = listener;
    }

    @Deprecated
    public VolleyMultipartRequest(int method, @NonNull String url, Map<String, ModelByPart> params, VolleyResponses listener) {
        super(method, url, VolleyWorkLoad.errorListenerHandler(listener));
        this.responses = listener;
        this.params = params;
    }

    public VolleyMultipartRequest(int method, @NonNull String url, VolleyResponses listener) {
        super(method, url, VolleyWorkLoad.errorListenerHandler(listener));
        this.responses = listener;
    }

    public VolleyMultipartRequest(int method, @NonNull String url, Map<String, ModelByPart> params, Response.Listener<String> listener, Response.ErrorListener errorListener) {
        super(method, url, errorListener);
        this.mListener = listener;
        this.params = params;
    }

    public VolleyMultipartRequest(@NonNull String url, Map<String, ModelByPart> params, Response.Listener<String> listener, Response.ErrorListener errorListener) {
        super(1, url, errorListener);
        this.mListener = listener;
        this.params = params;
    }

    public VolleyMultipartRequest(@NonNull String url, Response.Listener<String> listener, Response.ErrorListener errorListener) {
        super(0, url, errorListener);
        this.mListener = listener;
    }

    public VolleyMultipartRequest(int method, @NonNull String url, Response.Listener<String> listener, Response.ErrorListener errorListener) {
        super(method, url, errorListener);
        this.mListener = listener;
    }

    public Map<String, String> getHeaders() {
        return VolleyNeeds.get().setVolleyHeader();
    }

    public String getBodyContentType() {
        return "multipart/form-data;boundary=*****";
    }

    public byte[] getBody() throws AuthFailureError {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        try {
            Map<String, ModelByPart> data;
            Map params = this.getParams();
            if (params != null && params.size() > 0) {
                this.textParse(dos, params, this.getParamsEncoding());
            }
            if ((data = this.getByteData()) != null && data.size() > 0) {
                this.dataParse(dos, data);
            }
            dos.writeBytes("--*****--\r\n");
            return bos.toByteArray();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    protected Map<String, ModelByPart> getByteData() {
        return this.params;
    }

    protected Response<String> parseNetworkResponse(NetworkResponse response) {
        try {
            String jsonString = new String(response.data, HttpHeaderParser.parseCharset((Map)response.headers));
            return Response.success((Object)jsonString, (Cache.Entry)HttpHeaderParser.parseCacheHeaders((NetworkResponse)response));
        }
        catch (UnsupportedEncodingException e) {
            return Response.error((VolleyError)new ParseError((Throwable)e));
        }
    }

    protected void deliverResponse(String response) {
        if (this.listener != null) {
            this.listener.onResponse(response);
        }
        if (this.mListener != null) {
            this.mListener.onResponse((Object)response);
        }
        if (this.responses != null) {
            this.responses.onResponse(response);
        }
    }

    private void textParse(DataOutputStream dataOutputStream, Map<String, String> params, String encoding) throws IOException {
        try {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                this.buildTextPart(dataOutputStream, entry.getKey(), entry.getValue());
            }
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException("Encoding not supported: " + encoding, uee);
        }
    }

    private void dataParse(DataOutputStream dataOutputStream, Map<String, ModelByPart> data) throws IOException {
        for (Map.Entry<String, ModelByPart> entry : data.entrySet()) {
            this.buildDataPart(dataOutputStream, entry.getValue(), entry.getKey());
        }
    }

    private void buildTextPart(DataOutputStream dataOutputStream, String parameterName, String parameterValue) throws IOException {
        dataOutputStream.writeBytes("--*****\r\n");
        dataOutputStream.writeBytes("Content-Disposition: form-data; name=\"" + parameterName + "\"" + "\r\n");
        dataOutputStream.writeBytes("\r\n");
        dataOutputStream.writeBytes(parameterValue + "\r\n");
    }

    private void buildDataPart(DataOutputStream dataOutputStream, ModelByPart dataFile, String inputName) throws IOException {
        dataOutputStream.writeBytes("--*****\r\n");
        dataOutputStream.writeBytes("Content-Disposition: form-data; name=\"" + inputName + "\"; filename=\"" + dataFile.getFileName() + "\"" + "\r\n");
        if (dataFile.getType() != null && !dataFile.getType().trim().isEmpty()) {
            dataOutputStream.writeBytes("Content-Type: " + dataFile.getType() + "\r\n");
        }
        dataOutputStream.writeBytes("\r\n");
        ByteArrayInputStream fileInputStream = new ByteArrayInputStream(dataFile.getContent());
        int bytesAvailable = fileInputStream.available();
        int bufferSize = Math.min(bytesAvailable, VolleyValues.get().getMaxBufferSize());
        byte[] buffer = new byte[bufferSize];
        int bytesRead = fileInputStream.read(buffer, 0, bufferSize);
        while (bytesRead > 0) {
            dataOutputStream.write(buffer, 0, bufferSize);
            bytesAvailable = fileInputStream.available();
            bufferSize = Math.min(bytesAvailable, VolleyValues.get().getMaxBufferSize());
            bytesRead = fileInputStream.read(buffer, 0, bufferSize);
        }
        dataOutputStream.writeBytes("\r\n");
    }
}

