/*
 * Decompiled with CFR 0.152.
 */
package tk.jamun.volley.classes;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.android.volley.Cache;
import com.android.volley.NetworkResponse;
import com.android.volley.ParseError;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.HttpHeaderParser;
import com.android.volley.toolbox.JsonRequest;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;
import tk.jamun.volley.classes.VolleyGSON;
import tk.jamun.volley.classes.VolleyWorkLoad;
import tk.jamun.volley.helpers.VolleyNeeds;
import tk.jamun.volley.variables.VolleyResponse;
import tk.jamun.volley.variables.VolleyResponses;

public class VolleyJsonObjectRequest
extends JsonRequest<JSONObject> {
    public VolleyJsonObjectRequest(int method, @NonNull String url, String payload, Type typeOfResponse, VolleyResponses listener) {
        this(method, url, payload, VolleyWorkLoad.responseObjectHandler(listener, typeOfResponse), VolleyWorkLoad.errorWorkLoadHandler(listener));
    }

    public VolleyJsonObjectRequest(int method, @NonNull String url, Object payload, Type typeOfPayload, Type typeOfResponse, VolleyResponses listener) {
        this(method, url, VolleyGSON.get().toJson(payload, typeOfPayload), VolleyWorkLoad.responseObjectHandler(listener, typeOfResponse), VolleyWorkLoad.errorWorkLoadHandler(listener));
    }

    public VolleyJsonObjectRequest(int method, @NonNull String url, Object payload, Type typeOfPayload, VolleyResponses listener) {
        this(method, url, VolleyGSON.get().toJson(payload, typeOfPayload), VolleyWorkLoad.responseObjectHandler(listener, null), VolleyWorkLoad.errorWorkLoadHandler(listener));
    }

    public VolleyJsonObjectRequest(@NonNull String url, Object payload, Type typeOfPayload, Type typeOfResponse, VolleyResponses listener) {
        this(1, url, VolleyGSON.get().toJson(payload, typeOfPayload), VolleyWorkLoad.responseObjectHandler(listener, typeOfResponse), VolleyWorkLoad.errorWorkLoadHandler(listener));
    }

    public VolleyJsonObjectRequest(@NonNull String url, Type typeOfResponse, VolleyResponses listener) {
        this(0, url, null, VolleyWorkLoad.responseObjectHandler(listener, typeOfResponse), VolleyWorkLoad.errorWorkLoadHandler(listener));
    }

    public VolleyJsonObjectRequest(@NonNull String url, String payload, Type typeOfResponse, VolleyResponses listener) {
        this(1, url, payload, VolleyWorkLoad.responseObjectHandler(listener, typeOfResponse), VolleyWorkLoad.errorWorkLoadHandler(listener));
    }

    public VolleyJsonObjectRequest(int method, @NonNull String url, String payload, Class<?> modelClass, VolleyResponses listener) {
        this(method, url, payload, VolleyWorkLoad.responseObjectHandler(listener, modelClass), VolleyWorkLoad.errorWorkLoadHandler(listener));
    }

    public VolleyJsonObjectRequest(@NonNull String url, String payload, Class<?> modelClass, VolleyResponses listener) {
        this(1, url, payload, VolleyWorkLoad.responseObjectHandler(listener, modelClass), VolleyWorkLoad.errorWorkLoadHandler(listener));
    }

    public VolleyJsonObjectRequest(int method, @NonNull String url, Class<?> modelClass, VolleyResponses listener) {
        this(method, url, null, VolleyWorkLoad.responseObjectHandler(listener, modelClass), VolleyWorkLoad.errorWorkLoadHandler(listener));
    }

    public VolleyJsonObjectRequest(@NonNull String url, Class<?> modelClass, VolleyResponses listener) {
        this(0, url, null, VolleyWorkLoad.responseObjectHandler(listener, modelClass), VolleyWorkLoad.errorWorkLoadHandler(listener));
    }

    public VolleyJsonObjectRequest(int method, @NonNull String url, VolleyResponses listener) {
        this(method, url, null, VolleyWorkLoad.responseObjectHandler(listener), VolleyWorkLoad.errorWorkLoadHandler(listener));
    }

    public VolleyJsonObjectRequest(@NonNull String url, VolleyResponses listener) {
        this(0, url, null, VolleyWorkLoad.responseObjectHandler(listener), VolleyWorkLoad.errorWorkLoadHandler(listener));
    }

    public VolleyJsonObjectRequest(@NonNull String url, String payload, VolleyResponses listener) {
        this(1, url, payload, VolleyWorkLoad.responseObjectHandler(listener), VolleyWorkLoad.errorWorkLoadHandler(listener));
    }

    public VolleyJsonObjectRequest(int method, @NonNull String url, String payload, VolleyResponses listener) {
        super(method, url, payload, VolleyWorkLoad.objectListenerHandlerJamun(listener), VolleyWorkLoad.errorListenerHandlerJamun(listener));
    }

    @Deprecated
    public VolleyJsonObjectRequest(@NonNull String url, @Nullable String payload, @Nullable VolleyResponse.Listener<JSONObject> listener, @Nullable VolleyResponse.ErrorListener errorListener) {
        this(1, url, payload, listener, errorListener);
    }

    @Deprecated
    public VolleyJsonObjectRequest(@NonNull String url, @Nullable VolleyResponse.Listener<JSONObject> listener, @Nullable VolleyResponse.ErrorListener errorListener) {
        this(0, url, null, listener, errorListener);
    }

    public VolleyJsonObjectRequest(int method, @NonNull String url, @Nullable String payload, @Nullable VolleyResponse.Listener<JSONObject> listener, @Nullable VolleyResponse.ErrorListener errorListener) {
        super(method, url, payload, VolleyWorkLoad.objectListenerHandler(listener), VolleyWorkLoad.errorListenerHandler(errorListener));
    }

    public VolleyJsonObjectRequest(int method, @NonNull String url, @Nullable String payload, Response.Listener<JSONObject> listener, Response.ErrorListener errorListener) {
        super(method, url, payload, listener, errorListener);
    }

    public Map<String, String> getHeaders() {
        return VolleyNeeds.get().setVolleyHeader();
    }

    public String getBodyContentType() {
        return "application/json";
    }

    protected Response<JSONObject> parseNetworkResponse(NetworkResponse response) {
        try {
            String jsonString = new String(response.data, HttpHeaderParser.parseCharset((Map)response.headers, (String)"utf-8"));
            return Response.success((Object)new JSONObject(jsonString), (Cache.Entry)HttpHeaderParser.parseCacheHeaders((NetworkResponse)response));
        }
        catch (UnsupportedEncodingException e) {
            return Response.error((VolleyError)new ParseError((Throwable)e));
        }
        catch (JSONException je) {
            return Response.error((VolleyError)new ParseError((Throwable)je));
        }
    }
}

