/*
 * Decompiled with CFR 0.152.
 */
package tk.jamun.volley.classes;

import com.android.volley.Cache;
import com.android.volley.NetworkResponse;
import com.android.volley.ParseError;
import com.android.volley.Request;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.VolleyLog;
import com.android.volley.toolbox.HttpHeaderParser;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import tk.jamun.volley.helpers.VolleyErrorExceptions;
import tk.jamun.volley.helpers.VolleyNeeds;
import tk.jamun.volley.helpers.VolleyResponse;
import tk.jamun.volley.helpers.VolleyValues;

public class VolleyNetworkRequest
extends Request<NetworkResponse> {
    private String mRequestBody;
    private VolleyResponse.Listener<Integer> mListener;

    public VolleyNetworkRequest(String url, VolleyResponse.Listener<Integer> listener, VolleyResponse.ErrorListener errorListener) {
        this(0, url, null, listener, errorListener);
    }

    public VolleyNetworkRequest(int method, String url, String stringData, VolleyResponse.Listener<Integer> listener, final VolleyResponse.ErrorListener errorListener) {
        super(method, url, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                errorListener.onErrorResponse(VolleyErrorExceptions.getInstance().getVolleyErrorStatusCode(error), VolleyErrorExceptions.getInstance().getVolleyErrorMessage(error));
            }
        });
        this.mListener = listener;
        this.mRequestBody = stringData;
    }

    public VolleyNetworkRequest(String url, String stringData, VolleyResponse.Listener<Integer> listener, VolleyResponse.ErrorListener errorListener) {
        this(1, url, stringData, listener, errorListener);
    }

    public Map<String, String> getHeaders() {
        return VolleyNeeds.getInstance().setVolleyHeader();
    }

    public String getBodyContentType() {
        return "application/json";
    }

    protected Response<NetworkResponse> parseNetworkResponse(NetworkResponse response) {
        try {
            return Response.success((Object)response, (Cache.Entry)HttpHeaderParser.parseCacheHeaders((NetworkResponse)response));
        }
        catch (Exception e) {
            return Response.error((VolleyError)new ParseError((Throwable)e));
        }
    }

    public byte[] getBody() {
        try {
            return this.mRequestBody == null ? null : this.mRequestBody.getBytes(VolleyValues.PROTOCOL_CHARSET);
        }
        catch (UnsupportedEncodingException uee) {
            VolleyLog.wtf((String)"Unsupported Encoding while trying to get the bytes of %s using %s", (Object[])new Object[]{this.mRequestBody, VolleyValues.PROTOCOL_CHARSET});
            return null;
        }
    }

    protected void deliverResponse(NetworkResponse response) {
        this.mListener.onResponse(response.statusCode);
    }
}

