/*
 * Decompiled with CFR 0.152.
 */
package tk.jamun.volley.view;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.media.ThumbnailUtils;
import android.util.AttributeSet;
import com.android.volley.toolbox.NetworkImageView;

public class CircularNetworkImageView
extends NetworkImageView {
    Context mContext;

    public CircularNetworkImageView(Context context) {
        super(context);
        this.mContext = context;
    }

    public CircularNetworkImageView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
        this.mContext = context;
    }

    public CircularNetworkImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.mContext = context;
    }

    public void setImageBitmap(Bitmap bm) {
        if (bm == null) {
            return;
        }
        this.setImageDrawable((Drawable)new BitmapDrawable(this.mContext.getResources(), this.getCircularBitmap(bm)));
    }

    public Bitmap getCircularBitmap(Bitmap bitmap) {
        bitmap = ThumbnailUtils.extractThumbnail((Bitmap)bitmap, (int)300, (int)300);
        Bitmap output = Bitmap.createBitmap((int)bitmap.getWidth(), (int)bitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(output);
        int width = bitmap.getWidth();
        if (bitmap.getWidth() > bitmap.getHeight()) {
            width = bitmap.getHeight();
        }
        int color2 = -12434878;
        Paint paint = new Paint();
        Rect rect = new Rect(0, 0, width, width);
        RectF rectF = new RectF(rect);
        float roundPx = width / 2;
        paint.setAntiAlias(true);
        canvas.drawARGB(0, 0, 0, 0);
        paint.setColor(-12434878);
        canvas.drawRoundRect(rectF, roundPx, roundPx, paint);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        canvas.drawBitmap(bitmap, rect, rect, paint);
        return output;
    }
}

