/*
 * Decompiled with CFR 0.152.
 */
package tk.jamun.volley.classes;

import android.util.Log;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import tk.jamun.volley.helpers.HelperNotification;
import tk.jamun.volley.helpers.VolleyNeeds;
import tk.jamun.volley.helpers.VolleyValues;
import tk.jamun.volley.model.ModelHeader;

public class VolleyDownUpFiles {
    private static VolleyDownUpFiles VolleyDownUpFiles;
    private HttpURLConnection connection;
    private int maxBufferSize = VolleyValues.getInstance().getMaxBufferSize();
    private int delayAfterNotificationUpdate = 6;

    public static VolleyDownUpFiles getInstance() {
        if (VolleyDownUpFiles == null) {
            VolleyDownUpFiles = new VolleyDownUpFiles();
        }
        return VolleyDownUpFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String uploadFile(String uploadUrl, File sourceFile, HelperNotification helperNotification, int notificationId) {
        String string;
        HttpURLConnection.setFollowRedirects(false);
        DataInputStream inStream = null;
        try {
            int bytesRead;
            this.connection = (HttpURLConnection)new URL(uploadUrl).openConnection();
            this.connection.setRequestMethod("POST");
            this.connection.setDoInput(true);
            this.connection.setDoOutput(true);
            this.connection.setUseCaches(false);
            String boundary = "---------------------------boundary";
            String tail = "\r\n--" + boundary + "--\r\n";
            this.connection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
            for (ModelHeader modelHeader : VolleyNeeds.getInstance().getUpHeaders()) {
                this.connection.setRequestProperty(modelHeader.getValue(), modelHeader.getValue());
            }
            String metadataPart = "--" + boundary + "\r\nContent-Disposition: form-data; name=\"metadata\"\r\n\r\n\r\n";
            long fileLength = sourceFile.length() + (long)tail.length();
            String stringData = metadataPart + "--" + boundary + "\r\nContent-Disposition: form-data; name=\"fileToUpload\"; filename=\"" + sourceFile.getName() + "\"\r\nContent-Type: application/octet-stream\r\nContent-Transfer-Encoding: binary\r\nContent-length: " + fileLength + "\r\n\r\n";
            long requestLength = (long)stringData.length() + fileLength;
            this.connection.setRequestProperty("Content-length", "" + requestLength);
            this.connection.setFixedLengthStreamingMode((int)requestLength);
            this.connection.connect();
            DataOutputStream out = new DataOutputStream(this.connection.getOutputStream());
            out.writeBytes(stringData);
            out.flush();
            int total = 0;
            long maintainTotal = 6L;
            long totalSize = sourceFile.length();
            int delayAfterCount = 0;
            FileInputStream fileInputStream = new FileInputStream(sourceFile);
            BufferedInputStream bufInput = new BufferedInputStream(fileInputStream);
            byte[] buf = new byte[(int)sourceFile.length() / 200];
            while ((bytesRead = bufInput.read(buf)) != -1) {
                out.write(buf, 0, bytesRead);
                out.flush();
                if (helperNotification == null) continue;
                total += bytesRead;
                if (delayAfterCount > this.delayAfterNotificationUpdate && fileLength > 0L) {
                    helperNotification.updateProgressView(notificationId, total / 1024, ((long)total - maintainTotal) / 1024L, totalSize / 1024L);
                    delayAfterCount = 0;
                    maintainTotal = total;
                }
                ++delayAfterCount;
            }
            out.writeBytes(tail);
            out.flush();
            out.close();
        }
        catch (IOException e) {
            Log.e((String)VolleyDownUpFiles.class.getSimpleName(), (String)(e.getMessage() + " "));
            return null;
        }
        try {
            inStream = new DataInputStream(this.connection.getInputStream());
            String str = inStream.readLine();
            if (str != null) {
                inStream.close();
                string = str;
                return string;
            }
        }
        catch (IOException e) {
            Log.e((String)VolleyDownUpFiles.class.getSimpleName(), (String)("" + e.getMessage()));
            string = null;
            return string;
        }
        finally {
            if (this.connection != null) {
                this.connection.disconnect();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean downloadFile(String downUpUrl, String filePath, HelperNotification helperNotification, int notificationId) {
        InputStream input = null;
        OutputStream output = null;
        try {
            int count;
            URL url = new URL(downUpUrl);
            this.connection = (HttpURLConnection)url.openConnection();
            this.connection.setRequestMethod("GET");
            this.connection.setRequestProperty("Connection", "Keep-Alive");
            for (ModelHeader modelHeader : VolleyNeeds.getInstance().getUpHeaders()) {
                this.connection.setRequestProperty(modelHeader.getValue(), modelHeader.getValue());
            }
            this.connection.connect();
            if (this.connection.getResponseCode() != 200) {
                boolean bl = false;
                return bl;
            }
            int fileLength = this.connection.getContentLength();
            input = this.connection.getInputStream();
            output = new FileOutputStream(new File(filePath));
            byte[] data = new byte[this.maxBufferSize];
            long total = 0L;
            int delayAfterCount = 0;
            long maintainTotal = 6L;
            while ((count = input.read(data)) != -1) {
                if (helperNotification != null) {
                    total += (long)count;
                    if (delayAfterCount > this.delayAfterNotificationUpdate && fileLength > 0) {
                        helperNotification.updateProgressView(notificationId, total / 1024L, (total - maintainTotal) / 1024L, fileLength / 1024);
                        delayAfterCount = 0;
                        maintainTotal = total;
                    }
                    ++delayAfterCount;
                }
                output.write(data, 0, count);
            }
        }
        catch (IOException e) {
            Log.e((String)VolleyDownUpFiles.class.getSimpleName(), (String)(e.getMessage() + " "));
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (output != null) {
                    output.close();
                }
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException e) {
                Log.e((String)VolleyDownUpFiles.class.getSimpleName(), (String)(e.getMessage() + " "));
            }
            if (this.connection != null) {
                this.connection.disconnect();
            }
        }
        return true;
    }

    public void stop() {
        if (this.connection != null) {
            this.connection.disconnect();
        }
    }

    public void setMaxBufferSize(int maxBufferSize) {
        this.maxBufferSize = maxBufferSize;
    }

    public void setDelayAfterNotificationUpdate(int delayAfterNotificationUpdate) {
        this.delayAfterNotificationUpdate = delayAfterNotificationUpdate;
    }
}

