/*
 * Decompiled with CFR 0.152.
 */
package threads.webrtc;

import android.content.Context;
import android.content.SharedPreferences;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.util.Preconditions;
import org.webrtc.IceCandidate;
import org.webrtc.SessionDescription;
import threads.webrtc.RTCSession;

public class RTCClient
implements RTCSession.Listener {
    private static final String AUDIO_CODEC_KEY = "audioCodecKey";
    private static final String VIDEO_CODEC_KEY = "videoCodecKey";
    private static final String AUDIO_PROCESSING_KEY = "audioProcessingEnabledKey";
    private static final String OPEN_SL_ES_KEY = "openSlEsKey";
    private static final String AEC_KEY = "aecKey";
    private static final String AGC_KEY = "agcKey";
    private static final String HNS_KEY = "hnsKey";
    private static final String PREF_KEY = "prefKey";
    private static final String TIMEOUT_KEY = "timeoutKey";
    private final SignalingEvents events;
    private final String topic;

    public RTCClient(@NonNull String topic, @NonNull SignalingEvents events) {
        Preconditions.checkNotNull((Object)topic);
        Preconditions.checkNotNull((Object)events);
        this.events = events;
        this.topic = topic;
        RTCSession.getInstance().setListener(this);
    }

    @NonNull
    public static String getAudioCodec(@NonNull Context context) {
        Preconditions.checkNotNull((Object)context);
        SharedPreferences sharedPref = context.getSharedPreferences(PREF_KEY, 0);
        return sharedPref.getString(AUDIO_CODEC_KEY, "opus");
    }

    public static void setAudioCodec(@NonNull Context context, @NonNull String codec) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)codec);
        SharedPreferences sharedPref = context.getSharedPreferences(PREF_KEY, 0);
        SharedPreferences.Editor editor = sharedPref.edit();
        editor.putString(AUDIO_CODEC_KEY, codec);
        editor.apply();
    }

    @NonNull
    public static String getVideoCodec(@NonNull Context context) {
        Preconditions.checkNotNull((Object)context);
        SharedPreferences sharedPref = context.getSharedPreferences(PREF_KEY, 0);
        return sharedPref.getString(VIDEO_CODEC_KEY, "VP9");
    }

    public static void setVideoCodec(@NonNull Context context, @NonNull String codec) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)codec);
        SharedPreferences sharedPref = context.getSharedPreferences(PREF_KEY, 0);
        SharedPreferences.Editor editor = sharedPref.edit();
        editor.putString(VIDEO_CODEC_KEY, codec);
        editor.apply();
    }

    public static boolean isAutomaticGainControlEnabled(@NonNull Context context) {
        Preconditions.checkNotNull((Object)context);
        SharedPreferences sharedPref = context.getSharedPreferences(PREF_KEY, 0);
        return sharedPref.getBoolean(AGC_KEY, true);
    }

    public static void setAutomaticGainControlEnabled(@NonNull Context context, boolean enable) {
        Preconditions.checkNotNull((Object)context);
        SharedPreferences sharedPref = context.getSharedPreferences(PREF_KEY, 0);
        SharedPreferences.Editor editor = sharedPref.edit();
        editor.putBoolean(AGC_KEY, enable);
        editor.apply();
    }

    public static int getConnectionTimeout(@NonNull Context context) {
        Preconditions.checkNotNull((Object)context);
        SharedPreferences sharedPref = context.getSharedPreferences(PREF_KEY, 0);
        return sharedPref.getInt(TIMEOUT_KEY, 30);
    }

    public static void setConnectionTimeout(@NonNull Context context, int timeout) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkArgument((timeout >= 0 ? 1 : 0) != 0);
        SharedPreferences sharedPref = context.getSharedPreferences(PREF_KEY, 0);
        SharedPreferences.Editor editor = sharedPref.edit();
        editor.putInt(TIMEOUT_KEY, timeout);
        editor.apply();
    }

    public static boolean isHardwareNoiseSuppressorEnabled(@NonNull Context context) {
        Preconditions.checkNotNull((Object)context);
        SharedPreferences sharedPref = context.getSharedPreferences(PREF_KEY, 0);
        return sharedPref.getBoolean(HNS_KEY, true);
    }

    public static void setHardwareNoiseSuppressorEnabled(@NonNull Context context, boolean enable) {
        Preconditions.checkNotNull((Object)context);
        SharedPreferences sharedPref = context.getSharedPreferences(PREF_KEY, 0);
        SharedPreferences.Editor editor = sharedPref.edit();
        editor.putBoolean(HNS_KEY, enable);
        editor.apply();
    }

    public static boolean isAcousticEchoCancelerEnabled(@NonNull Context context) {
        Preconditions.checkNotNull((Object)context);
        SharedPreferences sharedPref = context.getSharedPreferences(PREF_KEY, 0);
        return sharedPref.getBoolean(AEC_KEY, true);
    }

    public static void setAcousticEchoCancelerEnabled(@NonNull Context context, boolean enable) {
        Preconditions.checkNotNull((Object)context);
        SharedPreferences sharedPref = context.getSharedPreferences(PREF_KEY, 0);
        SharedPreferences.Editor editor = sharedPref.edit();
        editor.putBoolean(AEC_KEY, enable);
        editor.apply();
    }

    public static boolean isOpenSlESEnabled(@NonNull Context context) {
        Preconditions.checkNotNull((Object)context);
        SharedPreferences sharedPref = context.getSharedPreferences(PREF_KEY, 0);
        return sharedPref.getBoolean(OPEN_SL_ES_KEY, true);
    }

    public static void setOpenSlESEnabled(@NonNull Context context, boolean enable) {
        Preconditions.checkNotNull((Object)context);
        SharedPreferences sharedPref = context.getSharedPreferences(PREF_KEY, 0);
        SharedPreferences.Editor editor = sharedPref.edit();
        editor.putBoolean(OPEN_SL_ES_KEY, enable);
        editor.apply();
    }

    public static boolean isAudioProcessingEnabled(@NonNull Context context) {
        Preconditions.checkNotNull((Object)context);
        SharedPreferences sharedPref = context.getSharedPreferences(PREF_KEY, 0);
        return sharedPref.getBoolean(AUDIO_PROCESSING_KEY, true);
    }

    public static void setAudioProcessingEnabled(@NonNull Context context, boolean enable) {
        Preconditions.checkNotNull((Object)context);
        SharedPreferences sharedPref = context.getSharedPreferences(PREF_KEY, 0);
        SharedPreferences.Editor editor = sharedPref.edit();
        editor.putBoolean(AUDIO_PROCESSING_KEY, enable);
        editor.apply();
    }

    @Override
    public void busy(@NonNull String pid) {
        this.events.onChannelBusy();
    }

    @Override
    public void accept(@NonNull String pid, @Nullable String[] ices) {
        this.events.onChannelAccepted(ices);
    }

    @Override
    public void reject(@NonNull String pid) {
        this.events.onChannelReject();
    }

    @Override
    public void offer(@NonNull String pid, @NonNull String sdp) {
        Preconditions.checkNotNull((Object)sdp);
        this.events.onChannelOffer(new SessionDescription(SessionDescription.Type.OFFER, sdp));
    }

    @Override
    public void answer(@NonNull String pid, @NonNull String sdp, @NonNull String type) {
        Preconditions.checkNotNull((Object)sdp);
        Preconditions.checkNotNull((Object)type);
        this.events.onRemoteDescription(new SessionDescription(SessionDescription.Type.fromCanonicalForm((String)type), sdp));
    }

    @Override
    public void candidate(@NonNull String pid, @NonNull String sdp, @NonNull String mid, @NonNull String index) {
        Preconditions.checkNotNull((Object)sdp);
        Preconditions.checkNotNull((Object)mid);
        Preconditions.checkNotNull((Object)index);
        this.events.onRemoteIceCandidate(new IceCandidate(mid, Integer.valueOf(index).intValue(), sdp));
    }

    @Override
    public void candidate_remove(@NonNull String topic, @NonNull String sdp, @NonNull String mid, @NonNull String index) {
        Preconditions.checkNotNull((Object)sdp);
        Preconditions.checkNotNull((Object)mid);
        Preconditions.checkNotNull((Object)index);
        this.events.onRemoteIceCandidateRemoved(new IceCandidate(mid, Integer.valueOf(index).intValue(), sdp));
    }

    @Override
    public void close(@NonNull String pid) {
        this.events.onChannelClose();
    }

    @Override
    public void timeout(@NonNull String pid) {
        this.events.onChannelTimeout();
    }

    public void sendOfferSdp(@NonNull Context context, @NonNull SessionDescription sdp) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)sdp);
        RTCSession.getInstance().emitSessionOffer(context, this.topic, sdp);
    }

    public void sendAnswerSdp(@NonNull Context context, @NonNull SessionDescription sdp) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)sdp);
        RTCSession.getInstance().emitSessionAnswer(context, this.topic, sdp);
    }

    public void sendLocalIceCandidate(@NonNull Context context, @NonNull IceCandidate candidate) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)candidate);
        RTCSession.getInstance().emitIceCandidate(context, this.topic, candidate);
    }

    public void sendLocalIceCandidateRemovals(@NonNull Context context, @Nullable IceCandidate[] candidates) {
        Preconditions.checkNotNull((Object)context);
        if (candidates != null) {
            RTCSession.getInstance().emitIceCandidatesRemove(context, this.topic, candidates);
        }
    }

    public static interface SignalingEvents {
        public void onChannelOffer(SessionDescription var1);

        public void onRemoteDescription(SessionDescription var1);

        public void onRemoteIceCandidate(IceCandidate var1);

        public void onRemoteIceCandidateRemoved(IceCandidate var1);

        public void onChannelClose();

        public void onChannelBusy();

        public void onChannelTimeout();

        public void onChannelReject();

        public void onChannelAccepted(@Nullable String[] var1);
    }
}

