/*
 * Decompiled with CFR 0.152.
 */
package threads.webrtc;

import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.content.Context;
import android.media.AudioAttributes;
import android.net.Uri;
import android.os.Build;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.util.Preconditions;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.webrtc.IceCandidate;
import org.webrtc.SessionDescription;
import threads.core.Singleton;
import threads.core.THREADS;
import threads.core.api.Addresses;
import threads.core.api.Content;
import threads.ipfs.IPFS;
import threads.ipfs.api.PubsubInfo;
import threads.ipfs.api.PubsubReader;
import threads.webrtc.R;
import threads.webrtc.RTCCallActivity;
import threads.webrtc.RTCVideoCallActivity;

public class RTCSession {
    public static final String RTC_CHANNEL_ID = "RTC_CHANNEL_ID";
    public static final int RTC_CALL_ID = 100;
    private static final int PUBSUB_TIMEOUT = 50;
    private static final String TAG = RTCSession.class.getSimpleName();
    private static final Gson gson = new Gson();
    private static final Hashtable<String, Future> topics = new Hashtable();
    private static RTCSession INSTANCE = new RTCSession();
    private final AtomicBoolean busy = new AtomicBoolean(false);
    @Nullable
    private Listener listener = null;

    private RTCSession() {
    }

    public static void createRTCChannel(@NonNull Context context) {
        Preconditions.checkNotNull((Object)context);
        if (Build.VERSION.SDK_INT >= 26) {
            try {
                String name = context.getString(R.string.rtc_channel_name);
                String description = context.getString(R.string.rtc_channel_description);
                int importance = 4;
                NotificationChannel mChannel = new NotificationChannel(RTC_CHANNEL_ID, (CharSequence)name, importance);
                mChannel.setDescription(description);
                mChannel.setSound(Uri.parse((String)("android.resource://" + context.getPackageName() + "/" + R.raw.incoming)), new AudioAttributes.Builder().setContentType(4).setLegacyStreamType(0).setUsage(2).build());
                NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
                if (notificationManager != null) {
                    notificationManager.createNotificationChannel(mChannel);
                }
            }
            catch (Throwable e) {
                Log.e((String)TAG, (String)("" + e.getLocalizedMessage()), (Throwable)e);
            }
        }
    }

    public static RTCSession getInstance() {
        return INSTANCE;
    }

    public static void handleContent(@NonNull Context context, @NonNull String topic, @NonNull Content content) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)topic);
        Preconditions.checkNotNull((Object)content);
        try {
            String est = (String)content.get((Object)"est");
            Event type = Event.valueOf(est);
            switch (type) {
                case SESSION_VIDEO_CALL: {
                    if (RTCSession.getInstance().isBusy()) {
                        RTCSession.getInstance().emitSessionBusy(context, topic);
                        break;
                    }
                    String adds = (String)content.get((Object)"ices");
                    String[] ices = null;
                    if (adds != null) {
                        Addresses addresses = Addresses.toAddresses((String)adds);
                        ices = RTCSession.getInstance().turnUris(addresses);
                    }
                    RTCVideoCallActivity.createVideoCallNotification(context, topic, ices);
                    break;
                }
                case SESSION_CALL: {
                    if (RTCSession.getInstance().isBusy()) {
                        RTCSession.getInstance().emitSessionBusy(context, topic);
                        break;
                    }
                    String adds = (String)content.get((Object)"ices");
                    String[] ices = null;
                    if (adds != null) {
                        Addresses addresses = Addresses.toAddresses((String)adds);
                        ices = RTCSession.getInstance().turnUris(addresses);
                    }
                    RTCCallActivity.createCallNotification(context, topic, ices);
                    break;
                }
                case SESSION_TIMEOUT: {
                    RTCSession.getInstance().timeout(topic);
                    NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
                    if (notificationManager == null) break;
                    notificationManager.cancel(100);
                    break;
                }
                case SESSION_BUSY: {
                    RTCSession.getInstance().busy(topic);
                    NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
                    if (notificationManager == null) break;
                    notificationManager.cancel(100);
                    break;
                }
                case SESSION_ACCEPT: {
                    String[] ices = null;
                    String adds = (String)content.get((Object)"ices");
                    if (adds != null) {
                        Addresses addresses = Addresses.toAddresses((String)adds);
                        ices = RTCSession.getInstance().turnUris(addresses);
                    }
                    RTCSession.getInstance().accept(topic, ices);
                    break;
                }
                case SESSION_REJECT: {
                    RTCSession.getInstance().reject(topic);
                    break;
                }
                case SESSION_OFFER: {
                    String sdp = (String)content.get((Object)"SDP");
                    Preconditions.checkNotNull((Object)sdp);
                    RTCSession.getInstance().offer(topic, sdp);
                    break;
                }
                case SESSION_ANSWER: {
                    String sdp = (String)content.get((Object)"SDP");
                    Preconditions.checkNotNull((Object)sdp);
                    String esk = (String)content.get((Object)"type");
                    Preconditions.checkNotNull((Object)esk);
                    RTCSession.getInstance().answer(topic, sdp, esk);
                    break;
                }
                case SESSION_CANDIDATE_REMOVE: {
                    String sdp = (String)content.get((Object)"SDP");
                    Preconditions.checkNotNull((Object)sdp);
                    String mid = (String)content.get((Object)"MID");
                    Preconditions.checkNotNull((Object)mid);
                    String index = (String)content.get((Object)"INDEX");
                    Preconditions.checkNotNull((Object)index);
                    RTCSession.getInstance().candidate_remove(topic, sdp, mid, index);
                    break;
                }
                case SESSION_CANDIDATE: {
                    String sdp = (String)content.get((Object)"SDP");
                    Preconditions.checkNotNull((Object)sdp);
                    String mid = (String)content.get((Object)"MID");
                    Preconditions.checkNotNull((Object)mid);
                    String index = (String)content.get((Object)"INDEX");
                    Preconditions.checkNotNull((Object)index);
                    RTCSession.getInstance().candidate(topic, sdp, mid, index);
                    break;
                }
                case SESSION_CLOSE: {
                    RTCSession.getInstance().close(topic);
                    NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
                    if (notificationManager == null) break;
                    notificationManager.cancel(100);
                    break;
                }
            }
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)("" + e.getLocalizedMessage()), (Throwable)e);
        }
    }

    private static boolean shouldRun(long start, long timeout) {
        Preconditions.checkArgument((start > 0L ? 1 : 0) != 0);
        Preconditions.checkArgument((timeout > 0L ? 1 : 0) != 0);
        long passedTime = System.currentTimeMillis() - start;
        return passedTime < timeout;
    }

    static void connectTopic(final @NonNull Context context, final @NonNull String topic) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)topic);
        if (topics.contains(topic)) {
            return;
        }
        final THREADS threads = Singleton.getInstance((Context)context).getThreads();
        IPFS ipfs = Singleton.getInstance((Context)context).getIpfs();
        Preconditions.checkNotNull((Object)ipfs, (Object)"IPFS not valid");
        ExecutorService executor = Executors.newSingleThreadExecutor();
        topics.put(topic, executor.submit(() -> {
            try {
                ipfs.pubsubSub(new PubsubReader(){

                    public void receive(@NonNull PubsubInfo message) {
                        try {
                            Content content;
                            if (!threads.isUserBlocked(message.getSenderPid()) && (content = (Content)gson.fromJson(message.getMessage(), Content.class)) != null) {
                                RTCSession.handleContent(context, topic, content);
                            }
                        }
                        catch (Throwable e) {
                            Log.e((String)TAG, (String)("" + e.getLocalizedMessage()), (Throwable)e);
                        }
                        finally {
                            Log.e((String)TAG, (String)("Receive : " + message.getMessage()));
                        }
                    }

                    @NonNull
                    public String getTopic() {
                        return topic;
                    }
                }, true);
            }
            catch (Throwable e) {
                Log.e((String)TAG, (String)("" + e.getLocalizedMessage()), (Throwable)e);
            }
        }));
    }

    @Nullable
    public String[] turnUris(@Nullable Addresses addresses) {
        if (addresses == null) {
            return null;
        }
        Collection values = addresses.values();
        ArrayList<String> uris = new ArrayList<String>();
        for (String address : values) {
            try {
                if (address.startsWith("/ip4/127.0.0.1") || address.startsWith("/ip6/::1/")) continue;
                String[] parts = address.split("/");
                String protocol = parts[3];
                if (protocol.equals("udp")) {
                    uris.add("stun:" + parts[2] + ":" + parts[4] + "?transport=udp");
                    continue;
                }
                uris.add("stun:" + parts[2] + ":" + parts[4]);
            }
            catch (Throwable e) {
                Log.e((String)TAG, (String)("" + e.getLocalizedMessage()));
            }
        }
        return uris.toArray(new String[uris.size()]);
    }

    public void emitSessionAnswer(@NonNull Context context, @NonNull String topic, @NonNull SessionDescription message) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)topic);
        Preconditions.checkNotNull((Object)message);
        IPFS ipfs = Singleton.getInstance((Context)context).getIpfs();
        if (ipfs != null) {
            try {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("est", Event.SESSION_ANSWER.name());
                map.put("SDP", message.description);
                map.put("type", message.type.name());
                ipfs.pubsubPub(topic, gson.toJson(map), 50);
            }
            catch (Throwable e) {
                Log.e((String)TAG, (String)("" + e.getLocalizedMessage()), (Throwable)e);
            }
        }
    }

    public void busy(@NonNull String pid) {
        if (this.listener != null) {
            this.listener.busy(pid);
        }
    }

    public void accept(@NonNull String topic, @Nullable String[] ices) {
        if (this.listener != null) {
            this.listener.accept(topic, ices);
        }
    }

    public void close(@NonNull String pid) {
        if (this.listener != null) {
            this.listener.close(pid);
        }
    }

    public void setListener(@Nullable Listener listener) {
        this.listener = listener;
    }

    public void reject(@NonNull String pid) {
        if (this.listener != null) {
            this.listener.reject(pid);
        }
    }

    public void offer(@NonNull String pid, @NonNull String sdp) {
        if (this.listener != null) {
            this.listener.offer(pid, sdp);
        }
    }

    public void answer(@NonNull String pid, @NonNull String sdp, @NonNull String type) {
        if (this.listener != null) {
            this.listener.answer(pid, sdp, type);
        }
    }

    public void candidate(@NonNull String pid, @NonNull String sdp, @NonNull String mid, @NonNull String index) {
        if (this.listener != null) {
            this.listener.candidate(pid, sdp, mid, index);
        }
    }

    public void candidate_remove(@NonNull String topic, @NonNull String sdp, @NonNull String mid, @NonNull String index) {
        if (this.listener != null) {
            this.listener.candidate_remove(topic, sdp, mid, index);
        }
    }

    public void timeout(String pid) {
        if (this.listener != null) {
            this.listener.timeout(pid);
        }
    }

    public void emitSessionOffer(@NonNull Context context, @NonNull String topic, @NonNull SessionDescription message) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)topic);
        Preconditions.checkNotNull((Object)message);
        try {
            IPFS ipfs = Singleton.getInstance((Context)context).getIpfs();
            Preconditions.checkNotNull((Object)ipfs, (Object)"IPFS not valid");
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("est", Event.SESSION_OFFER.name());
            map.put("SDP", message.description);
            ipfs.pubsubPub(topic, gson.toJson(map), 50);
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)("" + e.getLocalizedMessage()), (Throwable)e);
        }
    }

    public void emitSessionVideoCall(@NonNull Context context, @NonNull String topic) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)topic);
        try {
            IPFS ipfs = Singleton.getInstance((Context)context).getIpfs();
            Preconditions.checkNotNull((Object)ipfs);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("est", Event.SESSION_VIDEO_CALL.name());
            ipfs.pubsubPub(topic, gson.toJson(map), 50);
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)("" + e.getLocalizedMessage()), (Throwable)e);
        }
    }

    public void emitSessionAlive(@NonNull Context context, @NonNull String topic) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)topic);
        try {
            IPFS ipfs = Singleton.getInstance((Context)context).getIpfs();
            Preconditions.checkNotNull((Object)ipfs);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("est", Event.SESSION_ALIVE.name());
            ipfs.pubsubPub(topic, gson.toJson(map), 50);
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)("" + e.getLocalizedMessage()), (Throwable)e);
        }
    }

    public void emitSessionCall(@NonNull Context context, @NonNull String topic) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)topic);
        try {
            IPFS ipfs = Singleton.getInstance((Context)context).getIpfs();
            Preconditions.checkNotNull((Object)ipfs);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("est", Event.SESSION_CALL.name());
            ipfs.pubsubPub(topic, gson.toJson(map), 50);
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)("" + e.getLocalizedMessage()), (Throwable)e);
        }
    }

    public void emitSessionBusy(@NonNull Context context, @NonNull String topic) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)topic);
        try {
            IPFS ipfs = Singleton.getInstance((Context)context).getIpfs();
            Preconditions.checkNotNull((Object)ipfs, (Object)"IPFS not valid");
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("est", Event.SESSION_BUSY.name());
            ipfs.pubsubPub(topic, gson.toJson(map), 50);
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)("" + e.getLocalizedMessage()), (Throwable)e);
        }
    }

    public void emitSessionTimeout(@NonNull Context context, @NonNull String topic) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)topic);
        try {
            IPFS ipfs = Singleton.getInstance((Context)context).getIpfs();
            Preconditions.checkNotNull((Object)ipfs, (Object)"IPFS not valid");
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("est", Event.SESSION_TIMEOUT.name());
            ipfs.pubsubPub(topic, gson.toJson(map), 50);
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)("" + e.getLocalizedMessage()), (Throwable)e);
        }
    }

    public void emitSessionReject(@NonNull Context context, @NonNull String topic) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)topic);
        try {
            IPFS ipfs = Singleton.getInstance((Context)context).getIpfs();
            Preconditions.checkNotNull((Object)ipfs, (Object)"IPFS not valid");
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("est", Event.SESSION_REJECT.name());
            ipfs.pubsubPub(topic, gson.toJson(map), 50);
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)("" + e.getLocalizedMessage()), (Throwable)e);
        }
    }

    public void emitSessionAccept(@NonNull Context context, @NonNull String topic) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)topic);
        try {
            IPFS ipfs = Singleton.getInstance((Context)context).getIpfs();
            Preconditions.checkNotNull((Object)ipfs, (Object)"IPFS not valid");
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("est", Event.SESSION_ACCEPT.name());
            ipfs.pubsubPub(topic, gson.toJson(map), 50);
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)("" + e.getLocalizedMessage()), (Throwable)e);
        }
    }

    public void emitSessionClose(@NonNull Context context, @NonNull String topic) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)topic);
        try {
            IPFS ipfs = Singleton.getInstance((Context)context).getIpfs();
            Preconditions.checkNotNull((Object)ipfs, (Object)"IPFS not valid");
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("est", Event.SESSION_CLOSE.name());
            ipfs.pubsubPub(topic, gson.toJson(map), 50);
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)("" + e.getLocalizedMessage()), (Throwable)e);
        }
    }

    public void emitIceCandidatesRemove(@NonNull Context context, @NonNull String topic, @NonNull IceCandidate[] candidates) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)topic);
        Preconditions.checkNotNull((Object)candidates);
        try {
            IPFS ipfs = Singleton.getInstance((Context)context).getIpfs();
            Preconditions.checkNotNull((Object)ipfs, (Object)"IPFS not valid");
            for (IceCandidate candidate : candidates) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("est", Event.SESSION_CANDIDATE_REMOVE.name());
                map.put("SDP", candidate.sdp);
                map.put("MID", candidate.sdpMid);
                map.put("INDEX", String.valueOf(candidate.sdpMLineIndex));
                ipfs.pubsubPub(topic, gson.toJson(map), 50);
            }
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)("" + e.getLocalizedMessage()), (Throwable)e);
        }
    }

    public void emitIceCandidate(@NonNull Context context, @NonNull String topic, @NonNull IceCandidate candidate) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)topic);
        Preconditions.checkNotNull((Object)candidate);
        try {
            IPFS ipfs = Singleton.getInstance((Context)context).getIpfs();
            Preconditions.checkNotNull((Object)ipfs, (Object)"IPFS not valid");
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("est", Event.SESSION_CANDIDATE.name());
            map.put("SDP", candidate.sdp);
            map.put("MID", candidate.sdpMid);
            map.put("INDEX", String.valueOf(candidate.sdpMLineIndex));
            ipfs.pubsubPub(topic, gson.toJson(map), 50);
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)("" + e.getLocalizedMessage()), (Throwable)e);
        }
    }

    public boolean isBusy() {
        return this.busy.get();
    }

    public void setBusy(boolean flag) {
        this.busy.set(flag);
    }

    public static interface Listener {
        public void busy(@NonNull String var1);

        public void accept(@NonNull String var1, @Nullable String[] var2);

        public void reject(@NonNull String var1);

        public void offer(@NonNull String var1, @NonNull String var2);

        public void answer(@NonNull String var1, @NonNull String var2, @NonNull String var3);

        public void candidate(@NonNull String var1, @NonNull String var2, @NonNull String var3, @NonNull String var4);

        public void candidate_remove(@NonNull String var1, @NonNull String var2, @NonNull String var3, @NonNull String var4);

        public void close(@NonNull String var1);

        public void timeout(@NonNull String var1);
    }

    public static enum Event {
        SESSION_CALL,
        SESSION_VIDEO_CALL,
        SESSION_ACCEPT,
        SESSION_BUSY,
        SESSION_REJECT,
        SESSION_OFFER,
        SESSION_TIMEOUT,
        SESSION_ANSWER,
        SESSION_CANDIDATE,
        SESSION_ALIVE,
        SESSION_CLOSE,
        SESSION_CANDIDATE_REMOVE;

    }
}

